/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.tools.cfe;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.apache.uima.cas.FSIterator;
import org.apache.uima.jcas.JCas;
import org.apache.uima.jcas.tcas.Annotation;
import org.apache.uima.tools.cfe.AnnotationMatchedValue;
import org.apache.uima.tools.cfe.CollectionFeatureValues;
import org.apache.uima.tools.cfe.MatchedValue;
import org.apache.uima.tools.cfe.TargetObjectMatcher;
import org.apache.uima.tools.cfe.support.FeatureConstrainedIterator;
import org.apache.uima.tools.cfe.support.UIMAAnnotationUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ObjectPathFeatureValues
extends CollectionFeatureValues<MatchedValue> {
    String m_object_type_name;
    String m_object_path;

    public ObjectPathFeatureValues(String object_type_name, String object_path) {
        super(new HashSet());
        this.m_object_type_name = object_type_name;
        this.m_object_path = object_path;
    }

    void update(Object source, Annotation enclosing, Collection<MatchedValue> previosly_matched_objects) throws ClassNotFoundException, IllegalArgumentException, SecurityException, IllegalAccessException, NoSuchFieldException, InvocationTargetException {
        this.m_values.clear();
        JCas jcas = (JCas)source;
        TargetObjectMatcher tom = new TargetObjectMatcher(this.m_object_type_name, this.m_object_path, false);
        Class<? extends Annotation> cls_ann = UIMAAnnotationUtils.getAnnotationClass(tom.getRootClass());
        FSIterator<? extends Annotation> root_ann_it = FeatureConstrainedIterator.getEnclosedIterator(jcas, cls_ann, enclosing);
        while (root_ann_it.hasNext()) {
            List<MatchedValue> mfvs = tom.getFeatureValues(new AnnotationMatchedValue((Annotation)root_ann_it.next(), (List<Object>)new ArrayList<Object>()));
            if (null != previosly_matched_objects) {
                MatchedValue.removeAll(mfvs, previosly_matched_objects);
                if (!tom.isDetached()) {
                    previosly_matched_objects.addAll(mfvs);
                }
            }
            this.m_values.addAll(mfvs);
        }
    }

    @Override
    public String getFeatureImage(Object feature) {
        return this.m_object_type_name + "," + this.m_object_path;
    }

    @Override
    public boolean matches(Object feature) {
        return this.m_values.contains(feature);
    }
}

