/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.tools.cfe;

import java.util.Iterator;
import java.util.List;
import org.apache.uima.tools.cfe.ArrayDelimiterObject;
import org.apache.uima.tools.cfe.MatchedValue;
import org.apache.uima.tools.cfe.SingleFeatureMatcher;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MatchedSingleFeatureMatcher {
    public final SingleFeatureMatcher m_matcher;
    public final List<MatchedValue> m_values;

    MatchedSingleFeatureMatcher(SingleFeatureMatcher matcher, List<MatchedValue> values) {
        this.m_matcher = matcher;
        this.m_values = values;
    }

    String getFeatureImage(boolean feat_name, String[] value_separators) {
        StringBuilder result = new StringBuilder();
        ArrayDelimiterObject max_level = null;
        if (!this.m_values.isEmpty()) {
            max_level = (ArrayDelimiterObject)this.m_values.get((int)0).m_matchedObject;
        }
        Iterator<MatchedValue> it = this.m_values.iterator();
        while (it.hasNext()) {
            Object obj = it.next().m_matchedObject;
            if (max_level == obj) continue;
            if (obj instanceof ArrayDelimiterObject) {
                ArrayDelimiterObject ado = (ArrayDelimiterObject)obj;
                int ind = Math.min(max_level.m_level - ado.m_level, value_separators.length - 1);
                result.append(value_separators[ind]);
                continue;
            }
            result.append(this.m_matcher.m_feature_values.getFeatureImage(obj));
        }
        if (feat_name) {
            return this.m_matcher.m_feature_matcher.getFeaturePathImage() + value_separators[0] + result;
        }
        return result.toString();
    }
}

