/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.tools.cfe;

import java.io.IOException;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.uima.tools.cfe.BitsetFeatureValues;
import org.apache.uima.tools.cfe.EnumFeatureValues;
import org.apache.uima.tools.cfe.FeatureObjectMatcher;
import org.apache.uima.tools.cfe.GroupFeatureMatcher;
import org.apache.uima.tools.cfe.ObjectPathFeatureValues;
import org.apache.uima.tools.cfe.PartialObjectMatcher;
import org.apache.uima.tools.cfe.PatternFeatureValues;
import org.apache.uima.tools.cfe.RangeFeatureValues;
import org.apache.uima.tools.cfe.SingleFeatureMatcher;
import org.apache.uima.tools.cfe.TargetAnnotationDescriptor;
import org.apache.uima.tools.cfe.config.BitsetFeatureValuesXML;
import org.apache.uima.tools.cfe.config.CFEDescriptorXML;
import org.apache.uima.tools.cfe.config.DocumentRoot;
import org.apache.uima.tools.cfe.config.EnumFeatureValuesXML;
import org.apache.uima.tools.cfe.config.FeatureObjectMatcherXML;
import org.apache.uima.tools.cfe.config.GroupFeatureMatcherXML;
import org.apache.uima.tools.cfe.config.ObjectPathFeatureValuesXML;
import org.apache.uima.tools.cfe.config.PartialObjectMatcherXML;
import org.apache.uima.tools.cfe.config.PatternFeatureValuesXML;
import org.apache.uima.tools.cfe.config.RangeFeatureValuesXML;
import org.apache.uima.tools.cfe.config.SingleFeatureMatcherXML;
import org.apache.uima.tools.cfe.config.TargetAnnotationXML;
import org.apache.uima.tools.cfe.config.impl.ConfigFactoryImpl;
import org.apache.uima.tools.cfe.config.impl.ConfigPackageImpl;
import org.apache.uima.tools.cfe.config.util.ConfigResourceFactoryImpl;
import org.apache.uima.tools.cfe.config.util.ConfigResourceImpl;
import org.apache.uima.tools.cfe.config.util.ConfigResourceUtil;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CFEConfigFromXML_Ecore {
    private CFEDescriptorXML m_CFEDescriptor;
    private static boolean m_init = false;

    public CFEConfigFromXML_Ecore(String path) throws IOException {
        ConfigResourceUtil cru = ConfigResourceUtil.getInstance();
        DocumentRoot r = cru.load("file://" + path);
        this.m_CFEDescriptor = r.getCFEConfig();
    }

    private DocumentRoot load(String filename) throws IOException {
        if (!m_init) {
            Resource.Factory.Registry.INSTANCE.getExtensionToFactoryMap().put("xml", new ConfigResourceFactoryImpl());
            ConfigPackageImpl.init();
            ConfigFactoryImpl.init();
            m_init = true;
        }
        ConfigResourceImpl resource = (ConfigResourceImpl)new ConfigResourceFactoryImpl().createResource(URI.createURI((String)("file://" + filename)));
        resource.load(null);
        DocumentRoot documentRoot = (DocumentRoot)resource.getContents().get(0);
        return documentRoot;
    }

    public CFEConfigFromXML_Ecore(String path, boolean manual) throws IOException {
        DocumentRoot r = this.load(path);
        this.m_CFEDescriptor = r.getCFEConfig();
    }

    EnumFeatureValues getEnumFeatureValues(EnumFeatureValuesXML efvs_xml) throws IOException, URISyntaxException {
        EList<String> vals = efvs_xml.getValues();
        if (1 == vals.size() && ((String)vals.get(0)).startsWith("file://")) {
            return new EnumFeatureValues(new java.net.URI((String)vals.get(0)).getPath(), efvs_xml.isCaseSensitive());
        }
        return new EnumFeatureValues(vals.toArray(), efvs_xml.isCaseSensitive());
    }

    RangeFeatureValues getRangeFeatureValues(RangeFeatureValuesXML rfvs_xml) {
        String lb = ((String)rfvs_xml.getLowerBoundary()).trim();
        String ub = ((String)rfvs_xml.getUpperBoundary()).trim();
        return new RangeFeatureValues(Double.parseDouble(lb), rfvs_xml.isLowerBoundaryInclusive(), Double.parseDouble(ub), rfvs_xml.isUpperBoundaryInclusive());
    }

    BitsetFeatureValues getBitsetFeatureValues(BitsetFeatureValuesXML bfvs_xml) {
        return new BitsetFeatureValues(Integer.parseInt(bfvs_xml.getBitmask(), 16), bfvs_xml.isExactMatch());
    }

    PatternFeatureValues getPatternFeatureValues(PatternFeatureValuesXML pattern_xml) {
        return new PatternFeatureValues(pattern_xml.getPattern());
    }

    ObjectPathFeatureValues getObjectPathFeatureValues(ObjectPathFeatureValuesXML opfvs_xml, String feature_class) {
        return new ObjectPathFeatureValues(feature_class, opfvs_xml.getObjectPath());
    }

    SingleFeatureMatcher getSingleFeatureMatcher(SingleFeatureMatcherXML sfm_xml, String obj_class) throws SecurityException, NoSuchMethodException, ClassNotFoundException, IOException, URISyntaxException {
        if (null != sfm_xml.getEnumFeatureValues()) {
            return new SingleFeatureMatcher(sfm_xml.getFeatureTypeName(), obj_class + ":" + sfm_xml.getFeaturePath(), sfm_xml.isExclude(), sfm_xml.isQuiet(), this.getEnumFeatureValues(sfm_xml.getEnumFeatureValues()));
        }
        if (null != sfm_xml.getRangeFeatureValues()) {
            return new SingleFeatureMatcher(sfm_xml.getFeatureTypeName(), obj_class + ":" + sfm_xml.getFeaturePath(), sfm_xml.isExclude(), sfm_xml.isQuiet(), this.getRangeFeatureValues(sfm_xml.getRangeFeatureValues()));
        }
        if (null != sfm_xml.getBitsetFeatureValues()) {
            return new SingleFeatureMatcher(sfm_xml.getFeatureTypeName(), obj_class + ":" + sfm_xml.getFeaturePath(), sfm_xml.isExclude(), sfm_xml.isQuiet(), this.getBitsetFeatureValues(sfm_xml.getBitsetFeatureValues()));
        }
        if (null != sfm_xml.getPatternFeatureValues()) {
            return new SingleFeatureMatcher(sfm_xml.getFeatureTypeName(), obj_class + ":" + sfm_xml.getFeaturePath(), sfm_xml.isExclude(), sfm_xml.isQuiet(), this.getPatternFeatureValues(sfm_xml.getPatternFeatureValues()));
        }
        if (null != sfm_xml.getObjectPathFeatureValues()) {
            return new SingleFeatureMatcher(sfm_xml.getFeatureTypeName(), obj_class + ":" + sfm_xml.getFeaturePath(), sfm_xml.isExclude(), sfm_xml.isQuiet(), this.getObjectPathFeatureValues(sfm_xml.getObjectPathFeatureValues(), sfm_xml.getFeatureTypeName()));
        }
        return new SingleFeatureMatcher(sfm_xml.getFeatureTypeName(), obj_class + ":" + sfm_xml.getFeaturePath(), sfm_xml.isExclude(), sfm_xml.isQuiet(), new EnumFeatureValues());
    }

    GroupFeatureMatcher getGroupFeatureMatcher(GroupFeatureMatcherXML gfm_xml, String obj_class_name) throws SecurityException, NoSuchMethodException, ClassNotFoundException, IOException, URISyntaxException {
        EList<SingleFeatureMatcherXML> fms_xml = gfm_xml.getFeatureMatchers();
        ArrayList<SingleFeatureMatcher> sfms = new ArrayList<SingleFeatureMatcher>();
        Iterator fm_it = fms_xml.iterator();
        while (fm_it.hasNext()) {
            sfms.add(this.getSingleFeatureMatcher((SingleFeatureMatcherXML)fm_it.next(), obj_class_name));
        }
        return new GroupFeatureMatcher(sfms, gfm_xml.isExclude());
    }

    PartialObjectMatcher getPartialObjectMatcher(PartialObjectMatcherXML pom_xml) throws SecurityException, NoSuchMethodException, IOException, URISyntaxException, ClassNotFoundException {
        EList<GroupFeatureMatcherXML> gfms_xml = pom_xml.getGroupFeatureMatchers();
        ArrayList<GroupFeatureMatcher> gfms = new ArrayList<GroupFeatureMatcher>();
        Iterator it = gfms_xml.iterator();
        while (it.hasNext()) {
            gfms.add(this.getGroupFeatureMatcher((GroupFeatureMatcherXML)it.next(), pom_xml.getAnnotationTypeName()));
        }
        return new PartialObjectMatcher(pom_xml.getAnnotationTypeName(), pom_xml.getFullPath(), gfms);
    }

    FeatureObjectMatcher getFeatureObjectMatcher(FeatureObjectMatcherXML fom_xml) throws SecurityException, NoSuchMethodException, IOException, ClassNotFoundException, URISyntaxException {
        EList<GroupFeatureMatcherXML> gfms_xml = fom_xml.getGroupFeatureMatchers();
        ArrayList<GroupFeatureMatcher> gfms = new ArrayList<GroupFeatureMatcher>();
        Iterator it = gfms_xml.iterator();
        while (it.hasNext()) {
            gfms.add(this.getGroupFeatureMatcher((GroupFeatureMatcherXML)it.next(), fom_xml.getAnnotationTypeName()));
        }
        return new FeatureObjectMatcher(fom_xml.getAnnotationTypeName(), fom_xml.getFullPath(), gfms, fom_xml.getWindowsizeLeft(), fom_xml.getWindowsizeInside(), fom_xml.getWindowsizeRight(), fom_xml.getWindowsizeEnclosed(), fom_xml.getWindowFlags(), fom_xml.isOrientation(), fom_xml.isDistance());
    }

    TargetAnnotationDescriptor getTargetAnnotationDescriptor(TargetAnnotationXML ta_xml, int priorityOrder) throws SecurityException, NoSuchMethodException, IOException, ClassNotFoundException, URISyntaxException {
        PartialObjectMatcher ta_matcher = this.getPartialObjectMatcher(ta_xml.getTargetAnnotationMatcher());
        EList<FeatureObjectMatcherXML> fams_xml = ta_xml.getFeatureAnnotationMatchers();
        ArrayList<FeatureObjectMatcher> fams = new ArrayList<FeatureObjectMatcher>();
        Iterator it = fams_xml.iterator();
        while (it.hasNext()) {
            fams.add(this.getFeatureObjectMatcher((FeatureObjectMatcherXML)it.next()));
        }
        return new TargetAnnotationDescriptor(ta_xml.getClassName(), ta_xml.getEnclosingAnnotation(), ta_matcher, fams, priorityOrder);
    }

    public List<TargetAnnotationDescriptor> getTargetAnnotationDescriptors() throws SecurityException, NoSuchMethodException, IOException, ClassNotFoundException, URISyntaxException {
        ArrayList<TargetAnnotationDescriptor> result = new ArrayList<TargetAnnotationDescriptor>();
        EList<TargetAnnotationXML> tans = this.m_CFEDescriptor.getTargetAnnotations();
        Iterator it = tans.iterator();
        while (it.hasNext()) {
            result.add(this.getTargetAnnotationDescriptor((TargetAnnotationXML)it.next(), result.size() + 1));
        }
        return result;
    }

    public String getNullValueImage() {
        return this.m_CFEDescriptor.getNullValueImage();
    }
}

