/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.conceptMapper.support.tokens;

import java.util.regex.Pattern;
import org.apache.uima.analysis_engine.annotator.AnnotatorContext;
import org.apache.uima.analysis_engine.annotator.AnnotatorContextException;
import org.apache.uima.conceptMapper.Logger;
import org.apache.uima.conceptMapper.support.stemmer.Stemmer;

public class TokenNormalizer {
    private static Pattern CapPat = Pattern.compile("^[A-Z][a-z]+$");
    private static Pattern HasDigit = Pattern.compile("[0-9]");
    private static final String PARAM_REPLACE_COMMA_WITH_AND = "ReplaceCommaWithAND";
    public static final String PARAM_CASE_MATCH = "caseMatch";
    public static final String PARAM_STEMMER_CLASS = "Stemmer";
    public static final String PARAM_STEMMER_DICT = "StemmerDictionary";
    private boolean caseFoldAll;
    private boolean caseFoldInitCap;
    private boolean caseFoldDigit;
    private String CASE_INSENSITIVE = "insensitive";
    private String CASE_FOLD_DIGITS = "digitfold";
    private String CASE_IGNORE = "ignoreall";
    private Stemmer stemmer = null;
    private boolean replaceCommaWithAND;

    public TokenNormalizer(AnnotatorContext annotatorContext, Logger logger) throws AnnotatorContextException {
        Boolean replaceCommaWithANDObj = (Boolean)annotatorContext.getConfigParameterValue(PARAM_REPLACE_COMMA_WITH_AND);
        boolean replaceCommaWithAND = false;
        if (replaceCommaWithANDObj != null) {
            replaceCommaWithAND = replaceCommaWithANDObj;
        }
        String caseMatchParam = (String)annotatorContext.getConfigParameterValue(PARAM_CASE_MATCH);
        String stemmerParam = (String)annotatorContext.getConfigParameterValue(PARAM_STEMMER_CLASS);
        String stemmerDict = (String)annotatorContext.getConfigParameterValue(PARAM_STEMMER_DICT);
        this.replaceCommaWithAND = replaceCommaWithAND;
        this.setCaseFoldInitCap(false);
        this.setCaseFoldDigit(false);
        this.setCaseFoldAll(false);
        if (caseMatchParam != null) {
            if (caseMatchParam.equalsIgnoreCase(this.CASE_INSENSITIVE)) {
                this.setCaseFoldInitCap(true);
            } else if (caseMatchParam.equalsIgnoreCase(this.CASE_FOLD_DIGITS)) {
                this.setCaseFoldDigit(true);
            } else if (caseMatchParam.equalsIgnoreCase(this.CASE_IGNORE)) {
                this.setCaseFoldAll(true);
            }
        }
        if (stemmerParam != null) {
            try {
                Class<?> stemmerClass = Class.forName(stemmerParam);
                this.setStemmer((Stemmer)stemmerClass.newInstance());
                this.getStemmer().initialize(stemmerDict);
            }
            catch (Exception e) {
                logger.logError("Exception trying to instantiate stemmer class: '" + stemmerParam + "', original exception:" + e.getMessage());
                e.printStackTrace();
            }
        }
    }

    public Stemmer getStemmer() {
        return this.stemmer;
    }

    public void setStemmer(Stemmer stemmer) {
        this.stemmer = stemmer;
    }

    public boolean shouldStem() {
        return this.getStemmer() != null;
    }

    public boolean isCaseFoldAll() {
        return this.caseFoldAll;
    }

    public void setCaseFoldAll(boolean caseFoldAll) {
        this.caseFoldAll = caseFoldAll;
    }

    public boolean isCaseFoldDigit() {
        return this.caseFoldDigit;
    }

    public void setCaseFoldDigit(boolean caseFoldDigit) {
        this.caseFoldDigit = caseFoldDigit;
    }

    public boolean isCaseFoldInitCap() {
        return this.caseFoldInitCap;
    }

    public void setCaseFoldInitCap(boolean caseFoldInitCap) {
        this.caseFoldInitCap = caseFoldInitCap;
    }

    public boolean shouldFoldCase(String token) {
        return this.caseFoldAll || this.caseFoldInitCap && CapPat.matcher(token).matches() || this.caseFoldDigit && HasDigit.matcher(token).find();
    }

    public String foldCase(String token) {
        if (this.shouldFoldCase(token)) {
            return token.trim().toLowerCase();
        }
        return token;
    }

    public String stem(String token) {
        if (this.shouldStem()) {
            return this.getStemmer().stem(token.trim());
        }
        return token;
    }

    public String normalize(String token) {
        if (this.replaceCommaWithAND && token.equals(",")) {
            return this.stem(this.foldCase("and"));
        }
        return this.stem(this.foldCase(token));
    }
}

