/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.conceptMapper.support.dictionaryResource.annotatorAdaptor;

import java.io.IOException;
import java.net.MalformedURLException;
import java.util.Vector;
import org.apache.uima.UIMAFramework;
import org.apache.uima.analysis_engine.AnalysisEngine;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.cas.CAS;
import org.apache.uima.cas.FSIterator;
import org.apache.uima.cas.Feature;
import org.apache.uima.cas.Type;
import org.apache.uima.cas.TypeSystem;
import org.apache.uima.cas.text.AnnotationFS;
import org.apache.uima.conceptMapper.Logger;
import org.apache.uima.conceptMapper.support.dictionaryResource.DictionaryLoaderException;
import org.apache.uima.conceptMapper.support.dictionaryResource.DictionaryToken;
import org.apache.uima.conceptMapper.support.tokens.TokenFilter;
import org.apache.uima.conceptMapper.support.tokens.UnknownTypeException;
import org.apache.uima.resource.ResourceInitializationException;
import org.apache.uima.resource.ResourceManager;
import org.apache.uima.resource.ResourceSpecifier;
import org.apache.uima.util.InvalidXMLException;
import org.apache.uima.util.XMLInputSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnnotatorAdaptor {
    private ResourceSpecifier aeSpecifier;
    private AnalysisEngine ae;
    private CAS cas;
    private Vector<DictionaryToken> result;
    private TokenFilter tokenFilter;
    private String tokenTypeName;
    private Type tokenType;
    private Feature tokenTypeFeature;
    private Feature tokenClassFeature;
    private boolean typeSystemInitialized = false;
    private String langID;
    private Logger logger;

    public AnnotatorAdaptor(String analysisEngineDescriptorPath, Vector<DictionaryToken> result, String tokenTypeName, TokenFilter tokenFilter, String langID, Logger logger) throws DictionaryLoaderException {
        try {
            this.aeSpecifier = UIMAFramework.getXMLParser().parseResourceSpecifier(new XMLInputSource(analysisEngineDescriptorPath));
            this.tokenTypeName = tokenTypeName;
            this.tokenTypeFeature = tokenFilter.getTokenTypeFeature();
            this.tokenClassFeature = tokenFilter.getTokenClassFeature();
            this.tokenFilter = tokenFilter;
            this.langID = langID;
            this.result = result;
            this.logger = logger;
        }
        catch (InvalidXMLException e) {
            throw new DictionaryLoaderException(e);
        }
        catch (IOException e) {
            throw new DictionaryLoaderException(e);
        }
    }

    public void initCPM() throws DictionaryLoaderException {
        try {
            ResourceManager resMgr = UIMAFramework.newDefaultResourceManager();
            String dp = System.getProperty("uima.datapath");
            if (null != dp) {
                resMgr.setDataPath(dp);
            }
            this.ae = UIMAFramework.produceAnalysisEngine((ResourceSpecifier)this.aeSpecifier);
            this.cas = this.ae.newCAS();
        }
        catch (ResourceInitializationException e) {
            throw new DictionaryLoaderException(e);
        }
        catch (MalformedURLException e) {
            throw new DictionaryLoaderException(e);
        }
    }

    public void runCPM(String text) {
        this.cas.setDocumentText(text);
        this.cas.setDocumentLanguage(this.langID);
        try {
            this.ae.process(this.cas);
        }
        catch (AnalysisEngineProcessException e) {
            e.printStackTrace();
        }
        this.processCAS(this.cas);
        this.cas.reset();
    }

    private void processCAS(CAS cas) {
        if (cas != null) {
            try {
                this.result.clear();
                if (!this.typeSystemInitialized) {
                    TypeSystem typeSystem = cas.getTypeSystem();
                    this.tokenFilter.initTypes(typeSystem, false);
                    this.tokenType = typeSystem.getType(this.tokenTypeName);
                    this.typeSystemInitialized = true;
                }
                FSIterator tokenIter = cas.getIndexRepository().getAllIndexedFS(this.tokenType);
                while (tokenIter.hasNext()) {
                    AnnotationFS annotation = (AnnotationFS)tokenIter.next();
                    this.result.add(new DictionaryToken(annotation, this.tokenTypeFeature, this.tokenClassFeature));
                }
                if (this.result.size() == 0) {
                    this.logger.logWarning("Dictionary tokenization of: '" + cas.getDocumentText() + "' produced no tokens of type: '" + this.tokenType.getName() + "'");
                }
            }
            catch (UnknownTypeException e) {
                System.err.println(e.getMessage());
                e.printStackTrace();
            }
        }
    }
}

