/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.conceptMapper;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.uima.analysis_engine.ResultSpecification;
import org.apache.uima.analysis_engine.annotator.AnnotatorConfigurationException;
import org.apache.uima.analysis_engine.annotator.AnnotatorContext;
import org.apache.uima.analysis_engine.annotator.AnnotatorInitializationException;
import org.apache.uima.analysis_engine.annotator.AnnotatorProcessException;
import org.apache.uima.analysis_engine.annotator.Annotator_ImplBase;
import org.apache.uima.analysis_engine.annotator.TextAnnotator;
import org.apache.uima.cas.CAS;
import org.apache.uima.cas.FSIterator;
import org.apache.uima.cas.Feature;
import org.apache.uima.cas.FeatureStructure;
import org.apache.uima.cas.Type;
import org.apache.uima.cas.TypeSystem;
import org.apache.uima.cas.text.AnnotationFS;
import org.apache.uima.cas.text.AnnotationIndex;
import org.apache.uima.conceptMapper.Logger;
import org.apache.uima.conceptMapper.support.dictionaryResource.DictionaryResource;
import org.apache.uima.conceptMapper.support.dictionaryResource.EntryProperties;
import org.apache.uima.conceptMapper.support.tokens.TokenFilter;
import org.apache.uima.conceptMapper.support.tokens.TokenNormalizer;
import org.apache.uima.conceptMapper.support.tokens.UnknownTypeException;
import org.apache.uima.jcas.JCas;
import org.apache.uima.jcas.cas.FSArray;
import org.apache.uima.jcas.tcas.Annotation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConceptMapper
extends Annotator_ImplBase
implements TextAnnotator {
    public static final String PARAM_DICT_FILE = "DictionaryFile";
    public static final String PARAM_TOKENCLASSFEATURENAME = "TokenClassFeatureName";
    private String tokenClassFeatureName;
    public static final String PARAM_TOKENTYPEFEATURENAME = "TokenTypeFeatureName";
    private String tokenTypeFeatureName;
    public static final String PARAM_ANNOTATION_NAME = "ResultingAnnotationName";
    public static final String PARAM_ENCLOSINGSPAN = "ResultingEnclosingSpanName";
    private String resultEnclosingSpanName;
    private Feature resultEnclosingSpan;
    public static final String PARAM_MATCHEDFEATURE = "ResultingAnnotationMatchedTextFeature";
    private String resultMatchedTextFeatureName;
    private Feature resultMatchedTextFeature;
    public static final String PARAM_ATTRIBUTE_LIST = "AttributeList";
    public static final String PARAM_FEATURE_LIST = "FeatureList";
    public static final String PARAM_TOKENANNOTATION = "TokenAnnotation";
    private String tokenAnnotationName;
    public static final String PARAM_TOKENTEXTFEATURENAME = "TokenTextFeatureName";
    private String tokenTextFeatureName;
    private Feature tokenTextFeature;
    public static final String PARAM_TOKENCLASSWRITEBACKFEATURENAMES = "TokenClassWriteBackFeatureNames";
    private String[] tokenClassWriteBackFeatureNames;
    private Feature[] tokenClassWriteBackFeatures;
    public static final String PARAM_MATCHEDTOKENSFEATURENAME = "MatchedTokensFeatureName";
    private String matchedTokensFeatureName;
    private Feature matchedTokensFeature;
    public static final String PARAM_ORDERINDEPENDENTLOOKUP = "OrderIndependentLookup";
    private boolean sortElements;
    private static final int ContiguousMatch = 1;
    public static final String PARAMVALUE_CONTIGUOUSMATCH = "ContiguousMatch";
    private static final int SkipAnyMatch = 2;
    public static final String PARAMVALUE_SKIPANYMATCH = "SkipAnyMatch";
    private static final int SkipAnyMatchAllowOverlap = 3;
    public static final String PARAMVALUE_SKIPANYMATCHALLOWOVERLAP = "SkipAnyMatchAllowOverlap";
    private static final int DefaultSearchStrategy = 1;
    public static final String PARAM_SEARCHSTRATEGY = "SearchStrategy";
    private int searchStrategy = 1;
    public static final String PARAM_FINDALLMATCHES = "FindAllMatches";
    private boolean findAllMatches;
    private TokenNormalizer tokenNormalizer;
    private TokenFilter tokenFilter;
    protected String resultAnnotationName;
    protected Type resultAnnotationType;
    protected Type tokenType;
    protected Feature[] features;
    protected String[] featureNames;
    protected String[] attributeNames;
    private DictionaryResource dict;
    private static final String PARAM_DATA_BLOCK_FS = "SpanFeatureStructure";
    private String spanFeatureStructureName;
    private Type spanFeatureStructureType;
    private Logger logger;
    private JCas jcas;
    private static final String PARAM_TOKENIZERDESCRIPTOR = "TokenizerDescriptorPath";
    private static final String UNKNOWN_VALUE = "unknown";

    public void initialize(AnnotatorContext annotatorContext) throws AnnotatorConfigurationException, AnnotatorInitializationException {
        super.initialize(annotatorContext);
        try {
            this.logger = new Logger("ConceptMapper", annotatorContext.getLogger());
            this.tokenAnnotationName = (String)annotatorContext.getConfigParameterValue(PARAM_TOKENANNOTATION);
            String tokenizerDescriptor = (String)annotatorContext.getConfigParameterValue(PARAM_TOKENIZERDESCRIPTOR);
            this.tokenClassFeatureName = (String)annotatorContext.getConfigParameterValue(PARAM_TOKENCLASSFEATURENAME);
            this.tokenTypeFeatureName = (String)annotatorContext.getConfigParameterValue(PARAM_TOKENTYPEFEATURENAME);
            this.resultAnnotationName = (String)annotatorContext.getConfigParameterValue(PARAM_ANNOTATION_NAME);
            this.resultEnclosingSpanName = (String)annotatorContext.getConfigParameterValue(PARAM_ENCLOSINGSPAN);
            this.resultMatchedTextFeatureName = (String)annotatorContext.getConfigParameterValue(PARAM_MATCHEDFEATURE);
            this.featureNames = (String[])annotatorContext.getConfigParameterValue(PARAM_FEATURE_LIST);
            this.attributeNames = (String[])annotatorContext.getConfigParameterValue(PARAM_ATTRIBUTE_LIST);
            this.spanFeatureStructureName = (String)annotatorContext.getConfigParameterValue(PARAM_DATA_BLOCK_FS);
            this.tokenTextFeatureName = (String)annotatorContext.getConfigParameterValue(PARAM_TOKENTEXTFEATURENAME);
            this.tokenClassWriteBackFeatureNames = (String[])annotatorContext.getConfigParameterValue(PARAM_TOKENCLASSWRITEBACKFEATURENAMES);
            this.tokenAnnotationName = (String)annotatorContext.getConfigParameterValue(PARAM_TOKENANNOTATION);
            this.matchedTokensFeatureName = (String)annotatorContext.getConfigParameterValue(PARAM_MATCHEDTOKENSFEATURENAME);
            Boolean sortElementsParam = (Boolean)annotatorContext.getConfigParameterValue(PARAM_ORDERINDEPENDENTLOOKUP);
            this.sortElements = sortElementsParam == null ? false : sortElementsParam;
            this.searchStrategy = this.detectSearchStrategy((String)annotatorContext.getConfigParameterValue(PARAM_SEARCHSTRATEGY));
            Boolean findAllMatchesParam = (Boolean)annotatorContext.getConfigParameterValue(PARAM_FINDALLMATCHES);
            boolean bl = this.findAllMatches = findAllMatchesParam == null ? false : findAllMatchesParam;
            if (this.searchStrategy == 2) {
                this.sortElements = true;
            }
            if (this.featureNames.length != this.attributeNames.length) {
                throw new Exception("AttributeList and FeatureList are inconsistent");
            }
            this.tokenNormalizer = new TokenNormalizer(annotatorContext, this.logger);
            this.tokenFilter = new TokenFilter(this.tokenAnnotationName, this.tokenTypeFeatureName, this.tokenClassFeatureName, this.logger);
            this.tokenFilter.initConfig(annotatorContext);
            this.dict = (DictionaryResource)annotatorContext.getResourceObject(PARAM_DICT_FILE);
            if (!this.dict.isLoaded()) {
                this.dict.loadDictionaryContents(annotatorContext, this.logger, this.tokenAnnotationName, this.tokenTypeFeatureName, this.tokenClassFeatureName, tokenizerDescriptor);
            }
        }
        catch (Exception e) {
            throw new AnnotatorConfigurationException((Throwable)e);
        }
    }

    private int detectSearchStrategy(String strategyString) throws AnnotatorConfigurationException {
        if (strategyString == null || strategyString.equals("")) {
            return 1;
        }
        if (strategyString.equals(PARAMVALUE_CONTIGUOUSMATCH)) {
            return 1;
        }
        if (strategyString.equals(PARAMVALUE_SKIPANYMATCH)) {
            return 2;
        }
        if (strategyString.equals(PARAMVALUE_SKIPANYMATCHALLOWOVERLAP)) {
            return 3;
        }
        throw new AnnotatorConfigurationException();
    }

    public void typeSystemInit(TypeSystem typeSystem) throws AnnotatorConfigurationException, AnnotatorInitializationException {
        this.tokenType = typeSystem.getType(this.tokenAnnotationName);
        if (this.tokenType == null) {
            this.logger.logError("TokenAnnotation '" + this.tokenAnnotationName + "' specified, but does not exist");
            throw new AnnotatorInitializationException();
        }
        if (this.tokenTextFeatureName == null || this.tokenTextFeatureName.equals("")) {
            this.tokenTextFeature = null;
        } else {
            this.tokenTextFeature = this.tokenType.getFeatureByBaseName(this.tokenTextFeatureName);
            if (this.tokenTextFeature == null) {
                this.logger.logError("TokenTextFeatureName '" + this.tokenTextFeatureName + "' specified, but does not exist for type: " + this.tokenType.getName());
                throw new AnnotatorInitializationException();
            }
        }
        if (this.tokenClassWriteBackFeatureNames != null && this.tokenClassWriteBackFeatureNames.length > 0) {
            this.tokenClassWriteBackFeatures = new Feature[this.tokenClassWriteBackFeatureNames.length];
            for (int i = 0; i < this.tokenClassWriteBackFeatureNames.length; ++i) {
                this.tokenClassWriteBackFeatures[i] = this.tokenType.getFeatureByBaseName(this.tokenClassWriteBackFeatureNames[i]);
                if (this.tokenClassWriteBackFeatures[i] != null) continue;
                this.logger.logError("TokenClassWriteBackFeatureNames[" + i + "] '" + this.tokenClassWriteBackFeatureNames[i] + "' specified, but does not exist for type: " + this.tokenType.getName());
                throw new AnnotatorInitializationException();
            }
        } else {
            this.tokenClassWriteBackFeatures = null;
        }
        this.spanFeatureStructureType = typeSystem.getType(this.spanFeatureStructureName);
        if (this.spanFeatureStructureType == null) {
            this.logger.logError("SpanFeatureStructure '" + this.spanFeatureStructureName + "' specified, but does not exist for type: " + this.tokenType.getName());
            throw new AnnotatorInitializationException();
        }
        this.resultAnnotationType = typeSystem.getType(this.resultAnnotationName);
        if (this.resultAnnotationType == null) {
            this.logger.logError("ResultingAnnotationName '" + this.resultAnnotationName + "' specified, but does not exist");
            throw new AnnotatorInitializationException();
        }
        if (this.resultEnclosingSpanName == null || this.resultEnclosingSpanName.equals("")) {
            this.resultEnclosingSpan = null;
        } else {
            this.resultEnclosingSpan = this.resultAnnotationType.getFeatureByBaseName(this.resultEnclosingSpanName);
            if (this.resultEnclosingSpan == null) {
                this.logger.logError("ResultingEnclosingSpanName '" + this.resultEnclosingSpanName + "' specified, but does not exist for type: " + this.resultAnnotationType.getName());
                throw new AnnotatorInitializationException();
            }
        }
        if (this.resultMatchedTextFeatureName == null || this.resultMatchedTextFeatureName.equals("")) {
            this.resultMatchedTextFeature = null;
        } else {
            this.resultMatchedTextFeature = this.resultAnnotationType.getFeatureByBaseName(this.resultMatchedTextFeatureName);
            if (this.resultMatchedTextFeature == null) {
                this.logger.logError("ResultingAnnotationMatchedTextFeature '" + this.resultMatchedTextFeatureName + "' specified, but does not exist for type: " + this.resultAnnotationType.getName());
                throw new AnnotatorInitializationException();
            }
        }
        if (this.matchedTokensFeatureName == null || this.matchedTokensFeatureName.equals("")) {
            this.matchedTokensFeature = null;
        } else {
            this.matchedTokensFeature = this.resultAnnotationType.getFeatureByBaseName(this.matchedTokensFeatureName);
            if (this.matchedTokensFeature == null) {
                this.logger.logError("MatchedTokensFeatureName '" + this.matchedTokensFeatureName + "' specified, but does not exist for type: " + this.resultAnnotationType.getName());
                throw new AnnotatorInitializationException();
            }
        }
        int numFeatures = this.featureNames.length;
        this.features = new Feature[numFeatures];
        for (int i = 0; i < numFeatures; ++i) {
            this.features[i] = this.resultAnnotationType.getFeatureByBaseName(this.featureNames[i]);
            if (this.features[i] != null) continue;
            this.logger.logError("FeatureList[" + i + "] '" + this.featureNames[i] + "' specified, but does not exist for type: " + this.resultAnnotationType.getName());
            throw new AnnotatorInitializationException();
        }
        try {
            this.tokenFilter.initTypes(typeSystem);
        }
        catch (UnknownTypeException e) {
            throw new AnnotatorInitializationException((Throwable)e);
        }
    }

    public void process(CAS tcas, ResultSpecification aResultSpec) throws AnnotatorProcessException {
        try {
            this.setJCas(tcas.getJCas());
            AnnotationIndex dbIndex = tcas.getAnnotationIndex(this.spanFeatureStructureType);
            FSIterator spanIterator = dbIndex.iterator();
            AnnotationIndex tokenIndex = tcas.getAnnotationIndex(this.tokenType);
            block6: while (spanIterator.hasNext()) {
                ArrayList<AnnotationFS> tokens = new ArrayList<AnnotationFS>(2048);
                Annotation spanAnnotation = (Annotation)spanIterator.next();
                FSIterator tokenIter = tokenIndex.subiterator((AnnotationFS)spanAnnotation);
                while (tokenIter.hasNext()) {
                    AnnotationFS token = (AnnotationFS)tokenIter.next();
                    if (!this.tokenFilter.isOK_Token(token, this.tokenNormalizer)) continue;
                    tokens.add(token);
                }
                switch (this.searchStrategy) {
                    case 2: 
                    case 3: {
                        this.processTokenListSkipAny(this.searchStrategy, this.findAllMatches, tcas, tokens, spanAnnotation);
                        continue block6;
                    }
                    case 1: {
                        this.processTokenList(this.searchStrategy, this.findAllMatches, tcas, tokens, spanAnnotation);
                        continue block6;
                    }
                }
                this.processTokenList(this.searchStrategy, this.findAllMatches, tcas, tokens, spanAnnotation);
            }
        }
        catch (Exception e) {
            throw new AnnotatorProcessException((Throwable)e);
        }
    }

    private void setJCas(JCas jcas) {
        this.jcas = jcas;
    }

    private JCas getJCas() {
        return this.jcas;
    }

    private void processTokenListSkipAny(int searchStrategy, boolean findAllMatches, CAS tcas, ArrayList<AnnotationFS> tokens, Annotation spanAnnotation) {
        ArrayList<String> normalizedTokens = new ArrayList<String>();
        for (int whichToken = 0; whichToken < tokens.size(); ++whichToken) {
            AnnotationFS token = tokens.get(whichToken);
            String tokenText = this.getTokenText(token);
            String word = this.tokenNormalizer.normalize(tokenText);
            normalizedTokens.add(word);
        }
        this.findMatchesSkipAnyToken(searchStrategy, findAllMatches, tcas, tokens, normalizedTokens, this.findPotentialEntries(normalizedTokens, this.dict), spanAnnotation);
    }

    private Map<String, Collection<DictionaryResource.DictEntry>> findPotentialEntries(ArrayList<String> normalizedTokens, DictionaryResource dict) {
        HashMap<String, Collection<DictionaryResource.DictEntry>> potentialEntries = new HashMap<String, Collection<DictionaryResource.DictEntry>>();
        for (String word : normalizedTokens) {
            DictionaryResource.DictEntriesByLength entriesByLength;
            Collection<DictionaryResource.DictEntry> entries = potentialEntries.get(word);
            if (entries == null) {
                entries = new ArrayList<DictionaryResource.DictEntry>();
            }
            if ((entriesByLength = dict.getEntries(word)) != null) {
                int longest;
                int shortest = entriesByLength.getShortest();
                for (int currentLength = longest = entriesByLength.getLongest().intValue(); currentLength >= shortest; --currentLength) {
                    DictionaryResource.DictEntries dictEntries = entriesByLength.getEntries(currentLength);
                    if (dictEntries == null) continue;
                    ArrayList<DictionaryResource.DictEntry> entryItems = dictEntries.getEntries();
                    for (DictionaryResource.DictEntry entry : entryItems) {
                        if (!this.containsAll(normalizedTokens, entry.getElements()) || entries.contains(entry)) continue;
                        entries.add(entry);
                    }
                }
            }
            potentialEntries.put(word, entries);
        }
        return potentialEntries;
    }

    private boolean containsAll(List<String> container, String[] contained) {
        for (String item : contained) {
            if (container.contains(item)) continue;
            return false;
        }
        return true;
    }

    private void findMatchesSkipAnyToken(int searchStrategy, boolean findAllMatches, CAS tcas, ArrayList<AnnotationFS> tokens, ArrayList<String> normalizedTokens, Map<String, Collection<DictionaryResource.DictEntry>> potentialEntries, Annotation spanAnnotation) {
        int whichToken = 0;
        while (whichToken < normalizedTokens.size()) {
            Collection<DictionaryResource.DictEntry> entries = potentialEntries.get(normalizedTokens.get(whichToken));
            if (entries == null) {
                ++whichToken;
                continue;
            }
            Iterator<DictionaryResource.DictEntry> entryIter = entries.iterator();
            boolean foundMatch = false;
            while (entryIter.hasNext() && !foundMatch) {
                DictionaryResource.DictEntry entry = entryIter.next();
                if (!this.containsAll(normalizedTokens.subList(whichToken, normalizedTokens.size()), entry.getElements())) continue;
                int lengthOfMatch = this.processMatch(tcas, tokens, normalizedTokens, spanAnnotation, whichToken, entry);
                if (findAllMatches) continue;
                foundMatch = true;
                if (searchStrategy == 3) {
                    ++whichToken;
                    continue;
                }
                whichToken += lengthOfMatch;
            }
            if (foundMatch) continue;
            ++whichToken;
        }
    }

    private int processMatch(CAS tcas, ArrayList<AnnotationFS> tokens, ArrayList<String> normalizedTokens, Annotation spanAnnotation, int whichToken, DictionaryResource.DictEntry entry) {
        int startingPoint = whichToken;
        TreeMap<String, Integer> entryOccurences = this.findEntryOccurences(entry.getElements(), whichToken);
        int begin = -1;
        int end = 0;
        StringBuilder matchedText = new StringBuilder();
        ArrayList<AnnotationFS> matched = new ArrayList<AnnotationFS>();
        while (!entryOccurences.isEmpty() && whichToken < normalizedTokens.size()) {
            String currentTokenText = normalizedTokens.get(whichToken);
            Integer count = entryOccurences.get(currentTokenText);
            if (count != null) {
                if (matchedText.length() != 0) {
                    matchedText.append(' ');
                }
                matchedText.append(currentTokenText);
                AnnotationFS realToken = tokens.get(whichToken);
                begin = begin == -1 ? realToken.getBegin() : Math.min(begin, realToken.getBegin());
                end = Math.max(end, realToken.getEnd());
                matched.add(realToken);
                if (count == 1) {
                    entryOccurences.remove(currentTokenText);
                } else {
                    entryOccurences.put(currentTokenText, count - 1);
                }
            }
            ++whichToken;
        }
        if (entryOccurences.isEmpty()) {
            this.makeAnnotation(tcas, begin, end, entry.getProperties(), spanAnnotation, matchedText.toString(), matched, this.logger);
        }
        return whichToken - startingPoint;
    }

    private TreeMap<String, Integer> findEntryOccurences(String[] normalizedTokens, int whichToken) {
        TreeMap<String, Integer> result = new TreeMap<String, Integer>();
        for (String token : normalizedTokens) {
            Integer count = result.get(token);
            count = count == null ? Integer.valueOf(1) : Integer.valueOf(count + 1);
            result.put(token, count);
        }
        return result;
    }

    protected void processTokenList(int searchStrategy, boolean findAllMatches, CAS tcas, ArrayList<AnnotationFS> tokens, Annotation spanAnnotation) {
        int entryLength = 0;
        for (int whichToken = 0; whichToken < tokens.size(); whichToken += entryLength + 1) {
            AnnotationFS token = tokens.get(whichToken);
            String tokenText = this.getTokenText(token);
            entryLength = 0;
            String word = this.tokenNormalizer.normalize(tokenText);
            DictionaryResource.DictEntriesByLength entriesByLength = this.dict.getEntries(word);
            if (entriesByLength == null) continue;
            entryLength = Math.min(entriesByLength.getLongest(), tokens.size() - whichToken);
            entryLength = this.defaultMatcher(findAllMatches, tcas, tokens, spanAnnotation, whichToken, entryLength, token.getBegin(), entriesByLength, entriesByLength.getShortest());
        }
    }

    private int defaultMatcher(boolean findAllMatches, CAS tcas, ArrayList<AnnotationFS> tokens, Annotation spanAnnotation, int whichToken, int entryLength, int start, DictionaryResource.DictEntriesByLength lengthEntries, int minLength) {
        boolean entryFound = false;
        while (!entryFound && entryLength >= minLength) {
            String[] tokensToMatch = this.buildTokensToMatchArray(tokens, whichToken, entryLength, this.sortElements);
            DictionaryResource.DictEntries entriesByLength = lengthEntries.getEntries(entryLength);
            if (entriesByLength != null) {
                ArrayList<DictionaryResource.DictEntry> entries = entriesByLength.getEntries();
                Collection<DictionaryResource.DictEntry> resultEntries = this.findMatchingEntry(entries, tokensToMatch);
                Iterator<DictionaryResource.DictEntry> resultEntriesIterator = resultEntries.iterator();
                AnnotationFS endToken = tokens.get(whichToken + entryLength - 1);
                while (resultEntriesIterator.hasNext()) {
                    DictionaryResource.DictEntry dictEntry = resultEntriesIterator.next();
                    this.makeAnnotation(tcas, start, endToken.getEnd(), dictEntry.getProperties(), spanAnnotation, dictEntry.getUnsorted(), tokens.subList(whichToken, whichToken + entryLength), this.logger);
                    this.updateTokenAnnotations(tokens, whichToken, entryLength, dictEntry);
                    if (findAllMatches) continue;
                    entryFound = true;
                }
            }
            --entryLength;
        }
        if (!entryFound) {
            entryLength = 0;
        }
        return entryLength;
    }

    private void updateTokenAnnotations(ArrayList<AnnotationFS> tokens, int whichToken, int entryLength, DictionaryResource.DictEntry dictEntry) {
        if (this.tokenClassWriteBackFeatures != null) {
            for (int feature = 0; feature < this.tokenClassWriteBackFeatures.length; ++feature) {
                if (this.tokenClassWriteBackFeatures[feature] == null) continue;
                String propVal = dictEntry.getProperties().getProperty(this.tokenClassWriteBackFeatureNames[feature], UNKNOWN_VALUE);
                for (int i = whichToken; i < whichToken + entryLength; ++i) {
                    AnnotationFS tokenToUpdate = tokens.get(i);
                    tokenToUpdate.setStringValue(this.tokenClassWriteBackFeatures[feature], propVal);
                }
            }
        }
    }

    protected void makeAnnotation(CAS tcas, int start, int end, EntryProperties properties, Annotation spanAnnotation, String matchedText, Collection<AnnotationFS> matched, Logger log) {
        AnnotationFS annotation = tcas.createAnnotation(this.resultAnnotationType, start, end);
        if (this.resultEnclosingSpan != null) {
            annotation.setFeatureValue(this.resultEnclosingSpan, (FeatureStructure)spanAnnotation);
        }
        if (this.resultMatchedTextFeature != null) {
            annotation.setStringValue(this.resultMatchedTextFeature, matchedText);
        }
        if (this.matchedTokensFeature != null) {
            FSArray matchedTokens = new FSArray(this.getJCas(), matched.size());
            FeatureStructure[] featureStructArray = new FeatureStructure[matched.size()];
            matched.toArray(featureStructArray);
            matchedTokens.copyFromArray(featureStructArray, 0, 0, featureStructArray.length);
            annotation.setFeatureValue(this.matchedTokensFeature, (FeatureStructure)matchedTokens);
        }
        for (int featIndex = 0; featIndex < this.features.length; ++featIndex) {
            if (this.features[featIndex] != null) {
                annotation.setStringValue(this.features[featIndex], properties.getProperty(this.attributeNames[featIndex], UNKNOWN_VALUE));
                continue;
            }
            String message = "Feature '" + featIndex + "' not found in type '" + this.resultAnnotationName + "'";
            log.logWarning(message);
        }
        tcas.getIndexRepository().addFS((FeatureStructure)annotation);
    }

    private Collection<DictionaryResource.DictEntry> findMatchingEntry(ArrayList<DictionaryResource.DictEntry> entries, String[] tokensToMatch) {
        ArrayList<DictionaryResource.DictEntry> result = new ArrayList<DictionaryResource.DictEntry>();
        for (int i = 0; i < entries.size(); ++i) {
            DictionaryResource.DictEntry dictEntry = entries.get(i);
            String[] entryText = dictEntry.getElements();
            if (entryText.length != tokensToMatch.length) continue;
            boolean match = true;
            int item = 0;
            for (String entryTextItem : entryText) {
                if (!entryTextItem.equals(tokensToMatch[item])) {
                    match = false;
                    break;
                }
                ++item;
            }
            if (!match) continue;
            result.add(dictEntry);
        }
        return result;
    }

    private String[] buildTokensToMatchArray(ArrayList<AnnotationFS> tokens, int startIndex, int length, boolean sortElements) {
        Object[] elements = new String[length];
        for (int i = startIndex; i < length + startIndex; ++i) {
            AnnotationFS token = tokens.get(i);
            elements[i - startIndex] = this.tokenNormalizer.normalize(this.getTokenText(token));
        }
        if (sortElements) {
            Arrays.sort(elements);
        }
        return elements;
    }

    private String getTokenText(AnnotationFS token) {
        if (this.tokenTextFeature == null) {
            return token.getCoveredText();
        }
        return token.getStringValue(this.tokenTextFeature);
    }
}

