/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.cas.impl;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import org.apache.uima.cas.CASRuntimeException;
import org.apache.uima.cas.Marker;
import org.apache.uima.cas.impl.CASImpl;
import org.apache.uima.cas.impl.MarkerImpl;
import org.apache.uima.cas.impl.StringHeapDeserializationHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CASSerializer
implements Serializable {
    static final long serialVersionUID = -7972011651957420295L;
    public int[] heapArray = null;
    public int[] heapMetaData = null;
    public String[] stringTable;
    public int[] fsIndex;
    public byte[] byteHeapArray;
    public short[] shortHeapArray;
    public long[] longHeapArray;

    public void addNoMetaData(CASImpl casImpl) {
        this.addCAS(casImpl, false);
    }

    public void addCAS(CASImpl cas) {
        this.addCAS(cas, true);
    }

    public void addCAS(CASImpl cas, boolean addMetaData) {
        this.fsIndex = cas.getIndexedFSs();
        int heapSize = cas.getHeap().getCellsUsed();
        this.heapArray = new int[heapSize];
        System.arraycopy(cas.getHeap().heap, 0, this.heapArray, 0, heapSize);
        if (addMetaData) {
            this.heapMetaData = cas.getHeap().getMetaData();
        }
        this.stringTable = this.stringArrayListToArray(cas.getStringTable());
        int byteHeapSize = cas.getByteHeap().getSize();
        this.byteHeapArray = new byte[byteHeapSize];
        System.arraycopy(cas.getByteHeap().heap, 0, this.byteHeapArray, 0, byteHeapSize);
        int shortHeapSize = cas.getShortHeap().getSize();
        this.shortHeapArray = new short[shortHeapSize];
        System.arraycopy(cas.getShortHeap().heap, 0, this.shortHeapArray, 0, shortHeapSize);
        int longHeapSize = cas.getLongHeap().getSize();
        this.longHeapArray = new long[longHeapSize];
        System.arraycopy(cas.getLongHeap().heap, 0, this.longHeapArray, 0, longHeapSize);
    }

    public void addCAS(CASImpl cas, OutputStream ostream) {
        try {
            int i;
            DataOutputStream dos = new DataOutputStream(ostream);
            this.fsIndex = cas.getIndexedFSs();
            byte[] uima = new byte[]{85, 73, 77, 65};
            ByteBuffer buf = ByteBuffer.wrap(uima);
            int key = buf.asIntBuffer().get();
            int version = 1;
            dos.writeInt(key);
            dos.writeInt(version);
            int heapSize = cas.getHeap().getCellsUsed();
            dos.writeInt(heapSize);
            for (int i2 = 0; i2 < heapSize; ++i2) {
                dos.writeInt(cas.getHeap().heap[i2]);
            }
            StringHeapDeserializationHelper shdh = cas.getStringHeap().serialize();
            int stringHeapLength = shdh.charHeapPos;
            int stringListLength = 0;
            for (int i3 = 0; i3 < shdh.refHeap.length; i3 += 3) {
                int ref = shdh.refHeap[i3 + 2];
                if (ref == 0) continue;
                stringListLength += 1 + cas.getStringHeap().getStringForCode(ref).length();
            }
            int stringTotalLength = stringHeapLength + stringListLength;
            if (stringHeapLength == 0 && stringListLength > 0) {
                ++stringTotalLength;
            }
            dos.writeInt(stringTotalLength);
            if (stringTotalLength > 0) {
                if (shdh.charHeapPos > 0) {
                    dos.writeChars(String.valueOf(shdh.charHeap, 0, shdh.charHeapPos));
                } else if (stringListLength > 0) {
                    dos.writeChar(0);
                }
                if (stringTotalLength % 2 != 0) {
                    dos.writeChar(0);
                }
            }
            int refheapsz = (shdh.refHeap.length - 3) / 3 * 2;
            dos.writeInt(++refheapsz);
            dos.writeInt(0);
            for (i = 3; i < shdh.refHeap.length; i += 3) {
                dos.writeInt(shdh.refHeap[i + 0]);
                dos.writeInt(shdh.refHeap[i + 1]);
            }
            dos.writeInt(this.fsIndex.length);
            for (i = 0; i < this.fsIndex.length; ++i) {
                dos.writeInt(this.fsIndex[i]);
            }
            int byteheapsz = cas.getByteHeap().getSize();
            dos.writeInt(byteheapsz);
            for (int i4 = 0; i4 < cas.getByteHeap().getSize(); ++i4) {
                dos.writeByte(cas.getByteHeap().heap[i4]);
            }
            int align = (4 - byteheapsz % 4) % 4;
            for (int i5 = 0; i5 < align; ++i5) {
                dos.writeByte(0);
            }
            int shortheapsz = cas.getShortHeap().getSize();
            dos.writeInt(shortheapsz);
            for (int i6 = 0; i6 < cas.getShortHeap().getSize(); ++i6) {
                dos.writeShort(cas.getShortHeap().heap[i6]);
            }
            if (shortheapsz % 2 != 0) {
                dos.writeShort(0);
            }
            int longheapsz = cas.getLongHeap().getSize();
            dos.writeInt(longheapsz);
            for (int i7 = 0; i7 < cas.getLongHeap().getSize(); ++i7) {
                dos.writeLong(cas.getLongHeap().heap[i7]);
            }
        }
        catch (IOException e) {
            CASRuntimeException exception = new CASRuntimeException("BLOB_SERIALIZATION", new String[]{e.getMessage()});
            throw exception;
        }
    }

    public void addCAS(CASImpl cas, OutputStream ostream, Marker trackingMark) {
        try {
            int i;
            int i2;
            int i3;
            int i4;
            if (!trackingMark.isValid()) {
                CASRuntimeException exception = new CASRuntimeException("INVALID_MARKER", new String[]{"Invalid Marker."});
                throw exception;
            }
            MarkerImpl mark = (MarkerImpl)trackingMark;
            DataOutputStream dos = new DataOutputStream(ostream);
            this.fsIndex = cas.getDeltaIndexedFSs(mark);
            byte[] uima = new byte[]{85, 73, 77, 65};
            ByteBuffer buf = ByteBuffer.wrap(uima);
            int key = buf.asIntBuffer().get();
            int version = 2;
            dos.writeInt(key);
            dos.writeInt(version);
            int heapSize = cas.getHeap().getCellsUsed() - mark.nextFSId;
            dos.writeInt(heapSize);
            for (int i5 = mark.nextFSId; i5 < cas.getHeap().getCellsUsed(); ++i5) {
                dos.writeInt(cas.getHeap().heap[i5]);
            }
            StringHeapDeserializationHelper shdh = cas.getStringHeap().serialize(mark.nextStringHeapAddr);
            int stringHeapLength = shdh.charHeapPos;
            int stringListLength = 0;
            for (int i6 = 0; i6 < shdh.refHeap.length; i6 += 3) {
                int ref = shdh.refHeap[i6 + 2];
                if (ref == 0) continue;
                stringListLength += 1 + cas.getStringHeap().getStringForCode(ref).length();
            }
            int stringTotalLength = stringHeapLength + stringListLength;
            if (stringHeapLength == 0 && stringListLength > 0) {
                ++stringTotalLength;
            }
            dos.writeInt(stringTotalLength);
            if (stringTotalLength > 0) {
                if (shdh.charHeapPos > 0) {
                    dos.writeChars(String.valueOf(shdh.charHeap, 0, shdh.charHeapPos));
                } else if (stringListLength > 0) {
                    dos.writeChar(0);
                }
                if (stringTotalLength % 2 != 0) {
                    dos.writeChar(0);
                }
            }
            int refheapsz = (shdh.refHeap.length - 3) / 3 * 2;
            dos.writeInt(++refheapsz);
            dos.writeInt(0);
            for (int i7 = 3; i7 < shdh.refHeap.length; i7 += 3) {
                dos.writeInt(shdh.refHeap[i7 + 0]);
                dos.writeInt(shdh.refHeap[i7 + 1]);
            }
            int[] fsHeapModifiedAddrs = cas.getModifiedFSHeapAddrs().toArray();
            dos.writeInt(fsHeapModifiedAddrs.length);
            for (i4 = 0; i4 < fsHeapModifiedAddrs.length; ++i4) {
                dos.writeInt(fsHeapModifiedAddrs[i4]);
                dos.writeInt(cas.getHeapValue(fsHeapModifiedAddrs[i4]));
            }
            dos.writeInt(this.fsIndex.length);
            for (i4 = 0; i4 < this.fsIndex.length; ++i4) {
                dos.writeInt(this.fsIndex[i4]);
            }
            int byteheapsz = cas.getByteHeap().getSize() - mark.nextByteHeapAddr;
            dos.writeInt(byteheapsz);
            for (int i8 = mark.nextByteHeapAddr; i8 < cas.getByteHeap().getSize(); ++i8) {
                dos.writeByte(cas.getByteHeap().heap[i8]);
            }
            int align = (4 - byteheapsz % 4) % 4;
            for (int i9 = 0; i9 < align; ++i9) {
                dos.writeByte(0);
            }
            int shortheapsz = cas.getShortHeap().getSize() - mark.nextShortHeapAddr;
            dos.writeInt(shortheapsz);
            for (int i10 = mark.nextShortHeapAddr; i10 < cas.getShortHeap().getSize(); ++i10) {
                dos.writeShort(cas.getShortHeap().heap[i10]);
            }
            if (shortheapsz % 2 != 0) {
                dos.writeShort(0);
            }
            int longheapsz = cas.getLongHeap().getSize() - mark.nextLongHeapAddr;
            dos.writeInt(longheapsz);
            for (int i11 = mark.nextLongHeapAddr; i11 < cas.getLongHeap().getSize(); ++i11) {
                dos.writeLong(cas.getLongHeap().heap[i11]);
            }
            int[] byteHeapModifiedAddrs = cas.getModifiedByteHeapAddrs().toArray();
            byte[] byteValues = new byte[byteHeapModifiedAddrs.length];
            dos.writeInt(byteHeapModifiedAddrs.length);
            for (i3 = 0; i3 < byteHeapModifiedAddrs.length; ++i3) {
                dos.writeInt(byteHeapModifiedAddrs[i3]);
                byteValues[i3] = cas.getByteHeap().getHeapValue(byteHeapModifiedAddrs[i3]);
            }
            for (i3 = 0; i3 < byteValues.length; ++i3) {
                dos.writeByte(cas.getByteHeap().getHeapValue(byteHeapModifiedAddrs[i3]));
            }
            align = (4 - byteheapsz % 4) % 4;
            for (i3 = 0; i3 < align; ++i3) {
                dos.writeByte(0);
            }
            int[] shortHeapModifiedAddrs = cas.getModifiedShortHeapAddrs().toArray();
            short[] shortValues = new short[shortHeapModifiedAddrs.length];
            dos.writeInt(shortHeapModifiedAddrs.length);
            for (i2 = 0; i2 < shortHeapModifiedAddrs.length; ++i2) {
                dos.writeShort(shortHeapModifiedAddrs[i2]);
                shortValues[i2] = cas.getShortHeap().getHeapValue(shortHeapModifiedAddrs[i2]);
            }
            for (i2 = 0; i2 < shortValues.length; ++i2) {
                dos.writeShort(cas.getShortHeap().getHeapValue(shortHeapModifiedAddrs[i2]));
            }
            if (shortheapsz % 2 != 0) {
                dos.writeShort(0);
            }
            int[] longHeapModifiedAddrs = cas.getModifiedShortHeapAddrs().toArray();
            long[] longValues = new long[longHeapModifiedAddrs.length];
            dos.writeInt(longHeapModifiedAddrs.length);
            for (i = 0; i < longHeapModifiedAddrs.length; ++i) {
                dos.writeShort(longHeapModifiedAddrs[i]);
                longValues[i] = cas.getLongHeap().getHeapValue(longHeapModifiedAddrs[i]);
            }
            for (i = 0; i < longValues.length; ++i) {
                dos.writeLong(cas.getLongHeap().getHeapValue(longHeapModifiedAddrs[i]));
            }
        }
        catch (IOException e) {
            CASRuntimeException exception = new CASRuntimeException("BLOB_SERIALIZATION", new String[]{e.getMessage()});
            throw exception;
        }
    }

    private String[] stringArrayListToArray(ArrayList<String> arrayList) {
        int max = arrayList.size();
        String[] ar = new String[max];
        for (int i = 0; i < max; ++i) {
            ar[i] = arrayList.get(i);
        }
        return ar;
    }

    int[] getHeapMetadata() {
        return this.heapMetaData;
    }

    int[] getHeapArray() {
        return this.heapArray;
    }

    String[] getStringTable() {
        return this.stringTable;
    }

    int[] getFSIndex() {
        return this.fsIndex;
    }

    byte[] getByteArray() {
        return this.byteHeapArray;
    }

    short[] getShortArray() {
        return this.shortHeapArray;
    }

    long[] getLongArray() {
        return this.longHeapArray;
    }
}

