/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.tika;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.apache.uima.cas.CAS;
import org.apache.uima.cas.CASException;
import org.apache.uima.cas.FeatureStructure;
import org.apache.uima.cas.Type;
import org.apache.uima.jcas.JCas;
import org.apache.uima.jcas.cas.FSArray;
import org.apache.uima.tika.AttributeFS;
import org.apache.uima.tika.MarkupAnnotation;
import org.apache.uima.tika.ProtoAnnotation;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;

public class MarkupHandler
implements ContentHandler {
    private StringBuffer textBuffer = new StringBuffer();
    private List<ProtoAnnotation> protoAnnotations = new LinkedList<ProtoAnnotation>();
    private LinkedList<ProtoAnnotation> startedAnnotations = new LinkedList();

    public void characters(char[] ch, int start, int length) throws SAXException {
        for (int c = start; c < start + length; ++c) {
            if (!Character.isISOControl(ch[c]) || Character.isWhitespace(ch[c])) continue;
            ch[c] = 32;
        }
        this.textBuffer.append(ch, start, length);
    }

    public void startDocument() throws SAXException {
    }

    public void endDocument() throws SAXException {
        if (this.startedAnnotations.size() != 0) {
            // empty if block
        }
    }

    public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
        int startOffset = this.textBuffer.length();
        ProtoAnnotation proto = new ProtoAnnotation(uri, localName, qName, atts, startOffset);
        this.startedAnnotations.addLast(proto);
    }

    public void endElement(String uri, String localName, String qName) throws SAXException {
        int endOffset = this.textBuffer.length();
        Iterator iter = this.startedAnnotations.iterator();
        ProtoAnnotation startedAnnot = null;
        while (iter.hasNext()) {
            ProtoAnnotation temp = (ProtoAnnotation)iter.next();
            if (!temp.getLocalName().equals(localName)) continue;
            startedAnnot = temp;
            break;
        }
        if (startedAnnot == null) {
            return;
        }
        startedAnnot.setEnd(endOffset);
        this.startedAnnotations.remove(startedAnnot);
        this.protoAnnotations.add(startedAnnot);
        this.textBuffer.append("\n");
    }

    public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
    }

    public void startPrefixMapping(String prefix, String uri) throws SAXException {
    }

    public void endPrefixMapping(String prefix) throws SAXException {
    }

    public void setDocumentLocator(Locator locator) {
    }

    public void skippedEntity(String name) throws SAXException {
    }

    public void processingInstruction(String target, String data) throws SAXException {
    }

    public void populateCAS(CAS cas) {
        JCas jcas;
        cas.setDocumentText(this.textBuffer.toString());
        Type markupType = cas.getTypeSystem().getType("org.apache.uima.tika.MarkupAnnotation");
        Type attributeType = cas.getTypeSystem().getType("org.apache.uima.tika.AttributeFS");
        if (attributeType == null) {
            throw new RuntimeException("Can't find type org.apache.uima.tika.AttributeFS");
        }
        try {
            jcas = cas.getJCas();
        }
        catch (CASException e) {
            throw new RuntimeException(e);
        }
        for (ProtoAnnotation proto : this.protoAnnotations) {
            MarkupAnnotation markup = new MarkupAnnotation(jcas);
            markup.setBegin(proto.getStart());
            markup.setEnd(proto.getEnd());
            Attributes protoAttributes = proto.getAtts();
            FSArray attribs = (FSArray)cas.createArrayFS(protoAttributes.getLength());
            for (int index = 0; index < protoAttributes.getLength(); ++index) {
                AttributeFS afs = (AttributeFS)cas.createFS(attributeType);
                afs.setLocalName(protoAttributes.getLocalName(index));
                afs.setQualifiedName(protoAttributes.getQName(index));
                afs.setUri(protoAttributes.getURI(index));
                afs.setValue(protoAttributes.getValue(index));
                afs.addToIndexes();
                attribs.set(index, (FeatureStructure)afs);
            }
            markup.setAttributes(attribs);
            markup.setUri(proto.getUri());
            markup.setName(proto.getLocalName());
            markup.setQualifiedName(proto.getQName());
            markup.addToIndexes();
        }
    }
}

