/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ruta.example.extensions;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import org.apache.uima.cas.Type;
import org.apache.uima.cas.TypeSystem;
import org.apache.uima.cas.text.AnnotationFS;
import org.apache.uima.ruta.RutaStream;
import org.apache.uima.ruta.action.AbstractRutaAction;
import org.apache.uima.ruta.expression.number.INumberExpression;
import org.apache.uima.ruta.rule.AbstractRuleMatch;
import org.apache.uima.ruta.rule.MatchContext;
import org.apache.uima.ruta.rule.RuleElement;
import org.apache.uima.ruta.rule.RuleMatch;
import org.apache.uima.ruta.visitor.InferenceCrowd;

public class ExampleAction
extends AbstractRutaAction {
    private List<INumberExpression> indexExprList;

    public ExampleAction(List<INumberExpression> indexExprList) {
        this.indexExprList = indexExprList;
    }

    public void execute(MatchContext context, RutaStream stream, InferenceCrowd crowd) {
        RuleMatch match = context.getRuleMatch();
        RuleElement element = context.getElement();
        ArrayList<Integer> indexes = new ArrayList<Integer>();
        for (INumberExpression each : this.indexExprList) {
            int integerValue = each.getIntegerValue(context, stream);
            indexes.add(integerValue);
        }
        List ruleElements = element.getContainer().getRuleElements();
        for (Integer each : indexes) {
            if (each <= 0 || each > ruleElements.size()) continue;
            Type type = this.getRandomType(stream);
            RuleElement ruleElement = (RuleElement)ruleElements.get(each - 1);
            List matchedAnnotationsOf = match.getMatchedAnnotationsOfElement(ruleElement);
            for (AnnotationFS eachMatched : matchedAnnotationsOf) {
                AnnotationFS newAFS = stream.getCas().createAnnotation(type, eachMatched.getBegin(), eachMatched.getEnd());
                stream.addAnnotation(newAFS, true, (AbstractRuleMatch)match);
            }
        }
    }

    private Type getRandomType(RutaStream stream) {
        Type annotationType = stream.getCas().getTypeSystem().getType("org.apache.uima.ruta.type.TokenSeed");
        TypeSystem typeSystem = stream.getCas().getTypeSystem();
        List subsumedTypes = typeSystem.getProperlySubsumedTypes(annotationType);
        Random r = new Random();
        int nextInt = r.nextInt(subsumedTypes.size());
        return (Type)subsumedTypes.get(nextInt);
    }

    public List<INumberExpression> getIndexExprList() {
        return this.indexExprList;
    }

    public void setIndexExprList(List<INumberExpression> indexExprList) {
        this.indexExprList = indexExprList;
    }
}

