/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ruta.verbalize;

import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.uima.ruta.action.AbstractRutaAction;
import org.apache.uima.ruta.action.AddAction;
import org.apache.uima.ruta.action.AddFilterTypeAction;
import org.apache.uima.ruta.action.AddRetainTypeAction;
import org.apache.uima.ruta.action.AssignAction;
import org.apache.uima.ruta.action.CallAction;
import org.apache.uima.ruta.action.ClearAction;
import org.apache.uima.ruta.action.ColorAction;
import org.apache.uima.ruta.action.ConfigureAction;
import org.apache.uima.ruta.action.CreateAction;
import org.apache.uima.ruta.action.DelAction;
import org.apache.uima.ruta.action.DynamicAnchoringAction;
import org.apache.uima.ruta.action.ExecAction;
import org.apache.uima.ruta.action.FillAction;
import org.apache.uima.ruta.action.FilterTypeAction;
import org.apache.uima.ruta.action.GatherAction;
import org.apache.uima.ruta.action.GetAction;
import org.apache.uima.ruta.action.GetFeatureAction;
import org.apache.uima.ruta.action.GetListAction;
import org.apache.uima.ruta.action.GreedyAnchoringAction;
import org.apache.uima.ruta.action.ImplicitFeatureAction;
import org.apache.uima.ruta.action.ImplicitMarkAction;
import org.apache.uima.ruta.action.ImplicitVariableAssignmentAction;
import org.apache.uima.ruta.action.LogAction;
import org.apache.uima.ruta.action.MacroAction;
import org.apache.uima.ruta.action.MarkAction;
import org.apache.uima.ruta.action.MarkFastAction;
import org.apache.uima.ruta.action.MarkFirstAction;
import org.apache.uima.ruta.action.MarkLastAction;
import org.apache.uima.ruta.action.MarkOnceAction;
import org.apache.uima.ruta.action.MarkTableAction;
import org.apache.uima.ruta.action.MatchedTextAction;
import org.apache.uima.ruta.action.MergeAction;
import org.apache.uima.ruta.action.RemoveAction;
import org.apache.uima.ruta.action.RemoveDuplicateAction;
import org.apache.uima.ruta.action.RemoveFilterTypeAction;
import org.apache.uima.ruta.action.RemoveRetainTypeAction;
import org.apache.uima.ruta.action.ReplaceAction;
import org.apache.uima.ruta.action.RetainTypeAction;
import org.apache.uima.ruta.action.SetFeatureAction;
import org.apache.uima.ruta.action.ShiftAction;
import org.apache.uima.ruta.action.SplitAction;
import org.apache.uima.ruta.action.TransferAction;
import org.apache.uima.ruta.action.TrieAction;
import org.apache.uima.ruta.action.TrimAction;
import org.apache.uima.ruta.action.UnmarkAction;
import org.apache.uima.ruta.action.UnmarkAllAction;
import org.apache.uima.ruta.expression.IRutaExpression;
import org.apache.uima.ruta.expression.bool.IBooleanExpression;
import org.apache.uima.ruta.expression.number.INumberExpression;
import org.apache.uima.ruta.expression.resource.WordTableExpression;
import org.apache.uima.ruta.expression.string.IStringExpression;
import org.apache.uima.ruta.expression.type.AbstractTypeListExpression;
import org.apache.uima.ruta.expression.type.ITypeExpression;
import org.apache.uima.ruta.verbalize.RutaVerbalizer;

public class ActionVerbalizer {
    private RutaVerbalizer verbalizer;

    public ActionVerbalizer(RutaVerbalizer verbalizer) {
        this.verbalizer = verbalizer;
    }

    public String verbalizeName(AbstractRutaAction action) {
        if (action instanceof AddAction) {
            return "ADD";
        }
        if (action instanceof AssignAction) {
            return "ASSIGN";
        }
        if (action instanceof ExecAction) {
            return "EXEC";
        }
        if (action instanceof CallAction) {
            return "CALL";
        }
        if (action instanceof ColorAction) {
            return "COLOR";
        }
        if (action instanceof CreateAction) {
            return "CREATE";
        }
        if (action instanceof DelAction) {
            return "DEL";
        }
        if (action instanceof FillAction) {
            return "FILL";
        }
        if (action instanceof FilterTypeAction) {
            return "FILTERTYPE";
        }
        if (action instanceof AddFilterTypeAction) {
            return "ADDFILTERTYPE";
        }
        if (action instanceof RemoveFilterTypeAction) {
            return "REMOVEFILTERTYPE";
        }
        if (action instanceof LogAction) {
            return "LOG";
        }
        if (action instanceof MarkOnceAction) {
            return "MARKONCE";
        }
        if (action instanceof ShiftAction) {
            return "SHIFT";
        }
        if (action instanceof MarkAction) {
            MarkAction a = (MarkAction)action;
            if (a.getScore() != null) {
                return "MARKSCORE";
            }
            return "MARK";
        }
        if (action instanceof MarkFastAction) {
            return "MARKFAST";
        }
        if (action instanceof MarkLastAction) {
            return "MARKLAST";
        }
        if (action instanceof MarkFirstAction) {
            return "MARKFIRST";
        }
        if (action instanceof ReplaceAction) {
            return "REPLACE";
        }
        if (action instanceof RetainTypeAction) {
            return "RETAINTYPE";
        }
        if (action instanceof AddRetainTypeAction) {
            return "ADDRETAINTYPE";
        }
        if (action instanceof RemoveRetainTypeAction) {
            return "REMOVERETAINTYPE";
        }
        if (action instanceof SetFeatureAction) {
            String name = "SETFEATURE";
            return name;
        }
        if (action instanceof GetFeatureAction) {
            String name = "GETFEATURE";
            return name;
        }
        if (action instanceof UnmarkAction) {
            return "UNMARK";
        }
        if (action instanceof TransferAction) {
            return "TRANSFER";
        }
        if (action instanceof TrieAction) {
            return "TRIE";
        }
        if (action instanceof GatherAction) {
            return "GATHER";
        }
        if (action instanceof MergeAction) {
            return "MERGE";
        }
        if (action instanceof GetAction) {
            return "GET";
        }
        if (action instanceof RemoveAction) {
            return "REMOVE";
        }
        if (action instanceof RemoveDuplicateAction) {
            return "REMOVEDUPLICATE";
        }
        if (action instanceof ClearAction) {
            return "CLEAR";
        }
        if (action instanceof ConfigureAction) {
            return "CONFIGURE";
        }
        if (action instanceof DynamicAnchoringAction) {
            return "DYNAMICANCHORING";
        }
        if (action instanceof GreedyAnchoringAction) {
            return "GREEDYANCHORING";
        }
        if (action instanceof GetListAction) {
            return "GETLIST";
        }
        if (action instanceof MarkTableAction) {
            return "MARKTABLE";
        }
        if (action instanceof MatchedTextAction) {
            return "MATCHEDTEXT";
        }
        if (action instanceof RemoveDuplicateAction) {
            return "REMOVEDUPLICATE";
        }
        if (action instanceof UnmarkAllAction) {
            return "UNMARKALL";
        }
        if (action instanceof TrimAction) {
            return "TRIM";
        }
        if (action instanceof SplitAction) {
            return "SPLIT";
        }
        if (action instanceof ImplicitMarkAction) {
            return "";
        }
        if (action instanceof ImplicitFeatureAction) {
            return "";
        }
        if (action instanceof ImplicitVariableAssignmentAction) {
            return "";
        }
        if (action instanceof MacroAction) {
            MacroAction ma = (MacroAction)action;
            return ma.getName();
        }
        return action.getClass().getSimpleName();
    }

    public String verbalize(AbstractRutaAction action) {
        String name = this.verbalizeName(action) + "(";
        if (action instanceof AssignAction) {
            AssignAction a = (AssignAction)action;
            return name + a.getVar() + ", " + this.verbalizer.verbalize(a.getExpression()) + ")";
        }
        if (action instanceof ExecAction) {
            ExecAction a = (ExecAction)action;
            AbstractTypeListExpression typeList = a.getTypeList();
            String types = typeList == null ? "" : ", " + this.verbalizer.verbalize(typeList);
            String view = a.getView() == null ? "" : this.verbalizer.verbalize(a.getView()) + ", ";
            return name + view + a.getNamespace() + types + ")";
        }
        if (action instanceof CallAction) {
            CallAction a = (CallAction)action;
            return name + a.getNamespace() + ")";
        }
        if (action instanceof ColorAction) {
            ColorAction a = (ColorAction)action;
            return name + this.verbalizer.verbalize(a.getType()) + ", " + this.verbalizer.verbalize(a.getBgColor()) + ", " + this.verbalizer.verbalize(a.getFgColor()) + ", " + this.verbalizer.verbalize(a.getSelected()) + ")";
        }
        if (action instanceof CreateAction) {
            String feats;
            CreateAction a = (CreateAction)action;
            StringBuilder features = new StringBuilder();
            if (a.getFeatures() != null) {
                features.append(", ");
                for (Map.Entry<IStringExpression, IRutaExpression> each : a.getFeatures().entrySet()) {
                    features.append(this.verbalizer.verbalize(each.getKey()));
                    features.append(" = ");
                    features.append(this.verbalizer.verbalize(each.getValue()));
                    features.append(", ");
                }
            }
            if ((feats = features.toString()).endsWith(", ")) {
                feats = feats.substring(0, features.length() - 2);
            }
            Object indexes = "";
            if (a.getIndexes() != null) {
                indexes = (String)indexes + ", ";
                indexes = (String)indexes + this.verbalizer.verbalizeExpressionList(a.getIndexes());
            }
            return name + this.verbalizer.verbalize(a.getStructureType()) + (String)indexes + feats + ")";
        }
        if (action instanceof GatherAction) {
            GatherAction a = (GatherAction)action;
            Object features = "";
            if (a.getFeatures() != null) {
                features = (String)features + ", ";
                for (IStringExpression each : a.getFeatures().keySet()) {
                    features = (String)features + this.verbalizer.verbalize(each);
                    features = (String)features + " = ";
                    features = (String)features + this.verbalizer.verbalize(a.getFeatures().get(each));
                    features = (String)features + ", ";
                }
            }
            if (((String)features).endsWith(", ")) {
                features = ((String)features).substring(0, ((String)features).length() - 2);
            }
            Object indexes = "";
            if (a.getIndexes() != null) {
                indexes = (String)indexes + ", ";
                indexes = this.verbalizer.verbalizeExpressionList(a.getIndexes());
            }
            if (((String)indexes).endsWith(", ") && !a.getFeatures().isEmpty()) {
                indexes = ((String)indexes).substring(0, ((String)features).length() - 1);
            }
            return name + this.verbalizer.verbalize(a.getStructureType()) + ", " + (String)indexes + (String)features + ")";
        }
        if (action instanceof DelAction) {
            return "DEL";
        }
        if (action instanceof FillAction) {
            FillAction a = (FillAction)action;
            Object features = "";
            if (a.getFeatures() != null) {
                features = (String)features + ", ";
                for (IStringExpression each : a.getFeatures().keySet()) {
                    features = (String)features + this.verbalizer.verbalize(each);
                    features = (String)features + " = ";
                    features = (String)features + this.verbalizer.verbalize(a.getFeatures().get(each));
                    features = (String)features + ", ";
                }
            }
            if (((String)features).endsWith(", ")) {
                features = ((String)features).substring(0, ((String)features).length() - 2);
            }
            return name + this.verbalizer.verbalize(a.getStructureType()) + (String)features + ")";
        }
        if (action instanceof FilterTypeAction) {
            FilterTypeAction a = (FilterTypeAction)action;
            return a.getList().isEmpty() ? "FILTERTYPE" : "FILTERTYPE(" + this.verbalizer.verbalizeExpressionList(a.getList()) + ")";
        }
        if (action instanceof AddFilterTypeAction) {
            AddFilterTypeAction a = (AddFilterTypeAction)action;
            return name + this.verbalizer.verbalizeExpressionList(a.getList()) + ")";
        }
        if (action instanceof RemoveFilterTypeAction) {
            RemoveFilterTypeAction a = (RemoveFilterTypeAction)action;
            return name + this.verbalizer.verbalizeExpressionList(a.getList()) + ")";
        }
        if (action instanceof LogAction) {
            LogAction a = (LogAction)action;
            return name + this.verbalizer.verbalize(a.getText()) + ", " + String.valueOf(a.getLevel()) + ")";
        }
        if (action instanceof MarkOnceAction) {
            MarkOnceAction a = (MarkOnceAction)action;
            Object string = "";
            if (a.getList() != null && !a.getList().isEmpty()) {
                string = ", " + this.verbalizer.verbalizeExpressionList(a.getList());
            }
            return name + this.verbalizer.verbalize(a.getType()) + (String)string + ")";
        }
        if (action instanceof ShiftAction) {
            ShiftAction a = (ShiftAction)action;
            Object string = "";
            if (a.getList() != null && !a.getList().isEmpty()) {
                string = ", " + this.verbalizer.verbalizeExpressionList(a.getList());
            }
            Object all = "";
            if (a.getAll() != null) {
                all = ", " + this.verbalizer.verbalize(a.getAll());
            }
            return name + this.verbalizer.verbalize(a.getType()) + (String)string + (String)all + ")";
        }
        if (action instanceof MarkAction) {
            MarkAction a = (MarkAction)action;
            if (a.getScore() != null) {
                Object score = this.verbalizer.verbalize(a.getScore());
                if (!"".equals(score)) {
                    score = (String)score + ", ";
                }
                Object string = "";
                if (a.getList() != null && !a.getList().isEmpty()) {
                    string = ", " + this.verbalizer.verbalizeExpressionList(a.getList());
                }
                return name + (String)score + this.verbalizer.verbalize(a.getType()) + (String)string + ")";
            }
            Object string = "";
            if (a.getList() != null && !a.getList().isEmpty()) {
                string = ", " + this.verbalizer.verbalizeExpressionList(a.getList());
            }
            return name + this.verbalizer.verbalize(a.getType()) + (String)string + ")";
        }
        if (action instanceof MarkFastAction) {
            MarkFastAction a = (MarkFastAction)action;
            String list = "";
            if (a.getList() != null) {
                list = this.verbalizer.verbalize(a.getList());
            } else if (a.getStringList() != null) {
                list = this.verbalizer.verbalize(a.getStringList());
            }
            return name + this.verbalizer.verbalize(a.getType()) + ", " + list + ", " + this.verbalizer.verbalize(a.getIgnore()) + ", " + this.verbalizer.verbalize(a.getIgnoreLength()) + ", " + this.verbalizer.verbalize(a.getIgnoreWS()) + ")";
        }
        if (action instanceof MarkLastAction) {
            MarkLastAction a = (MarkLastAction)action;
            return name + this.verbalizer.verbalize(a.getType()) + ")";
        }
        if (action instanceof MarkFirstAction) {
            MarkFirstAction a = (MarkFirstAction)action;
            return name + this.verbalizer.verbalize(a.getType()) + ")";
        }
        if (action instanceof ReplaceAction) {
            ReplaceAction a = (ReplaceAction)action;
            return name + this.verbalizer.verbalize(a.getReplacement()) + ")";
        }
        if (action instanceof RetainTypeAction) {
            RetainTypeAction a = (RetainTypeAction)action;
            return a.getList().isEmpty() ? "RETAINTYPE" : "RETAINTYPE(" + this.verbalizer.verbalizeExpressionList(a.getList()) + ")";
        }
        if (action instanceof AddRetainTypeAction) {
            AddRetainTypeAction a = (AddRetainTypeAction)action;
            return name + this.verbalizer.verbalizeExpressionList(a.getList()) + ")";
        }
        if (action instanceof RemoveRetainTypeAction) {
            RemoveRetainTypeAction a = (RemoveRetainTypeAction)action;
            return name + this.verbalizer.verbalizeExpressionList(a.getList()) + ")";
        }
        if (action instanceof SetFeatureAction) {
            SetFeatureAction a = (SetFeatureAction)action;
            String e1 = this.verbalizer.verbalize(a.getFeatureStringExpression());
            String e2 = this.verbalizer.verbalize(a.getExpr());
            return name + e1 + ", " + e2 + ")";
        }
        if (action instanceof GetFeatureAction) {
            GetFeatureAction a = (GetFeatureAction)action;
            return name + this.verbalizer.verbalize(a.getFeatureStringExpression()) + ", " + a.getVariable() + ")";
        }
        if (action instanceof UnmarkAction) {
            UnmarkAction a = (UnmarkAction)action;
            if (a.getExpression() != null) {
                return name + this.verbalizer.verbalize(a.getExpression()) + ")";
            }
            if (a.getAllAnchor() == null) {
                if (a.getList() == null) {
                    return name + this.verbalizer.verbalize(a.getType()) + ")";
                }
                String l = this.verbalizer.verbalizeExpressionList(a.getList());
                if (StringUtils.isBlank((CharSequence)l)) {
                    return name + this.verbalizer.verbalize(a.getType()) + ")";
                }
                return name + this.verbalizer.verbalize(a.getType()) + ", " + l + ")";
            }
            return name + this.verbalizer.verbalize(a.getType()) + ", " + this.verbalizer.verbalizeExpressionList(a.getList()) + ", " + this.verbalizer.verbalize(a.getAllAnchor()) + ")";
        }
        if (action instanceof TransferAction) {
            TransferAction a = (TransferAction)action;
            return name + this.verbalizer.verbalize(a.getType()) + ")";
        }
        if (action instanceof TrieAction) {
            TrieAction a = (TrieAction)action;
            Object map = "";
            if (a.getMap() != null) {
                for (IStringExpression each : a.getMap().keySet()) {
                    map = (String)map + this.verbalizer.verbalize(each);
                    map = (String)map + " = ";
                    map = (String)map + this.verbalizer.verbalize(a.getMap().get(each));
                    map = (String)map + ", ";
                }
            }
            return name + (String)map + this.verbalizer.verbalize(a.getList()) + ", " + this.verbalizer.verbalize(a.getIgnoreCase()) + ", " + this.verbalizer.verbalize(a.getIgnoreLength()) + ", " + this.verbalizer.verbalize(a.getEdit()) + ", " + this.verbalizer.verbalize(a.getDistance()) + ", " + this.verbalizer.verbalize(a.getIgnoreChar()) + ")";
        }
        if (action instanceof AddAction) {
            AddAction a = (AddAction)action;
            return name + a.getListExpr() + ", " + this.verbalizer.verbalizeExpressionList(a.getElements()) + ")";
        }
        if (action instanceof RemoveAction) {
            RemoveAction a = (RemoveAction)action;
            return name + a.getListExpr() + ", " + this.verbalizer.verbalizeExpressionList(a.getElements()) + ")";
        }
        if (action instanceof RemoveAction) {
            RemoveAction a = (RemoveAction)action;
            return name + a.getListExpr() + ")";
        }
        if (action instanceof MergeAction) {
            MergeAction a = (MergeAction)action;
            return name + this.verbalizer.verbalize(a.getUnion()) + ", " + a.getTarget() + ", " + this.verbalizer.verbalizeExpressionList(a.getLists()) + ")";
        }
        if (action instanceof GetAction) {
            GetAction a = (GetAction)action;
            return name + this.verbalizer.verbalize(a.getListExpr()) + ", " + a.getVar() + ", " + this.verbalizer.verbalize(a.getOpExpr()) + ")";
        }
        if (action instanceof ClearAction) {
            ClearAction a = (ClearAction)action;
            return name + a.getList() + ")";
        }
        if (action instanceof ConfigureAction) {
            ConfigureAction a = (ConfigureAction)action;
            Object map = "";
            if (a.getParameterMap() != null) {
                map = (String)map + ", ";
                for (IStringExpression each : a.getParameterMap().keySet()) {
                    map = (String)map + this.verbalizer.verbalize(each);
                    map = (String)map + " = ";
                    map = (String)map + this.verbalizer.verbalize(a.getParameterMap().get(each));
                    map = (String)map + ", ";
                }
            }
            map = ((String)map).substring(0, ((String)map).length() - 2);
            return name + a.getNamespace() + (String)map + ")";
        }
        if (action instanceof DynamicAnchoringAction) {
            DynamicAnchoringAction a = (DynamicAnchoringAction)action;
            IBooleanExpression active = a.getActive();
            INumberExpression panelty = a.getPanelty();
            INumberExpression factor = a.getFactor();
            String pa = this.verbalizer.verbalize(active);
            String pp = panelty == null ? "" : ", " + this.verbalizer.verbalize(panelty);
            String pf = factor == null ? "" : ", " + this.verbalizer.verbalize(factor);
            return name + pa + pp + pf + ")";
        }
        if (action instanceof GreedyAnchoringAction) {
            GreedyAnchoringAction a = (GreedyAnchoringAction)action;
            IBooleanExpression active = a.getGreedyRuleElement();
            IBooleanExpression active2 = a.getGreedyRule();
            String pa = this.verbalizer.verbalize(active);
            Object pa2 = "";
            if (active2 != null) {
                pa2 = ", " + this.verbalizer.verbalize(active2);
            }
            return name + pa + (String)pa2 + ")";
        }
        if (action instanceof GetListAction) {
            GetListAction a = (GetListAction)action;
            String var = a.getVar();
            String op = this.verbalizer.verbalize(a.getOpExpr());
            return name + var + ", " + op + ")";
        }
        if (action instanceof MarkTableAction) {
            MarkTableAction a = (MarkTableAction)action;
            ITypeExpression typeExpr = a.getTypeExpr();
            INumberExpression indexExpr = a.getIndexExpr();
            WordTableExpression tableExpr = a.getTableExpr();
            Map<IStringExpression, INumberExpression> featureMap = a.getFeatureMap();
            IBooleanExpression ignoreCase = a.getIgnoreCase();
            INumberExpression ignoreLength = a.getIgnoreLength();
            IStringExpression ignoreChar = a.getIgnoreChar();
            INumberExpression maxIgnoreChar = a.getMaxIgnoreChar();
            String type = this.verbalizer.verbalize(typeExpr);
            String index = this.verbalizer.verbalize(indexExpr);
            String table = this.verbalizer.verbalize(tableExpr);
            Object map = "";
            if (featureMap != null) {
                map = (String)map + ", ";
                for (IStringExpression each : featureMap.keySet()) {
                    map = (String)map + this.verbalizer.verbalize(each);
                    map = (String)map + " = ";
                    map = (String)map + this.verbalizer.verbalize(featureMap.get(each));
                    map = (String)map + ", ";
                }
            }
            String icase = ignoreCase == null ? "" : ", " + this.verbalizer.verbalize(ignoreCase);
            String ilength = ignoreCase == null ? "" : ", " + this.verbalizer.verbalize(ignoreLength);
            String ichar = ignoreCase == null ? "" : ", " + this.verbalizer.verbalize(ignoreChar);
            String mic = ignoreCase == null ? "" : ", " + this.verbalizer.verbalize(maxIgnoreChar);
            return name + type + ", " + index + ", " + table + (String)map + icase + ilength + ichar + mic + ")";
        }
        if (action instanceof MatchedTextAction) {
            MatchedTextAction a = (MatchedTextAction)action;
            String var = a.getVar();
            List<INumberExpression> list = a.getList();
            String indexes = list == null ? "" : ", " + this.verbalizer.verbalizeExpressionList(list);
            return name + var + indexes + ")";
        }
        if (action instanceof RemoveDuplicateAction) {
            RemoveDuplicateAction a = (RemoveDuplicateAction)action;
            String listExpr = a.getListExpr();
            return name + listExpr + ")";
        }
        if (action instanceof UnmarkAllAction) {
            UnmarkAllAction a = (UnmarkAllAction)action;
            String verbalize = this.verbalizer.verbalize(a.getType());
            String but = a.getList() == null ? "" : ", " + this.verbalizer.verbalize(a.getList());
            return name + verbalize + but + ")";
        }
        if (action instanceof TrimAction) {
            TrimAction a = (TrimAction)action;
            AbstractTypeListExpression typeList = a.getTypeList();
            String verbalize = "";
            if (typeList != null) {
                verbalize = this.verbalizer.verbalize(typeList);
            } else if (a.getTypes() != null) {
                verbalize = this.verbalizer.verbalizeExpressionList(a.getTypes());
            }
            return name + verbalize + ")";
        }
        if (action instanceof TrimAction) {
            TrimAction a = (TrimAction)action;
            AbstractTypeListExpression typeList = a.getTypeList();
            String verbalize = "";
            if (typeList != null) {
                verbalize = this.verbalizer.verbalize(typeList);
            } else if (a.getTypes() != null) {
                verbalize = this.verbalizer.verbalizeExpressionList(a.getTypes());
            }
            return name + verbalize + ")";
        }
        if (action instanceof SplitAction) {
            SplitAction a = (SplitAction)action;
            ITypeExpression splitOnType = a.getSplitOnType();
            IBooleanExpression complete = a.getComplete();
            IBooleanExpression appendToBegin = a.getAppendToBegin();
            IBooleanExpression appendToEnd = a.getAppendToEnd();
            return name + this.verbalizer.verbalize(splitOnType) + ", " + this.verbalizer.verbalize(complete) + ", " + this.verbalizer.verbalize(appendToBegin) + ", " + this.verbalizer.verbalize(appendToEnd) + ")";
        }
        if (action instanceof ImplicitMarkAction) {
            ImplicitMarkAction a = (ImplicitMarkAction)action;
            return this.verbalizer.verbalize(a.getType());
        }
        if (action instanceof ImplicitFeatureAction) {
            ImplicitFeatureAction a = (ImplicitFeatureAction)action;
            return this.verbalizer.verbalize(a.getExpr());
        }
        if (action instanceof ImplicitVariableAssignmentAction) {
            ImplicitVariableAssignmentAction a = (ImplicitVariableAssignmentAction)action;
            return a.getVar() + a.getOp() + this.verbalizer.verbalize(a.getArg());
        }
        if (action instanceof MacroAction) {
            MacroAction a = (MacroAction)action;
            return name + this.verbalizer.verbalizeExpressionList(a.getArguments()) + ")";
        }
        return action.getClass().getSimpleName();
    }
}

