/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ruta.resource;

import java.net.URL;
import org.apache.uima.UIMAFramework;
import org.apache.uima.UimaContext;
import org.apache.uima.UimaContextAdmin;
import org.apache.uima.UimaContextHolder;
import org.apache.uima.resource.ResourceManager;
import org.apache.uima.resource.metadata.Import;
import org.apache.uima.ruta.resource.ResourcePathResourceLoader;
import org.apache.uima.util.InvalidXMLException;
import org.springframework.core.io.DefaultResourceLoader;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.io.UrlResource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;

public class RutaResourceLoader
implements ResourceLoader {
    private final ResourceManager resMgr;
    private final ResourceLoader wrapped;
    private final ResourceLoader fallback;
    private final ResourceLoader fallback2;
    private final ClassLoader classLoader;

    public RutaResourceLoader(ResourceManager resMgr, String[] paths, ClassLoader classLoader) {
        this.resMgr = resMgr;
        this.wrapped = new PathMatchingResourcePatternResolver((ResourceLoader)new ResourcePathResourceLoader(paths));
        this.classLoader = classLoader == null ? this.getClass().getClassLoader() : classLoader;
        this.fallback = new DefaultResourceLoader(this.classLoader);
        this.fallback2 = new DefaultResourceLoader();
    }

    public RutaResourceLoader(String[] paths, ClassLoader classLoader) {
        this(null, paths, classLoader);
    }

    public RutaResourceLoader(String[] paths) {
        this(null, paths, null);
    }

    public Resource getResource(String location) {
        Resource resource = this.wrapped.getResource(location);
        if (!resource.exists()) {
            resource = this.fallback.getResource(location);
        }
        if (!resource.exists()) {
            resource = this.fallback2.getResource(location);
        }
        return resource;
    }

    public Resource getResourceWithDotNotation(String location, String extension) {
        UimaContext uimaContext;
        String path = location.replaceAll("[.]", "/") + extension;
        Resource resource = this.getResource(path);
        ResourceManager rm = this.resMgr;
        if (rm == null && (uimaContext = UimaContextHolder.getContext()) instanceof UimaContextAdmin) {
            UimaContextAdmin ctxAdm = (UimaContextAdmin)uimaContext;
            rm = ctxAdm.getResourceManager();
        }
        if (rm != null && !resource.exists()) {
            try {
                Import descImport = UIMAFramework.getResourceSpecifierFactory().createImport();
                descImport.setName(location);
                URL url = descImport.findAbsoluteUrl(rm);
                if (url != null) {
                    return new UrlResource(url);
                }
            }
            catch (InvalidXMLException invalidXMLException) {
                // empty catch block
            }
        }
        return resource;
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }
}

