/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ruta.resource;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.uima.cas.Feature;
import org.apache.uima.cas.FeatureStructure;
import org.apache.uima.cas.Type;
import org.apache.uima.cas.TypeSystem;
import org.apache.uima.cas.text.AnnotationFS;
import org.apache.uima.ruta.RutaStream;
import org.apache.uima.ruta.resource.EditDistanceCostMap;
import org.apache.uima.ruta.resource.EditDistanceResultMap;
import org.apache.uima.ruta.resource.MultiTextNode;
import org.apache.uima.ruta.resource.MultiTreeWordListPersistence;
import org.apache.uima.ruta.resource.RutaWordList;
import org.apache.uima.ruta.type.RutaBasic;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;

public class MultiTreeWordList
implements RutaWordList {
    private static final String ENCODING = "UTF-8";
    private MultiTreeWordListPersistence persistence = new MultiTreeWordListPersistence();
    protected MultiTextNode root = new MultiTextNode();
    private EditDistanceCostMap costMap = new EditDistanceCostMap();
    private boolean dictRemoveWS = false;

    public MultiTreeWordList() throws IOException {
        this(new String[0], null);
    }

    public MultiTreeWordList(String pathname, File base) throws IOException {
        this(new Resource[]{new FileSystemResource(pathname)});
    }

    public MultiTreeWordList(Resource ... lists) throws IOException {
        if (lists == null) {
            return;
        }
        for (Resource list : lists) {
            File directory = null;
            try {
                directory = list.getFile();
            }
            catch (IOException e) {
                directory = null;
            }
            if (directory != null && directory.isDirectory()) {
                for (File data : directory.listFiles()) {
                    this.load((Resource)new FileSystemResource(data));
                }
                continue;
            }
            this.load(list);
        }
    }

    public MultiTreeWordList(InputStream stream, String name) throws IOException {
        if (name.endsWith(".mtwl")) {
            this.persistence.readMTWL(this.root, stream, ENCODING);
        } else if (name.endsWith(".txt")) {
            this.buildNewTree(stream, name);
        }
    }

    public MultiTreeWordList(String[] pathnames, File base) throws IOException {
        this(pathnames, base, false);
    }

    public MultiTreeWordList(String[] pathnames, File base, boolean dictRemoveWS) throws IOException {
        this.dictRemoveWS = dictRemoveWS;
        if (pathnames == null) {
            return;
        }
        for (String pathname : pathnames) {
            String name = this.getRelativePath(new File(pathname), base);
            this.load((Resource)new FileSystemResource(pathname), name);
        }
    }

    public MultiTreeWordList(List<File> files, File base) throws IOException {
        this(files, base, false);
    }

    public MultiTreeWordList(List<File> files, File base, boolean dictRemoveWS) throws IOException {
        this.dictRemoveWS = dictRemoveWS;
        if (files == null) {
            return;
        }
        for (File file : files) {
            String name = this.getRelativePath(file, base);
            this.load((Resource)new FileSystemResource(file), name);
        }
    }

    private String getRelativePath(File file, File base) {
        if (base == null) {
            return file.getName();
        }
        Path filePath = file.toPath();
        Path basePath = base.toPath();
        Path relativize = basePath.relativize(filePath);
        String result = relativize.toString().replaceAll("\\\\", "/");
        return result;
    }

    private void load(Resource resource) throws IOException {
        this.load(resource, resource.getFilename());
    }

    private void load(Resource resource, String name) throws IOException {
        block9: {
            try (InputStream stream = resource.getInputStream();){
                if (name == null) {
                    throw new IllegalArgumentException("List does not have a name.");
                }
                if (name.endsWith(".txt")) {
                    this.buildNewTree(stream, name);
                    break block9;
                }
                if (name.endsWith(".mtwl")) {
                    this.persistence.readMTWL(this.root, stream, ENCODING);
                    break block9;
                }
                throw new IllegalArgumentException("File name should end with .mtwl or .txt, found " + name);
            }
        }
    }

    public void buildNewTree(InputStream stream, String name) throws IOException {
        BufferedReader br = new BufferedReader(new InputStreamReader(stream, ENCODING));
        String s = null;
        while ((s = br.readLine()) != null) {
            this.addWord(s.trim(), name);
        }
        stream.close();
        br.close();
    }

    public void addWord(String s, String type) {
        MultiTextNode pointer = this.root;
        char[] cArray = s.toCharArray();
        int n = cArray.length;
        for (int i = 0; i < n; ++i) {
            Character each = Character.valueOf(cArray[i]);
            if (this.dictRemoveWS && Character.isWhitespace(each.charValue())) continue;
            MultiTextNode childNode = pointer.getChildNode(each.charValue());
            if (childNode == null) {
                childNode = new MultiTextNode(each.charValue(), false);
                pointer.addChild(childNode);
            }
            pointer = childNode;
        }
        pointer.setWordEnd(s.length() > 0);
        pointer.addType(type);
    }

    public Collection<String> getTypes() {
        return this.getTypeCone(this.root);
    }

    public Collection<String> getTypeCone(MultiTextNode node) {
        LinkedList<String> returnList = new LinkedList<String>();
        if (node.getTypes() != null) {
            for (String s : node.getTypes()) {
                if (returnList.contains(s)) continue;
                returnList.add(s);
            }
        }
        for (Character c : node.getChildren().keySet()) {
            for (String s : this.getTypeCone(node.getChildNode(c.charValue()))) {
                if (returnList.contains(s)) continue;
                returnList.add(s);
            }
        }
        return returnList;
    }

    public Collection<String> keySet() {
        LinkedList<String> keySet = new LinkedList<String>(this.keySet(this.root, ""));
        Collections.sort(keySet);
        return keySet;
    }

    private Collection<String> keySet(MultiTextNode node, String prefix) {
        LinkedList<String> resultList = new LinkedList<String>();
        if (node.isWordEnd()) {
            resultList.add(prefix);
        }
        for (Character c : node.getChildren().keySet()) {
            String temp = prefix + String.valueOf(c);
            resultList.addAll(this.keySet(node.getChildNode(c.charValue()), temp));
        }
        return resultList;
    }

    public Collection<String> getTypes(String s) {
        return this.getTypes(s, false);
    }

    public Collection<String> getTypes(String s, boolean ignoreCase) {
        Map<String, Set<String>> types = this.editDistance(s, 0, ignoreCase, "");
        HashSet<String> returnSet = new HashSet<String>();
        for (Map.Entry<String, Set<String>> each : types.entrySet()) {
            returnSet.addAll((Collection<String>)each.getValue());
        }
        return returnSet;
    }

    public List<String> contains(String string, boolean ignoreCase, int ignoreLength, boolean edit, double distance, String ignoreToken) {
        LinkedList<String> resultList = new LinkedList<String>();
        Map<String, Set<String>> editDistance = string.length() >= ignoreLength && ignoreCase ? this.editDistance(string, (int)distance, true, ignoreToken, false) : this.editDistance(string, (int)distance, false, ignoreToken, false);
        for (Map.Entry<String, Set<String>> each : editDistance.entrySet()) {
            resultList.addAll((Collection<String>)each.getValue());
        }
        return resultList;
    }

    public boolean containsBool(String string, boolean ignoreCase, int ignoreLength, boolean edit, double distance, String ignoreToken) {
        return this.editDistanceBool(this.root, string, "", distance, 0, ignoreCase, false, this.costMap);
    }

    public boolean contains(String s) {
        return this.contains(s, false);
    }

    public boolean contains(String s, boolean ignoreCase) {
        return this.contains(s, ignoreCase, 0, new char[0], 0, true);
    }

    @Override
    public boolean contains(String s, boolean ignoreCase, int size, char[] ignoreChars, int maxIgnoreChars, boolean ignoreWS) {
        EditDistanceCostMap edm = new EditDistanceCostMap();
        char[] cArray = ignoreChars;
        int n = cArray.length;
        for (int i = 0; i < n; ++i) {
            Character c = Character.valueOf(cArray[i]);
            edm.setDeleteCosts(c.charValue(), 0.0);
        }
        return this.editDistanceBool(this.root, s, "", maxIgnoreChars, 0, ignoreCase, false, edm);
    }

    @Override
    public boolean containsFragment(String s, boolean ignoreCase, int size, char[] ignoreChars, int maxIgnoreChars, boolean ignoreWS) {
        MultiTextNode pointer = this.root;
        return this.recursiveContains(pointer, s, 0, ignoreCase && s.length() > size, true, ignoreChars, maxIgnoreChars);
    }

    public boolean containsFragmentBool(String string, boolean ignoreCase, int ignoreLength, boolean edit, double distance, String ignoreToken) {
        if (string.length() >= ignoreLength && ignoreCase) {
            return this.editDistanceBool(this.root, string, "", distance, 0, true, true, this.costMap);
        }
        return this.editDistanceBool(this.root, string, "", distance, 0, false, true, this.costMap);
    }

    public List<String> containsFragment(String string, boolean ignoreCase, int ignoreLength, boolean edit, double distance, String ignoreToken) {
        LinkedList<String> resultList = new LinkedList<String>();
        Map<String, Set<String>> resultMap = null;
        if (!edit) {
            return this.recursiveContains2(this.root, string, 0, ignoreCase && string.length() > ignoreLength, true, ignoreToken.toCharArray(), ignoreLength);
        }
        resultMap = string.length() >= ignoreLength && ignoreCase ? this.editDistance(string, (int)distance, true, ignoreToken, true) : this.editDistance(string, (int)distance, false, ignoreToken, true);
        for (Set<String> set : resultMap.values()) {
            for (String s : set) {
                if (resultList.contains(s)) continue;
                resultList.add(s);
            }
        }
        return resultList;
    }

    private List<String> recursiveContains2(MultiTextNode pointer, String text, int index, boolean ignoreCase, boolean fragment, char[] ignoreChars, int maxIgnoreChars) {
        if (pointer == null) {
            return null;
        }
        if (index == text.length()) {
            if (pointer.isWordEnd()) {
                return new ArrayList<String>(pointer.getTypes());
            }
            if (fragment) {
                return Collections.emptyList();
            }
        }
        char charAt = text.charAt(index);
        boolean charAtIgnored = false;
        if (ignoreChars != null) {
            for (char each : ignoreChars) {
                if (each != charAt) continue;
                charAtIgnored = true;
                break;
            }
            charAtIgnored &= index != 0;
        }
        int next = ++index;
        if (ignoreCase) {
            MultiTextNode childNodeU;
            MultiTextNode childNodeL = pointer.getChildNode(Character.toLowerCase(charAt));
            if (childNodeL == null) {
                childNodeL = this.skipWS(pointer, Character.toLowerCase(charAt));
            }
            if ((childNodeU = pointer.getChildNode(Character.toUpperCase(charAt))) == null) {
                childNodeU = this.skipWS(pointer, Character.toUpperCase(charAt));
            }
            if (charAtIgnored && childNodeL == null && childNodeU == null) {
                return this.recursiveContains2(pointer, text, next, ignoreCase, fragment, ignoreChars, maxIgnoreChars);
            }
            List<String> recursiveContainsL = this.recursiveContains2(childNodeL, text, next, ignoreCase, fragment, ignoreChars, maxIgnoreChars);
            List<String> recursiveContainsU = this.recursiveContains2(childNodeU, text, next, ignoreCase, fragment, ignoreChars, maxIgnoreChars);
            if (recursiveContainsL == null && recursiveContainsU == null) {
                return null;
            }
            LinkedList<String> result = new LinkedList<String>();
            if (recursiveContainsL != null) {
                result.addAll(recursiveContainsL);
            }
            if (recursiveContainsU != null) {
                result.addAll(recursiveContainsU);
            }
            return result;
        }
        MultiTextNode childNode = pointer.getChildNode(charAt);
        if (charAtIgnored && childNode == null) {
            return this.recursiveContains2(pointer, text, next, ignoreCase, fragment, ignoreChars, maxIgnoreChars);
        }
        return this.recursiveContains2(childNode, text, next, ignoreCase, fragment, ignoreChars, maxIgnoreChars);
    }

    private MultiTextNode skipWS(MultiTextNode pointer, char charAt) {
        MultiTextNode childNode = pointer.getChildNode(' ');
        if (childNode != null) {
            MultiTextNode node = childNode.getChildNode(charAt);
            if (node == null) {
                return this.skipWS(childNode, charAt);
            }
            return node;
        }
        return null;
    }

    private boolean recursiveContains(MultiTextNode pointer, String text, int index, boolean ignoreCase, boolean fragment, char[] ignoreChars, int maxIgnoreChars) {
        if (pointer == null) {
            return false;
        }
        if (index == text.length()) {
            return fragment || pointer.isWordEnd();
        }
        char charAt = text.charAt(index);
        boolean charAtIgnored = false;
        if (ignoreChars != null) {
            for (char each : ignoreChars) {
                if (each != charAt) continue;
                charAtIgnored = true;
                break;
            }
            charAtIgnored &= index != 0;
        }
        int next = ++index;
        if (ignoreCase) {
            MultiTextNode childNodeL = pointer.getChildNode(Character.toLowerCase(charAt));
            MultiTextNode childNodeU = pointer.getChildNode(Character.toUpperCase(charAt));
            if (charAtIgnored && childNodeL == null && childNodeU == null) {
                return this.recursiveContains(pointer, text, next, ignoreCase, fragment, ignoreChars, maxIgnoreChars);
            }
            return this.recursiveContains(childNodeL, text, next, ignoreCase, fragment, ignoreChars, maxIgnoreChars) || this.recursiveContains(childNodeU, text, next, ignoreCase, fragment, ignoreChars, maxIgnoreChars);
        }
        MultiTextNode childNode = pointer.getChildNode(charAt);
        if (charAtIgnored && childNode == null) {
            return this.recursiveContains(pointer, text, next, ignoreCase, fragment, ignoreChars, maxIgnoreChars);
        }
        return this.recursiveContains(childNode, text, next, ignoreCase, fragment, ignoreChars, maxIgnoreChars);
    }

    @Override
    public Collection<AnnotationFS> find(RutaStream stream, Map<String, Object> typeMap, boolean ignoreCase, int ignoreLength, boolean edit, double distance, String ignoreToken) {
        HashSet<AnnotationFS> results = new HashSet<AnnotationFS>();
        stream.moveToFirst();
        RutaStream streamPointer = stream.copy();
        while (stream.isValid()) {
            RutaBasic anchorBasic = (RutaBasic)stream.get();
            streamPointer.moveTo((FeatureStructure)anchorBasic);
            ArrayList<RutaBasic> basicsToAdd = new ArrayList<RutaBasic>();
            basicsToAdd.add(anchorBasic);
            String text = anchorBasic.getCoveredText();
            StringBuilder candidate = new StringBuilder(text);
            String lastCandidate = candidate.toString();
            if (text.length() != 1 || !ignoreToken.contains(text)) {
                ArrayList<AnnotationFS> interResults = new ArrayList<AnnotationFS>();
                while (streamPointer.isValid()) {
                    boolean skip = false;
                    String currentBasicText = ((RutaBasic)((Object)basicsToAdd.get(basicsToAdd.size() - 1))).getCoveredText();
                    if (currentBasicText.length() == 1 && ignoreToken.contains(currentBasicText)) {
                        skip = true;
                    }
                    Collection types = null;
                    if (!skip) {
                        types = this.containsFragment(candidate.toString(), ignoreCase, ignoreLength, edit, distance, ignoreToken);
                    }
                    if (!skip && types == null) break;
                    streamPointer.moveToNext();
                    if (streamPointer.isValid()) {
                        RutaBasic next = (RutaBasic)streamPointer.get();
                        if (!skip) {
                            this.tryToCreateAnnotation((List<String>)types, stream, results, basicsToAdd, candidate.toString(), interResults, ignoreCase, ignoreLength, edit, distance, ignoreToken, typeMap);
                        }
                        lastCandidate = candidate.toString();
                        candidate.append(next.getCoveredText());
                        basicsToAdd.add(next);
                        continue;
                    }
                    this.tryToCreateAnnotation((List<String>)types, stream, results, basicsToAdd, lastCandidate, interResults, ignoreCase, ignoreLength, edit, distance, ignoreToken, typeMap);
                }
            }
            stream.moveToNext();
        }
        return results;
    }

    public List<AnnotationFS> find(RutaStream stream, boolean ignoreCase, int size, char[] ignoreChars, int maxIgnoredChars, boolean ignoreWS) {
        assert (false);
        return new ArrayList<AnnotationFS>();
    }

    private void tryToCreateAnnotation(List<String> types, RutaStream stream, Collection<AnnotationFS> results, List<RutaBasic> basicsToAdd, String lastCandidate, List<AnnotationFS> interResult, boolean ignoreCase, int ignoreLength, boolean edit, double distance, String ignoreToken, Map<String, Object> map) {
        if (basicsToAdd.size() >= 1 && types != null) {
            HashSet<String> set = new HashSet<String>(types);
            for (String each : set) {
                Object o = map.get(each);
                if (o instanceof Type) {
                    Type type = (Type)o;
                    int begin = basicsToAdd.get(0).getBegin();
                    int end = basicsToAdd.get(basicsToAdd.size() - 1).getEnd();
                    AnnotationFS newFS = stream.getCas().createAnnotation(type, begin, end);
                    results.add(newFS);
                    continue;
                }
                if (!(o instanceof List)) continue;
                List list = (List)o;
                Type type = null;
                String featureString = null;
                String value = each;
                if (list.size() != 2 && list.size() != 3) continue;
                if (list.get(0) instanceof Type) {
                    type = (Type)list.get(0);
                }
                if (list.get(1) instanceof String) {
                    featureString = (String)list.get(1);
                }
                if (list.size() == 3) {
                    value = list.get(2);
                }
                if (type == null || featureString == null) continue;
                int begin = basicsToAdd.get(0).getBegin();
                int end = basicsToAdd.get(basicsToAdd.size() - 1).getEnd();
                AnnotationFS newFS = stream.getCas().createAnnotation(type, begin, end);
                Feature feature = type.getFeatureByBaseName(featureString);
                this.setFeatureValue(newFS, feature, value, stream);
                results.add(newFS);
            }
        } else if (interResult != null && !interResult.isEmpty()) {
            results.addAll(interResult);
        }
    }

    private void setFeatureValue(AnnotationFS annotationFS, Feature feature, Object o, RutaStream stream) {
        TypeSystem typeSystem = stream.getCas().getTypeSystem();
        if (feature != null && o != null) {
            Type range = feature.getRange();
            String rangeName = range.getName();
            if (typeSystem.subsumes(typeSystem.getType("uima.cas.String"), range) && o instanceof String) {
                annotationFS.setStringValue(feature, (String)o);
            } else if (rangeName.equals("uima.cas.Integer") && o instanceof Number) {
                annotationFS.setIntValue(feature, ((Number)o).intValue());
            } else if (rangeName.equals("uima.cas.Double") && o instanceof Number) {
                annotationFS.setDoubleValue(feature, ((Number)o).doubleValue());
            } else if (rangeName.equals("uima.cas.Float") && o instanceof Number) {
                annotationFS.setFloatValue(feature, ((Number)o).floatValue());
            } else if (rangeName.equals("uima.cas.Byte") && o instanceof Number) {
                annotationFS.setByteValue(feature, ((Number)o).byteValue());
            } else if (rangeName.equals("uima.cas.Short") && o instanceof Number) {
                annotationFS.setShortValue(feature, ((Number)o).shortValue());
            } else if (rangeName.equals("uima.cas.Long") && o instanceof Number) {
                annotationFS.setLongValue(feature, ((Number)o).longValue());
            } else if (rangeName.equals("uima.cas.Boolean") && o instanceof Boolean) {
                annotationFS.setBooleanValue(feature, ((Boolean)o).booleanValue());
            } else if (typeSystem.subsumes(typeSystem.getType("uima.cas.String"), range) & o instanceof Type) {
                annotationFS.setStringValue(feature, ((Type)o).getName());
            }
        } else {
            throw new IllegalArgumentException("Not able to assign feature value: " + String.valueOf(o) + " -> " + String.valueOf(feature));
        }
    }

    public Map<String, Set<String>> editDistance(String query, int distance) {
        return this.editDistance(query, distance, false, "");
    }

    public Map<String, Set<String>> editDistance(String query, int distance, boolean ignoreCase, String ignoreToken) {
        return this.editDistance(query, distance, ignoreCase, ignoreToken, false);
    }

    public Map<String, Set<String>> editDistance(String query, int distance, boolean ignoreCase, String ignoreToken, boolean fragment) {
        HashMap<Character, Double> oldInsertCosts = new HashMap<Character, Double>();
        EditDistanceCostMap edcm = new EditDistanceCostMap();
        for (char c : ignoreToken.toCharArray()) {
            oldInsertCosts.put(Character.valueOf(c), edcm.getInsertCosts(c));
            edcm.setInsertCosts(c, 0.0);
        }
        Map<String, Set<String>> result = null;
        result = ignoreCase ? this.editDistanceClever(this.root, query.toLowerCase(), "", distance, 0, true, fragment, edcm, false, false) : this.editDistanceClever(this.root, query, "", distance, 0, false, fragment, edcm, false, false);
        for (Map.Entry c : oldInsertCosts.entrySet()) {
            edcm.setDeleteCosts(((Character)c.getKey()).charValue(), (Double)c.getValue());
        }
        return result;
    }

    private Map<String, Set<String>> editDistanceClever(MultiTextNode node, String query, String result, double distance, int index, boolean ignoreCase, boolean fragment, EditDistanceCostMap edm, boolean lastActionInsert, boolean lastActionDelete) {
        EditDistanceResultMap resultMap = new EditDistanceResultMap();
        if (!lastActionInsert && distance - edm.getDeleteCosts(node.getValue()) >= 0.0 && result.length() > 0) {
            resultMap.putAll((Map<? extends String, ? extends Set<String>>)this.editDistanceClever(node, query, result, distance - edm.getDeleteCosts(node.getValue()), index + 1, ignoreCase, fragment, edm, false, true));
        }
        if (node.isWordEnd() || fragment) {
            HashMap<String, HashSet<String>> temp = new HashMap<String, HashSet<String>>();
            double remainingInsertCosts = 0.0;
            for (int i = index; i < query.length(); ++i) {
                remainingInsertCosts += edm.getInsertCosts(query.charAt(i));
            }
            if (remainingInsertCosts <= distance) {
                if (fragment) {
                    temp.put(result, new HashSet<String>(this.getTypeCone(node)));
                } else {
                    temp.put(result, new HashSet<String>(node.getTypes()));
                }
                resultMap.putAll((Map<? extends String, ? extends Set<String>>)temp);
            }
            if (node.getChildren() == null) {
                return resultMap;
            }
        }
        for (MultiTextNode tempNode : node.getChildren().values()) {
            if (index < query.length()) {
                if (ignoreCase) {
                    if (Character.toLowerCase(tempNode.getValue()) == Character.toLowerCase(query.charAt(index))) {
                        resultMap.putAll((Map<? extends String, ? extends Set<String>>)this.editDistanceClever(tempNode, query, result + tempNode.getValue(), distance, index + 1, ignoreCase, fragment, edm, false, false));
                    }
                } else if (tempNode.getValue() == query.charAt(index)) {
                    resultMap.putAll((Map<? extends String, ? extends Set<String>>)this.editDistanceClever(tempNode, query, result + tempNode.getValue(), distance, index + 1, ignoreCase, fragment, edm, false, false));
                }
            }
            if (distance - edm.getReplaceCosts(node.getValue(), tempNode.getValue()) >= 0.0) {
                resultMap.putAll((Map<? extends String, ? extends Set<String>>)this.editDistanceClever(tempNode, query, result + tempNode.getValue(), distance - edm.getReplaceCosts(node.getValue(), tempNode.getValue()), index + 1, ignoreCase, fragment, edm, false, false));
            }
            if (lastActionDelete || !(distance - edm.getInsertCosts(tempNode.getValue()) >= 0.0)) continue;
            resultMap.putAll((Map<? extends String, ? extends Set<String>>)this.editDistanceClever(tempNode, query, result + tempNode.getValue(), distance - edm.getInsertCosts(tempNode.getValue()), index, ignoreCase, fragment, edm, true, false));
        }
        return resultMap;
    }

    private boolean editDistanceBool(MultiTextNode node, String query, String result, double distance, int index, boolean ignoreCase, boolean fragment, EditDistanceCostMap edm) {
        boolean deletion = false;
        boolean insertion = false;
        boolean substitution = false;
        boolean noop = false;
        if (fragment && index == query.length()) {
            return true;
        }
        if (node.isWordEnd()) {
            double remainingInsertCosts = 0.0;
            for (int i = index; i < query.length(); ++i) {
                remainingInsertCosts += edm.getInsertCosts(query.charAt(i));
            }
            if (remainingInsertCosts <= distance) {
                return true;
            }
        }
        if (distance - edm.getDeleteCosts(node.getValue()) >= 0.0 && result.length() > 0 && (deletion = this.editDistanceBool(node, query, result, distance - edm.getDeleteCosts(node.getValue()), index + 1, ignoreCase, fragment, edm))) {
            return true;
        }
        for (MultiTextNode tempNode : node.getChildren().values()) {
            if (index < query.length()) {
                if (ignoreCase) {
                    if (Character.toLowerCase(tempNode.getValue()) == Character.toLowerCase(query.charAt(index))) {
                        noop = this.editDistanceBool(tempNode, query, result + tempNode.getValue(), distance, index + 1, ignoreCase, fragment, edm);
                    }
                } else if (tempNode.getValue() == query.charAt(index)) {
                    noop = this.editDistanceBool(tempNode, query, result + tempNode.getValue(), distance, index + 1, ignoreCase, fragment, edm);
                }
                if (noop) {
                    return true;
                }
            }
            if (distance - edm.getReplaceCosts(node.getValue(), tempNode.getValue()) >= 0.0 && (substitution = this.editDistanceBool(tempNode, query, result + tempNode.getValue(), distance - edm.getReplaceCosts(node.getValue(), tempNode.getValue()), index + 1, ignoreCase, fragment, edm))) {
                return true;
            }
            if (!(distance - edm.getInsertCosts(tempNode.getValue()) >= 0.0) || !(insertion = this.editDistanceBool(tempNode, query, result + tempNode.getValue(), distance - edm.getInsertCosts(tempNode.getValue()), index, ignoreCase, fragment, edm))) continue;
            return true;
        }
        return false;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.costMap == null ? 0 : this.costMap.hashCode());
        result = 31 * result + (this.root == null ? 0 : this.root.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MultiTreeWordList other = (MultiTreeWordList)obj;
        if (this.costMap == null ? other.costMap != null : !this.costMap.equals(other.costMap)) {
            return false;
        }
        return !(this.root == null ? other.root != null : !this.root.equals(other.root));
    }

    public void createMTWLFile(String path, boolean compress, String encoding) throws IOException {
        this.persistence.createMTWLFile(this.root, path, compress, encoding);
    }
}

