/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ruta.action;

import java.util.List;
import org.apache.uima.cas.Feature;
import org.apache.uima.cas.FeatureStructure;
import org.apache.uima.cas.text.AnnotationFS;
import org.apache.uima.ruta.RutaStream;
import org.apache.uima.ruta.action.AbstractRutaAction;
import org.apache.uima.ruta.expression.IRutaExpression;
import org.apache.uima.ruta.expression.string.IStringExpression;
import org.apache.uima.ruta.rule.MatchContext;
import org.apache.uima.ruta.rule.RuleElement;
import org.apache.uima.ruta.rule.RuleMatch;
import org.apache.uima.ruta.visitor.InferenceCrowd;

public class SetFeatureAction
extends AbstractRutaAction {
    private final IStringExpression featureStringExpression;
    private final IRutaExpression expr;

    public SetFeatureAction(IStringExpression feature, IRutaExpression expr) {
        this.featureStringExpression = feature;
        this.expr = expr;
    }

    public IStringExpression getFeatureStringExpression() {
        return this.featureStringExpression;
    }

    @Override
    public void execute(MatchContext context, RutaStream stream, InferenceCrowd crowd) {
        RuleMatch match = context.getRuleMatch();
        RuleElement element = context.getElement();
        element.getParent();
        String featureString = this.featureStringExpression.getStringValue(context, stream);
        List<AnnotationFS> matchedAnnotations = match.getMatchedAnnotationsOfElement(element);
        for (AnnotationFS annotationFS : matchedAnnotations) {
            Feature feature = annotationFS.getType().getFeatureByBaseName(featureString);
            if (feature != null) {
                stream.getCas().removeFsFromIndexes((FeatureStructure)annotationFS);
                stream.assignFeatureValue((FeatureStructure)annotationFS, feature, this.expr, context);
                stream.getCas().addFsToIndexes((FeatureStructure)annotationFS);
                continue;
            }
            throw new IllegalArgumentException("Not able to assign feature value (e.g., coveredText) in script " + context.getParent().getName());
        }
    }

    public IRutaExpression getExpr() {
        return this.expr;
    }
}

