/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ruta.textruler.extension;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import org.apache.uima.ruta.ide.core.builder.RutaProjectUtils;
import org.apache.uima.ruta.textruler.TextRulerPlugin;
import org.apache.uima.ruta.textruler.core.TextRulerToolkit;
import org.apache.uima.ruta.textruler.extension.TextRulerControllerDelegate;
import org.apache.uima.ruta.textruler.extension.TextRulerLearnerController;
import org.apache.uima.ruta.textruler.extension.TextRulerLearnerFactory;
import org.apache.uima.ruta.textruler.extension.TextRulerPreprocessor;
import org.apache.uima.ruta.textruler.extension.TextRulerPreprocessorDelegate;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Platform;

public class TextRulerController {
    protected static ArrayList<TextRulerLearnerController> learners = null;
    protected static String currentTempDir = null;
    protected static String[] currentSlotNames = null;
    protected static Set<String> currentFilters = null;
    protected static TextRulerControllerDelegate currentDelegate = null;
    protected static Thread preprocessorThread = null;
    protected static boolean shouldAbort = false;
    protected static String currentPreprocessorTMFile = null;
    protected static boolean skip;
    protected static Map<String, Map<String, Object>> currentAlgorithmParams;

    private static boolean anAlgorithmIsRunning() {
        for (TextRulerLearnerController i : TextRulerController.getAvailableControllers()) {
            if (!i.isRunning()) continue;
            return true;
        }
        return false;
    }

    public static int enabledAlgorithmsCount() {
        int cnt = 0;
        for (TextRulerLearnerController c : learners) {
            if (!c.isEnabled()) continue;
            ++cnt;
        }
        return cnt;
    }

    private static void preprocessorDidEnd(String algorithmsInputFolder, String additionalFolder) {
        if (TextRulerController.shouldAbort()) {
            if (currentDelegate != null) {
                currentDelegate.globalStatusUpdate("Aborted!");
            }
            TextRulerController.cleanUp();
        } else {
            if (currentDelegate != null) {
                currentDelegate.globalStatusUpdate("Running...");
            }
            for (TextRulerLearnerController c : learners) {
                if (!c.isEnabled()) continue;
                c.runInNewThread(algorithmsInputFolder, additionalFolder, currentPreprocessorTMFile, currentSlotNames, currentFilters, currentTempDir, currentDelegate, skip, currentAlgorithmParams.get(c.getID()));
            }
        }
        preprocessorThread = null;
    }

    private static void cleanUp() {
        currentTempDir = null;
        currentPreprocessorTMFile = null;
        currentSlotNames = null;
        currentFilters = null;
        currentDelegate = null;
        currentAlgorithmParams = null;
        shouldAbort = false;
    }

    protected static void saveParametersToTempFolder(String inFolder, boolean skipPreprocessing) {
        Object str = "\nSettings:\n\n";
        str = (String)str + "inputDir: " + inFolder;
        str = (String)str + "\npreprocessTMFile: " + currentPreprocessorTMFile;
        str = (String)str + "\nslotnames : ";
        for (String s : currentSlotNames) {
            str = (String)str + s + "; ";
        }
        str = (String)str + "\nfilters: " + currentFilters;
        str = (String)str + "\nskip preproc: " + skipPreprocessing;
        str = (String)str + "\n";
        TextRulerToolkit.appendStringToFile(TextRulerToolkit.addTrailingSlashToPath(currentTempDir) + "settings.txt", (String)str);
    }

    public static boolean start(final String inFolder, final String additionalFolder, String preprocessorFile, String[] slotNames, Set<String> filters, TextRulerControllerDelegate delegate, Map<String, Map<String, Object>> algParams, boolean skipPreprocessing) {
        if (TextRulerController.isRunning() || TextRulerController.enabledAlgorithmsCount() == 0) {
            return false;
        }
        shouldAbort = false;
        String outFolder = null;
        try {
            currentTempDir = TextRulerToolkit.createTemporaryDirectory();
            outFolder = currentTempDir + "input";
            File outputFolder = new File(outFolder);
            outputFolder.mkdir();
        }
        catch (IOException e) {
            TextRulerPlugin.error(e);
            return false;
        }
        IPath analysisEngineDescriptorPath = null;
        try {
            analysisEngineDescriptorPath = RutaProjectUtils.getAnalysisEngineDescriptorPath((String)preprocessorFile);
        }
        catch (CoreException e) {
            TextRulerPlugin.error(e);
        }
        if (analysisEngineDescriptorPath == null) {
            return false;
        }
        currentPreprocessorTMFile = preprocessorFile;
        currentSlotNames = slotNames;
        currentFilters = filters;
        currentDelegate = delegate;
        currentAlgorithmParams = algParams;
        skip = skipPreprocessing;
        TextRulerController.saveParametersToTempFolder(inFolder, skipPreprocessing);
        for (TextRulerLearnerController c : learners) {
            c.resetStatusString();
        }
        if (skipPreprocessing) {
            TextRulerController.preprocessorDidEnd(inFolder, additionalFolder);
        } else {
            preprocessorThread = new Thread(new Runnable(){

                @Override
                public void run() {
                    TextRulerPreprocessor p = new TextRulerPreprocessor();
                    String algorithmsInputFolder = p.run(inFolder, currentPreprocessorTMFile, currentTempDir, currentSlotNames, new TextRulerPreprocessorDelegate(){

                        @Override
                        public void preprocessorStatusUpdate(TextRulerPreprocessor p, String statusString) {
                            currentDelegate.preprocessorStatusUpdate(p, statusString);
                        }

                        @Override
                        public boolean shouldAbort() {
                            return TextRulerController.shouldAbort();
                        }
                    });
                    String algorithmsAdditionalFolder = p.run(additionalFolder, "additional", currentPreprocessorTMFile, currentTempDir, currentSlotNames, new TextRulerPreprocessorDelegate(){

                        @Override
                        public void preprocessorStatusUpdate(TextRulerPreprocessor p, String statusString) {
                            currentDelegate.preprocessorStatusUpdate(p, statusString);
                        }

                        @Override
                        public boolean shouldAbort() {
                            return TextRulerController.shouldAbort();
                        }
                    });
                    TextRulerController.preprocessorDidEnd(algorithmsInputFolder, algorithmsAdditionalFolder);
                }
            });
            if (currentDelegate != null) {
                currentDelegate.globalStatusUpdate("Preprocessing...");
            }
            preprocessorThread.setPriority(5);
            preprocessorThread.start();
        }
        return true;
    }

    public static TextRulerLearnerController getControllerForID(String id) {
        for (TextRulerLearnerController c : TextRulerController.getAvailableControllers()) {
            if (!c.getID().equals(id)) continue;
            return c;
        }
        return null;
    }

    public static ArrayList<TextRulerLearnerController> getAvailableControllers() {
        if (learners == null) {
            IConfigurationElement[] extensions;
            learners = new ArrayList();
            IExtensionRegistry reg = Platform.getExtensionRegistry();
            if (reg == null) {
                return null;
            }
            for (IConfigurationElement element : extensions = reg.getConfigurationElementsFor("org.apache.uima.ruta.textruler.learners")) {
                try {
                    TextRulerLearnerFactory factory = (TextRulerLearnerFactory)element.createExecutableExtension("class");
                    learners.add(new TextRulerLearnerController(element.getAttribute("id"), element.getAttribute("name"), factory));
                }
                catch (CoreException e) {
                    TextRulerPlugin.error(e);
                }
            }
        }
        return learners;
    }

    public static void anAlgorithmDidEnd(TextRulerLearnerController algController) {
        if (!TextRulerController.anAlgorithmIsRunning()) {
            if (currentDelegate != null) {
                currentDelegate.globalStatusUpdate(shouldAbort ? "Aborted!" : "Done.");
            }
            TextRulerController.cleanUp();
        }
    }

    public static boolean isRunning() {
        return preprocessorThread != null || TextRulerController.anAlgorithmIsRunning();
    }

    public static synchronized boolean shouldAbort() {
        return shouldAbort;
    }

    public static synchronized void abort() {
        shouldAbort = true;
    }
}

