/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ruta.expression.string;

import java.util.List;
import org.apache.uima.ruta.RutaStream;
import org.apache.uima.ruta.expression.string.IStringExpression;
import org.apache.uima.ruta.expression.string.LiteralStringExpression;
import org.apache.uima.ruta.rule.MatchContext;

public class ComposedStringExpression
extends LiteralStringExpression {
    private final List<IStringExpression> expressions;

    public ComposedStringExpression(List<IStringExpression> expressions) {
        this.expressions = expressions;
    }

    @Override
    public String getStringValue(MatchContext context, RutaStream stream) {
        if (this.expressions == null) {
            return null;
        }
        if (this.expressions.size() == 1) {
            IStringExpression stringExpression = this.expressions.get(0);
            return stringExpression.getStringValue(context, stream);
        }
        StringBuilder result = new StringBuilder();
        for (IStringExpression each : this.getExpressions()) {
            result.append(each.getStringValue(context, stream));
        }
        return result.toString();
    }

    public List<IStringExpression> getExpressions() {
        return this.expressions;
    }
}

