/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ruta.condition;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.antlr.runtime.Token;
import org.apache.commons.lang3.tuple.Triple;
import org.apache.uima.ruta.TypeUsageInformation;
import org.apache.uima.ruta.block.RutaBlock;
import org.apache.uima.ruta.condition.AbstractRutaCondition;
import org.apache.uima.ruta.condition.AfterCondition;
import org.apache.uima.ruta.condition.AndCondition;
import org.apache.uima.ruta.condition.BeforeCondition;
import org.apache.uima.ruta.condition.ContainsCondition;
import org.apache.uima.ruta.condition.ContextCountCondition;
import org.apache.uima.ruta.condition.CountCondition;
import org.apache.uima.ruta.condition.CurrentCountCondition;
import org.apache.uima.ruta.condition.EndsWithCondition;
import org.apache.uima.ruta.condition.FeatureCondition;
import org.apache.uima.ruta.condition.IfCondition;
import org.apache.uima.ruta.condition.ImplicitCondition;
import org.apache.uima.ruta.condition.InListCondition;
import org.apache.uima.ruta.condition.IsCondition;
import org.apache.uima.ruta.condition.LastCondition;
import org.apache.uima.ruta.condition.MOfNCondition;
import org.apache.uima.ruta.condition.MacroCondition;
import org.apache.uima.ruta.condition.NearCondition;
import org.apache.uima.ruta.condition.NotCondition;
import org.apache.uima.ruta.condition.OrCondition;
import org.apache.uima.ruta.condition.ParseCondition;
import org.apache.uima.ruta.condition.PartOfCondition;
import org.apache.uima.ruta.condition.PartOfNeqCondition;
import org.apache.uima.ruta.condition.PositionCondition;
import org.apache.uima.ruta.condition.RegExpCondition;
import org.apache.uima.ruta.condition.ScoreCondition;
import org.apache.uima.ruta.condition.SizeCondition;
import org.apache.uima.ruta.condition.StartsWithCondition;
import org.apache.uima.ruta.condition.TotalCountCondition;
import org.apache.uima.ruta.condition.VoteCondition;
import org.apache.uima.ruta.expression.IRutaExpression;
import org.apache.uima.ruta.expression.bool.IBooleanExpression;
import org.apache.uima.ruta.expression.list.ListExpression;
import org.apache.uima.ruta.expression.number.INumberExpression;
import org.apache.uima.ruta.expression.resource.WordListExpression;
import org.apache.uima.ruta.expression.string.AbstractStringListExpression;
import org.apache.uima.ruta.expression.string.IStringExpression;
import org.apache.uima.ruta.expression.type.AbstractTypeListExpression;
import org.apache.uima.ruta.expression.type.ITypeExpression;
import org.apache.uima.ruta.extensions.RutaParseRuntimeException;
import org.apache.uima.ruta.verbalize.RutaVerbalizer;

public class ConditionFactory {
    private TypeUsageInformation typeUsage;

    public ConditionFactory(TypeUsageInformation typeUsage) {
        this.typeUsage = typeUsage;
    }

    public ConditionFactory() {
        this(null);
    }

    public AbstractRutaCondition createConditionAnd(List<AbstractRutaCondition> conds, RutaBlock parent) {
        return new AndCondition(conds);
    }

    public AbstractRutaCondition createConditionOr(List<AbstractRutaCondition> conds, RutaBlock parent) {
        return new OrCondition(conds);
    }

    public AbstractRutaCondition createConditionNot(AbstractRutaCondition cond, RutaBlock parent) {
        return new NotCondition(cond);
    }

    public AbstractRutaCondition createConditionContains(List<IRutaExpression> args, RutaBlock parent) {
        if (args.size() == 1) {
            IRutaExpression arg = args.get(0);
            if (arg instanceof ITypeExpression) {
                return this.createConditionContains((ITypeExpression)arg, null, null, null, parent);
            }
        } else if (args.size() == 2) {
            arg1 = args.get(0);
            arg2 = args.get(1);
            if (arg1 instanceof ListExpression) {
                return this.createConditionContains((ListExpression)arg1, arg2, null, null, null, parent);
            }
        } else if (args.size() == 3) {
            arg1 = args.get(0);
            arg2 = args.get(1);
            arg3 = args.get(2);
            if (arg1 instanceof ITypeExpression && arg2 instanceof INumberExpression && arg3 instanceof INumberExpression) {
                return this.createConditionContains((ITypeExpression)arg1, (INumberExpression)arg2, (INumberExpression)arg3, null, parent);
            }
        } else if (args.size() == 4) {
            arg1 = args.get(0);
            arg2 = args.get(1);
            arg3 = args.get(2);
            arg4 = args.get(3);
            if (arg1 instanceof ITypeExpression && arg2 instanceof INumberExpression && arg3 instanceof INumberExpression && arg4 instanceof IBooleanExpression) {
                return this.createConditionContains((ITypeExpression)arg1, (INumberExpression)arg2, (INumberExpression)arg3, (IBooleanExpression)arg4, parent);
            }
        } else if (args.size() == 5) {
            arg1 = args.get(0);
            arg2 = args.get(1);
            arg3 = args.get(2);
            arg4 = args.get(3);
            IRutaExpression arg5 = args.get(3);
            if (arg1 instanceof ListExpression && arg3 instanceof INumberExpression && arg4 instanceof INumberExpression && arg5 instanceof IBooleanExpression) {
                return this.createConditionContains((ListExpression)arg1, arg2, (INumberExpression)arg3, (INumberExpression)arg4, (IBooleanExpression)arg5, parent);
            }
        }
        StringBuilder sb = new StringBuilder();
        RutaVerbalizer verb = new RutaVerbalizer();
        Iterator<IRutaExpression> iterator = args.iterator();
        while (iterator.hasNext()) {
            IRutaExpression each = iterator.next();
            sb.append(verb.verbalize(each));
            sb.append("(");
            sb.append(each.getClass().getSimpleName());
            sb.append(")");
            if (!iterator.hasNext()) continue;
            sb.append(", ");
        }
        throw new RutaParseRuntimeException("The condition CONTAINS does not support the following arguments in script " + parent.getName() + ": " + sb.toString());
    }

    public AbstractRutaCondition createConditionContains(ITypeExpression typeExpr, INumberExpression min, INumberExpression max, IBooleanExpression percent, RutaBlock parent) {
        return new ContainsCondition(typeExpr, min, max, percent);
    }

    public AbstractRutaCondition createConditionContains(ListExpression list, IRutaExpression a, INumberExpression min, INumberExpression max, IBooleanExpression percent, RutaBlock env) {
        return new ContainsCondition(list, a, min, max, percent);
    }

    public AbstractRutaCondition createConditionContextCount(ITypeExpression typeExpr, INumberExpression min, INumberExpression max, Token var, RutaBlock parent) {
        String varString = null;
        if (var != null) {
            varString = var.getText();
        }
        return new ContextCountCondition(typeExpr, min, max, varString);
    }

    public AbstractRutaCondition createConditionCurrentCount(ITypeExpression typeExpr, INumberExpression min, INumberExpression max, Token var, RutaBlock parent) {
        String varString = null;
        if (var != null) {
            varString = var.getText();
        }
        return new CurrentCountCondition(typeExpr, min, max, varString);
    }

    public AbstractRutaCondition createConditionCount(ITypeExpression typeExpr, INumberExpression min, INumberExpression max, Token var, RutaBlock parent) {
        String varString = null;
        if (var != null) {
            varString = var.getText();
        }
        return new CountCondition(typeExpr, min, max, varString);
    }

    public AbstractRutaCondition createConditionTotalCount(ITypeExpression typeExpr, INumberExpression min, INumberExpression max, Token var, RutaBlock parent) {
        String varString = null;
        if (var != null) {
            varString = var.getText();
        }
        return new TotalCountCondition(typeExpr, min, max, varString);
    }

    public AbstractRutaCondition createConditionInList(WordListExpression listExpr, IStringExpression arg, RutaBlock parent) {
        return new InListCondition(listExpr, arg);
    }

    public AbstractRutaCondition createConditionMOfN(List<AbstractRutaCondition> conds, INumberExpression min, INumberExpression max, RutaBlock parent) {
        return new MOfNCondition(conds, min, max);
    }

    public AbstractRutaCondition createConditionNear(ITypeExpression typeExpr, INumberExpression min, INumberExpression max, IBooleanExpression direction, IBooleanExpression filtered, RutaBlock parent) {
        return new NearCondition(typeExpr, min, max, direction, filtered);
    }

    public AbstractRutaCondition createConditionPartOf(ITypeExpression type, AbstractTypeListExpression list, RutaBlock parent) {
        if (type != null) {
            return new PartOfCondition(type);
        }
        return new PartOfCondition(list);
    }

    public AbstractRutaCondition createConditionPosition(ITypeExpression typeExpr, INumberExpression pos, IBooleanExpression rel, RutaBlock parent) {
        return new PositionCondition(typeExpr, pos, rel);
    }

    public AbstractRutaCondition createConditionRegExp(IStringExpression patternExpr, IBooleanExpression ignoreCase, RutaBlock parent) {
        return new RegExpCondition(patternExpr, ignoreCase);
    }

    public AbstractRutaCondition createConditionRegExp(IStringExpression v, IStringExpression patternExpr, IBooleanExpression ignoreCase, RutaBlock parent) {
        return new RegExpCondition(v, patternExpr, ignoreCase);
    }

    public AbstractRutaCondition createConditionScore(INumberExpression min, INumberExpression max, Token var, RutaBlock parent) {
        String varString = null;
        if (var != null) {
            varString = var.getText();
        }
        return new ScoreCondition(min, max, varString);
    }

    public AbstractRutaCondition createConditionVote(ITypeExpression type1Expr, ITypeExpression type2Expr, RutaBlock parent) {
        return new VoteCondition(type1Expr, type2Expr);
    }

    public AbstractRutaCondition createConditionLast(ITypeExpression typeExpr, RutaBlock parent) {
        return new LastCondition(typeExpr);
    }

    public AbstractRutaCondition createConditionIf(IBooleanExpression e, RutaBlock parent) {
        return new IfCondition(e);
    }

    public AbstractRutaCondition createConditionFeature(IStringExpression se, Object v, RutaBlock parent) {
        if (v instanceof INumberExpression) {
            return new FeatureCondition(se, (INumberExpression)v);
        }
        if (v instanceof IBooleanExpression) {
            return new FeatureCondition(se, (IBooleanExpression)v);
        }
        if (v instanceof IStringExpression) {
            return new FeatureCondition(se, (IStringExpression)v);
        }
        return null;
    }

    public AbstractRutaCondition createConditionParse(Token id, IStringExpression localeExpr, RutaBlock env) {
        return this.createConditionParse(null, id, localeExpr, env);
    }

    public AbstractRutaCondition createConditionParse(IStringExpression se, Token id, IStringExpression localeExpr, RutaBlock env) {
        String var = id == null ? "" : id.getText();
        return new ParseCondition(se, var, localeExpr);
    }

    public AbstractRutaCondition createConditionIs(ITypeExpression type, AbstractTypeListExpression list, RutaBlock env) {
        if (type != null) {
            return new IsCondition(type);
        }
        return new IsCondition(list);
    }

    public AbstractRutaCondition createConditionAfter(ITypeExpression type, AbstractTypeListExpression list, RutaBlock env) {
        if (type != null) {
            return new AfterCondition(type);
        }
        return new AfterCondition(list);
    }

    public AbstractRutaCondition createConditionBefore(ITypeExpression type, AbstractTypeListExpression list, RutaBlock env) {
        if (type != null) {
            return new BeforeCondition(type);
        }
        return new BeforeCondition(list);
    }

    public AbstractRutaCondition createConditionEndsWith(ITypeExpression type, AbstractTypeListExpression list, RutaBlock env) {
        if (type != null) {
            return new EndsWithCondition(type);
        }
        return new EndsWithCondition(list);
    }

    public AbstractRutaCondition createConditionStartsWith(ITypeExpression type, AbstractTypeListExpression list, RutaBlock env) {
        if (type != null) {
            return new StartsWithCondition(type);
        }
        return new StartsWithCondition(list);
    }

    public AbstractRutaCondition createConditionPartOfNeq(ITypeExpression type, AbstractTypeListExpression list, RutaBlock env) {
        if (type != null) {
            return new PartOfNeqCondition(type);
        }
        return new PartOfNeqCondition(list);
    }

    public AbstractRutaCondition createConditionSize(ListExpression<?> list, INumberExpression min, INumberExpression max, Token var, RutaBlock env) {
        return new SizeCondition(list, min, max, var == null ? null : var.getText());
    }

    public AbstractRutaCondition createConditionInList(AbstractStringListExpression list, IStringExpression arg, RutaBlock env) {
        return new InListCondition(list, arg);
    }

    public AbstractRutaCondition createConditionCount(ListExpression<Object> type, IRutaExpression a, INumberExpression min, INumberExpression max, Token var, RutaBlock env) {
        return new CountCondition(type, a, min, max, var == null ? null : var.getText());
    }

    public AbstractRutaCondition createImplicitCondition(IRutaExpression expr) {
        return new ImplicitCondition(expr);
    }

    public AbstractRutaCondition createMacroCondition(Token id, List<IRutaExpression> args, RutaBlock env) {
        String name = id.getText();
        Triple<Map<String, String>, List<AbstractRutaCondition>, Set<String>> macroConditionDefinition = env.getEnvironment().getMacroCondition(name);
        if (macroConditionDefinition == null) {
            return null;
        }
        int argSize = 0;
        if (args != null) {
            argSize = args.size();
        }
        Map definition = (Map)macroConditionDefinition.getLeft();
        List conditions = (List)macroConditionDefinition.getMiddle();
        Set vars = (Set)macroConditionDefinition.getRight();
        if (definition.size() != argSize) {
            throw new RutaParseRuntimeException("Arguments of macro action '" + name + "' do not match its definition in script " + env.getName() + ": " + definition.values());
        }
        return new MacroCondition(name, definition, conditions, vars, args);
    }
}

