/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ruta.check;

import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.uima.internal.util.XMLUtils;
import org.apache.uima.ruta.check.CheckDocument;
import org.apache.uima.ruta.check.CheckDocumentsContentHandler;
import org.apache.uima.util.FileUtils;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public class CheckDocumentXMLUtils {
    public static void write(List<CheckDocument> docs, File file) throws IOException {
        StringBuilder sb = new StringBuilder();
        sb.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        sb.append("\n");
        sb.append("<documents>");
        sb.append("\n");
        for (CheckDocument checkDocument : docs) {
            sb.append(checkDocument.toXML());
        }
        sb.append("</documents>");
        FileUtils.saveString2File((String)sb.toString(), (File)file, (String)"UTF-8");
    }

    public static List<CheckDocument> read(File file) throws SAXException, IOException {
        if (file == null || !file.exists()) {
            return new ArrayList<CheckDocument>();
        }
        try (FileReader reader = new FileReader(file);){
            InputSource inputSource = new InputSource(reader);
            CheckDocumentsContentHandler handler = new CheckDocumentsContentHandler();
            XMLReader xmlReader = XMLUtils.createXMLReader();
            xmlReader.setContentHandler(handler);
            xmlReader.parse(inputSource);
            List<CheckDocument> list = handler.getCheckDocuments();
            return list;
        }
    }
}

