/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ruta.ide.parser.ast;

import java.util.ArrayList;
import java.util.List;
import org.apache.uima.ruta.ide.parser.ast.RutaAction;
import org.apache.uima.ruta.ide.parser.ast.RutaCondition;
import org.eclipse.dltk.ast.ASTVisitor;
import org.eclipse.dltk.ast.expressions.Expression;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RutaRuleElement
extends Expression {
    protected List<RutaCondition> conditions;
    protected List<RutaAction> actions;
    protected Expression head;
    protected List<Expression> quantifierExpressions;

    public RutaRuleElement(int start, int end) {
        super(start, end);
    }

    public RutaRuleElement(int start, int end, Expression head, List<Expression> quantifierPartExpressions, List<RutaCondition> conditions, List<RutaAction> actions) {
        super(start, end);
        if (conditions != null) {
            this.conditions = conditions;
        } else {
            conditions = new ArrayList<RutaCondition>();
        }
        if (actions != null) {
            this.actions = actions;
        } else {
            actions = new ArrayList<RutaAction>();
        }
        this.quantifierExpressions = quantifierPartExpressions != null ? quantifierPartExpressions : new ArrayList<Expression>();
        this.head = head;
    }

    public int getKind() {
        return 1067;
    }

    public void traverse(ASTVisitor visitor) throws Exception {
        if (visitor.visit((Expression)this)) {
            if (this.head != null) {
                this.head.traverse(visitor);
            }
            if (this.quantifierExpressions != null) {
                for (Expression qpe : this.quantifierExpressions) {
                    qpe.traverse(visitor);
                }
            }
            if (this.conditions != null) {
                for (RutaCondition cond : this.conditions) {
                    cond.traverse(visitor);
                }
            }
            if (this.actions != null) {
                for (RutaAction action : this.actions) {
                    action.traverse(visitor);
                }
            }
        }
    }

    public Expression getHead() {
        return this.head;
    }

    public List<RutaAction> getActions() {
        return this.actions;
    }

    public List<RutaCondition> getConditions() {
        return this.conditions;
    }

    public List<Expression> getQuantifierExpressions() {
        return this.quantifierExpressions;
    }

    public String toString() {
        return ((Object)((Object)this)).getClass().getSimpleName() + " : " + super.toString();
    }
}

