/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ruta.engine;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import org.apache.commons.io.IOUtils;
import org.apache.uima.UIMAFramework;
import org.apache.uima.analysis_engine.AnalysisEngine;
import org.apache.uima.analysis_engine.AnalysisEngineDescription;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.analysis_engine.metadata.AnalysisEngineMetaData;
import org.apache.uima.cas.CAS;
import org.apache.uima.resource.ResourceConfigurationException;
import org.apache.uima.resource.ResourceInitializationException;
import org.apache.uima.resource.ResourceSpecifier;
import org.apache.uima.resource.metadata.ConfigurationParameterSettings;
import org.apache.uima.resource.metadata.TypeSystemDescription;
import org.apache.uima.ruta.engine.RutaEngine;
import org.apache.uima.util.CasCreationUtils;
import org.apache.uima.util.FileUtils;
import org.apache.uima.util.InvalidXMLException;
import org.apache.uima.util.XMLInputSource;

public class Ruta {
    public static void apply(CAS cas, String script) throws IOException, InvalidXMLException, ResourceInitializationException, ResourceConfigurationException, AnalysisEngineProcessException, URISyntaxException {
        String viewName = cas.getViewName();
        URL aedesc = RutaEngine.class.getResource("BasicEngine.xml");
        AnalysisEngine ae = Ruta.wrapAnalysisEngine(aedesc, viewName);
        File scriptFile = File.createTempFile("Ruta", ".ruta");
        scriptFile.deleteOnExit();
        if (!script.startsWith("PACKAGE")) {
            script = "PACKAGE org.apache.uima.ruta;\n" + script;
        }
        FileUtils.saveString2File((String)script, (File)scriptFile);
        ae.setConfigParameterValue("scriptPaths", (Object)new String[]{scriptFile.getParentFile().getAbsolutePath()});
        String name = scriptFile.getName().substring(0, scriptFile.getName().length() - 5);
        ae.setConfigParameterValue("mainScript", (Object)name);
        ae.reconfigure();
        ae.process(cas);
        scriptFile.delete();
        ae.destroy();
    }

    public static AnalysisEngine wrapAnalysisEngine(URL descriptorUrl, String viewName) throws ResourceInitializationException, ResourceConfigurationException, InvalidXMLException, IOException, URISyntaxException {
        return Ruta.wrapAnalysisEngine(descriptorUrl, viewName, false, Charset.defaultCharset().name());
    }

    public static AnalysisEngine wrapAnalysisEngine(URL descriptorUrl, String viewName, boolean rutaEngine, String encoding) throws ResourceInitializationException, ResourceConfigurationException, InvalidXMLException, IOException, URISyntaxException {
        if (viewName.equals("_InitialView")) {
            XMLInputSource in = new XMLInputSource(descriptorUrl);
            ResourceSpecifier specifier = UIMAFramework.getXMLParser().parseResourceSpecifier(in);
            AnalysisEngine ae = UIMAFramework.produceAnalysisEngine((ResourceSpecifier)specifier);
            return ae;
        }
        InputStream inputStream = null;
        inputStream = rutaEngine ? Ruta.class.getResourceAsStream("AAEDBasicEngine.xml") : Ruta.class.getResourceAsStream("AAED.xml");
        String aaedString = IOUtils.toString(inputStream, encoding);
        String absolutePath = descriptorUrl.toExternalForm();
        aaedString = aaedString.replaceAll("\\$\\{sofaName\\}", viewName);
        aaedString = aaedString.replaceAll("\\$\\{descriptorLocation\\}", absolutePath);
        File tempFile = File.createTempFile("RutaAAED", ".xml");
        FileUtils.saveString2File((String)aaedString, (File)tempFile);
        XMLInputSource in = new XMLInputSource(tempFile);
        ResourceSpecifier specifier = UIMAFramework.getXMLParser().parseResourceSpecifier(in);
        AnalysisEngine ae = UIMAFramework.produceAnalysisEngine((ResourceSpecifier)specifier);
        tempFile.delete();
        return ae;
    }

    public static AnalysisEngineDescription createAnalysisEngineDescription(String script) throws IOException, InvalidXMLException, ResourceInitializationException {
        return Ruta.createAnalysisEngineDescription(script, null);
    }

    public static AnalysisEngineDescription createAnalysisEngineDescription(String script, TypeSystemDescription ... tsds) throws IOException, InvalidXMLException, ResourceInitializationException {
        File scriptFile = File.createTempFile("Ruta", ".ruta");
        scriptFile.deleteOnExit();
        if (!script.startsWith("PACKAGE")) {
            script = "PACKAGE org.apache.uima.ruta;\n" + script;
        }
        FileUtils.saveString2File((String)script, (File)scriptFile);
        URL url = RutaEngine.class.getResource("BasicEngine.xml");
        XMLInputSource in = new XMLInputSource(url);
        AnalysisEngineDescription aed = (AnalysisEngineDescription)UIMAFramework.getXMLParser().parseResourceSpecifier(in);
        AnalysisEngineMetaData metaData = aed.getAnalysisEngineMetaData();
        ConfigurationParameterSettings settings = metaData.getConfigurationParameterSettings();
        settings.setParameterValue("scriptPaths", (Object)new String[]{scriptFile.getParentFile().getAbsolutePath()});
        String name = scriptFile.getName().substring(0, scriptFile.getName().length() - 5);
        settings.setParameterValue("mainScript", (Object)name);
        if (tsds != null) {
            ArrayList<TypeSystemDescription> tsdList = new ArrayList<TypeSystemDescription>();
            tsdList.add(metaData.getTypeSystem());
            tsdList.addAll(Arrays.asList(tsds));
            TypeSystemDescription typeSystemDescription = CasCreationUtils.mergeTypeSystems(tsdList);
            metaData.setTypeSystem(typeSystemDescription);
        }
        return aed;
    }
}

