/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ruta.action;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.uima.analysis_engine.AnalysisEngine;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.cas.CAS;
import org.apache.uima.cas.Type;
import org.apache.uima.cas.text.AnnotationFS;
import org.apache.uima.cas.text.AnnotationIndex;
import org.apache.uima.resource.ResourceInitializationException;
import org.apache.uima.ruta.RutaBlock;
import org.apache.uima.ruta.RutaModule;
import org.apache.uima.ruta.RutaStream;
import org.apache.uima.ruta.ScriptApply;
import org.apache.uima.ruta.action.CallAction;
import org.apache.uima.ruta.expression.list.TypeListExpression;
import org.apache.uima.ruta.rule.RuleElement;
import org.apache.uima.ruta.rule.RuleMatch;
import org.apache.uima.ruta.type.RutaBasic;
import org.apache.uima.ruta.visitor.InferenceCrowd;

public class ExecAction
extends CallAction {
    private TypeListExpression typeList;

    public ExecAction(String namespace) {
        super(namespace);
    }

    public ExecAction(String ns, TypeListExpression tl) {
        this(ns);
        this.typeList = tl;
    }

    protected void callScript(String blockName, RuleMatch match, RuleElement element, RutaStream stream, InferenceCrowd crowd, RutaModule targetScript) {
        RutaBlock block = targetScript.getBlock(blockName);
        if (block == null) {
            return;
        }
        RutaStream completeStream = stream.getCompleteStream();
        ScriptApply apply = block.apply(completeStream, crowd);
        match.addDelegateApply(this, apply);
    }

    protected void callEngine(RuleMatch match, InferenceCrowd crowd, AnalysisEngine targetEngine, RuleElement element, RutaStream stream) throws ResourceInitializationException, AnalysisEngineProcessException {
        CAS cas = stream.getCas();
        targetEngine.process(cas);
        if (this.typeList != null) {
            List list = this.typeList.getList(element.getParent());
            for (Type type : list) {
                HashMap<RutaBasic, HashSet<AnnotationFS>> map = new HashMap<RutaBasic, HashSet<AnnotationFS>>();
                AnnotationIndex ai = cas.getAnnotationIndex(type);
                for (AnnotationFS fs : ai) {
                    RutaBasic basic = stream.getFirstBasicInWindow(fs);
                    if (basic == null) continue;
                    HashSet<AnnotationFS> collection = (HashSet<AnnotationFS>)map.get((Object)basic);
                    if (collection == null) {
                        collection = new HashSet<AnnotationFS>();
                        map.put(basic, collection);
                    }
                    collection.add(fs);
                }
                Set entrySet = map.entrySet();
                for (Map.Entry entry : entrySet) {
                    for (AnnotationFS each : (Collection)entry.getValue()) {
                        stream.removeAnnotation(each);
                        stream.addAnnotation(each, true, match);
                    }
                }
            }
        }
    }

    public TypeListExpression getTypeList() {
        return this.typeList;
    }
}

