/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ruta.action;

import java.util.List;
import org.apache.uima.cas.Type;
import org.apache.uima.ruta.RutaBlock;
import org.apache.uima.ruta.RutaEnvironment;
import org.apache.uima.ruta.RutaStream;
import org.apache.uima.ruta.action.AbstractRutaAction;
import org.apache.uima.ruta.expression.RutaExpression;
import org.apache.uima.ruta.expression.bool.BooleanExpression;
import org.apache.uima.ruta.expression.list.ListExpression;
import org.apache.uima.ruta.expression.number.NumberExpression;
import org.apache.uima.ruta.expression.string.StringExpression;
import org.apache.uima.ruta.expression.type.TypeExpression;
import org.apache.uima.ruta.rule.RuleElement;
import org.apache.uima.ruta.rule.RuleMatch;
import org.apache.uima.ruta.visitor.InferenceCrowd;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AddAction
extends AbstractRutaAction {
    private String var;
    private List<RutaExpression> elements;

    public AddAction(String var, List<RutaExpression> list) {
        this.var = var;
        this.elements = list;
    }

    public String getListExpr() {
        return this.var;
    }

    public List<RutaExpression> getElements() {
        return this.elements;
    }

    @Override
    public void execute(RuleMatch match, RuleElement element, RutaStream stream, InferenceCrowd crowd) {
        RutaBlock parent = element.getParent();
        RutaEnvironment environment = parent.getEnvironment();
        List list = environment.getVariableValue(this.var, List.class);
        Class<?> vgtype = environment.getVariableGenericType(this.var);
        for (RutaExpression each : this.elements) {
            if (each instanceof ListExpression) {
                ListExpression l = (ListExpression)each;
                list.addAll(l.getList(parent));
                continue;
            }
            if (vgtype.equals(Boolean.class) && each instanceof BooleanExpression) {
                list.add(((BooleanExpression)each).getBooleanValue(parent));
                continue;
            }
            if (vgtype.equals(Integer.class) && each instanceof NumberExpression) {
                list.add(((NumberExpression)each).getIntegerValue(parent));
                continue;
            }
            if (vgtype.equals(Double.class) && each instanceof NumberExpression) {
                list.add(((NumberExpression)each).getDoubleValue(parent));
                continue;
            }
            if (vgtype.equals(Type.class) && each instanceof TypeExpression) {
                list.add(((TypeExpression)each).getType(parent));
                continue;
            }
            if (!vgtype.equals(String.class) || !(each instanceof StringExpression)) continue;
            list.add(((StringExpression)each).getStringValue(parent));
        }
    }
}

