/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ruta.ide.ui.documentation;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FilenameFilter;
import java.io.Reader;
import org.apache.uima.ruta.ide.ui.documentation.IRutaPagesLocation;

public class HtmlRutaPagesLocation
implements IRutaPagesLocation {
    private File fLocation;

    public HtmlRutaPagesLocation(File location) {
        if (!location.isDirectory()) {
            throw new IllegalArgumentException();
        }
        this.fLocation = location;
    }

    @Override
    public Reader getHtmlInfo(String keyword) {
        final String pattern = keyword + ".htm";
        File[] result = this.fLocation.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.equals(pattern);
            }
        });
        if (result != null && result.length >= 1 && result[0] != null) {
            try {
                FileReader reader = new FileReader(result[0]);
                return reader;
            }
            catch (FileNotFoundException fileNotFoundException) {
                // empty catch block
            }
        }
        return null;
    }

    public File getLocation() {
        return this.fLocation;
    }

    public void setLocation(File location) {
        if (!location.isDirectory()) {
            return;
        }
        this.fLocation = location;
    }
}

