package org.apache.turbine.om;


/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */


/**
 * A factory that can provide retrievers
 *
 * @author <a href="mailto:jmcnally@collab.net">John D. McNally</a>
 * @version $Id: RetrieverFactory.java 1706239 2015-10-01 13:18:35Z tv $
 */
public interface RetrieverFactory
{
    /**
     * Gets an object capable of retrieving objects of type "className"
     *
     * @param className the class name of the {@link Retriever} implementation
     * @return the {@link Retriever} instance
     * @throws Exception if the instance could not be provided
     */
    Retriever getInstance(String className)
        throws Exception;
}
