
-----------------------------------------------------------------------------
-- TURBINE_PERMISSION
-----------------------------------------------------------------------------
DROP TABLE TURBINE_PERMISSION CASCADE CONSTRAINTS;

CREATE TABLE TURBINE_PERMISSION
(
    PERMISSION_ID NUMBER(10,0) NOT NULL,
    PERMISSION_NAME VARCHAR2(64) NOT NULL,
    CONSTRAINT TURBINE_PERMISSION_U_1 UNIQUE (PERMISSION_NAME)
);

ALTER TABLE TURBINE_PERMISSION
    ADD CONSTRAINT TURBINE_PERMISSION_PK
PRIMARY KEY (PERMISSION_ID);






-----------------------------------------------------------------------------
-- TURBINE_ROLE
-----------------------------------------------------------------------------
DROP TABLE TURBINE_ROLE CASCADE CONSTRAINTS;

CREATE TABLE TURBINE_ROLE
(
    ROLE_ID NUMBER(10,0) NOT NULL,
    ROLE_NAME VARCHAR2(64) NOT NULL,
    CONSTRAINT TURBINE_ROLE_U_1 UNIQUE (ROLE_NAME)
);

ALTER TABLE TURBINE_ROLE
    ADD CONSTRAINT TURBINE_ROLE_PK
PRIMARY KEY (ROLE_ID);






-----------------------------------------------------------------------------
-- TURBINE_GROUP
-----------------------------------------------------------------------------
DROP TABLE TURBINE_GROUP CASCADE CONSTRAINTS;

CREATE TABLE TURBINE_GROUP
(
    GROUP_ID NUMBER(10,0) NOT NULL,
    GROUP_NAME VARCHAR2(64) NOT NULL,
    CONSTRAINT TURBINE_GROUP_U_1 UNIQUE (GROUP_NAME)
);

ALTER TABLE TURBINE_GROUP
    ADD CONSTRAINT TURBINE_GROUP_PK
PRIMARY KEY (GROUP_ID);






-----------------------------------------------------------------------------
-- TURBINE_ROLE_PERMISSION
-----------------------------------------------------------------------------
DROP TABLE TURBINE_ROLE_PERMISSION CASCADE CONSTRAINTS;

CREATE TABLE TURBINE_ROLE_PERMISSION
(
    ROLE_ID NUMBER(10,0) NOT NULL,
    PERMISSION_ID NUMBER(10,0) NOT NULL
);

ALTER TABLE TURBINE_ROLE_PERMISSION
    ADD CONSTRAINT TURBINE_ROLE_PERMISSION_PK
PRIMARY KEY (ROLE_ID,PERMISSION_ID);






-----------------------------------------------------------------------------
-- TURBINE_USER
-----------------------------------------------------------------------------
DROP TABLE TURBINE_USER CASCADE CONSTRAINTS;

CREATE TABLE TURBINE_USER
(
    USER_ID NUMBER(10,0) NOT NULL,
    LOGIN_NAME VARCHAR2(64) NOT NULL,
    PASSWORD_VALUE VARCHAR2(16) NOT NULL,
    FIRST_NAME VARCHAR2(64) NOT NULL,
    LAST_NAME VARCHAR2(64) NOT NULL,
    EMAIL VARCHAR2(64),
    CONFIRM_VALUE VARCHAR2(16),
    MODIFIED TIMESTAMP,
    CREATED TIMESTAMP,
    LAST_LOGIN TIMESTAMP,
    OBJECTDATA BLOB,
    CONSTRAINT TURBINE_USER_U_1 UNIQUE (LOGIN_NAME)
);

ALTER TABLE TURBINE_USER
    ADD CONSTRAINT TURBINE_USER_PK
PRIMARY KEY (USER_ID);






-----------------------------------------------------------------------------
-- TURBINE_USER_GROUP_ROLE
-----------------------------------------------------------------------------
DROP TABLE TURBINE_USER_GROUP_ROLE CASCADE CONSTRAINTS;

CREATE TABLE TURBINE_USER_GROUP_ROLE
(
    USER_ID NUMBER(10,0) NOT NULL,
    GROUP_ID NUMBER(10,0) NOT NULL,
    ROLE_ID NUMBER(10,0) NOT NULL
);

ALTER TABLE TURBINE_USER_GROUP_ROLE
    ADD CONSTRAINT TURBINE_USER_GROUP_ROLE_PK
PRIMARY KEY (USER_ID,GROUP_ID,ROLE_ID);











ALTER TABLE TURBINE_ROLE_PERMISSION
    ADD CONSTRAINT TURBINE_ROLE_PERMISSION_FK_1 FOREIGN KEY (ROLE_ID)
    REFERENCES TURBINE_ROLE (ROLE_ID)
;

ALTER TABLE TURBINE_ROLE_PERMISSION
    ADD CONSTRAINT TURBINE_ROLE_PERMISSION_FK_2 FOREIGN KEY (PERMISSION_ID)
    REFERENCES TURBINE_PERMISSION (PERMISSION_ID)
;





ALTER TABLE TURBINE_USER_GROUP_ROLE
    ADD CONSTRAINT TURBINE_USER_GROUP_ROLE_FK_1 FOREIGN KEY (USER_ID)
    REFERENCES TURBINE_USER (USER_ID)
;

ALTER TABLE TURBINE_USER_GROUP_ROLE
    ADD CONSTRAINT TURBINE_USER_GROUP_ROLE_FK_2 FOREIGN KEY (GROUP_ID)
    REFERENCES TURBINE_GROUP (GROUP_ID)
;

ALTER TABLE TURBINE_USER_GROUP_ROLE
    ADD CONSTRAINT TURBINE_USER_GROUP_ROLE_FK_3 FOREIGN KEY (ROLE_ID)
    REFERENCES TURBINE_ROLE (ROLE_ID)
;



