/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fulcrum.intake.model;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Locale;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fulcrum.intake.IntakeError;
import org.apache.fulcrum.intake.IntakeException;
import org.apache.fulcrum.intake.IntakeServiceFacade;
import org.apache.fulcrum.intake.Retrievable;
import org.apache.fulcrum.intake.model.Group;
import org.apache.fulcrum.intake.validator.InitableByConstraintMap;
import org.apache.fulcrum.intake.validator.ValidationException;
import org.apache.fulcrum.intake.validator.Validator;
import org.apache.fulcrum.intake.xmlmodel.Rule;
import org.apache.fulcrum.intake.xmlmodel.XmlField;
import org.apache.fulcrum.parser.ValueParser;

public abstract class Field {
    private static final String EMPTY = "";
    private static final String VALUE_IF_ABSENT_KEY = "_vifa_";
    public static final String defaultValidatorPackage = "org.apache.fulcrum.intake.validator.";
    public static final String defaultFieldPackage = "org.apache.fulcrum.intake.model.";
    protected final String name;
    protected final String key;
    protected String displayName;
    protected final String mapToObject;
    protected Validator validator;
    protected final Method getter;
    protected final Method setter;
    protected String ifRequiredMessage;
    protected final boolean isMultiValued;
    protected final Group group;
    protected boolean alwaysRequired;
    protected Object onError;
    protected Object defaultValue;
    protected Object emptyValue;
    private String displaySize;
    private String maxSize;
    protected boolean setFlag;
    protected boolean validFlag;
    protected boolean validated;
    protected boolean required;
    protected boolean initialized;
    protected String message;
    protected Retrievable retrievable;
    private Locale locale;
    private String stringValue;
    private String[] stringValues;
    private Object validValue;
    private Object testValue;
    private Object[] valArray;
    protected ValueParser parser;
    protected Log log = LogFactory.getLog(this.getClass());
    protected boolean isDebugEnabled = this.log.isDebugEnabled();
    static /* synthetic */ Class class$org$apache$fulcrum$intake$validator$DefaultValidator;

    public Field(XmlField field, Group group) throws IntakeException {
        Rule maxLengthRule;
        Rule reqRule;
        this.group = group;
        this.key = field.getKey();
        this.name = field.getName();
        this.displayName = field.getDisplayName();
        this.displaySize = field.getDisplaySize();
        this.isMultiValued = field.isMultiValued();
        try {
            this.setDefaultValue(field.getDefaultValue());
        }
        catch (RuntimeException e) {
            this.log.error((Object)("Could not set default value of " + this.getDisplayName() + " to " + field.getDefaultValue()), (Throwable)e);
        }
        try {
            this.setEmptyValue(field.getEmptyValue());
        }
        catch (RuntimeException e) {
            this.log.error((Object)("Could not set empty value of " + this.getDisplayName() + " to " + field.getEmptyValue()), (Throwable)e);
        }
        String validatorClassName = field.getValidator();
        if (validatorClassName == null) {
            validatorClassName = this.getDefaultValidator();
        } else if (validatorClassName.indexOf(46) == -1) {
            validatorClassName = defaultValidatorPackage + validatorClassName;
        }
        if (validatorClassName != null) {
            try {
                this.validator = (Validator)Class.forName(validatorClassName).newInstance();
            }
            catch (InstantiationException e) {
                throw new IntakeException("Could not create new instance of Validator(" + validatorClassName + ")", e);
            }
            catch (IllegalAccessException e) {
                throw new IntakeException("Could not create new instance of Validator(" + validatorClassName + ")", e);
            }
            catch (ClassNotFoundException e) {
                throw new IntakeException("Could not load Validator class(" + validatorClassName + ")", e);
            }
            if (this.validator instanceof InitableByConstraintMap) {
                ((InitableByConstraintMap)((Object)this.validator)).init(field.getRuleMap());
            } else {
                throw new IntakeError("All Validation objects must be subclasses of InitableByConstraintMap");
            }
        }
        if ((reqRule = (Rule)field.getRuleMap().get("required")) != null) {
            this.alwaysRequired = Boolean.valueOf(reqRule.getValue());
            this.ifRequiredMessage = reqRule.getMessage();
        }
        if ((maxLengthRule = (Rule)field.getRuleMap().get("maxLength")) != null) {
            this.maxSize = maxLengthRule.getValue();
        }
        this.mapToObject = field.getMapToObject();
        String propName = field.getMapToProperty();
        Method tmpGetter = null;
        Method tmpSetter = null;
        if (StringUtils.isNotEmpty((String)this.mapToObject) && StringUtils.isNotEmpty((String)propName)) {
            try {
                tmpGetter = IntakeServiceFacade.getFieldGetter(this.mapToObject, propName);
            }
            catch (Exception e) {
                this.log.error((Object)("IntakeService could not map the getter for field " + this.getDisplayName() + " in group " + this.group.getIntakeGroupName() + " to the property " + propName + " in object " + this.mapToObject), (Throwable)e);
            }
            try {
                tmpSetter = IntakeServiceFacade.getFieldSetter(this.mapToObject, propName);
            }
            catch (Exception e) {
                this.log.error((Object)("IntakeService could not map the setter for field " + this.getDisplayName() + " in group " + this.group.getIntakeGroupName() + " to the property " + propName + " in object " + this.mapToObject), (Throwable)e);
            }
        }
        this.getter = tmpGetter;
        this.setter = tmpSetter;
        this.valArray = new Object[1];
    }

    public Field init(ValueParser pp) throws IntakeException {
        this.parser = pp;
        this.validFlag = true;
        this.validated = false;
        this.locale = pp.getLocale();
        if (pp.containsKey((Object)this.getKey())) {
            if (this.isDebugEnabled) {
                this.log.debug((Object)(this.name + ": Found our Key in the request, setting Value"));
            }
            if (pp.getString(this.getKey()) != null) {
                this.setFlag = true;
            }
        } else if (pp.containsKey((Object)this.getValueIfAbsent()) && pp.getString(this.getValueIfAbsent()) != null) {
            pp.add(this.getKey(), pp.getString(this.getValueIfAbsent()));
            this.setFlag = true;
        }
        this.initialized = true;
        return this;
    }

    public Field init(Retrievable obj) {
        if (!this.initialized) {
            this.validFlag = true;
            this.validated = false;
        }
        this.retrievable = obj;
        return this;
    }

    public Group getGroup() {
        return this.group;
    }

    public Locale getLocale() {
        return this.locale;
    }

    protected String getDefaultValidator() {
        return (class$org$apache$fulcrum$intake$validator$DefaultValidator == null ? (class$org$apache$fulcrum$intake$validator$DefaultValidator = Field.class$("org.apache.fulcrum.intake.validator.DefaultValidator")) : class$org$apache$fulcrum$intake$validator$DefaultValidator).getName();
    }

    public Validator getValidator() {
        return this.validator;
    }

    public boolean isMultiValued() {
        return this.isMultiValued;
    }

    public boolean isRequired() {
        return this.alwaysRequired || this.required;
    }

    public void setRequired(boolean v) {
        this.setRequired(v, this.ifRequiredMessage);
    }

    public void setRequired(boolean v, String message) {
        this.required = v;
        if (v && (!this.setFlag || null == this.getTestValue())) {
            this.validFlag = false;
            this.message = message;
        }
    }

    public void removeFromRequest() {
        this.parser.remove(this.getKey());
        this.parser.remove(this.getKey() + VALUE_IF_ABSENT_KEY);
    }

    public void dispose() {
        this.parser = null;
        this.initialized = false;
        this.setFlag = false;
        this.validFlag = false;
        this.validated = false;
        this.required = false;
        this.message = null;
        this.retrievable = null;
        this.locale = null;
        this.stringValue = null;
        this.stringValues = null;
        this.validValue = null;
        this.testValue = null;
        this.valArray[0] = null;
    }

    public String getKey() {
        return this.group == null ? this.key : this.group.getObjectKey() + this.key;
    }

    public String getValueIfAbsent() {
        return this.getKey() + VALUE_IF_ABSENT_KEY;
    }

    public boolean isValid() {
        return this.validFlag;
    }

    public boolean isValidated() {
        return this.validated;
    }

    public boolean isSet() {
        return this.setFlag;
    }

    public String getDisplayName() {
        return this.displayName == null ? this.name : this.displayName;
    }

    public void setDisplayName(String newDisplayName) {
        this.displayName = newDisplayName;
    }

    public String getMessage() {
        return this.message == null ? EMPTY : this.message;
    }

    public void setMessage(String message) {
        this.message = message;
        this.validFlag = false;
    }

    protected boolean validate(ValueParser pp) {
        return this.validate();
    }

    public boolean validate() {
        this.log.debug((Object)(this.name + ": validate()"));
        if (this.isMultiValued) {
            this.stringValues = this.parser.getStrings(this.getKey());
            if (this.isDebugEnabled) {
                this.log.debug((Object)(this.name + ": Multi-Valued, Value is " + this.stringValue));
                if (this.stringValues != null) {
                    for (int i = 0; i < this.stringValues.length; ++i) {
                        this.log.debug((Object)(this.name + ": " + i + ". Value: " + this.stringValues[i]));
                    }
                }
            }
            if (this.validator != null) {
                this.setTestValue(this.stringValues);
                try {
                    this.validator.assertValidity(this);
                }
                catch (ValidationException ve) {
                    this.setMessage(ve.getMessage());
                }
            }
            if (this.validFlag) {
                this.doSetValue();
            }
        } else {
            this.stringValue = this.parser.getString(this.getKey());
            if (this.isDebugEnabled) {
                this.log.debug((Object)(this.name + ": Single Valued, Value is " + this.stringValue));
            }
            if (this.validator != null) {
                this.setTestValue(this.parser.getString(this.getKey()));
                try {
                    this.validator.assertValidity(this);
                    this.log.debug((Object)(this.name + ": Value is ok"));
                    this.doSetValue();
                }
                catch (ValidationException ve) {
                    this.log.debug((Object)(this.name + ": Value failed validation!"));
                    this.setMessage(ve.getMessage());
                }
            } else {
                this.doSetValue();
            }
        }
        this.validated = true;
        return this.validFlag;
    }

    public abstract void setDefaultValue(String var1);

    public abstract void setEmptyValue(String var1);

    protected void doSetValue(ValueParser pp) {
        this.doSetValue();
    }

    protected abstract void doSetValue();

    void setInitialValue(Object obj) {
        this.validValue = obj;
    }

    public Object getInitialValue() throws IntakeException {
        if (this.validValue == null) {
            if (this.retrievable != null) {
                this.getProperty(this.retrievable);
            } else {
                this.getDefault();
            }
        }
        return this.validValue;
    }

    void setTestValue(Object obj) {
        this.testValue = obj;
    }

    public Object getTestValue() {
        return this.testValue;
    }

    public Object getValue() {
        Object val = null;
        try {
            val = this.getInitialValue();
        }
        catch (IntakeException e) {
            this.log.error((Object)("Could not get intial value of " + this.getDisplayName() + " in group " + this.group.getIntakeGroupName()), (Throwable)e);
        }
        if (this.getTestValue() != null) {
            val = this.getTestValue();
        }
        if (val == null) {
            val = this.onError;
        }
        return val;
    }

    public String toString() {
        String res = EMPTY;
        if (this.stringValue != null) {
            res = this.stringValue;
        } else if (this.getValue() != null) {
            res = this.getValue().toString();
        }
        return res;
    }

    public String getHTMLString() {
        String res = this.toString();
        return StringUtils.replace((String)res, (String)"\"", (String)"&quot;");
    }

    public void getProperty(Object obj) throws IntakeException {
        try {
            this.validValue = this.getter.invoke(obj, (Object[])null);
        }
        catch (IllegalAccessException e) {
            this.throwSetGetException("getter", obj, this.getDisplayName(), this.group.getIntakeGroupName(), e);
        }
        catch (IllegalArgumentException e) {
            this.throwSetGetException("getter", obj, this.getDisplayName(), this.group.getIntakeGroupName(), e);
        }
        catch (InvocationTargetException e) {
            this.throwSetGetException("getter", obj, this.getDisplayName(), this.group.getIntakeGroupName(), e);
        }
    }

    public void getDefault() {
        this.validValue = this.getDefaultValue();
    }

    public void setProperty(Object obj) throws IntakeException {
        if (this.isDebugEnabled) {
            this.log.debug((Object)(this.name + ".setProperty(" + obj.getClass().getName() + ")"));
        }
        if (!this.isValid()) {
            throw new IntakeException("Attempted to assign an invalid input.");
        }
        if (this.isSet() && null != this.getTestValue()) {
            this.valArray[0] = this.getTestValue();
            if (this.isDebugEnabled) {
                this.log.debug((Object)(this.name + ": Property is set, value is " + this.valArray[0]));
            }
        } else {
            this.valArray[0] = this.getSafeEmptyValue();
            if (this.isDebugEnabled) {
                this.log.debug((Object)(this.name + ": Property is not set, using emptyValue " + this.valArray[0]));
            }
        }
        try {
            if (this.setter != null) {
                this.setter.invoke(obj, this.valArray);
            } else if (this.isDebugEnabled) {
                this.log.debug((Object)(this.name + ": has a null setter for the mapToProperty" + " Attribute, although all Fields should be mapped" + " to " + this.mapToObject + ". If this is unwanted, you" + " should double check the mapToProperty Attribute, and" + " consult the logs. The Turbine Intake Service will" + " have logged a detailed Message with the error."));
            }
        }
        catch (IllegalAccessException e) {
            this.throwSetGetException("setter", obj, this.getDisplayName(), this.group.getIntakeGroupName(), e);
        }
        catch (IllegalArgumentException e) {
            this.throwSetGetException("setter", obj, this.getDisplayName(), this.group.getIntakeGroupName(), e);
        }
        catch (InvocationTargetException e) {
            this.throwSetGetException("setter", obj, this.getDisplayName(), this.group.getIntakeGroupName(), e);
        }
    }

    private void throwSetGetException(String type, Object obj, String fieldName, String groupName, Exception e) throws IntakeException {
        throw new IntakeException("Could not execute " + type + " method for " + fieldName + " in group " + groupName + " on " + obj.getClass().getName(), e);
    }

    public Object getDefaultValue() {
        return this.defaultValue;
    }

    public Object getEmptyValue() {
        return this.emptyValue;
    }

    protected Object getSafeEmptyValue() {
        return this.getEmptyValue();
    }

    public String getName() {
        return this.name;
    }

    public String getDisplaySize() {
        return StringUtils.isEmpty((String)this.displaySize) ? EMPTY : this.displaySize;
    }

    public String getMaxSize() {
        return StringUtils.isEmpty((String)this.maxSize) ? EMPTY : this.maxSize;
    }

    public String getStringValue() {
        return this.toString();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

