/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fulcrum.jce.crypto.cli;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.fulcrum.jce.crypto.HexConverter;
import org.apache.fulcrum.jce.crypto.StreamUtil;
import org.apache.fulcrum.jce.crypto.extended.CryptoParametersJ8;
import org.apache.fulcrum.jce.crypto.extended.CryptoStreamFactoryJ8Template;
import org.apache.fulcrum.jce.crypto.extended.CryptoUtilJ8;

public class CLI2 {
    static boolean debug = false;
    private static final Pattern HEXADECIMAL_PATTERN = Pattern.compile("\\p{XDigit}+");

    public static void main(String[] args) {
        try {
            if (args.length == 0) {
                CLI2.printHelp();
                return;
            }
            String operationMode = args[0];
            String msg = "No operationMode";
            if (operationMode == null || operationMode.equals("")) {
                throw new IllegalArgumentException(msg);
            }
            if (operationMode.equals("info")) {
                CLI2.printInfo();
                return;
            }
            if (operationMode.equals("help")) {
                CLI2.printHelp();
                return;
            }
            if (args.length < 3) {
                CLI2.printHelp();
                throw new IllegalArgumentException("Invalid command line");
            }
            if (operationMode.equals("file")) {
                CLI2.processFiles(args);
            } else if (operationMode.equals("string")) {
                CLI2.processString(args);
            }
        }
        catch (Exception e) {
            System.out.println("Error: " + e.getMessage());
            e.printStackTrace();
        }
    }

    private static void printInfo() {
        CryptoUtilJ8 cryptoUtilJ8 = CryptoUtilJ8.getInstance();
        System.out.println("");
        System.out.println("\t| Default Crypto factory class: \t" + cryptoUtilJ8.getCryptoStreamFactory().getClass());
        System.out.println("\t|_Default Algorithm used: \t" + cryptoUtilJ8.getCryptoStreamFactory().getAlgorithm());
        for (int i = 0; i < CryptoParametersJ8.LISTS.length; ++i) {
            List list = CryptoParametersJ8.LISTS[i];
            String type = CryptoParametersJ8.PROVIDER_TYPES[i];
            System.out.println("\t|Algorithms (unchecked) supported: \t" + list);
            List<String> result = CryptoParametersJ8.getSupportedAlgos(list, type, true);
            LinkedHashSet<String> resultSet = new LinkedHashSet<String>(result);
            resultSet.addAll(CryptoParametersJ8.getSupportedAlgos(list, type, false));
            System.out.println(String.format("\t|_Matched supported %2$s:\t%1$s", resultSet, type));
        }
        List<String> supportedAlgos = CryptoParametersJ8.init();
        System.out.println(String.format("\t|Effectively supported from %2$ss:\t*** %1$s ***", supportedAlgos, Arrays.toString(CryptoParametersJ8.PROVIDER_TYPES)));
        if (debug) {
            Arrays.stream(CryptoParametersJ8.TYPES.values()).forEach(t -> {
                CryptoUtilJ8 testcu = CryptoUtilJ8.getInstance(t);
                System.out.println("\t| Crypto factory class: \t" + testcu.getCryptoStreamFactory().getClass());
                System.out.println("\t|_Algorithm used: \t" + testcu.getCryptoStreamFactory().getAlgorithm());
            });
        }
        System.out.println("\t|_ More Info: https://docs.oracle.com/javase/8/docs/technotes/guides/security/StandardNames.html\r\n");
    }

    public static void printHelp() {
        System.out.println("\r\n\t*** Command line tool for encrypting/decrypting strings/files ***\r\n\t*** algorithm based on " + (Object)((Object)CryptoParametersJ8.TYPES_IMPL.ALGORITHM_J8_PBE) + "***\r\n");
        System.out.println("\tjava -cp target\\classes " + CLI2.class.getName() + " <operation mode> <coding mode> <password> <path|string> [target]\r\n");
        System.out.println("\tjava -jar target/fulcrum-yaafi-crypto-1.0.8-SNAPSHOT.jar <operation mode> <coding mode> <password> <path|string> [target]\r\n");
        System.out.println("\t-------------------");
        System.out.println("\toperation mode: file|string|info");
        System.out.println("\tcoding mode: enc|dec|enc:GCM. Default algorithm is " + (Object)((Object)CryptoParametersJ8.DEFAULT_TYPE));
        System.out.println("\t<password: string or empty:''");
        System.out.println("\tcode|coderef: path|string");
        System.out.println("\ttarget: optional\r\n");
        System.out.println("\t-------------------");
        System.out.println("\t*** Usage: ***\r\n");
        System.out.println("\t" + CLI2.class.getSimpleName() + " file [enc|dec] passwd source [target]");
        System.out.println("\t" + CLI2.class.getSimpleName() + " string [enc|dec] passwd source");
        System.out.println("\t" + CLI2.class.getSimpleName() + " info");
    }

    public static void processFiles(String[] args) throws Exception {
        String cipherMode = args[1];
        char[] password = args[2].toCharArray();
        File sourceFile = new File(args[3]);
        File targetFile = null;
        if (args.length == 4) {
            targetFile = sourceFile;
        } else {
            boolean success;
            targetFile = new File(args[4]);
            File parentFile = targetFile.getParentFile();
            if (!(parentFile == null || parentFile.exists() && parentFile.isDirectory() || (success = parentFile.mkdirs()))) {
                System.err.println("Error, could not create directory to write parent file");
            }
        }
        CLI2.processFile(cipherMode, password, sourceFile, targetFile);
    }

    public static void processFile(String cipherMode, char[] password, File sourceFile, File targetFile) throws Exception {
        block18: {
            try (FileInputStream fis = new FileInputStream(sourceFile);){
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                CryptoUtilJ8 cryptoUtilJ8 = CLI2.createCryptoUtil(cipherMode);
                if (cryptoUtilJ8 == null) {
                    System.out.println("Canceling ");
                    return;
                }
                if (cipherMode.startsWith("dec")) {
                    int i;
                    System.out.println("Decrypting " + sourceFile.getAbsolutePath());
                    StringBuffer stringBuffer = new StringBuffer();
                    while ((i = fis.read()) != -1) {
                        stringBuffer.append((char)i);
                    }
                    String value = stringBuffer.toString();
                    if (CLI2.isHexadecimal(value)) {
                        byte[] buffer = HexConverter.toBytes(value);
                        cryptoUtilJ8.decrypt(buffer, baos, password);
                    } else {
                        try (FileInputStream fis2 = new FileInputStream(sourceFile);){
                            cryptoUtilJ8.decrypt(fis2, baos, password);
                        }
                    }
                    ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
                    FileOutputStream fos = new FileOutputStream(targetFile);
                    StreamUtil.copy(bais, fos);
                    bais.close();
                    fos.close();
                    break block18;
                }
                if (cipherMode.startsWith("enc")) {
                    System.out.println("Encrypting " + sourceFile.getAbsolutePath());
                    cryptoUtilJ8.encrypt(fis, baos, password);
                    fis.close();
                    ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
                    FileOutputStream fos = new FileOutputStream(targetFile);
                    StreamUtil.copy(bais, fos);
                    bais.close();
                    fos.close();
                    break block18;
                }
                String msg = "Don't know what to do with : " + cipherMode;
                throw new IllegalArgumentException(msg);
            }
        }
    }

    private static CryptoUtilJ8 createCryptoUtil(String cipherMode) throws Exception {
        CryptoUtilJ8 cryptoUtilJ8 = null;
        List<String> supportedTypes = CryptoParametersJ8.init();
        if (cipherMode.substring("enc".length()).equals("")) {
            if (supportedTypes.stream().anyMatch(x -> x.equals(CryptoParametersJ8.DEFAULT_TYPE.toString()))) {
                System.err.println("using default type:" + (Object)((Object)CryptoParametersJ8.DEFAULT_TYPE));
                cryptoUtilJ8 = CryptoUtilJ8.getInstance();
            } else {
                System.err.println("Could not use default type:" + (Object)((Object)CryptoParametersJ8.TYPES.PBE) + ".You have to set explicit type, e.g. enc:" + supportedTypes.get(0));
            }
        } else {
            System.err.println("checking supported types:" + supportedTypes);
            List matchedType = supportedTypes.stream().filter(x -> cipherMode.endsWith((String)x)).collect(Collectors.toList());
            System.err.println("matched type:" + matchedType);
            Optional<CryptoParametersJ8.TYPES> algoShortcut = Arrays.stream(CryptoParametersJ8.TYPES.values()).filter(a -> ((String)matchedType.get(0)).equals(a.toString())).findFirst();
            if (algoShortcut.isPresent()) {
                System.err.println("initializing type:" + algoShortcut);
                cryptoUtilJ8 = CryptoUtilJ8.getInstance(algoShortcut.get());
            }
        }
        if (cryptoUtilJ8 == null) {
            throw new Exception("Could not use algorithm. Check debug output and JDK provided algo shortcuts with CLI2 info!");
        }
        if (debug) {
            CryptoStreamFactoryJ8Template crt = (CryptoStreamFactoryJ8Template)cryptoUtilJ8.getCryptoStreamFactory();
            System.err.println(String.format("using crypto factory instance %s for algo %s and type %s with salt length: %s and count %s", new Object[]{crt.getClass().getSimpleName(), crt.getType(), crt.getAlgorithm(), crt.getSalt().length, crt.getCount()}));
        }
        return cryptoUtilJ8;
    }

    public static void processString(String[] args) throws Exception {
        boolean success;
        File parentFile;
        String value;
        char[] password;
        String cipherMode;
        File targetFile = null;
        if (args.length > 3) {
            cipherMode = args[1];
            password = args[2].toCharArray();
            value = args[3];
        } else {
            value = null;
            cipherMode = null;
            password = null;
        }
        if (!(args.length != 5 || (parentFile = (targetFile = new File(args[4])).getParentFile()) == null || parentFile.exists() && parentFile.isDirectory() || (success = parentFile.mkdirs()))) {
            System.err.println("Error, could not create directory to write parent file");
        }
        if (value != null && !value.equals("")) {
            String result = CLI2.processString(cipherMode, password, value);
            if (targetFile != null) {
                try (OutputStreamWriter osw = new OutputStreamWriter((OutputStream)new FileOutputStream(targetFile), Charset.forName("UTF-8").newEncoder());){
                    osw.write(result);
                }
            } else {
                System.out.println(result);
            }
        }
    }

    public static String processString(String cipherMode, char[] password, String value) throws Exception {
        if (value != null && !value.equals("")) {
            CryptoUtilJ8 cryptoUtilJ8 = CLI2.createCryptoUtil(cipherMode);
            String result = null;
            if (cipherMode.startsWith("dec")) {
                result = cryptoUtilJ8.decryptString(value, password);
            } else if (cipherMode.startsWith("enc")) {
                result = cryptoUtilJ8.encryptString(value, password);
            }
            return result;
        }
        return null;
    }

    public static boolean isHexadecimal(String input) {
        Matcher matcher = HEXADECIMAL_PATTERN.matcher(input);
        return matcher.matches();
    }
}

