/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fulcrum.jce.crypto;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.GeneralSecurityException;
import java.security.Key;
import javax.crypto.Cipher;
import javax.crypto.CipherInputStream;
import javax.crypto.CipherOutputStream;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.PBEParameterSpec;
import org.apache.fulcrum.jce.crypto.CryptoParameters;
import org.apache.fulcrum.jce.crypto.CryptoStreamFactory;
import org.apache.fulcrum.jce.crypto.PasswordFactory;
import org.apache.fulcrum.jce.crypto.SmartDecryptingInputStream;

public final class CryptoStreamFactoryImpl
implements CryptoStreamFactory {
    private byte[] salt;
    private int count;
    private String providerName;
    private String algorithm;
    private static CryptoStreamFactory instance;
    private static final String PROVIDERNAME;

    public static synchronized CryptoStreamFactory getInstance() {
        if (instance == null) {
            instance = new CryptoStreamFactoryImpl();
        }
        return instance;
    }

    public static void setInstance(CryptoStreamFactory instance) {
        CryptoStreamFactoryImpl.instance = instance;
    }

    public CryptoStreamFactoryImpl() {
        this.salt = CryptoParameters.SALT;
        this.count = 20;
        this.providerName = PROVIDERNAME;
        this.algorithm = "PBEWithMD5AndDES";
    }

    public CryptoStreamFactoryImpl(byte[] salt, int count) {
        this.salt = salt;
        this.count = count;
        this.providerName = PROVIDERNAME;
        this.algorithm = "PBEWithMD5AndDES";
    }

    @Override
    public InputStream getInputStream(InputStream is, String decryptionMode) throws GeneralSecurityException, IOException {
        InputStream result = null;
        result = "auto".equalsIgnoreCase(decryptionMode) ? CryptoStreamFactoryImpl.getInstance().getSmartInputStream(is) : ("true".equalsIgnoreCase(decryptionMode) ? CryptoStreamFactoryImpl.getInstance().getInputStream(is) : is);
        return result;
    }

    @Override
    public InputStream getInputStream(InputStream is, String decryptionMode, char[] password) throws GeneralSecurityException, IOException {
        InputStream result = null;
        result = "auto".equalsIgnoreCase(decryptionMode) ? CryptoStreamFactoryImpl.getInstance().getSmartInputStream(is, password) : ("true".equalsIgnoreCase(decryptionMode) ? CryptoStreamFactoryImpl.getInstance().getInputStream(is, password) : is);
        return result;
    }

    @Override
    public InputStream getInputStream(InputStream is) throws GeneralSecurityException, IOException {
        Cipher cipher = this.createCipher(2, PasswordFactory.create());
        return new CipherInputStream(is, cipher);
    }

    @Override
    public InputStream getInputStream(InputStream is, char[] password) throws GeneralSecurityException, IOException {
        Cipher cipher = this.createCipher(2, password);
        return new CipherInputStream(is, cipher);
    }

    @Override
    public InputStream getSmartInputStream(InputStream is) throws GeneralSecurityException, IOException {
        return this.getSmartInputStream(is, PasswordFactory.create());
    }

    @Override
    public InputStream getSmartInputStream(InputStream is, char[] password) throws GeneralSecurityException, IOException {
        SmartDecryptingInputStream result = new SmartDecryptingInputStream(CryptoStreamFactoryImpl.getInstance(), is, password);
        return result;
    }

    @Override
    public OutputStream getOutputStream(OutputStream os) throws GeneralSecurityException, IOException {
        Cipher cipher = this.createCipher(1, PasswordFactory.create());
        return new CipherOutputStream(os, cipher);
    }

    @Override
    public OutputStream getOutputStream(OutputStream os, char[] password) throws GeneralSecurityException, IOException {
        Cipher cipher = this.createCipher(1, password);
        return new CipherOutputStream(os, cipher);
    }

    private String getAlgorithm() {
        return this.algorithm;
    }

    private int getCount() {
        return this.count;
    }

    private String getProviderName() {
        return this.providerName;
    }

    private byte[] getSalt() {
        return this.salt;
    }

    private Key createKey(char[] password) throws GeneralSecurityException {
        String algorithm = this.getAlgorithm();
        PBEKeySpec keySpec = new PBEKeySpec(password);
        SecretKeyFactory keyFactory = this.getProviderName() == null ? SecretKeyFactory.getInstance(algorithm) : SecretKeyFactory.getInstance(algorithm, this.getProviderName());
        return keyFactory.generateSecret(keySpec);
    }

    private Cipher createCipher(int mode, char[] password) throws GeneralSecurityException, IOException {
        PBEParameterSpec paramSpec = new PBEParameterSpec(this.getSalt(), this.getCount());
        Key key = this.createKey(password);
        Cipher cipher = this.getProviderName() == null ? Cipher.getInstance(this.getAlgorithm()) : Cipher.getInstance(this.getAlgorithm(), this.getProviderName());
        cipher.init(mode, key, paramSpec);
        return cipher;
    }

    static {
        PROVIDERNAME = null;
    }
}

