/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fulcrum.testcontainer;

import java.io.File;
import org.apache.avalon.excalibur.component.DefaultRoleManager;
import org.apache.avalon.excalibur.component.ExcaliburComponentManager;
import org.apache.avalon.excalibur.component.RoleManager;
import org.apache.avalon.excalibur.logger.Log4JLoggerManager;
import org.apache.avalon.excalibur.logger.LoggerManager;
import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.component.ComponentException;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.DefaultConfigurationBuilder;
import org.apache.avalon.framework.context.Context;
import org.apache.avalon.framework.context.DefaultContext;
import org.apache.avalon.framework.logger.AbstractLogEnabled;
import org.apache.fulcrum.testcontainer.Container;

public class ECMContainer
extends AbstractLogEnabled
implements Container {
    private ExcaliburComponentManager manager = new ExcaliburComponentManager();
    private String configFileName;
    private String roleFileName;
    private LoggerManager lm = new Log4JLoggerManager();

    public ECMContainer() {
        this.enableLogging(this.lm.getLoggerForCategory("org.apache.fulcrum.testcontainer.Container"));
    }

    @Override
    public void startup(String configFileName, String roleFileName, String parametersFileName) {
        this.getLogger().debug("Starting container...");
        this.getLogger().debug("with logger: " + this.getLogger().getClass().getSimpleName());
        this.configFileName = configFileName;
        this.roleFileName = roleFileName;
        File configFile = new File(configFileName);
        if (!configFile.exists()) {
            throw new RuntimeException("Could not initialize the container because the config file could not be found:" + String.valueOf(configFile));
        }
        try {
            this.initialize();
            this.getLogger().info("Container ready.");
        }
        catch (Exception e) {
            this.getLogger().error("Could not initialize the container", (Throwable)e);
            throw new RuntimeException("Could not initialize the container");
        }
    }

    public void initialize() throws Exception {
        boolean useRoles = true;
        File roleFile = new File(this.roleFileName);
        if (!roleFile.exists()) {
            useRoles = false;
            this.getLogger().info("Not using separate roles file");
        }
        DefaultConfigurationBuilder builder = new DefaultConfigurationBuilder();
        Configuration sysConfig = builder.buildFromFile(this.configFileName);
        if (useRoles) {
            Configuration roleConfig = builder.buildFromFile(this.roleFileName);
            DefaultRoleManager roles = new DefaultRoleManager();
            roles.enableLogging(this.lm.getLoggerForCategory("org.apache.fulcrum"));
            roles.configure(roleConfig);
            this.manager.setRoleManager((RoleManager)roles);
        }
        this.manager.setLoggerManager(this.lm);
        this.manager.enableLogging(this.lm.getLoggerForCategory("org.apache.fulcrum"));
        DefaultContext context = new DefaultContext();
        String absolutePath = new File("").getAbsolutePath();
        context.put((Object)"componentAppRoot", (Object)absolutePath);
        context.put((Object)"urn:avalon:home", (Object)absolutePath);
        this.manager.contextualize((Context)context);
        this.manager.configure(sysConfig);
        this.manager.initialize();
    }

    public void dispose() {
        this.getLogger().debug("Disposing of container...");
        this.manager.dispose();
        this.getLogger().info("Container has been disposed.");
    }

    @Override
    public Object lookup(String roleName) throws ComponentException {
        return this.manager.lookup(roleName);
    }

    public void release(Component component) {
        this.manager.release(component);
    }

    @Override
    public void release(Object component) {
        this.manager.release((Component)component);
    }
}

