package org.apache.fulcrum.security.torque.om;

import java.sql.Connection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

import org.apache.torque.NoRowsException;
import org.apache.torque.TooManyRowsException;
import org.apache.torque.TorqueException;
import org.apache.torque.criteria.Criteria;
import org.apache.torque.criteria.Criterion;
import org.apache.torque.om.mapper.RecordMapper;
import org.apache.torque.om.mapper.CompositeMapper;
import org.apache.torque.om.ObjectKey;
import org.apache.torque.om.SimpleKey;
import org.apache.torque.map.TableMap;
import org.apache.torque.util.TorqueConnection;
import org.apache.torque.util.Transaction;
import org.apache.torque.util.ColumnValues;
import org.apache.torque.util.JdbcTypedValue;



/**
 * The skeleton for this class was autogenerated by Torque on:
 *
 * [Fri Nov 03 10:19:40 CET 2023]
 *
 * You should not use this class directly.  It should not even be
 * extended; all references should be to TorqueTurbineRolePermissionPeer
 */

@SuppressWarnings("unused")
public abstract class BaseTorqueTurbineRolePermissionPeerImpl
    extends org.apache.torque.util.AbstractPeerImpl<TorqueTurbineRolePermission>
{
    /** Serial version */
    private static final long serialVersionUID = 1699003180663L;



    /**
     * Constructor.
     * The recordMapper, tableMap and databaseName fields are correctly
     * initialized.
     */
    public BaseTorqueTurbineRolePermissionPeerImpl()
    {
        this(new TorqueTurbineRolePermissionRecordMapper(),
            TorqueTurbineRolePermissionPeer.TABLE,
            TorqueTurbineRolePermissionPeer.DATABASE_NAME);
    }

    /**
     * Constructor providing the objects to be injected as parameters.
     *
     * @param recordMapper a record mapper to map JDBC result sets to objects
     * @param tableMap the default table map
     * @param databaseName the name of the database
     */
    public BaseTorqueTurbineRolePermissionPeerImpl(
            RecordMapper<TorqueTurbineRolePermission> recordMapper, 
            TableMap tableMap,
            String databaseName)
    {
        super(recordMapper, tableMap, databaseName);
    }


    /**
     * Returns a new instance of the Data object class
     */
    public TorqueTurbineRolePermission getDbObjectInstance()
    {
        return new TorqueTurbineRolePermission();
    }


    /**
     * Method to do updates.  This method is to be used during a transaction,
     * otherwise use the doUpdate(Criteria) method.
     *
     * @param columnValues the values to update plus the primary key
     *        identifying the row to update.
     * @param con the connection to use, not null.
     *
     * @return the number of affected rows.
     *
     * @throws TorqueException Any exceptions caught during processing will be
     *         rethrown wrapped into a TorqueException.
     */
    public int doUpdate(ColumnValues columnValues, Connection con)
        throws TorqueException
    {
        Criteria selectCriteria = new Criteria(getDatabaseName());
        correctBooleans(columnValues);

        {
            JdbcTypedValue pkValue
                = columnValues.remove(TorqueTurbineRolePermissionPeer.ROLE_ID);
            if (pkValue == null)
            {
                throw new TorqueException(
                        "The value for the primary key column "
                        + "TorqueTurbineRolePermissionPeer.ROLE_ID"
                        + " must be set");
            }
            if (pkValue.getSqlExpression() == null)
            {
                selectCriteria.where(
                        TorqueTurbineRolePermissionPeer.ROLE_ID,
                        pkValue.getValue());
            }
            else
            {
                selectCriteria.where(
                        TorqueTurbineRolePermissionPeer.ROLE_ID,
                        pkValue.getSqlExpression());
            }
        }
        {
            JdbcTypedValue pkValue
                = columnValues.remove(TorqueTurbineRolePermissionPeer.PERMISSION_ID);
            if (pkValue == null)
            {
                throw new TorqueException(
                        "The value for the primary key column "
                        + "TorqueTurbineRolePermissionPeer.PERMISSION_ID"
                        + " must be set");
            }
            if (pkValue.getSqlExpression() == null)
            {
                selectCriteria.where(
                        TorqueTurbineRolePermissionPeer.PERMISSION_ID,
                        pkValue.getValue());
            }
            else
            {
                selectCriteria.where(
                        TorqueTurbineRolePermissionPeer.PERMISSION_ID,
                        pkValue.getSqlExpression());
            }
        }


        int rowCount = doUpdate(selectCriteria, columnValues, con);
        return rowCount;
    }

    /**
     * Deletes a data object, i.e. a row in a table, in the database.
     *
     * @param obj the data object to delete in the database, not null.
     *
     * @return the number of deleted rows.
     *
     * @throws TorqueException Any exceptions caught during processing will be
     *         rethrown wrapped into a TorqueException.
     */
    public int doDelete(TorqueTurbineRolePermission obj) throws TorqueException
    {
        int result = doDelete(buildCriteria(obj.getPrimaryKey()));
        obj.setDeleted(true);
        return result;
    }

    /**
     * Deletes a data object, i.e. a row in a table, in the database.
     * This method is to be used during a transaction, otherwise use the
     * doDelete(TorqueTurbineRolePermission) method.
     *
     * @param obj the data object to delete in the database, not null.
     * @param con the connection to use, not null.
     *
     * @return the number of deleted rows.
     *
     * @throws TorqueException Any exceptions caught during processing will be
     *         rethrown wrapped into a TorqueException.
     */
    public int doDelete(TorqueTurbineRolePermission obj, Connection con)
        throws TorqueException
    {
        int result = doDelete(buildCriteria(obj.getPrimaryKey()), con);
        obj.setDeleted(true);
        return result;
    }

    /**
     * Deletes data objects, i.e. rows in a table, in the database.
     *
     * @param objects the data object to delete in the database, not null,
     *        may not contain null.
     *
     * @return the number of deleted rows.
     *
     * @throws TorqueException Any exceptions caught during processing will be
     *         rethrown wrapped into a TorqueException.
     */
    public int doDelete(Collection<TorqueTurbineRolePermission> objects)
            throws TorqueException
    {
        int result = doDelete(buildPkCriteria(objects));
        objects.forEach(object -> object.setDeleted(true));
        return result;
    }

    /**
     * Deletes data objects, i.e. rows in a table, in the database.
     * This method uses the passed connection to delete the rows;
     * if a transaction is open in the connection, the deletion happens inside
     * this transaction.
     *
     * @param objects the data objects to delete in the database, not null,
     *        may not contain null.
     * @param con the connection to use for deleting, not null.
     *
     * @return the number of deleted rows.
     *
     * @throws TorqueException Any exceptions caught during processing will be
     *         rethrown wrapped into a TorqueException.
     */
    public int doDelete(
            Collection<TorqueTurbineRolePermission> objects,
            Connection con)
        throws TorqueException
    {
        int result = doDelete(buildPkCriteria(objects), con);
        objects.forEach(object -> object.setDeleted(true));
        return result;
    }

    /** 
     * Build a Criteria object which selects all objects which have a given
     * primary key.
     *
     * @param pk the primary key value to build the criteria from, not null.
     */
    public Criteria buildCriteria(ObjectKey<?> pk)
    {
        Criteria criteria = new Criteria();
        SimpleKey<?>[] keys = (SimpleKey[])pk.getValue();
        criteria.and(TorqueTurbineRolePermissionPeer.ROLE_ID, keys[0]);
        criteria.and(TorqueTurbineRolePermissionPeer.PERMISSION_ID, keys[1]);
        return criteria;
     }

    /** 
     * Build a Criteria object which selects all objects which primary keys
     * are contained in the passed collection.
     *
     * @param pks the primary key values to build the criteria from, not null,
     *        may not contain null.
     */
    public Criteria buildCriteria(Collection<ObjectKey<?>> pks)
    {
        Criteria criteria = new Criteria();
        for (ObjectKey<?> pk : pks)
        {
            SimpleKey<?>[] keys = (SimpleKey[])pk.getValue();
                Criterion c0 = new Criterion(
                    TorqueTurbineRolePermissionPeer.ROLE_ID, keys[0], Criteria.EQUAL);
                Criterion c1 = new Criterion(
                    TorqueTurbineRolePermissionPeer.PERMISSION_ID, keys[1], Criteria.EQUAL);
                    c0.and(c1);
            criteria.or(c0);
        }
        return criteria;
     }


    /** 
     * Build a Criteria object which selects all passed objects using their
     * primary key. Objects which do not yet have a primary key are ignored.
     *
     * @param objects the objects to build the criteria from, not null,
     *        may not contain null.
     */
    public Criteria buildPkCriteria(
            Collection<TorqueTurbineRolePermission> objects)
    {
        return buildCriteria(objects.stream()
                .map(object -> object.getPrimaryKey())
                .collect(Collectors.toList()));
    }

    /** 
     * Build a Criteria object from the data object for this peer.
     *
     * @param obj the object to build the criteria from, not null.
     */
    public Criteria buildCriteria(TorqueTurbineRolePermission obj)
    {
        Criteria criteria = new Criteria(getDatabaseName());
        criteria.and(TorqueTurbineRolePermissionPeer.ROLE_ID, obj.getRoleId());
        criteria.and(TorqueTurbineRolePermissionPeer.PERMISSION_ID, obj.getPermissionId());
        return criteria;
    }

    /** 
     * Build a Criteria object from the data object for this peer,
     * skipping all binary columns.
     *
     * @param obj the object to build the criteria from, not null.
     */
    public Criteria buildSelectCriteria(TorqueTurbineRolePermission obj)
    {
        Criteria criteria = new Criteria(getDatabaseName());
        criteria.and(TorqueTurbineRolePermissionPeer.ROLE_ID, obj.getRoleId());
        criteria.and(TorqueTurbineRolePermissionPeer.PERMISSION_ID, obj.getPermissionId());
        return criteria;
    }

    /** 
     * Returns the contents of the object as ColumnValues object.
     * Primary key columns which are generated on insertion are not
     * added to the returned object if they still have their initial
     * value. Also, columns which have the useDatabaseDefaultValue
     * flag set to true are also not added to the returned object
     * if they still have their initial value.
     *
     * @throws TorqueException if the table map cannot be retrieved
     *         (should not happen).
     */
    public ColumnValues buildColumnValues(TorqueTurbineRolePermission torqueTurbineRolePermission)
            throws TorqueException
    {
        ColumnValues columnValues = new ColumnValues();
        columnValues.put(
                TorqueTurbineRolePermissionPeer.ROLE_ID,
                new JdbcTypedValue(
                    torqueTurbineRolePermission.getRoleId(),
                    4));
        columnValues.put(
                TorqueTurbineRolePermissionPeer.PERMISSION_ID,
                new JdbcTypedValue(
                    torqueTurbineRolePermission.getPermissionId(),
                    4));
        return columnValues;
    }

    /**
     * retrieve object using using pk values.
     *
     * @param roleId Integer
     * @param permissionId Integer
     */
    public TorqueTurbineRolePermission retrieveByPK(
            Integer roleId,
            Integer permissionId)
        throws TorqueException
    {
        try (TorqueConnection connection = Transaction.begin(getDatabaseName()))
        {
            TorqueTurbineRolePermission result = retrieveByPK(
               roleId,
               permissionId,
               connection);
            Transaction.commit(connection);
            return result;
        }
    }

    /**
     * retrieve object using using pk values.
     *
     * @param roleId Integer
     * @param permissionId Integer
     * @param con Connection
     */
    public TorqueTurbineRolePermission retrieveByPK(
            Integer roleId,
            Integer permissionId,
            Connection con) throws TorqueException
    {

        Criteria criteria = new Criteria();
        criteria.and(TorqueTurbineRolePermissionPeer.ROLE_ID, roleId);
        criteria.and(TorqueTurbineRolePermissionPeer.PERMISSION_ID, permissionId);
        TorqueTurbineRolePermission v = doSelectSingleRecord(criteria, con);
        if (v == null)
        {
            throw new NoRowsException("Failed to select a row.");
        }

        return v;
    }

    /**
     * Retrieve a single object by pk
     *
     * @param pk the primary key
     * @throws TorqueException Any exceptions caught during processing will be
     *         rethrown wrapped into a TorqueException.
     * @throws NoRowsException Primary key was not found in database.
     * @throws TooManyRowsException Primary key was not found in database.
     */
    public TorqueTurbineRolePermission retrieveByPK(ObjectKey<?> pk)
        throws TorqueException, NoRowsException, TooManyRowsException
    {
        try (TorqueConnection connection = Transaction.begin(getDatabaseName()))
        {
            TorqueTurbineRolePermission result = retrieveByPK(pk, connection);
            Transaction.commit(connection);
            return result;
        }
    }

    /**
     * Retrieve a single object by pk
     *
     * @param pk the primary key
     * @param con the connection to use
     * @throws TorqueException Any exceptions caught during processing will be
     *         rethrown wrapped into a TorqueException.
     * @throws NoRowsException Primary key was not found in database.
     * @throws TooManyRowsException Primary key was not found in database.
     */
    public TorqueTurbineRolePermission retrieveByPK(ObjectKey<?> pk, Connection con)
        throws TorqueException, NoRowsException, TooManyRowsException
    {
        Criteria criteria = buildCriteria(pk);
        TorqueTurbineRolePermission v = doSelectSingleRecord(criteria, con);
        if (v == null)
        {
            throw new NoRowsException("Failed to select a row.");
        }

        return v;
    }


    /**
     * Retrieve multiple objects by pk.
     *
     * @param pks List of primary keys.
     *        Entries in pks which do not match entries in the database are ignored.
     *
     * @return the list of matching objects, not null.
     *
     * @throws TorqueException Any exceptions caught during processing will be
     *         rethrown wrapped into a TorqueException.
     */
    public List<TorqueTurbineRolePermission> retrieveByObjectKeys(Collection<ObjectKey<?>> pks)
        throws TorqueException
    {
        try (TorqueConnection connection = Transaction.begin(getDatabaseName()))
        {
            List<TorqueTurbineRolePermission> result = retrieveByObjectKeys(pks, connection);
            Transaction.commit(connection);
            return result;
        }
    }

    /**
     * Retrieve multiple objects by pk.
     *
     * @param pks List of primary keys.
     *        Entries in pks which do not match entries in the database are ignored.
     * @param dbcon the connection to use
     *
     * @return the list of matching objects, not null.
     *
     * @throws TorqueException Any exceptions caught during processing will be
     *         rethrown wrapped into a TorqueException.
     */
    public List<TorqueTurbineRolePermission> retrieveByObjectKeys(
                Collection<ObjectKey<?>> pks,
                Connection dbcon)
            throws TorqueException
    {
        if (pks == null || pks.size() == 0)
        {
            return new ArrayList<TorqueTurbineRolePermission>();
        }
        Criteria criteria = buildCriteria(pks);
        List<TorqueTurbineRolePermission> result = doSelect(criteria, dbcon);
        return result;
    }


    /**
     * Selects a collection of dbObjectClassName objects pre-filled with their
     * TorqueTurbineRole objects.
     *
     * @throws TorqueException Any exceptions caught during processing will be
     *         rethrown wrapped into a TorqueException.
     */
    public List<TorqueTurbineRolePermission> doSelectJoinTorqueTurbineRole(Criteria criteria)
        throws TorqueException
    {
        try (TorqueConnection connection = Transaction.begin(getDatabaseName()))
        {
            List<TorqueTurbineRolePermission> result
                    = TorqueTurbineRolePermissionPeer.doSelectJoinTorqueTurbineRole(criteria, connection);
            Transaction.commit(connection);
            return result;
        }
    }

    /**
     * Selects a collection of TorqueTurbineRolePermission objects pre-filled with their
     * TorqueTurbineRole objects.
     *
     * @throws TorqueException Any exceptions caught during processing will be
     *         rethrown wrapped into a TorqueException.
     */
    public List<TorqueTurbineRolePermission> doSelectJoinTorqueTurbineRole(
            Criteria criteria, Connection conn)
        throws TorqueException
    {
        setDbName(criteria);

        addSelectColumns(criteria);
        org.apache.fulcrum.security.torque.om.TorqueTurbineRolePeer.addSelectColumns(criteria);

        CompositeMapper compositeMapper = new CompositeMapper();
        compositeMapper.addMapper(
                new TorqueTurbineRolePermissionRecordMapper(),
                0);
        compositeMapper.addMapper(
                new TorqueTurbineRoleRecordMapper(),
                TorqueTurbineRolePermissionPeer.numColumns);
        criteria.addJoin(TorqueTurbineRolePermissionPeer.ROLE_ID,
            org.apache.fulcrum.security.torque.om.TorqueTurbineRolePeer.ROLE_ID);

        correctBooleans(criteria);

        List<TorqueTurbineRolePermission> result = new ArrayList<TorqueTurbineRolePermission>();
        List<List<Object>> rawResult = doSelect(
                criteria, compositeMapper, conn);
        for (List<Object> rawResultRow : rawResult)
        {
            TorqueTurbineRolePermission obj1 = (TorqueTurbineRolePermission) rawResultRow.get(0);
            TorqueTurbineRole obj2 = (TorqueTurbineRole) rawResultRow.get(1);

            boolean newObject = true;
            for (int j = 0; j < result.size(); j++)
            {
                TorqueTurbineRolePermission temp_obj1 = result.get(j);
                org.apache.fulcrum.security.torque.om.TorqueTurbineRole temp_obj2 = temp_obj1.getTorqueTurbineRole();
                if (temp_obj2.getPrimaryKey().equals(obj2.getPrimaryKey()))
                {
                    newObject = false;
                    temp_obj2.addTorqueTurbineRolePermission(obj1);
                    break;
                }
            }
            if (newObject)
            {
                obj2.initTorqueTurbineRolePermissions();
                obj2.addTorqueTurbineRolePermission(obj1);
            }
            result.add(obj1);
        }
        return result;
    }
    /**
     * Selects a collection of dbObjectClassName objects pre-filled with their
     * TorqueTurbinePermission objects.
     *
     * @throws TorqueException Any exceptions caught during processing will be
     *         rethrown wrapped into a TorqueException.
     */
    public List<TorqueTurbineRolePermission> doSelectJoinTorqueTurbinePermission(Criteria criteria)
        throws TorqueException
    {
        try (TorqueConnection connection = Transaction.begin(getDatabaseName()))
        {
            List<TorqueTurbineRolePermission> result
                    = TorqueTurbineRolePermissionPeer.doSelectJoinTorqueTurbinePermission(criteria, connection);
            Transaction.commit(connection);
            return result;
        }
    }

    /**
     * Selects a collection of TorqueTurbineRolePermission objects pre-filled with their
     * TorqueTurbinePermission objects.
     *
     * @throws TorqueException Any exceptions caught during processing will be
     *         rethrown wrapped into a TorqueException.
     */
    public List<TorqueTurbineRolePermission> doSelectJoinTorqueTurbinePermission(
            Criteria criteria, Connection conn)
        throws TorqueException
    {
        setDbName(criteria);

        addSelectColumns(criteria);
        org.apache.fulcrum.security.torque.om.TorqueTurbinePermissionPeer.addSelectColumns(criteria);

        CompositeMapper compositeMapper = new CompositeMapper();
        compositeMapper.addMapper(
                new TorqueTurbineRolePermissionRecordMapper(),
                0);
        compositeMapper.addMapper(
                new TorqueTurbinePermissionRecordMapper(),
                TorqueTurbineRolePermissionPeer.numColumns);
        criteria.addJoin(TorqueTurbineRolePermissionPeer.PERMISSION_ID,
            org.apache.fulcrum.security.torque.om.TorqueTurbinePermissionPeer.PERMISSION_ID);

        correctBooleans(criteria);

        List<TorqueTurbineRolePermission> result = new ArrayList<TorqueTurbineRolePermission>();
        List<List<Object>> rawResult = doSelect(
                criteria, compositeMapper, conn);
        for (List<Object> rawResultRow : rawResult)
        {
            TorqueTurbineRolePermission obj1 = (TorqueTurbineRolePermission) rawResultRow.get(0);
            TorqueTurbinePermission obj2 = (TorqueTurbinePermission) rawResultRow.get(1);

            boolean newObject = true;
            for (int j = 0; j < result.size(); j++)
            {
                TorqueTurbineRolePermission temp_obj1 = result.get(j);
                org.apache.fulcrum.security.torque.om.TorqueTurbinePermission temp_obj2 = temp_obj1.getTorqueTurbinePermission();
                if (temp_obj2.getPrimaryKey().equals(obj2.getPrimaryKey()))
                {
                    newObject = false;
                    temp_obj2.addTorqueTurbineRolePermission(obj1);
                    break;
                }
            }
            if (newObject)
            {
                obj2.initTorqueTurbineRolePermissions();
                obj2.addTorqueTurbineRolePermission(obj1);
            }
            result.add(obj1);
        }
        return result;
    }




}
