package org.apache.fulcrum.security.torque.om;

import java.io.Serializable;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

import org.apache.torque.TorqueException;
import org.apache.torque.map.TableMap;
import org.apache.torque.om.NumberKey;
import org.apache.torque.om.ObjectKey;
import org.apache.torque.om.SimpleKey;
import org.apache.torque.om.Persistent;
import org.apache.torque.criteria.Criteria;
import org.apache.torque.util.TorqueConnection;
import org.apache.torque.util.Transaction;

/**
 * This class was autogenerated by Torque on:
 *
 * [Fri Nov 03 10:19:35 CET 2023]
 *
 * You should not use this class directly.  It should not even be
 * extended; all references should be to TorqueDynamicGroup
 */
@SuppressWarnings("unused")
public abstract class BaseTorqueDynamicGroup extends org.apache.fulcrum.security.torque.dynamic.TorqueAbstractDynamicGroup
    implements Persistent, Serializable
{
    /** Serial version */
    private static final long serialVersionUID = 1699003175784L;



    /** Defines the entityId field. */
    private Integer entityId = null;

    /** Defines the entityName field. */
    private String entityName = null;

    /** Whether this object was modified after loading or after last save. */
    private boolean modified = true;

    /** 
     * Whether this object was loaded from the database or already saved 
     * (false) or whether it is not yet in the database(true).
     */
    private boolean isNew = true;

    /** Flag which indicates whether this object is currently saving. */
    private boolean saving = false;

    /** 
     * Flag which indicates whether this object is currently loaded
     * from the database. 
     */
    private boolean loading = false;

    /** 
     * Flag which indicates whether this object was deleted from the database.
     * Note that this flags does not always display the current database state,
     * there is no magical connection between this flag and the database.
     */
    private boolean deleted = false;



    /** Defines the collTorqueDynamicUserGroups field. */
    protected List<TorqueDynamicUserGroup> collTorqueDynamicUserGroups = null;

    /** Defines the collTorqueDynamicGroupRoles field. */
    protected List<TorqueDynamicGroupRole> collTorqueDynamicGroupRoles = null;



    /**
     * Get the value of entityId.
     *
     * @return the value of entityId as Integer
     */
    public Integer getEntityId() 
    {
        
        return entityId;
    }

    /**
     * Set the value of entityId.
     *
     * @param v new value of entityId
     */
    public void setEntityId(Integer v)
    {
        if (!Objects.equals(this.entityId, v))
        {
            setModified(true);
        }

        this.entityId = v;

        // update associated objects in collTorqueDynamicUserGroups 
        if (collTorqueDynamicUserGroups != null)
        {
            for (TorqueDynamicUserGroup element : collTorqueDynamicUserGroups)
            {
                element.setGroupId(v);
            }
        }
        // update associated objects in collTorqueDynamicGroupRoles 
        if (collTorqueDynamicGroupRoles != null)
        {
            for (TorqueDynamicGroupRole element : collTorqueDynamicGroupRoles)
            {
                element.setGroupId(v);
            }
        }

    }
    
    /**
     * Get the value of entityName.
     *
     * @return the value of entityName as String
     */
    public String getEntityName() 
    {
        
        return entityName;
    }

    /**
     * Set the value of entityName.
     *
     * @param v new value of entityName
     */
    public void setEntityName(String v)
    {
        if (!Objects.equals(this.entityName, v))
        {
            setModified(true);
        }

        this.entityName = v;


    }
    

    /**
     * Returns whether the object has ever been saved.  This will
     * be false, if the object was retrieved from storage or was created
     * and then saved.
     *
     * @return true, if the object has never been persisted.
     */
    public boolean isNew()
    {
        return isNew;
    }

    /**
     * Sets whether the object has ever been saved.
     *
     * @param isNew true if the object has never been saved, false otherwise.
     */
    public void setNew(boolean isNew)
    {
        this.isNew = isNew;
    }

    /**
     * Returns whether the object has been modified.
     *
     * @return True if the object has been modified.
     */
    public boolean isModified()
    {
        return modified;
    }

    /**
     * Sets whether the object has been modified.
     *
     * @param modified true if the object has been modified, false otherwise.
     */
    public void setModified(boolean modified)
    {
        this.modified = modified;
    }

    /**
     * Sets the modified state for the object to be false.
     */
    public void resetModified()
    {
        modified = false;
    }


    /**
     * Returns whether this object is currently saving.
     *
     * @return true if this object is currently saving, false otherwise.
     */
    public boolean isSaving()
    {
        return saving;
    }

    /**
     * Sets whether this object is currently saving.
     *
     * @param saving true if this object is currently saving, false otherwise.
     */
    public void setSaving(boolean saving)
    {
        this.saving = saving;
    }


    /**
     * Returns whether this object is currently being loaded from the database.
     *
     * @return true if this object is currently loading, false otherwise.
     */
    public boolean isLoading()
    {
        return loading;
    }

    /**
     * Sets whether this object is currently being loaded from the database.
     *
     * @param loading true if this object is currently loading, false otherwise.
     */
    public void setLoading(boolean loading)
    {
        this.loading = loading;
    }


    /**
     * Returns whether this object was deleted from the database.
     * Note that this getter does not automatically reflect database state,
     * it will be set to true by Torque if doDelete() was called with this 
     * object. Bulk deletes and deletes via primary key do not change
     * this flag. Also, if doDelete() was called on an object which does
     * not exist in the database, the deleted flag is set to true even if
     * it was not deleted.
     *
     * @return true if this object was deleted, false otherwise.
     */
    public boolean isDeleted()
    {
        return deleted;
    }

    /**
     * Sets whether this object was deleted from the database.
     *
     * @param deleted true if this object was deleted, false otherwise.
     */
    public void setDeleted(boolean deleted)
    {
        this.deleted = deleted;
    }




    /**
     * Initializes the cache collTorqueDynamicUserGroups for referenced objects.
     * This, means, if collTorqueDynamicUserGroups is null when this operation is called, it is
     * initialized with an empty collection, otherwise it remains unchanged. 
     *
     * @return the (possibly new) content of the field collTorqueDynamicUserGroups, not null.
     */
    public List<TorqueDynamicUserGroup> initTorqueDynamicUserGroups()
    {
        if (collTorqueDynamicUserGroups == null)
        {
            collTorqueDynamicUserGroups = new ArrayList<TorqueDynamicUserGroup>();
        }
        return collTorqueDynamicUserGroups;
    }

    /**
     * Checks whether the cache collTorqueDynamicUserGroups for referenced objects has either been
     * loaded from the database or has been manually initialized.
     *
     * @return boolean true if initialized
     */
    public boolean isTorqueDynamicUserGroupsInitialized()
    {
        return (collTorqueDynamicUserGroups != null);
    }


    /**
     * Method called to associate a TorqueDynamicUserGroup object to this object
     * through the collTorqueDynamicUserGroups foreign key attribute.
     * If the associated objects were not retrieved before
     * and this object is not new, the associated objects are retrieved
     * from the database before adding the <code>toAdd</code> object.
     *
     * @param toAdd the object to add to the associated objects, not null.
     *
     * @throws TorqueException if retrieval of the associated objects fails.
     * @throws NullPointerException if toAdd is null.
     */
    public void addTorqueDynamicUserGroup(TorqueDynamicUserGroup toAdd)
        throws TorqueException
    {
        toAdd.setTorqueDynamicGroup((TorqueDynamicGroup) this);
        getTorqueDynamicUserGroups().add(toAdd);
    }

    /**
     * Method called to associate a TorqueDynamicUserGroup object to this object
     * through the collTorqueDynamicUserGroups foreign key attribute using connection.
     *
     * @param l TorqueDynamicUserGroup
     * @throws TorqueException if retrieval of the associated objects fails.
     */
    public void addTorqueDynamicUserGroup(TorqueDynamicUserGroup l, Connection con) throws TorqueException
    {
        getTorqueDynamicUserGroups(con).add(l);
        l.setTorqueDynamicGroup((TorqueDynamicGroup) this);
    }
    
    /**
     * Method called to reset the cache of TorqueDynamicUserGroup objects
     * which are related through the collTorqueDynamicUserGroups foreign key attribute.
     */
    public void resetTorqueDynamicUserGroup()
    {
        collTorqueDynamicUserGroups = null;
    }


    /**
     * The criteria used to select the current contents of collTorqueDynamicUserGroups
     */
    private Criteria lastTorqueDynamicUserGroupCriteria = null;

    /**
     * If this collection has already been initialized, returns
     * the collection. Otherwise returns the results of
     * getTorqueDynamicUserGroups(new Criteria())
     *
     * @return the collection of associated objects
     * @throws TorqueException
     */
    public List<TorqueDynamicUserGroup> getTorqueDynamicUserGroups()
        throws TorqueException
    {
        if (collTorqueDynamicUserGroups == null)
        {
            collTorqueDynamicUserGroups = getTorqueDynamicUserGroups(new Criteria());
            for (TorqueDynamicUserGroup torqueDynamicUserGroup : collTorqueDynamicUserGroups)
            {
                torqueDynamicUserGroup.setTorqueDynamicGroup((TorqueDynamicGroup) this);
            }
        }
        return collTorqueDynamicUserGroups;
    }

    /**
     * If this collection has already been initialized with
     * an identical criteria, it returns the collection.
     * Otherwise if this BaseTorqueDynamicGroup has previously
     * been saved, it will retrieve related collTorqueDynamicUserGroups from storage.
     * If this BaseTorqueDynamicGroup is new, it will return
     * an empty collection or the current collection, the criteria
     * is ignored on a new object.
     *
     * @throws TorqueException If a problem occurs with the get[criteria] method.     
     */
    public List<TorqueDynamicUserGroup> getTorqueDynamicUserGroups(Criteria criteria) throws TorqueException
    {
        if (collTorqueDynamicUserGroups == null)
        {
            if (isNew())
            {
               initTorqueDynamicUserGroups();
            }
            else
            {
                criteria.and(org.apache.fulcrum.security.torque.om.TorqueDynamicUserGroupPeer.GROUP_ID, getEntityId());
                collTorqueDynamicUserGroups = org.apache.fulcrum.security.torque.om.TorqueDynamicUserGroupPeer.doSelect(criteria);
                for (TorqueDynamicUserGroup torqueDynamicUserGroup : collTorqueDynamicUserGroups)
                {
                    torqueDynamicUserGroup.setTorqueDynamicGroup((TorqueDynamicGroup) this);
                }
            }
        }
        else
        {
            // criteria has no effect for a new object
            if (!isNew())
            {
                // the following code is to determine if a new query is
                // called for.  If the criteria is the same as the last
                // one, just return the collection.
                criteria.and(org.apache.fulcrum.security.torque.om.TorqueDynamicUserGroupPeer.GROUP_ID, getEntityId());
                if (lastTorqueDynamicUserGroupCriteria == null
                        || !lastTorqueDynamicUserGroupCriteria.equals(criteria))
                {
                    collTorqueDynamicUserGroups = org.apache.fulcrum.security.torque.om.TorqueDynamicUserGroupPeer.doSelect(criteria);
                    for (TorqueDynamicUserGroup torqueDynamicUserGroup : collTorqueDynamicUserGroups)
                    {
                        torqueDynamicUserGroup.setTorqueDynamicGroup((TorqueDynamicGroup) this);
                    }
                }
            }
        }
        lastTorqueDynamicUserGroupCriteria = criteria;
        return collTorqueDynamicUserGroups;
    }

    /**
     * If this collection has already been initialized, returns
     * the collection. Otherwise returns the results of
     * getTorqueDynamicUserGroups(new Criteria(),Connection)
     * This method takes in the Connection also as input so that
     * referenced objects can also be obtained using a Connection
     * that is taken as input
     *
     * @param con the Connection
     * @return List<TorqueDynamicUserGroup> results of the collection
     * @throws TorqueException If a problem occurs with the get[connection] method.
     */
    public List<TorqueDynamicUserGroup> getTorqueDynamicUserGroups(Connection con) throws TorqueException
    {
        if (collTorqueDynamicUserGroups == null)
        {
            collTorqueDynamicUserGroups = getTorqueDynamicUserGroups(new Criteria(), con);
            for (TorqueDynamicUserGroup torqueDynamicUserGroup : collTorqueDynamicUserGroups)
            {
                torqueDynamicUserGroup.setTorqueDynamicGroup((TorqueDynamicGroup) this);
            }
        }
        return collTorqueDynamicUserGroups;
    }

    /**
     * If this collection has already been initialized with
     * an identical criteria, it returns the collection.
     * Otherwise if this BaseTorqueDynamicGroup has previously
     * been saved, it will retrieve the related TorqueDynamicUserGroup Objects
     * from storage.
     * If this BaseTorqueDynamicGroup is new, it will return
     * an empty collection or the current collection, the criteria
     * is ignored on a new object.
     * This method takes in the Connection also as input so that
     * referenced objects can also be obtained using a Connection
     * that is taken as input
     *
     * @param con the Connection
     * @return List<TorqueDynamicUserGroup> results of the collection
     * @throws TorqueException If a problem occurs with the get[connection] method.
     */
    public List<TorqueDynamicUserGroup> getTorqueDynamicUserGroups(Criteria criteria, Connection con)
            throws TorqueException
    {
        if (collTorqueDynamicUserGroups == null)
        {
            if (isNew())
            {
               initTorqueDynamicUserGroups();
            }
            else
            {
                criteria.and(org.apache.fulcrum.security.torque.om.TorqueDynamicUserGroupPeer.GROUP_ID, getEntityId());
                collTorqueDynamicUserGroups = org.apache.fulcrum.security.torque.om.TorqueDynamicUserGroupPeer.doSelect(criteria, con);
                for (TorqueDynamicUserGroup torqueDynamicUserGroup : collTorqueDynamicUserGroups)
                {
                    torqueDynamicUserGroup.setTorqueDynamicGroup((TorqueDynamicGroup) this);
                }
            }
        }
        else
        {
             // criteria has no effect for a new object
            if (!isNew())
            {
                // the following code is to determine if a new query is
                // called for.  If the criteria is the same as the last
                // one, just return the collection.
                criteria.and(org.apache.fulcrum.security.torque.om.TorqueDynamicUserGroupPeer.GROUP_ID, getEntityId());
                if (lastTorqueDynamicUserGroupCriteria == null
                        || !lastTorqueDynamicUserGroupCriteria.equals(criteria))
                {
                    collTorqueDynamicUserGroups = org.apache.fulcrum.security.torque.om.TorqueDynamicUserGroupPeer.doSelect(criteria, con);
                    for (TorqueDynamicUserGroup torqueDynamicUserGroup : collTorqueDynamicUserGroups)
                    {
                        torqueDynamicUserGroup.setTorqueDynamicGroup((TorqueDynamicGroup) this);
                    }
                }
            }
        }
        lastTorqueDynamicUserGroupCriteria = criteria;

        return collTorqueDynamicUserGroups;
    }

    /**
     * Initializes the cache collTorqueDynamicGroupRoles for referenced objects.
     * This, means, if collTorqueDynamicGroupRoles is null when this operation is called, it is
     * initialized with an empty collection, otherwise it remains unchanged. 
     *
     * @return the (possibly new) content of the field collTorqueDynamicGroupRoles, not null.
     */
    public List<TorqueDynamicGroupRole> initTorqueDynamicGroupRoles()
    {
        if (collTorqueDynamicGroupRoles == null)
        {
            collTorqueDynamicGroupRoles = new ArrayList<TorqueDynamicGroupRole>();
        }
        return collTorqueDynamicGroupRoles;
    }

    /**
     * Checks whether the cache collTorqueDynamicGroupRoles for referenced objects has either been
     * loaded from the database or has been manually initialized.
     *
     * @return boolean true if initialized
     */
    public boolean isTorqueDynamicGroupRolesInitialized()
    {
        return (collTorqueDynamicGroupRoles != null);
    }


    /**
     * Method called to associate a TorqueDynamicGroupRole object to this object
     * through the collTorqueDynamicGroupRoles foreign key attribute.
     * If the associated objects were not retrieved before
     * and this object is not new, the associated objects are retrieved
     * from the database before adding the <code>toAdd</code> object.
     *
     * @param toAdd the object to add to the associated objects, not null.
     *
     * @throws TorqueException if retrieval of the associated objects fails.
     * @throws NullPointerException if toAdd is null.
     */
    public void addTorqueDynamicGroupRole(TorqueDynamicGroupRole toAdd)
        throws TorqueException
    {
        toAdd.setTorqueDynamicGroup((TorqueDynamicGroup) this);
        getTorqueDynamicGroupRoles().add(toAdd);
    }

    /**
     * Method called to associate a TorqueDynamicGroupRole object to this object
     * through the collTorqueDynamicGroupRoles foreign key attribute using connection.
     *
     * @param l TorqueDynamicGroupRole
     * @throws TorqueException if retrieval of the associated objects fails.
     */
    public void addTorqueDynamicGroupRole(TorqueDynamicGroupRole l, Connection con) throws TorqueException
    {
        getTorqueDynamicGroupRoles(con).add(l);
        l.setTorqueDynamicGroup((TorqueDynamicGroup) this);
    }
    
    /**
     * Method called to reset the cache of TorqueDynamicGroupRole objects
     * which are related through the collTorqueDynamicGroupRoles foreign key attribute.
     */
    public void resetTorqueDynamicGroupRole()
    {
        collTorqueDynamicGroupRoles = null;
    }


    /**
     * The criteria used to select the current contents of collTorqueDynamicGroupRoles
     */
    private Criteria lastTorqueDynamicGroupRoleCriteria = null;

    /**
     * If this collection has already been initialized, returns
     * the collection. Otherwise returns the results of
     * getTorqueDynamicGroupRoles(new Criteria())
     *
     * @return the collection of associated objects
     * @throws TorqueException
     */
    public List<TorqueDynamicGroupRole> getTorqueDynamicGroupRoles()
        throws TorqueException
    {
        if (collTorqueDynamicGroupRoles == null)
        {
            collTorqueDynamicGroupRoles = getTorqueDynamicGroupRoles(new Criteria());
            for (TorqueDynamicGroupRole torqueDynamicGroupRole : collTorqueDynamicGroupRoles)
            {
                torqueDynamicGroupRole.setTorqueDynamicGroup((TorqueDynamicGroup) this);
            }
        }
        return collTorqueDynamicGroupRoles;
    }

    /**
     * If this collection has already been initialized with
     * an identical criteria, it returns the collection.
     * Otherwise if this BaseTorqueDynamicGroup has previously
     * been saved, it will retrieve related collTorqueDynamicGroupRoles from storage.
     * If this BaseTorqueDynamicGroup is new, it will return
     * an empty collection or the current collection, the criteria
     * is ignored on a new object.
     *
     * @throws TorqueException If a problem occurs with the get[criteria] method.     
     */
    public List<TorqueDynamicGroupRole> getTorqueDynamicGroupRoles(Criteria criteria) throws TorqueException
    {
        if (collTorqueDynamicGroupRoles == null)
        {
            if (isNew())
            {
               initTorqueDynamicGroupRoles();
            }
            else
            {
                criteria.and(org.apache.fulcrum.security.torque.om.TorqueDynamicGroupRolePeer.GROUP_ID, getEntityId());
                collTorqueDynamicGroupRoles = org.apache.fulcrum.security.torque.om.TorqueDynamicGroupRolePeer.doSelect(criteria);
                for (TorqueDynamicGroupRole torqueDynamicGroupRole : collTorqueDynamicGroupRoles)
                {
                    torqueDynamicGroupRole.setTorqueDynamicGroup((TorqueDynamicGroup) this);
                }
            }
        }
        else
        {
            // criteria has no effect for a new object
            if (!isNew())
            {
                // the following code is to determine if a new query is
                // called for.  If the criteria is the same as the last
                // one, just return the collection.
                criteria.and(org.apache.fulcrum.security.torque.om.TorqueDynamicGroupRolePeer.GROUP_ID, getEntityId());
                if (lastTorqueDynamicGroupRoleCriteria == null
                        || !lastTorqueDynamicGroupRoleCriteria.equals(criteria))
                {
                    collTorqueDynamicGroupRoles = org.apache.fulcrum.security.torque.om.TorqueDynamicGroupRolePeer.doSelect(criteria);
                    for (TorqueDynamicGroupRole torqueDynamicGroupRole : collTorqueDynamicGroupRoles)
                    {
                        torqueDynamicGroupRole.setTorqueDynamicGroup((TorqueDynamicGroup) this);
                    }
                }
            }
        }
        lastTorqueDynamicGroupRoleCriteria = criteria;
        return collTorqueDynamicGroupRoles;
    }

    /**
     * If this collection has already been initialized, returns
     * the collection. Otherwise returns the results of
     * getTorqueDynamicGroupRoles(new Criteria(),Connection)
     * This method takes in the Connection also as input so that
     * referenced objects can also be obtained using a Connection
     * that is taken as input
     *
     * @param con the Connection
     * @return List<TorqueDynamicGroupRole> results of the collection
     * @throws TorqueException If a problem occurs with the get[connection] method.
     */
    public List<TorqueDynamicGroupRole> getTorqueDynamicGroupRoles(Connection con) throws TorqueException
    {
        if (collTorqueDynamicGroupRoles == null)
        {
            collTorqueDynamicGroupRoles = getTorqueDynamicGroupRoles(new Criteria(), con);
            for (TorqueDynamicGroupRole torqueDynamicGroupRole : collTorqueDynamicGroupRoles)
            {
                torqueDynamicGroupRole.setTorqueDynamicGroup((TorqueDynamicGroup) this);
            }
        }
        return collTorqueDynamicGroupRoles;
    }

    /**
     * If this collection has already been initialized with
     * an identical criteria, it returns the collection.
     * Otherwise if this BaseTorqueDynamicGroup has previously
     * been saved, it will retrieve the related TorqueDynamicGroupRole Objects
     * from storage.
     * If this BaseTorqueDynamicGroup is new, it will return
     * an empty collection or the current collection, the criteria
     * is ignored on a new object.
     * This method takes in the Connection also as input so that
     * referenced objects can also be obtained using a Connection
     * that is taken as input
     *
     * @param con the Connection
     * @return List<TorqueDynamicGroupRole> results of the collection
     * @throws TorqueException If a problem occurs with the get[connection] method.
     */
    public List<TorqueDynamicGroupRole> getTorqueDynamicGroupRoles(Criteria criteria, Connection con)
            throws TorqueException
    {
        if (collTorqueDynamicGroupRoles == null)
        {
            if (isNew())
            {
               initTorqueDynamicGroupRoles();
            }
            else
            {
                criteria.and(org.apache.fulcrum.security.torque.om.TorqueDynamicGroupRolePeer.GROUP_ID, getEntityId());
                collTorqueDynamicGroupRoles = org.apache.fulcrum.security.torque.om.TorqueDynamicGroupRolePeer.doSelect(criteria, con);
                for (TorqueDynamicGroupRole torqueDynamicGroupRole : collTorqueDynamicGroupRoles)
                {
                    torqueDynamicGroupRole.setTorqueDynamicGroup((TorqueDynamicGroup) this);
                }
            }
        }
        else
        {
             // criteria has no effect for a new object
            if (!isNew())
            {
                // the following code is to determine if a new query is
                // called for.  If the criteria is the same as the last
                // one, just return the collection.
                criteria.and(org.apache.fulcrum.security.torque.om.TorqueDynamicGroupRolePeer.GROUP_ID, getEntityId());
                if (lastTorqueDynamicGroupRoleCriteria == null
                        || !lastTorqueDynamicGroupRoleCriteria.equals(criteria))
                {
                    collTorqueDynamicGroupRoles = org.apache.fulcrum.security.torque.om.TorqueDynamicGroupRolePeer.doSelect(criteria, con);
                    for (TorqueDynamicGroupRole torqueDynamicGroupRole : collTorqueDynamicGroupRoles)
                    {
                        torqueDynamicGroupRole.setTorqueDynamicGroup((TorqueDynamicGroup) this);
                    }
                }
            }
        }
        lastTorqueDynamicGroupRoleCriteria = criteria;

        return collTorqueDynamicGroupRoles;
    }

    /**
     * If this collection has already been initialized with
     * an identical criteria, it returns the collection.
     * Otherwise if this BaseTorqueDynamicGroup is new, it will return
     * an empty collection; or if this thisObjectClassName has previously
     * been saved, it will retrieve the related objects from storage.
     *
     * This method is protected by default in order to keep the public
     * api reasonable.  You can change the access modifier to public
     * by overriding this method in the child class.
     *
     * @return List<TorqueDynamicUserGroup> the collection
     * @param criteria the criteria to use when filling the collection.
     * @throws TorqueException if associated objects are not found
     */
    protected List<TorqueDynamicUserGroup> getTorqueDynamicUserGroupsJoinTorqueDynamicUser(Criteria criteria) throws TorqueException
    {
        try (TorqueConnection connection = Transaction.begin(criteria.getDbName()))
        {
            List<TorqueDynamicUserGroup> result = getTorqueDynamicUserGroupsJoinTorqueDynamicUser(criteria, connection);

            Transaction.commit(connection);
            return result;
        }
    }

    /**
     * If this collection has already been initialized with
     * an identical criteria, it returns the collection.
     * Otherwise if this BaseTorqueDynamicGroup is new, it will return
     * an empty collection; or if this BaseTorqueDynamicGroup has previously
     * been saved, it will retrieve the related objects from storage.
     *
     * This method is protected by default in order to keep the public
     * api reasonable.  You can change the access modifier to public
     * by overriding this method in the child class.
     */
    protected List<TorqueDynamicUserGroup> getTorqueDynamicUserGroupsJoinTorqueDynamicUser(Criteria criteria, Connection connection)
        throws TorqueException
    {
        if (collTorqueDynamicUserGroups == null)
        {
            if (isNew())
            {
                initTorqueDynamicUserGroups();
            }
            else
            {
                criteria.and(org.apache.fulcrum.security.torque.om.TorqueDynamicUserGroupPeer.GROUP_ID, getEntityId());
                collTorqueDynamicUserGroups = org.apache.fulcrum.security.torque.om.TorqueDynamicUserGroupPeer.doSelectJoinTorqueDynamicUser(criteria, connection);
                for (TorqueDynamicUserGroup torqueDynamicUserGroup : collTorqueDynamicUserGroups)
                {
                    torqueDynamicUserGroup.setTorqueDynamicGroup((TorqueDynamicGroup) this);
                }
            }
        }
        else
        {
            // the following code is to determine if a new query is
            // called for.  If the criteria is the same as the last
            // one, just return the collection.
            criteria.and(org.apache.fulcrum.security.torque.om.TorqueDynamicUserGroupPeer.GROUP_ID, getEntityId());
            if (lastTorqueDynamicUserGroupCriteria == null
                        || !lastTorqueDynamicUserGroupCriteria.equals(criteria))
            {
                collTorqueDynamicUserGroups = org.apache.fulcrum.security.torque.om.TorqueDynamicUserGroupPeer.doSelectJoinTorqueDynamicUser(criteria, connection);
                for (TorqueDynamicUserGroup torqueDynamicUserGroup : collTorqueDynamicUserGroups)
                {
                    torqueDynamicUserGroup.setTorqueDynamicGroup((TorqueDynamicGroup) this);
                }
            }
        }
        lastTorqueDynamicUserGroupCriteria = criteria;

        return collTorqueDynamicUserGroups;
    }

    /**
     * If this collection has already been initialized with
     * an identical criteria, it returns the collection.
     * Otherwise if this BaseTorqueDynamicGroup is new, it will return
     * an empty collection; or if this thisObjectClassName has previously
     * been saved, it will retrieve the related objects from storage.
     *
     * This method is protected by default in order to keep the public
     * api reasonable.  You can change the access modifier to public
     * by overriding this method in the child class.
     *
     * @return List<TorqueDynamicGroupRole> the collection
     * @param criteria the criteria to use when filling the collection.
     * @throws TorqueException if associated objects are not found
     */
    protected List<TorqueDynamicGroupRole> getTorqueDynamicGroupRolesJoinTorqueDynamicRole(Criteria criteria) throws TorqueException
    {
        try (TorqueConnection connection = Transaction.begin(criteria.getDbName()))
        {
            List<TorqueDynamicGroupRole> result = getTorqueDynamicGroupRolesJoinTorqueDynamicRole(criteria, connection);

            Transaction.commit(connection);
            return result;
        }
    }

    /**
     * If this collection has already been initialized with
     * an identical criteria, it returns the collection.
     * Otherwise if this BaseTorqueDynamicGroup is new, it will return
     * an empty collection; or if this BaseTorqueDynamicGroup has previously
     * been saved, it will retrieve the related objects from storage.
     *
     * This method is protected by default in order to keep the public
     * api reasonable.  You can change the access modifier to public
     * by overriding this method in the child class.
     */
    protected List<TorqueDynamicGroupRole> getTorqueDynamicGroupRolesJoinTorqueDynamicRole(Criteria criteria, Connection connection)
        throws TorqueException
    {
        if (collTorqueDynamicGroupRoles == null)
        {
            if (isNew())
            {
                initTorqueDynamicGroupRoles();
            }
            else
            {
                criteria.and(org.apache.fulcrum.security.torque.om.TorqueDynamicGroupRolePeer.GROUP_ID, getEntityId());
                collTorqueDynamicGroupRoles = org.apache.fulcrum.security.torque.om.TorqueDynamicGroupRolePeer.doSelectJoinTorqueDynamicRole(criteria, connection);
                for (TorqueDynamicGroupRole torqueDynamicGroupRole : collTorqueDynamicGroupRoles)
                {
                    torqueDynamicGroupRole.setTorqueDynamicGroup((TorqueDynamicGroup) this);
                }
            }
        }
        else
        {
            // the following code is to determine if a new query is
            // called for.  If the criteria is the same as the last
            // one, just return the collection.
            criteria.and(org.apache.fulcrum.security.torque.om.TorqueDynamicGroupRolePeer.GROUP_ID, getEntityId());
            if (lastTorqueDynamicGroupRoleCriteria == null
                        || !lastTorqueDynamicGroupRoleCriteria.equals(criteria))
            {
                collTorqueDynamicGroupRoles = org.apache.fulcrum.security.torque.om.TorqueDynamicGroupRolePeer.doSelectJoinTorqueDynamicRole(criteria, connection);
                for (TorqueDynamicGroupRole torqueDynamicGroupRole : collTorqueDynamicGroupRoles)
                {
                    torqueDynamicGroupRole.setTorqueDynamicGroup((TorqueDynamicGroup) this);
                }
            }
        }
        lastTorqueDynamicGroupRoleCriteria = criteria;

        return collTorqueDynamicGroupRoles;
    }





    /**
     * Stores an object in the database.  If the object is new,
     * it is inserted; otherwise an update is performed.
     *
     * @throws TorqueException if an error occurs during saving.
     */
    public void save() throws TorqueException
    {
        save(TorqueDynamicGroupPeer.DATABASE_NAME);
    }

    /**
     * Stores an object in the database.  If the object is new,
     * it is inserted; otherwise an update is performed.
     *
     * @param dbName the name of the database to which the object
     *        should be saved.
     *
     * @throws TorqueException if an error occurs during saving.
     */
    public void save(String dbName) 
            throws TorqueException
    {
        try (TorqueConnection con = Transaction.begin(dbName))
        {
            save(con);
            Transaction.commit(con);
        }
    }

    /**
     * Stores an object in the database.  If the object is new,
     * it is inserted; otherwise an update is performed.  This method
     * is meant to be used as part of a transaction, otherwise use
     * the save() method and the connection details will be handled
     * internally.
     *
     * @param con the connection to use for saving the object, not null.
     *
     * @throws TorqueException if an error occurs during saving.
     */
    public void save(Connection con) 
            throws TorqueException
    {
        if (isSaving())
        {
            return;
        }
        try
        {
            setSaving(true);
            // If this object has been modified, then save it to the database.
            if (isModified())
            {
                if (isNew())
                {
                    TorqueDynamicGroupPeer.doInsert((TorqueDynamicGroup) this, con);
                    setNew(false);
                }
                else
                {
                    TorqueDynamicGroupPeer.doUpdate((TorqueDynamicGroup) this, con);
                }
            }

            if (isTorqueDynamicUserGroupsInitialized())
            {
                for (TorqueDynamicUserGroup collTorqueDynamicUserGroups : getTorqueDynamicUserGroups())
                {
                    collTorqueDynamicUserGroups.save(con);
                }
            }
            if (isTorqueDynamicGroupRolesInitialized())
            {
                for (TorqueDynamicGroupRole collTorqueDynamicGroupRoles : getTorqueDynamicGroupRoles())
                {
                    collTorqueDynamicGroupRoles.save(con);
                }
            }
        }
        finally
        {
            setSaving(false);
        }
    }




    /**
     * Set the PrimaryKey using ObjectKey.
     *
     * @param key entityId ObjectKey
     */
    public void setPrimaryKey(ObjectKey<?> key)
        
    {
        setEntityId(Integer.valueOf(((NumberKey) key).intValue()));
    }

    /**
     * Set the PrimaryKey using a String.
     *
     * @param key the primary key to set.
     */
    public void setPrimaryKey(String key) 
    {
        setEntityId(new Integer(key));
    }


    /**
     * returns an id that differentiates this object from others
     * of its class.
     */
    public ObjectKey<?> getPrimaryKey()
    {
        return SimpleKey.keyFor(getEntityId());
    }



    /**
     * Makes a copy of this object.
     * It creates a new object filling in the simple attributes.
     * It then fills all the association collections and sets the
     * related objects to isNew=true.
     * @throws TorqueException if retrieval of the associated objects fails  
     */
    public TorqueDynamicGroup copy() throws TorqueException
    {
        return copy(true);
    }

    /**
     * Makes a copy of this object using a connection.
     * It creates a new object filling in the simple attributes.
     * It then fills all the association collections and sets the
     * related objects to isNew=true.
     *
     * @param con the database connection to read associated objects.
     * @throws TorqueException if retrieval of the associated objects fails     
     */
    public TorqueDynamicGroup copy(Connection con) throws TorqueException
    {
        return copy(true, con);
    }

    /**
     * Makes a copy of this object.
     * It creates a new object filling in the simple attributes.
     * If the parameter deepcopy is true, it then fills all the
     * association collections and sets the related objects to
     * isNew=true.
     *
     * @param deepcopy whether to copy the associated objects.
     * @throws TorqueException if retrieval of the associated objects fails
     */
    public TorqueDynamicGroup copy(boolean deepcopy) throws TorqueException
    {
        TorqueDynamicGroup torqueDynamicGroup = new TorqueDynamicGroup();

        return copyInto(torqueDynamicGroup, deepcopy);
    }

    /**
     * Makes a copy of this object using connection.
     * It creates a new object filling in the simple attributes.
     * If the parameter deepcopy is true, it then fills all the
     * association collections and sets the related objects to
     * isNew=true.
     *
     * @param deepcopy whether to copy the associated objects.
     * @param con the database connection to read associated objects.
     * @throws TorqueException if retrieval of the associated objects fails
     */
    public TorqueDynamicGroup copy(boolean deepcopy, Connection con) throws TorqueException
    {
        TorqueDynamicGroup torqueDynamicGroup = new TorqueDynamicGroup();

        return copyInto(torqueDynamicGroup, deepcopy, con);
    }
  
    /**
     * Fills the copyObj with the contents of this object.
     * The associated objects are also copied and treated as new objects.
     *
     * @param copyObj the object to fill.
     * @throws TorqueException if retrieval of the associated objects fails
     */
    public TorqueDynamicGroup copyInto(TorqueDynamicGroup copyObj) throws TorqueException
    {
        return copyInto(copyObj, true);
    }

    /**
     * Fills the copyObj with the contents of this object using connection.
     * The associated objects are also copied and treated as new objects.
     *
     * @param copyObj the object to fill.
     * @param con the database connection to read associated objects.
     * @throws TorqueException if retrieval of the associated objects fails
     */
    public TorqueDynamicGroup copyInto(TorqueDynamicGroup copyObj, Connection con) throws TorqueException
    {
        return copyInto(copyObj, true, con);
    }
  
    /**
     * Fills the copyObj with the contents of this object.
     * If deepcopy is true, The associated objects are also copied
     * and treated as new objects.
     *
     * @param copyObj the object to fill.
     * @param deepcopy whether the associated objects should be copied.
     * @throws TorqueException if retrieval of the associated objects fails
     */
    protected TorqueDynamicGroup copyInto(TorqueDynamicGroup copyObj, boolean deepcopy) throws TorqueException
    {
        copyObj.setEntityId((Integer) null);
        copyObj.setEntityName(entityName);

        if (deepcopy)
        {
            if (collTorqueDynamicUserGroups != null)
            {
                for (TorqueDynamicUserGroup obj : collTorqueDynamicUserGroups)
                {
                    copyObj.addTorqueDynamicUserGroup(obj.copy());
                }
            }
            else
            {
                copyObj.collTorqueDynamicUserGroups = null;
            }
            if (collTorqueDynamicGroupRoles != null)
            {
                for (TorqueDynamicGroupRole obj : collTorqueDynamicGroupRoles)
                {
                    copyObj.addTorqueDynamicGroupRole(obj.copy());
                }
            }
            else
            {
                copyObj.collTorqueDynamicGroupRoles = null;
            }
        }
        return copyObj;
    }
        
    
    /**
     * Fills the copyObj with the contents of this object using connection.
     * If deepcopy is true, The associated objects are also copied
     * and treated as new objects.
     *
     * @param copyObj the object to fill.
     * @param deepcopy whether the associated objects should be copied.
     * @param con the database connection to read associated objects.
     * @throws TorqueException if retrieval of the associated objects fails
     */
    public TorqueDynamicGroup copyInto(TorqueDynamicGroup copyObj, boolean deepcopy, Connection con) throws TorqueException
    {
        copyObj.setEntityId((Integer) null);
        copyObj.setEntityName(entityName);

        if (deepcopy)
        {
            for (TorqueDynamicUserGroup obj : getTorqueDynamicUserGroups(con))
            {
                copyObj.addTorqueDynamicUserGroup(obj.copy());
            }
            for (TorqueDynamicGroupRole obj : getTorqueDynamicGroupRoles(con))
            {
                copyObj.addTorqueDynamicGroupRole(obj.copy());
            }
        }
        return copyObj;
    }

    /** The Peer class */
    private static final org.apache.fulcrum.security.torque.om.TorqueDynamicGroupPeer peer
            = new org.apache.fulcrum.security.torque.om.TorqueDynamicGroupPeer();

    /**
     * returns a peer instance associated with this om.  Since Peer classes
     * are not to have any instance attributes, this method returns the
     * same instance for all member of this class. The method could therefore
     * be static, but this would prevent one from overriding the behavior.
     */
    public org.apache.fulcrum.security.torque.om.TorqueDynamicGroupPeer getPeer()
    {
        return peer;
    }

    /**
     * Retrieves the TableMap object related to this Table data without
     * compiler warnings of using getPeer().getTableMap().
     *
     * @return The associated TableMap object.
     * @throws TorqueException if associated objects are not found
     */
    public TableMap getTableMap() throws TorqueException
    {
        return org.apache.fulcrum.security.torque.om.TorqueDynamicGroupPeer.getTableMap();
    }



    public String toString()
    {
        StringBuffer str = new StringBuffer();
        str.append("TorqueDynamicGroup:\n");
        str.append("entityId = ")
           .append(getEntityId())
           .append("\n");
        str.append("entityName = ")
           .append(getEntityName())
           .append("\n");
        return(str.toString());
    }

    /**
     * Compares the primary key of this instance with the key of another.
     *
     * @param toCompare The object to compare to.
     * @return Whether the primary keys are equal and the object have the
     *         same class.
     */
    public boolean equals(Object toCompare)
    {
        if (toCompare == null)
        {
            return false;
        }
        if (this == toCompare)
        {
            return true;
        }
        if (!getClass().equals(toCompare.getClass()))
        {
            return false;
        }
        TorqueDynamicGroup other = (TorqueDynamicGroup) toCompare;
        if (getPrimaryKey() == null || other.getPrimaryKey() == null)
        {
            return false;
        }
        return getPrimaryKey().equals(other.getPrimaryKey());
    }

    /**
     * If the primary key is not <code>null</code>, return the hashcode of the
     * primary key.  Otherwise calls <code>Object.hashCode()</code>.
     *
     * @return an <code>int</code> value
     */
    public int hashCode()
    {
        ObjectKey<?> ok = getPrimaryKey();
        if (ok == null)
        {
            return super.hashCode();
        }

        return ok.hashCode();
    }



    /**
     * Compares the content of this object to another object
     *
     * @param toCompare The object to compare to.
     * @return true if all of the columns in the other object have 
     *         the same value as the objects in this class.
     */
    public boolean valueEquals(TorqueDynamicGroup toCompare)
    {
        if (toCompare == null)
        {
            return false;
        }
        if (this == toCompare)
        {
            return true;
        }
        if (!Objects.equals(this.entityId, toCompare.getEntityId()))
        {
            return false;
        }
        if (!Objects.equals(this.entityName, toCompare.getEntityName()))
        {
            return false;
        }
        return true;
    }



}
