/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fulcrum.security.torque.turbine;

import java.sql.Connection;
import java.util.List;
import org.apache.fulcrum.security.entity.Role;
import org.apache.fulcrum.security.torque.om.TorqueTurbineRole;
import org.apache.fulcrum.security.torque.om.TorqueTurbineRolePeer;
import org.apache.fulcrum.security.torque.peer.TorqueTurbinePeer;
import org.apache.fulcrum.security.torque.peer.managers.PeerRoleManager;
import org.apache.fulcrum.security.util.DataBackendException;
import org.apache.torque.NoRowsException;
import org.apache.torque.TooManyRowsException;
import org.apache.torque.TorqueException;
import org.apache.torque.criteria.Criteria;

public class TorqueTurbineRoleManagerImpl
extends PeerRoleManager {
    private static final long serialVersionUID = 1L;

    @Override
    protected <T extends Role> List<T> doSelectAllRoles(Connection con) throws TorqueException {
        Criteria criteria = new Criteria();
        if (this.getCustomPeer().booleanValue()) {
            try {
                TorqueTurbinePeer peerInstance = (TorqueTurbinePeer)this.getPeerInstance();
                return peerInstance.doSelect(criteria, con);
            }
            catch (DataBackendException e) {
                throw new TorqueException((Throwable)e);
            }
        }
        return TorqueTurbineRolePeer.doSelect(criteria, con);
    }

    @Override
    protected <T extends Role> T doSelectById(Integer id, Connection con) throws NoRowsException, TooManyRowsException, TorqueException {
        if (this.getCustomPeer().booleanValue()) {
            try {
                TorqueTurbinePeer peerInstance = (TorqueTurbinePeer)this.getPeerInstance();
                return (T)((Role)peerInstance.retrieveByPK(id, con));
            }
            catch (DataBackendException e) {
                throw new TorqueException((Throwable)e);
            }
        }
        return (T)TorqueTurbineRolePeer.retrieveByPK(id, con);
    }

    @Override
    protected <T extends Role> T doSelectByName(String name, Connection con) throws NoRowsException, TooManyRowsException, TorqueException {
        Criteria criteria = new Criteria();
        criteria.setIgnoreCase(true);
        criteria.setSingleRecord(true);
        List<TorqueTurbineRole> roles = null;
        if (this.getCustomPeer().booleanValue()) {
            try {
                TorqueTurbinePeer peerInstance = (TorqueTurbinePeer)this.getPeerInstance();
                criteria.where((Object)peerInstance.getTableMap().getColumn(this.getColumnName()), (Object)name);
                roles = peerInstance.doSelect(criteria, con);
            }
            catch (DataBackendException e) {
                throw new TorqueException((Throwable)e);
            }
        } else {
            criteria.where((Object)TorqueTurbineRolePeer.ROLE_NAME, (Object)name);
            roles = TorqueTurbineRolePeer.doSelect(criteria, con);
        }
        if (roles.isEmpty()) {
            throw new NoRowsException(name);
        }
        return (T)((Role)roles.get(0));
    }
}

