/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fulcrum.security.torque.om;

import java.io.Serializable;
import java.sql.Connection;
import java.util.Objects;
import org.apache.fulcrum.security.torque.om.TurbinePermission;
import org.apache.fulcrum.security.torque.om.TurbinePermissionPeer;
import org.apache.fulcrum.security.torque.om.TurbineRole;
import org.apache.fulcrum.security.torque.om.TurbineRolePeer;
import org.apache.fulcrum.security.torque.om.TurbineRolePermission;
import org.apache.fulcrum.security.torque.om.TurbineRolePermissionPeer;
import org.apache.torque.TorqueException;
import org.apache.torque.map.TableMap;
import org.apache.torque.om.ComboKey;
import org.apache.torque.om.NumberKey;
import org.apache.torque.om.ObjectKey;
import org.apache.torque.om.Persistent;
import org.apache.torque.om.SimpleKey;
import org.apache.torque.util.TorqueConnection;
import org.apache.torque.util.Transaction;

public abstract class BaseTurbineRolePermission
implements Persistent,
Serializable {
    private static final long serialVersionUID = 1699003176918L;
    private Integer roleId = null;
    private Integer permissionId = null;
    private boolean modified = true;
    private boolean isNew = true;
    private boolean saving = false;
    private boolean loading = false;
    private boolean deleted = false;
    private TurbineRole aTurbineRole = null;
    private TurbinePermission aTurbinePermission = null;
    private final SimpleKey<?>[] pks = new SimpleKey[2];
    private final ComboKey comboPK = new ComboKey(this.pks);
    private static final TurbineRolePermissionPeer peer = new TurbineRolePermissionPeer();

    public Integer getRoleId() {
        return this.roleId;
    }

    public void setRoleId(Integer v) {
        if (!Objects.equals(this.roleId, v)) {
            this.setModified(true);
        }
        this.roleId = v;
        if (this.aTurbineRole != null && !Objects.equals(this.aTurbineRole.getEntityId(), v)) {
            this.aTurbineRole = null;
        }
    }

    public Integer getPermissionId() {
        return this.permissionId;
    }

    public void setPermissionId(Integer v) {
        if (!Objects.equals(this.permissionId, v)) {
            this.setModified(true);
        }
        this.permissionId = v;
        if (this.aTurbinePermission != null && !Objects.equals(this.aTurbinePermission.getEntityId(), v)) {
            this.aTurbinePermission = null;
        }
    }

    public boolean isNew() {
        return this.isNew;
    }

    public void setNew(boolean isNew) {
        this.isNew = isNew;
    }

    public boolean isModified() {
        return this.modified;
    }

    public void setModified(boolean modified) {
        this.modified = modified;
    }

    public void resetModified() {
        this.modified = false;
    }

    public boolean isSaving() {
        return this.saving;
    }

    public void setSaving(boolean saving) {
        this.saving = saving;
    }

    public boolean isLoading() {
        return this.loading;
    }

    public void setLoading(boolean loading) {
        this.loading = loading;
    }

    public boolean isDeleted() {
        return this.deleted;
    }

    public void setDeleted(boolean deleted) {
        this.deleted = deleted;
    }

    public TurbineRole getTurbineRole() throws TorqueException {
        if (this.aTurbineRole == null && !Objects.equals(this.roleId, null)) {
            this.aTurbineRole = TurbineRolePeer.retrieveByPK(SimpleKey.keyFor((Number)this.roleId));
        }
        return this.aTurbineRole;
    }

    public TurbineRole getTurbineRole(Connection connection) throws TorqueException {
        if (this.aTurbineRole == null && !Objects.equals(this.roleId, null)) {
            this.aTurbineRole = TurbineRolePeer.retrieveByPK(SimpleKey.keyFor((Number)this.roleId), connection);
        }
        return this.aTurbineRole;
    }

    public void setTurbineRole(TurbineRole v) {
        if (v == null) {
            this.setRoleId(null);
        } else {
            this.setRoleId(v.getEntityId());
        }
        this.aTurbineRole = v;
    }

    public void setTurbineRoleKey(ObjectKey<?> key) throws TorqueException {
        this.setRoleId(((NumberKey)key).intValue());
    }

    public TurbinePermission getTurbinePermission() throws TorqueException {
        if (this.aTurbinePermission == null && !Objects.equals(this.permissionId, null)) {
            this.aTurbinePermission = TurbinePermissionPeer.retrieveByPK(SimpleKey.keyFor((Number)this.permissionId));
        }
        return this.aTurbinePermission;
    }

    public TurbinePermission getTurbinePermission(Connection connection) throws TorqueException {
        if (this.aTurbinePermission == null && !Objects.equals(this.permissionId, null)) {
            this.aTurbinePermission = TurbinePermissionPeer.retrieveByPK(SimpleKey.keyFor((Number)this.permissionId), connection);
        }
        return this.aTurbinePermission;
    }

    public void setTurbinePermission(TurbinePermission v) {
        if (v == null) {
            this.setPermissionId(null);
        } else {
            this.setPermissionId(v.getEntityId());
        }
        this.aTurbinePermission = v;
    }

    public void setTurbinePermissionKey(ObjectKey<?> key) throws TorqueException {
        this.setPermissionId(((NumberKey)key).intValue());
    }

    public void save() throws TorqueException {
        this.save(TurbineRolePermissionPeer.DATABASE_NAME);
    }

    public void save(String dbName) throws TorqueException {
        try (TorqueConnection con = Transaction.begin((String)dbName);){
            this.save((Connection)con);
            Transaction.commit((Connection)con);
        }
    }

    public void save(Connection con) throws TorqueException {
        if (this.isSaving()) {
            return;
        }
        try {
            this.setSaving(true);
            if (this.isModified()) {
                if (this.isNew()) {
                    TurbineRolePermissionPeer.doInsert((TurbineRolePermission)this, con);
                    this.setNew(false);
                } else {
                    TurbineRolePermissionPeer.doUpdate((TurbineRolePermission)this, con);
                }
            }
        }
        finally {
            this.setSaving(false);
        }
    }

    public void setPrimaryKey(ObjectKey<?> key) throws TorqueException {
        SimpleKey[] keys = (SimpleKey[])key.getValue();
        this.setRoleId(((NumberKey)keys[0]).intValue());
        this.setPermissionId(((NumberKey)keys[1]).intValue());
    }

    public void setPrimaryKey(Integer roleId, Integer permissionId) {
        this.setRoleId(roleId);
        this.setPermissionId(permissionId);
    }

    public void setPrimaryKey(String key) throws TorqueException {
        this.setPrimaryKey((ObjectKey<?>)new ComboKey(key));
    }

    public ObjectKey<?> getPrimaryKey() {
        SimpleKey[] pks = new SimpleKey[]{SimpleKey.keyFor((Number)this.getRoleId()), SimpleKey.keyFor((Number)this.getPermissionId())};
        return new ComboKey(pks);
    }

    public ObjectKey<?> getForeignKeyForTurbineRole() {
        return SimpleKey.keyFor((Number)this.getRoleId());
    }

    public ObjectKey<?> getForeignKeyForTurbinePermission() {
        return SimpleKey.keyFor((Number)this.getPermissionId());
    }

    public TurbineRolePermission copy() throws TorqueException {
        return this.copy(true);
    }

    public TurbineRolePermission copy(Connection con) throws TorqueException {
        return this.copy(true, con);
    }

    public TurbineRolePermission copy(boolean deepcopy) throws TorqueException {
        TurbineRolePermission turbineRolePermission = new TurbineRolePermission();
        return this.copyInto(turbineRolePermission, deepcopy);
    }

    public TurbineRolePermission copy(boolean deepcopy, Connection con) throws TorqueException {
        TurbineRolePermission turbineRolePermission = new TurbineRolePermission();
        return this.copyInto(turbineRolePermission, deepcopy, con);
    }

    public TurbineRolePermission copyInto(TurbineRolePermission copyObj) throws TorqueException {
        return this.copyInto(copyObj, true);
    }

    public TurbineRolePermission copyInto(TurbineRolePermission copyObj, Connection con) throws TorqueException {
        return this.copyInto(copyObj, true, con);
    }

    protected TurbineRolePermission copyInto(TurbineRolePermission copyObj, boolean deepcopy) throws TorqueException {
        copyObj.setRoleId(null);
        copyObj.setPermissionId(null);
        if (deepcopy) {
            // empty if block
        }
        return copyObj;
    }

    public TurbineRolePermission copyInto(TurbineRolePermission copyObj, boolean deepcopy, Connection con) throws TorqueException {
        copyObj.setRoleId(null);
        copyObj.setPermissionId(null);
        if (deepcopy) {
            // empty if block
        }
        return copyObj;
    }

    public TurbineRolePermissionPeer getPeer() {
        return peer;
    }

    public TableMap getTableMap() throws TorqueException {
        return TurbineRolePermissionPeer.getTableMap();
    }

    public String toString() {
        StringBuffer str = new StringBuffer();
        str.append("TurbineRolePermission:\n");
        str.append("roleId = ").append(this.getRoleId()).append("\n");
        str.append("permissionId = ").append(this.getPermissionId()).append("\n");
        return str.toString();
    }

    public boolean equals(Object toCompare) {
        if (toCompare == null) {
            return false;
        }
        if (this == toCompare) {
            return true;
        }
        if (!this.getClass().equals(toCompare.getClass())) {
            return false;
        }
        TurbineRolePermission other = (TurbineRolePermission)toCompare;
        if (this.getPrimaryKey() == null || other.getPrimaryKey() == null) {
            return false;
        }
        return this.getPrimaryKey().equals(other.getPrimaryKey());
    }

    public int hashCode() {
        ObjectKey<?> ok = this.getPrimaryKey();
        if (ok == null) {
            return super.hashCode();
        }
        return ok.hashCode();
    }

    public boolean valueEquals(TurbineRolePermission toCompare) {
        if (toCompare == null) {
            return false;
        }
        if (this == toCompare) {
            return true;
        }
        if (!Objects.equals(this.roleId, toCompare.getRoleId())) {
            return false;
        }
        return Objects.equals(this.permissionId, toCompare.getPermissionId());
    }
}

