package org.apache.fulcrum.security.torque.om;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.torque.Column;
import org.apache.torque.TorqueException;
import org.apache.torque.criteria.Criteria;
import org.apache.torque.om.mapper.RecordMapper;


/**
 * Maps ResultSet rows into TurbineUserGroupRole objects.
 *
 * The skeleton for this class was autogenerated by Torque on:
 *
 * [Fri Nov 03 10:19:41 CET 2023]
 *
 */
@SuppressWarnings("unused")
public class BaseTurbineUserGroupRoleRecordMapper implements RecordMapper<TurbineUserGroupRole>
{
    /** Serial version */
    private static final long serialVersionUID = 1699003181048L;

    /** The class log. */
    private static Log log
            = LogFactory.getLog(BaseTurbineUserGroupRoleRecordMapper.class);

    /**
     * Constructs the object from the current row in the resultSet.
     *
     * @param resultSet the resultSet to operate on, already pointing
     *        to the correct row. Not null.
     * @param offset a possible offset in the columns to be considered
     *        (if previous columns contain other objects),
     *        or 0 for no offset.
     * @param criteria The criteria which created the result set.
     *        If set, the attributes to set in the data object
     *        are determined from the select columns in the criteria;
     *        if no matching column can be found, null is returned.
     *        If not set, all of the table's columns are read from the
     *        result set in the order defined in the table definition.
     *
     * @return the mapped object, not null.
     *
     * @throws TorqueException when reading fields from the RecordSet fails
     *         or if a Criteria is passed which contains select columns other
     *         than the columns in the TURBINE_USER_GROUP_ROLE table.
     */
    public TurbineUserGroupRole processRow(
                ResultSet resultSet,
                int offset,
                Criteria criteria)
            throws TorqueException
    {
        TurbineUserGroupRole turbineUserGroupRole = new TurbineUserGroupRole();

        try 
        {
            turbineUserGroupRole.setLoading(true);
            if (criteria == null)
            {
                turbineUserGroupRole.setUserId(
                        getUserId(resultSet, offset + 1));
                turbineUserGroupRole.setGroupId(
                        getGroupId(resultSet, offset + 2));
                turbineUserGroupRole.setRoleId(
                        getRoleId(resultSet, offset + 3));
            }
            else
            {
                // try to get columns to be mapped
                // from criteria's select columns
                boolean columnMapped = false;
                int totalOffset = offset + 1;
                List<Column> selectColumns = criteria.getSelectColumns();
                List<Column> columnsWithoutOffset = selectColumns.subList(
                        offset, 
                        selectColumns.size());
                for (Column column : columnsWithoutOffset)
                {
                    if (BaseTurbineUserGroupRolePeer.USER_ID.getSqlExpression().equals(
                            column.getSqlExpression()))
                    {
                        turbineUserGroupRole.setUserId(
                            getUserId(resultSet, totalOffset));
                        columnMapped = true;
                    }
                    else if (BaseTurbineUserGroupRolePeer.GROUP_ID.getSqlExpression().equals(
                            column.getSqlExpression()))
                    {
                        turbineUserGroupRole.setGroupId(
                            getGroupId(resultSet, totalOffset));
                        columnMapped = true;
                    }
                    else if (BaseTurbineUserGroupRolePeer.ROLE_ID.getSqlExpression().equals(
                            column.getSqlExpression()))
                    {
                        turbineUserGroupRole.setRoleId(
                            getRoleId(resultSet, totalOffset));
                        columnMapped = true;
                    }
                    totalOffset++;
                }
                if (!columnMapped)
                {
                    log.debug("no columns to map found in criteria, "
                        + "returning null");
                    return null;
                }
            }
            turbineUserGroupRole.setNew(false);
            turbineUserGroupRole.setModified(false);
        }
        finally
        {
            turbineUserGroupRole.setLoading(false);
        }
        return turbineUserGroupRole;
    }

    /**
     * Reads the value of the <code>columnIndex</code>'th column
     * in the <code>resultSet</code> so that it can be used to set
     * the field userId in TurbineUserGroupRole.
     *
     * @param resultSet the ResultSet to read from, not null.
     * @param columnIndex the index in the resultSet which should be read.
     *
     * @return the content of the column.
     *
     * @throws SQLException if a problem occurs when reading
     *         from the resultSet.
     */
    protected Integer getUserId(
                ResultSet resultSet,
                int columnIndex)
            throws TorqueException
    {
        try
        {
            Integer value = resultSet.getInt(columnIndex);
            if (resultSet.wasNull())
            {
                value = null;
            }
            return value;
        }
        catch (SQLException e)
        {
            throw new TorqueException(e);
        }
    }
    /**
     * Reads the value of the <code>columnIndex</code>'th column
     * in the <code>resultSet</code> so that it can be used to set
     * the field groupId in TurbineUserGroupRole.
     *
     * @param resultSet the ResultSet to read from, not null.
     * @param columnIndex the index in the resultSet which should be read.
     *
     * @return the content of the column.
     *
     * @throws SQLException if a problem occurs when reading
     *         from the resultSet.
     */
    protected Integer getGroupId(
                ResultSet resultSet,
                int columnIndex)
            throws TorqueException
    {
        try
        {
            Integer value = resultSet.getInt(columnIndex);
            if (resultSet.wasNull())
            {
                value = null;
            }
            return value;
        }
        catch (SQLException e)
        {
            throw new TorqueException(e);
        }
    }
    /**
     * Reads the value of the <code>columnIndex</code>'th column
     * in the <code>resultSet</code> so that it can be used to set
     * the field roleId in TurbineUserGroupRole.
     *
     * @param resultSet the ResultSet to read from, not null.
     * @param columnIndex the index in the resultSet which should be read.
     *
     * @return the content of the column.
     *
     * @throws SQLException if a problem occurs when reading
     *         from the resultSet.
     */
    protected Integer getRoleId(
                ResultSet resultSet,
                int columnIndex)
            throws TorqueException
    {
        try
        {
            Integer value = resultSet.getInt(columnIndex);
            if (resultSet.wasNull())
            {
                value = null;
            }
            return value;
        }
        catch (SQLException e)
        {
            throw new TorqueException(e);
        }
    }

}
