package org.apache.fulcrum.security.torque.om;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.torque.Column;
import org.apache.torque.TorqueException;
import org.apache.torque.criteria.Criteria;
import org.apache.torque.om.mapper.RecordMapper;


/**
 * Maps ResultSet rows into TorqueTurbineUser objects.
 *
 * The skeleton for this class was autogenerated by Torque on:
 *
 * [Fri Nov 03 10:19:41 CET 2023]
 *
 */
@SuppressWarnings("unused")
public class BaseTorqueTurbineUserRecordMapper implements RecordMapper<TorqueTurbineUser>
{
    /** Serial version */
    private static final long serialVersionUID = 1699003181086L;

    /** The class log. */
    private static Log log
            = LogFactory.getLog(BaseTorqueTurbineUserRecordMapper.class);

    /**
     * Constructs the object from the current row in the resultSet.
     *
     * @param resultSet the resultSet to operate on, already pointing
     *        to the correct row. Not null.
     * @param offset a possible offset in the columns to be considered
     *        (if previous columns contain other objects),
     *        or 0 for no offset.
     * @param criteria The criteria which created the result set.
     *        If set, the attributes to set in the data object
     *        are determined from the select columns in the criteria;
     *        if no matching column can be found, null is returned.
     *        If not set, all of the table's columns are read from the
     *        result set in the order defined in the table definition.
     *
     * @return the mapped object, not null.
     *
     * @throws TorqueException when reading fields from the RecordSet fails
     *         or if a Criteria is passed which contains select columns other
     *         than the columns in the FULCRUM_TURBINE_USER table.
     */
    public TorqueTurbineUser processRow(
                ResultSet resultSet,
                int offset,
                Criteria criteria)
            throws TorqueException
    {
        TorqueTurbineUser torqueTurbineUser = new TorqueTurbineUser();

        try 
        {
            torqueTurbineUser.setLoading(true);
            if (criteria == null)
            {
                torqueTurbineUser.setEntityId(
                        getEntityId(resultSet, offset + 1));
                torqueTurbineUser.setEntityName(
                        getEntityName(resultSet, offset + 2));
                torqueTurbineUser.setPassword(
                        getPassword(resultSet, offset + 3));
                torqueTurbineUser.setFirstName(
                        getFirstName(resultSet, offset + 4));
                torqueTurbineUser.setLastName(
                        getLastName(resultSet, offset + 5));
                torqueTurbineUser.setEmail(
                        getEmail(resultSet, offset + 6));
                torqueTurbineUser.setObjectdata(
                        getObjectdata(resultSet, offset + 7));
            }
            else
            {
                // try to get columns to be mapped
                // from criteria's select columns
                boolean columnMapped = false;
                int totalOffset = offset + 1;
                List<Column> selectColumns = criteria.getSelectColumns();
                List<Column> columnsWithoutOffset = selectColumns.subList(
                        offset, 
                        selectColumns.size());
                for (Column column : columnsWithoutOffset)
                {
                    if (BaseTorqueTurbineUserPeer.USER_ID.getSqlExpression().equals(
                            column.getSqlExpression()))
                    {
                        torqueTurbineUser.setEntityId(
                            getEntityId(resultSet, totalOffset));
                        columnMapped = true;
                    }
                    else if (BaseTorqueTurbineUserPeer.LOGIN_NAME.getSqlExpression().equals(
                            column.getSqlExpression()))
                    {
                        torqueTurbineUser.setEntityName(
                            getEntityName(resultSet, totalOffset));
                        columnMapped = true;
                    }
                    else if (BaseTorqueTurbineUserPeer.PASSWORD_VALUE.getSqlExpression().equals(
                            column.getSqlExpression()))
                    {
                        torqueTurbineUser.setPassword(
                            getPassword(resultSet, totalOffset));
                        columnMapped = true;
                    }
                    else if (BaseTorqueTurbineUserPeer.FIRST_NAME.getSqlExpression().equals(
                            column.getSqlExpression()))
                    {
                        torqueTurbineUser.setFirstName(
                            getFirstName(resultSet, totalOffset));
                        columnMapped = true;
                    }
                    else if (BaseTorqueTurbineUserPeer.LAST_NAME.getSqlExpression().equals(
                            column.getSqlExpression()))
                    {
                        torqueTurbineUser.setLastName(
                            getLastName(resultSet, totalOffset));
                        columnMapped = true;
                    }
                    else if (BaseTorqueTurbineUserPeer.EMAIL.getSqlExpression().equals(
                            column.getSqlExpression()))
                    {
                        torqueTurbineUser.setEmail(
                            getEmail(resultSet, totalOffset));
                        columnMapped = true;
                    }
                    else if (BaseTorqueTurbineUserPeer.OBJECTDATA.getSqlExpression().equals(
                            column.getSqlExpression()))
                    {
                        torqueTurbineUser.setObjectdata(
                            getObjectdata(resultSet, totalOffset));
                        columnMapped = true;
                    }
                    totalOffset++;
                }
                if (!columnMapped)
                {
                    log.debug("no columns to map found in criteria, "
                        + "returning null");
                    return null;
                }
            }
            torqueTurbineUser.setNew(false);
            torqueTurbineUser.setModified(false);
        }
        finally
        {
            torqueTurbineUser.setLoading(false);
        }
        return torqueTurbineUser;
    }

    /**
     * Reads the value of the <code>columnIndex</code>'th column
     * in the <code>resultSet</code> so that it can be used to set
     * the field entityId in TorqueTurbineUser.
     *
     * @param resultSet the ResultSet to read from, not null.
     * @param columnIndex the index in the resultSet which should be read.
     *
     * @return the content of the column.
     *
     * @throws SQLException if a problem occurs when reading
     *         from the resultSet.
     */
    protected Integer getEntityId(
                ResultSet resultSet,
                int columnIndex)
            throws TorqueException
    {
        try
        {
            Integer value = resultSet.getInt(columnIndex);
            if (resultSet.wasNull())
            {
                value = null;
            }
            return value;
        }
        catch (SQLException e)
        {
            throw new TorqueException(e);
        }
    }
    /**
     * Reads the value of the <code>columnIndex</code>'th column
     * in the <code>resultSet</code> so that it can be used to set
     * the field entityName in TorqueTurbineUser.
     *
     * @param resultSet the ResultSet to read from, not null.
     * @param columnIndex the index in the resultSet which should be read.
     *
     * @return the content of the column.
     *
     * @throws SQLException if a problem occurs when reading
     *         from the resultSet.
     */
    protected String getEntityName(
                ResultSet resultSet,
                int columnIndex)
            throws TorqueException
    {
        try
        {
            return resultSet.getString(columnIndex);
        }
        catch (SQLException e)
        {
            throw new TorqueException(e);
        }
    }
    /**
     * Reads the value of the <code>columnIndex</code>'th column
     * in the <code>resultSet</code> so that it can be used to set
     * the field password in TorqueTurbineUser.
     *
     * @param resultSet the ResultSet to read from, not null.
     * @param columnIndex the index in the resultSet which should be read.
     *
     * @return the content of the column.
     *
     * @throws SQLException if a problem occurs when reading
     *         from the resultSet.
     */
    protected String getPassword(
                ResultSet resultSet,
                int columnIndex)
            throws TorqueException
    {
        try
        {
            return resultSet.getString(columnIndex);
        }
        catch (SQLException e)
        {
            throw new TorqueException(e);
        }
    }
    /**
     * Reads the value of the <code>columnIndex</code>'th column
     * in the <code>resultSet</code> so that it can be used to set
     * the field firstName in TorqueTurbineUser.
     *
     * @param resultSet the ResultSet to read from, not null.
     * @param columnIndex the index in the resultSet which should be read.
     *
     * @return the content of the column.
     *
     * @throws SQLException if a problem occurs when reading
     *         from the resultSet.
     */
    protected String getFirstName(
                ResultSet resultSet,
                int columnIndex)
            throws TorqueException
    {
        try
        {
            return resultSet.getString(columnIndex);
        }
        catch (SQLException e)
        {
            throw new TorqueException(e);
        }
    }
    /**
     * Reads the value of the <code>columnIndex</code>'th column
     * in the <code>resultSet</code> so that it can be used to set
     * the field lastName in TorqueTurbineUser.
     *
     * @param resultSet the ResultSet to read from, not null.
     * @param columnIndex the index in the resultSet which should be read.
     *
     * @return the content of the column.
     *
     * @throws SQLException if a problem occurs when reading
     *         from the resultSet.
     */
    protected String getLastName(
                ResultSet resultSet,
                int columnIndex)
            throws TorqueException
    {
        try
        {
            return resultSet.getString(columnIndex);
        }
        catch (SQLException e)
        {
            throw new TorqueException(e);
        }
    }
    /**
     * Reads the value of the <code>columnIndex</code>'th column
     * in the <code>resultSet</code> so that it can be used to set
     * the field email in TorqueTurbineUser.
     *
     * @param resultSet the ResultSet to read from, not null.
     * @param columnIndex the index in the resultSet which should be read.
     *
     * @return the content of the column.
     *
     * @throws SQLException if a problem occurs when reading
     *         from the resultSet.
     */
    protected String getEmail(
                ResultSet resultSet,
                int columnIndex)
            throws TorqueException
    {
        try
        {
            return resultSet.getString(columnIndex);
        }
        catch (SQLException e)
        {
            throw new TorqueException(e);
        }
    }
    /**
     * Reads the value of the <code>columnIndex</code>'th column
     * in the <code>resultSet</code> so that it can be used to set
     * the field objectdata in TorqueTurbineUser.
     *
     * @param resultSet the ResultSet to read from, not null.
     * @param columnIndex the index in the resultSet which should be read.
     *
     * @return the content of the column.
     *
     * @throws SQLException if a problem occurs when reading
     *         from the resultSet.
     */
    protected byte[] getObjectdata(
                ResultSet resultSet,
                int columnIndex)
            throws TorqueException
    {
        try
        {
            byte[] value = resultSet.getBytes(columnIndex);
            if (resultSet.wasNull())
            {
                value = null;
            }
            return value;
        }
        catch (SQLException e)
        {
            throw new TorqueException(e);
        }
    }

}
