package org.apache.fulcrum.security.torque.om;

import java.io.Serializable;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

import org.apache.torque.TorqueException;
import org.apache.torque.map.TableMap;
import org.apache.torque.om.NumberKey;
import org.apache.torque.om.ObjectKey;
import org.apache.torque.om.SimpleKey;
import org.apache.torque.om.Persistent;
import org.apache.torque.criteria.Criteria;
import org.apache.torque.util.TorqueConnection;
import org.apache.torque.util.Transaction;

/**
 * This class was autogenerated by Torque on:
 *
 * [Fri Nov 03 10:19:35 CET 2023]
 *
 * You should not use this class directly.  It should not even be
 * extended; all references should be to TorqueDynamicUser
 */
@SuppressWarnings("unused")
public abstract class BaseTorqueDynamicUser extends org.apache.fulcrum.security.torque.dynamic.TorqueAbstractDynamicUser
    implements Persistent, Serializable
{
    /** Serial version */
    private static final long serialVersionUID = 1699003175956L;



    /** Defines the entityId field. */
    private Integer entityId = null;

    /** Defines the entityName field. */
    private String entityName = null;

    /** Defines the password field. */
    private String password = null;

    /** Whether this object was modified after loading or after last save. */
    private boolean modified = true;

    /** 
     * Whether this object was loaded from the database or already saved 
     * (false) or whether it is not yet in the database(true).
     */
    private boolean isNew = true;

    /** Flag which indicates whether this object is currently saving. */
    private boolean saving = false;

    /** 
     * Flag which indicates whether this object is currently loaded
     * from the database. 
     */
    private boolean loading = false;

    /** 
     * Flag which indicates whether this object was deleted from the database.
     * Note that this flags does not always display the current database state,
     * there is no magical connection between this flag and the database.
     */
    private boolean deleted = false;



    /** Defines the collTorqueDynamicUserGroups field. */
    protected List<TorqueDynamicUserGroup> collTorqueDynamicUserGroups = null;

    /** Defines the collTorqueDynamicUserDelegatessRelatedByDelegatorUserId field. */
    protected List<TorqueDynamicUserDelegates> collTorqueDynamicUserDelegatessRelatedByDelegatorUserId = null;

    /** Defines the collTorqueDynamicUserDelegatessRelatedByDelegateeUserId field. */
    protected List<TorqueDynamicUserDelegates> collTorqueDynamicUserDelegatessRelatedByDelegateeUserId = null;



    /**
     * Get the value of entityId.
     *
     * @return the value of entityId as Integer
     */
    public Integer getEntityId() 
    {
        
        return entityId;
    }

    /**
     * Set the value of entityId.
     *
     * @param v new value of entityId
     */
    public void setEntityId(Integer v)
    {
        if (!Objects.equals(this.entityId, v))
        {
            setModified(true);
        }

        this.entityId = v;

        // update associated objects in collTorqueDynamicUserGroups 
        if (collTorqueDynamicUserGroups != null)
        {
            for (TorqueDynamicUserGroup element : collTorqueDynamicUserGroups)
            {
                element.setUserId(v);
            }
        }
        // update associated objects in collTorqueDynamicUserDelegatessRelatedByDelegatorUserId 
        if (collTorqueDynamicUserDelegatessRelatedByDelegatorUserId != null)
        {
            for (TorqueDynamicUserDelegates element : collTorqueDynamicUserDelegatessRelatedByDelegatorUserId)
            {
                element.setDelegatorUserId(v);
            }
        }
        // update associated objects in collTorqueDynamicUserDelegatessRelatedByDelegateeUserId 
        if (collTorqueDynamicUserDelegatessRelatedByDelegateeUserId != null)
        {
            for (TorqueDynamicUserDelegates element : collTorqueDynamicUserDelegatessRelatedByDelegateeUserId)
            {
                element.setDelegateeUserId(v);
            }
        }

    }
    
    /**
     * Get the value of entityName.
     *
     * @return the value of entityName as String
     */
    public String getEntityName() 
    {
        
        return entityName;
    }

    /**
     * Set the value of entityName.
     *
     * @param v new value of entityName
     */
    public void setEntityName(String v)
    {
        if (!Objects.equals(this.entityName, v))
        {
            setModified(true);
        }

        this.entityName = v;


    }
    
    /**
     * Get the value of password.
     *
     * @return the value of password as String
     */
    public String getPassword() 
    {
        
        return password;
    }

    /**
     * Set the value of password.
     *
     * @param v new value of password
     */
    public void setPassword(String v)
    {
        if (!Objects.equals(this.password, v))
        {
            setModified(true);
        }

        this.password = v;


    }
    

    /**
     * Returns whether the object has ever been saved.  This will
     * be false, if the object was retrieved from storage or was created
     * and then saved.
     *
     * @return true, if the object has never been persisted.
     */
    public boolean isNew()
    {
        return isNew;
    }

    /**
     * Sets whether the object has ever been saved.
     *
     * @param isNew true if the object has never been saved, false otherwise.
     */
    public void setNew(boolean isNew)
    {
        this.isNew = isNew;
    }

    /**
     * Returns whether the object has been modified.
     *
     * @return True if the object has been modified.
     */
    public boolean isModified()
    {
        return modified;
    }

    /**
     * Sets whether the object has been modified.
     *
     * @param modified true if the object has been modified, false otherwise.
     */
    public void setModified(boolean modified)
    {
        this.modified = modified;
    }

    /**
     * Sets the modified state for the object to be false.
     */
    public void resetModified()
    {
        modified = false;
    }


    /**
     * Returns whether this object is currently saving.
     *
     * @return true if this object is currently saving, false otherwise.
     */
    public boolean isSaving()
    {
        return saving;
    }

    /**
     * Sets whether this object is currently saving.
     *
     * @param saving true if this object is currently saving, false otherwise.
     */
    public void setSaving(boolean saving)
    {
        this.saving = saving;
    }


    /**
     * Returns whether this object is currently being loaded from the database.
     *
     * @return true if this object is currently loading, false otherwise.
     */
    public boolean isLoading()
    {
        return loading;
    }

    /**
     * Sets whether this object is currently being loaded from the database.
     *
     * @param loading true if this object is currently loading, false otherwise.
     */
    public void setLoading(boolean loading)
    {
        this.loading = loading;
    }


    /**
     * Returns whether this object was deleted from the database.
     * Note that this getter does not automatically reflect database state,
     * it will be set to true by Torque if doDelete() was called with this 
     * object. Bulk deletes and deletes via primary key do not change
     * this flag. Also, if doDelete() was called on an object which does
     * not exist in the database, the deleted flag is set to true even if
     * it was not deleted.
     *
     * @return true if this object was deleted, false otherwise.
     */
    public boolean isDeleted()
    {
        return deleted;
    }

    /**
     * Sets whether this object was deleted from the database.
     *
     * @param deleted true if this object was deleted, false otherwise.
     */
    public void setDeleted(boolean deleted)
    {
        this.deleted = deleted;
    }




    /**
     * Initializes the cache collTorqueDynamicUserGroups for referenced objects.
     * This, means, if collTorqueDynamicUserGroups is null when this operation is called, it is
     * initialized with an empty collection, otherwise it remains unchanged. 
     *
     * @return the (possibly new) content of the field collTorqueDynamicUserGroups, not null.
     */
    public List<TorqueDynamicUserGroup> initTorqueDynamicUserGroups()
    {
        if (collTorqueDynamicUserGroups == null)
        {
            collTorqueDynamicUserGroups = new ArrayList<TorqueDynamicUserGroup>();
        }
        return collTorqueDynamicUserGroups;
    }

    /**
     * Checks whether the cache collTorqueDynamicUserGroups for referenced objects has either been
     * loaded from the database or has been manually initialized.
     *
     * @return boolean true if initialized
     */
    public boolean isTorqueDynamicUserGroupsInitialized()
    {
        return (collTorqueDynamicUserGroups != null);
    }


    /**
     * Method called to associate a TorqueDynamicUserGroup object to this object
     * through the collTorqueDynamicUserGroups foreign key attribute.
     * If the associated objects were not retrieved before
     * and this object is not new, the associated objects are retrieved
     * from the database before adding the <code>toAdd</code> object.
     *
     * @param toAdd the object to add to the associated objects, not null.
     *
     * @throws TorqueException if retrieval of the associated objects fails.
     * @throws NullPointerException if toAdd is null.
     */
    public void addTorqueDynamicUserGroup(TorqueDynamicUserGroup toAdd)
        throws TorqueException
    {
        toAdd.setTorqueDynamicUser((TorqueDynamicUser) this);
        getTorqueDynamicUserGroups().add(toAdd);
    }

    /**
     * Method called to associate a TorqueDynamicUserGroup object to this object
     * through the collTorqueDynamicUserGroups foreign key attribute using connection.
     *
     * @param l TorqueDynamicUserGroup
     * @throws TorqueException if retrieval of the associated objects fails.
     */
    public void addTorqueDynamicUserGroup(TorqueDynamicUserGroup l, Connection con) throws TorqueException
    {
        getTorqueDynamicUserGroups(con).add(l);
        l.setTorqueDynamicUser((TorqueDynamicUser) this);
    }
    
    /**
     * Method called to reset the cache of TorqueDynamicUserGroup objects
     * which are related through the collTorqueDynamicUserGroups foreign key attribute.
     */
    public void resetTorqueDynamicUserGroup()
    {
        collTorqueDynamicUserGroups = null;
    }


    /**
     * The criteria used to select the current contents of collTorqueDynamicUserGroups
     */
    private Criteria lastTorqueDynamicUserGroupCriteria = null;

    /**
     * If this collection has already been initialized, returns
     * the collection. Otherwise returns the results of
     * getTorqueDynamicUserGroups(new Criteria())
     *
     * @return the collection of associated objects
     * @throws TorqueException
     */
    public List<TorqueDynamicUserGroup> getTorqueDynamicUserGroups()
        throws TorqueException
    {
        if (collTorqueDynamicUserGroups == null)
        {
            collTorqueDynamicUserGroups = getTorqueDynamicUserGroups(new Criteria());
            for (TorqueDynamicUserGroup torqueDynamicUserGroup : collTorqueDynamicUserGroups)
            {
                torqueDynamicUserGroup.setTorqueDynamicUser((TorqueDynamicUser) this);
            }
        }
        return collTorqueDynamicUserGroups;
    }

    /**
     * If this collection has already been initialized with
     * an identical criteria, it returns the collection.
     * Otherwise if this BaseTorqueDynamicUser has previously
     * been saved, it will retrieve related collTorqueDynamicUserGroups from storage.
     * If this BaseTorqueDynamicUser is new, it will return
     * an empty collection or the current collection, the criteria
     * is ignored on a new object.
     *
     * @throws TorqueException If a problem occurs with the get[criteria] method.     
     */
    public List<TorqueDynamicUserGroup> getTorqueDynamicUserGroups(Criteria criteria) throws TorqueException
    {
        if (collTorqueDynamicUserGroups == null)
        {
            if (isNew())
            {
               initTorqueDynamicUserGroups();
            }
            else
            {
                criteria.and(org.apache.fulcrum.security.torque.om.TorqueDynamicUserGroupPeer.USER_ID, getEntityId());
                collTorqueDynamicUserGroups = org.apache.fulcrum.security.torque.om.TorqueDynamicUserGroupPeer.doSelect(criteria);
                for (TorqueDynamicUserGroup torqueDynamicUserGroup : collTorqueDynamicUserGroups)
                {
                    torqueDynamicUserGroup.setTorqueDynamicUser((TorqueDynamicUser) this);
                }
            }
        }
        else
        {
            // criteria has no effect for a new object
            if (!isNew())
            {
                // the following code is to determine if a new query is
                // called for.  If the criteria is the same as the last
                // one, just return the collection.
                criteria.and(org.apache.fulcrum.security.torque.om.TorqueDynamicUserGroupPeer.USER_ID, getEntityId());
                if (lastTorqueDynamicUserGroupCriteria == null
                        || !lastTorqueDynamicUserGroupCriteria.equals(criteria))
                {
                    collTorqueDynamicUserGroups = org.apache.fulcrum.security.torque.om.TorqueDynamicUserGroupPeer.doSelect(criteria);
                    for (TorqueDynamicUserGroup torqueDynamicUserGroup : collTorqueDynamicUserGroups)
                    {
                        torqueDynamicUserGroup.setTorqueDynamicUser((TorqueDynamicUser) this);
                    }
                }
            }
        }
        lastTorqueDynamicUserGroupCriteria = criteria;
        return collTorqueDynamicUserGroups;
    }

    /**
     * If this collection has already been initialized, returns
     * the collection. Otherwise returns the results of
     * getTorqueDynamicUserGroups(new Criteria(),Connection)
     * This method takes in the Connection also as input so that
     * referenced objects can also be obtained using a Connection
     * that is taken as input
     *
     * @param con the Connection
     * @return List<TorqueDynamicUserGroup> results of the collection
     * @throws TorqueException If a problem occurs with the get[connection] method.
     */
    public List<TorqueDynamicUserGroup> getTorqueDynamicUserGroups(Connection con) throws TorqueException
    {
        if (collTorqueDynamicUserGroups == null)
        {
            collTorqueDynamicUserGroups = getTorqueDynamicUserGroups(new Criteria(), con);
            for (TorqueDynamicUserGroup torqueDynamicUserGroup : collTorqueDynamicUserGroups)
            {
                torqueDynamicUserGroup.setTorqueDynamicUser((TorqueDynamicUser) this);
            }
        }
        return collTorqueDynamicUserGroups;
    }

    /**
     * If this collection has already been initialized with
     * an identical criteria, it returns the collection.
     * Otherwise if this BaseTorqueDynamicUser has previously
     * been saved, it will retrieve the related TorqueDynamicUserGroup Objects
     * from storage.
     * If this BaseTorqueDynamicUser is new, it will return
     * an empty collection or the current collection, the criteria
     * is ignored on a new object.
     * This method takes in the Connection also as input so that
     * referenced objects can also be obtained using a Connection
     * that is taken as input
     *
     * @param con the Connection
     * @return List<TorqueDynamicUserGroup> results of the collection
     * @throws TorqueException If a problem occurs with the get[connection] method.
     */
    public List<TorqueDynamicUserGroup> getTorqueDynamicUserGroups(Criteria criteria, Connection con)
            throws TorqueException
    {
        if (collTorqueDynamicUserGroups == null)
        {
            if (isNew())
            {
               initTorqueDynamicUserGroups();
            }
            else
            {
                criteria.and(org.apache.fulcrum.security.torque.om.TorqueDynamicUserGroupPeer.USER_ID, getEntityId());
                collTorqueDynamicUserGroups = org.apache.fulcrum.security.torque.om.TorqueDynamicUserGroupPeer.doSelect(criteria, con);
                for (TorqueDynamicUserGroup torqueDynamicUserGroup : collTorqueDynamicUserGroups)
                {
                    torqueDynamicUserGroup.setTorqueDynamicUser((TorqueDynamicUser) this);
                }
            }
        }
        else
        {
             // criteria has no effect for a new object
            if (!isNew())
            {
                // the following code is to determine if a new query is
                // called for.  If the criteria is the same as the last
                // one, just return the collection.
                criteria.and(org.apache.fulcrum.security.torque.om.TorqueDynamicUserGroupPeer.USER_ID, getEntityId());
                if (lastTorqueDynamicUserGroupCriteria == null
                        || !lastTorqueDynamicUserGroupCriteria.equals(criteria))
                {
                    collTorqueDynamicUserGroups = org.apache.fulcrum.security.torque.om.TorqueDynamicUserGroupPeer.doSelect(criteria, con);
                    for (TorqueDynamicUserGroup torqueDynamicUserGroup : collTorqueDynamicUserGroups)
                    {
                        torqueDynamicUserGroup.setTorqueDynamicUser((TorqueDynamicUser) this);
                    }
                }
            }
        }
        lastTorqueDynamicUserGroupCriteria = criteria;

        return collTorqueDynamicUserGroups;
    }

    /**
     * Initializes the cache collTorqueDynamicUserDelegatessRelatedByDelegatorUserId for referenced objects.
     * This, means, if collTorqueDynamicUserDelegatessRelatedByDelegatorUserId is null when this operation is called, it is
     * initialized with an empty collection, otherwise it remains unchanged. 
     *
     * @return the (possibly new) content of the field collTorqueDynamicUserDelegatessRelatedByDelegatorUserId, not null.
     */
    public List<TorqueDynamicUserDelegates> initTorqueDynamicUserDelegatesRelatedByDelegatorUserIds()
    {
        if (collTorqueDynamicUserDelegatessRelatedByDelegatorUserId == null)
        {
            collTorqueDynamicUserDelegatessRelatedByDelegatorUserId = new ArrayList<TorqueDynamicUserDelegates>();
        }
        return collTorqueDynamicUserDelegatessRelatedByDelegatorUserId;
    }

    /**
     * Checks whether the cache collTorqueDynamicUserDelegatessRelatedByDelegatorUserId for referenced objects has either been
     * loaded from the database or has been manually initialized.
     *
     * @return boolean true if initialized
     */
    public boolean isTorqueDynamicUserDelegatesRelatedByDelegatorUserIdsInitialized()
    {
        return (collTorqueDynamicUserDelegatessRelatedByDelegatorUserId != null);
    }


    /**
     * Method called to associate a TorqueDynamicUserDelegates object to this object
     * through the collTorqueDynamicUserDelegatessRelatedByDelegatorUserId foreign key attribute.
     * If the associated objects were not retrieved before
     * and this object is not new, the associated objects are retrieved
     * from the database before adding the <code>toAdd</code> object.
     *
     * @param toAdd the object to add to the associated objects, not null.
     *
     * @throws TorqueException if retrieval of the associated objects fails.
     * @throws NullPointerException if toAdd is null.
     */
    public void addTorqueDynamicUserDelegatesRelatedByDelegatorUserId(TorqueDynamicUserDelegates toAdd)
        throws TorqueException
    {
        toAdd.setTorqueDynamicUserRelatedByDelegatorUserId((TorqueDynamicUser) this);
        getTorqueDynamicUserDelegatesRelatedByDelegatorUserIds().add(toAdd);
    }

    /**
     * Method called to associate a TorqueDynamicUserDelegates object to this object
     * through the collTorqueDynamicUserDelegatessRelatedByDelegatorUserId foreign key attribute using connection.
     *
     * @param l TorqueDynamicUserDelegates
     * @throws TorqueException if retrieval of the associated objects fails.
     */
    public void addTorqueDynamicUserDelegatesRelatedByDelegatorUserId(TorqueDynamicUserDelegates l, Connection con) throws TorqueException
    {
        getTorqueDynamicUserDelegatesRelatedByDelegatorUserIds(con).add(l);
        l.setTorqueDynamicUserRelatedByDelegatorUserId((TorqueDynamicUser) this);
    }
    
    /**
     * Method called to reset the cache of TorqueDynamicUserDelegates objects
     * which are related through the collTorqueDynamicUserDelegatessRelatedByDelegatorUserId foreign key attribute.
     */
    public void resetTorqueDynamicUserDelegatesRelatedByDelegatorUserId()
    {
        collTorqueDynamicUserDelegatessRelatedByDelegatorUserId = null;
    }


    /**
     * The criteria used to select the current contents of collTorqueDynamicUserDelegatessRelatedByDelegatorUserId
     */
    private Criteria lastTorqueDynamicUserDelegatesRelatedByDelegatorUserIdCriteria = null;

    /**
     * If this collection has already been initialized, returns
     * the collection. Otherwise returns the results of
     * getTorqueDynamicUserDelegatesRelatedByDelegatorUserIds(new Criteria())
     *
     * @return the collection of associated objects
     * @throws TorqueException
     */
    public List<TorqueDynamicUserDelegates> getTorqueDynamicUserDelegatesRelatedByDelegatorUserIds()
        throws TorqueException
    {
        if (collTorqueDynamicUserDelegatessRelatedByDelegatorUserId == null)
        {
            collTorqueDynamicUserDelegatessRelatedByDelegatorUserId = getTorqueDynamicUserDelegatesRelatedByDelegatorUserIds(new Criteria());
            for (TorqueDynamicUserDelegates torqueDynamicUserDelegates : collTorqueDynamicUserDelegatessRelatedByDelegatorUserId)
            {
                torqueDynamicUserDelegates.setTorqueDynamicUserRelatedByDelegatorUserId((TorqueDynamicUser) this);
            }
        }
        return collTorqueDynamicUserDelegatessRelatedByDelegatorUserId;
    }

    /**
     * If this collection has already been initialized with
     * an identical criteria, it returns the collection.
     * Otherwise if this BaseTorqueDynamicUser has previously
     * been saved, it will retrieve related collTorqueDynamicUserDelegatessRelatedByDelegatorUserId from storage.
     * If this BaseTorqueDynamicUser is new, it will return
     * an empty collection or the current collection, the criteria
     * is ignored on a new object.
     *
     * @throws TorqueException If a problem occurs with the get[criteria] method.     
     */
    public List<TorqueDynamicUserDelegates> getTorqueDynamicUserDelegatesRelatedByDelegatorUserIds(Criteria criteria) throws TorqueException
    {
        if (collTorqueDynamicUserDelegatessRelatedByDelegatorUserId == null)
        {
            if (isNew())
            {
               initTorqueDynamicUserDelegatesRelatedByDelegatorUserIds();
            }
            else
            {
                criteria.and(org.apache.fulcrum.security.torque.om.TorqueDynamicUserDelegatesPeer.DELEGATOR_USER_ID, getEntityId());
                collTorqueDynamicUserDelegatessRelatedByDelegatorUserId = org.apache.fulcrum.security.torque.om.TorqueDynamicUserDelegatesPeer.doSelect(criteria);
                for (TorqueDynamicUserDelegates torqueDynamicUserDelegates : collTorqueDynamicUserDelegatessRelatedByDelegatorUserId)
                {
                    torqueDynamicUserDelegates.setTorqueDynamicUserRelatedByDelegatorUserId((TorqueDynamicUser) this);
                }
            }
        }
        else
        {
            // criteria has no effect for a new object
            if (!isNew())
            {
                // the following code is to determine if a new query is
                // called for.  If the criteria is the same as the last
                // one, just return the collection.
                criteria.and(org.apache.fulcrum.security.torque.om.TorqueDynamicUserDelegatesPeer.DELEGATOR_USER_ID, getEntityId());
                if (lastTorqueDynamicUserDelegatesRelatedByDelegatorUserIdCriteria == null
                        || !lastTorqueDynamicUserDelegatesRelatedByDelegatorUserIdCriteria.equals(criteria))
                {
                    collTorqueDynamicUserDelegatessRelatedByDelegatorUserId = org.apache.fulcrum.security.torque.om.TorqueDynamicUserDelegatesPeer.doSelect(criteria);
                    for (TorqueDynamicUserDelegates torqueDynamicUserDelegates : collTorqueDynamicUserDelegatessRelatedByDelegatorUserId)
                    {
                        torqueDynamicUserDelegates.setTorqueDynamicUserRelatedByDelegatorUserId((TorqueDynamicUser) this);
                    }
                }
            }
        }
        lastTorqueDynamicUserDelegatesRelatedByDelegatorUserIdCriteria = criteria;
        return collTorqueDynamicUserDelegatessRelatedByDelegatorUserId;
    }

    /**
     * If this collection has already been initialized, returns
     * the collection. Otherwise returns the results of
     * getTorqueDynamicUserDelegatesRelatedByDelegatorUserIds(new Criteria(),Connection)
     * This method takes in the Connection also as input so that
     * referenced objects can also be obtained using a Connection
     * that is taken as input
     *
     * @param con the Connection
     * @return List<TorqueDynamicUserDelegates> results of the collection
     * @throws TorqueException If a problem occurs with the get[connection] method.
     */
    public List<TorqueDynamicUserDelegates> getTorqueDynamicUserDelegatesRelatedByDelegatorUserIds(Connection con) throws TorqueException
    {
        if (collTorqueDynamicUserDelegatessRelatedByDelegatorUserId == null)
        {
            collTorqueDynamicUserDelegatessRelatedByDelegatorUserId = getTorqueDynamicUserDelegatesRelatedByDelegatorUserIds(new Criteria(), con);
            for (TorqueDynamicUserDelegates torqueDynamicUserDelegates : collTorqueDynamicUserDelegatessRelatedByDelegatorUserId)
            {
                torqueDynamicUserDelegates.setTorqueDynamicUserRelatedByDelegatorUserId((TorqueDynamicUser) this);
            }
        }
        return collTorqueDynamicUserDelegatessRelatedByDelegatorUserId;
    }

    /**
     * If this collection has already been initialized with
     * an identical criteria, it returns the collection.
     * Otherwise if this BaseTorqueDynamicUser has previously
     * been saved, it will retrieve the related TorqueDynamicUserDelegates Objects
     * from storage.
     * If this BaseTorqueDynamicUser is new, it will return
     * an empty collection or the current collection, the criteria
     * is ignored on a new object.
     * This method takes in the Connection also as input so that
     * referenced objects can also be obtained using a Connection
     * that is taken as input
     *
     * @param con the Connection
     * @return List<TorqueDynamicUserDelegates> results of the collection
     * @throws TorqueException If a problem occurs with the get[connection] method.
     */
    public List<TorqueDynamicUserDelegates> getTorqueDynamicUserDelegatesRelatedByDelegatorUserIds(Criteria criteria, Connection con)
            throws TorqueException
    {
        if (collTorqueDynamicUserDelegatessRelatedByDelegatorUserId == null)
        {
            if (isNew())
            {
               initTorqueDynamicUserDelegatesRelatedByDelegatorUserIds();
            }
            else
            {
                criteria.and(org.apache.fulcrum.security.torque.om.TorqueDynamicUserDelegatesPeer.DELEGATOR_USER_ID, getEntityId());
                collTorqueDynamicUserDelegatessRelatedByDelegatorUserId = org.apache.fulcrum.security.torque.om.TorqueDynamicUserDelegatesPeer.doSelect(criteria, con);
                for (TorqueDynamicUserDelegates torqueDynamicUserDelegates : collTorqueDynamicUserDelegatessRelatedByDelegatorUserId)
                {
                    torqueDynamicUserDelegates.setTorqueDynamicUserRelatedByDelegatorUserId((TorqueDynamicUser) this);
                }
            }
        }
        else
        {
             // criteria has no effect for a new object
            if (!isNew())
            {
                // the following code is to determine if a new query is
                // called for.  If the criteria is the same as the last
                // one, just return the collection.
                criteria.and(org.apache.fulcrum.security.torque.om.TorqueDynamicUserDelegatesPeer.DELEGATOR_USER_ID, getEntityId());
                if (lastTorqueDynamicUserDelegatesRelatedByDelegatorUserIdCriteria == null
                        || !lastTorqueDynamicUserDelegatesRelatedByDelegatorUserIdCriteria.equals(criteria))
                {
                    collTorqueDynamicUserDelegatessRelatedByDelegatorUserId = org.apache.fulcrum.security.torque.om.TorqueDynamicUserDelegatesPeer.doSelect(criteria, con);
                    for (TorqueDynamicUserDelegates torqueDynamicUserDelegates : collTorqueDynamicUserDelegatessRelatedByDelegatorUserId)
                    {
                        torqueDynamicUserDelegates.setTorqueDynamicUserRelatedByDelegatorUserId((TorqueDynamicUser) this);
                    }
                }
            }
        }
        lastTorqueDynamicUserDelegatesRelatedByDelegatorUserIdCriteria = criteria;

        return collTorqueDynamicUserDelegatessRelatedByDelegatorUserId;
    }

    /**
     * Initializes the cache collTorqueDynamicUserDelegatessRelatedByDelegateeUserId for referenced objects.
     * This, means, if collTorqueDynamicUserDelegatessRelatedByDelegateeUserId is null when this operation is called, it is
     * initialized with an empty collection, otherwise it remains unchanged. 
     *
     * @return the (possibly new) content of the field collTorqueDynamicUserDelegatessRelatedByDelegateeUserId, not null.
     */
    public List<TorqueDynamicUserDelegates> initTorqueDynamicUserDelegatesRelatedByDelegateeUserIds()
    {
        if (collTorqueDynamicUserDelegatessRelatedByDelegateeUserId == null)
        {
            collTorqueDynamicUserDelegatessRelatedByDelegateeUserId = new ArrayList<TorqueDynamicUserDelegates>();
        }
        return collTorqueDynamicUserDelegatessRelatedByDelegateeUserId;
    }

    /**
     * Checks whether the cache collTorqueDynamicUserDelegatessRelatedByDelegateeUserId for referenced objects has either been
     * loaded from the database or has been manually initialized.
     *
     * @return boolean true if initialized
     */
    public boolean isTorqueDynamicUserDelegatesRelatedByDelegateeUserIdsInitialized()
    {
        return (collTorqueDynamicUserDelegatessRelatedByDelegateeUserId != null);
    }


    /**
     * Method called to associate a TorqueDynamicUserDelegates object to this object
     * through the collTorqueDynamicUserDelegatessRelatedByDelegateeUserId foreign key attribute.
     * If the associated objects were not retrieved before
     * and this object is not new, the associated objects are retrieved
     * from the database before adding the <code>toAdd</code> object.
     *
     * @param toAdd the object to add to the associated objects, not null.
     *
     * @throws TorqueException if retrieval of the associated objects fails.
     * @throws NullPointerException if toAdd is null.
     */
    public void addTorqueDynamicUserDelegatesRelatedByDelegateeUserId(TorqueDynamicUserDelegates toAdd)
        throws TorqueException
    {
        toAdd.setTorqueDynamicUserRelatedByDelegateeUserId((TorqueDynamicUser) this);
        getTorqueDynamicUserDelegatesRelatedByDelegateeUserIds().add(toAdd);
    }

    /**
     * Method called to associate a TorqueDynamicUserDelegates object to this object
     * through the collTorqueDynamicUserDelegatessRelatedByDelegateeUserId foreign key attribute using connection.
     *
     * @param l TorqueDynamicUserDelegates
     * @throws TorqueException if retrieval of the associated objects fails.
     */
    public void addTorqueDynamicUserDelegatesRelatedByDelegateeUserId(TorqueDynamicUserDelegates l, Connection con) throws TorqueException
    {
        getTorqueDynamicUserDelegatesRelatedByDelegateeUserIds(con).add(l);
        l.setTorqueDynamicUserRelatedByDelegateeUserId((TorqueDynamicUser) this);
    }
    
    /**
     * Method called to reset the cache of TorqueDynamicUserDelegates objects
     * which are related through the collTorqueDynamicUserDelegatessRelatedByDelegateeUserId foreign key attribute.
     */
    public void resetTorqueDynamicUserDelegatesRelatedByDelegateeUserId()
    {
        collTorqueDynamicUserDelegatessRelatedByDelegateeUserId = null;
    }


    /**
     * The criteria used to select the current contents of collTorqueDynamicUserDelegatessRelatedByDelegateeUserId
     */
    private Criteria lastTorqueDynamicUserDelegatesRelatedByDelegateeUserIdCriteria = null;

    /**
     * If this collection has already been initialized, returns
     * the collection. Otherwise returns the results of
     * getTorqueDynamicUserDelegatesRelatedByDelegateeUserIds(new Criteria())
     *
     * @return the collection of associated objects
     * @throws TorqueException
     */
    public List<TorqueDynamicUserDelegates> getTorqueDynamicUserDelegatesRelatedByDelegateeUserIds()
        throws TorqueException
    {
        if (collTorqueDynamicUserDelegatessRelatedByDelegateeUserId == null)
        {
            collTorqueDynamicUserDelegatessRelatedByDelegateeUserId = getTorqueDynamicUserDelegatesRelatedByDelegateeUserIds(new Criteria());
            for (TorqueDynamicUserDelegates torqueDynamicUserDelegates : collTorqueDynamicUserDelegatessRelatedByDelegateeUserId)
            {
                torqueDynamicUserDelegates.setTorqueDynamicUserRelatedByDelegateeUserId((TorqueDynamicUser) this);
            }
        }
        return collTorqueDynamicUserDelegatessRelatedByDelegateeUserId;
    }

    /**
     * If this collection has already been initialized with
     * an identical criteria, it returns the collection.
     * Otherwise if this BaseTorqueDynamicUser has previously
     * been saved, it will retrieve related collTorqueDynamicUserDelegatessRelatedByDelegateeUserId from storage.
     * If this BaseTorqueDynamicUser is new, it will return
     * an empty collection or the current collection, the criteria
     * is ignored on a new object.
     *
     * @throws TorqueException If a problem occurs with the get[criteria] method.     
     */
    public List<TorqueDynamicUserDelegates> getTorqueDynamicUserDelegatesRelatedByDelegateeUserIds(Criteria criteria) throws TorqueException
    {
        if (collTorqueDynamicUserDelegatessRelatedByDelegateeUserId == null)
        {
            if (isNew())
            {
               initTorqueDynamicUserDelegatesRelatedByDelegateeUserIds();
            }
            else
            {
                criteria.and(org.apache.fulcrum.security.torque.om.TorqueDynamicUserDelegatesPeer.DELEGATEE_USER_ID, getEntityId());
                collTorqueDynamicUserDelegatessRelatedByDelegateeUserId = org.apache.fulcrum.security.torque.om.TorqueDynamicUserDelegatesPeer.doSelect(criteria);
                for (TorqueDynamicUserDelegates torqueDynamicUserDelegates : collTorqueDynamicUserDelegatessRelatedByDelegateeUserId)
                {
                    torqueDynamicUserDelegates.setTorqueDynamicUserRelatedByDelegateeUserId((TorqueDynamicUser) this);
                }
            }
        }
        else
        {
            // criteria has no effect for a new object
            if (!isNew())
            {
                // the following code is to determine if a new query is
                // called for.  If the criteria is the same as the last
                // one, just return the collection.
                criteria.and(org.apache.fulcrum.security.torque.om.TorqueDynamicUserDelegatesPeer.DELEGATEE_USER_ID, getEntityId());
                if (lastTorqueDynamicUserDelegatesRelatedByDelegateeUserIdCriteria == null
                        || !lastTorqueDynamicUserDelegatesRelatedByDelegateeUserIdCriteria.equals(criteria))
                {
                    collTorqueDynamicUserDelegatessRelatedByDelegateeUserId = org.apache.fulcrum.security.torque.om.TorqueDynamicUserDelegatesPeer.doSelect(criteria);
                    for (TorqueDynamicUserDelegates torqueDynamicUserDelegates : collTorqueDynamicUserDelegatessRelatedByDelegateeUserId)
                    {
                        torqueDynamicUserDelegates.setTorqueDynamicUserRelatedByDelegateeUserId((TorqueDynamicUser) this);
                    }
                }
            }
        }
        lastTorqueDynamicUserDelegatesRelatedByDelegateeUserIdCriteria = criteria;
        return collTorqueDynamicUserDelegatessRelatedByDelegateeUserId;
    }

    /**
     * If this collection has already been initialized, returns
     * the collection. Otherwise returns the results of
     * getTorqueDynamicUserDelegatesRelatedByDelegateeUserIds(new Criteria(),Connection)
     * This method takes in the Connection also as input so that
     * referenced objects can also be obtained using a Connection
     * that is taken as input
     *
     * @param con the Connection
     * @return List<TorqueDynamicUserDelegates> results of the collection
     * @throws TorqueException If a problem occurs with the get[connection] method.
     */
    public List<TorqueDynamicUserDelegates> getTorqueDynamicUserDelegatesRelatedByDelegateeUserIds(Connection con) throws TorqueException
    {
        if (collTorqueDynamicUserDelegatessRelatedByDelegateeUserId == null)
        {
            collTorqueDynamicUserDelegatessRelatedByDelegateeUserId = getTorqueDynamicUserDelegatesRelatedByDelegateeUserIds(new Criteria(), con);
            for (TorqueDynamicUserDelegates torqueDynamicUserDelegates : collTorqueDynamicUserDelegatessRelatedByDelegateeUserId)
            {
                torqueDynamicUserDelegates.setTorqueDynamicUserRelatedByDelegateeUserId((TorqueDynamicUser) this);
            }
        }
        return collTorqueDynamicUserDelegatessRelatedByDelegateeUserId;
    }

    /**
     * If this collection has already been initialized with
     * an identical criteria, it returns the collection.
     * Otherwise if this BaseTorqueDynamicUser has previously
     * been saved, it will retrieve the related TorqueDynamicUserDelegates Objects
     * from storage.
     * If this BaseTorqueDynamicUser is new, it will return
     * an empty collection or the current collection, the criteria
     * is ignored on a new object.
     * This method takes in the Connection also as input so that
     * referenced objects can also be obtained using a Connection
     * that is taken as input
     *
     * @param con the Connection
     * @return List<TorqueDynamicUserDelegates> results of the collection
     * @throws TorqueException If a problem occurs with the get[connection] method.
     */
    public List<TorqueDynamicUserDelegates> getTorqueDynamicUserDelegatesRelatedByDelegateeUserIds(Criteria criteria, Connection con)
            throws TorqueException
    {
        if (collTorqueDynamicUserDelegatessRelatedByDelegateeUserId == null)
        {
            if (isNew())
            {
               initTorqueDynamicUserDelegatesRelatedByDelegateeUserIds();
            }
            else
            {
                criteria.and(org.apache.fulcrum.security.torque.om.TorqueDynamicUserDelegatesPeer.DELEGATEE_USER_ID, getEntityId());
                collTorqueDynamicUserDelegatessRelatedByDelegateeUserId = org.apache.fulcrum.security.torque.om.TorqueDynamicUserDelegatesPeer.doSelect(criteria, con);
                for (TorqueDynamicUserDelegates torqueDynamicUserDelegates : collTorqueDynamicUserDelegatessRelatedByDelegateeUserId)
                {
                    torqueDynamicUserDelegates.setTorqueDynamicUserRelatedByDelegateeUserId((TorqueDynamicUser) this);
                }
            }
        }
        else
        {
             // criteria has no effect for a new object
            if (!isNew())
            {
                // the following code is to determine if a new query is
                // called for.  If the criteria is the same as the last
                // one, just return the collection.
                criteria.and(org.apache.fulcrum.security.torque.om.TorqueDynamicUserDelegatesPeer.DELEGATEE_USER_ID, getEntityId());
                if (lastTorqueDynamicUserDelegatesRelatedByDelegateeUserIdCriteria == null
                        || !lastTorqueDynamicUserDelegatesRelatedByDelegateeUserIdCriteria.equals(criteria))
                {
                    collTorqueDynamicUserDelegatessRelatedByDelegateeUserId = org.apache.fulcrum.security.torque.om.TorqueDynamicUserDelegatesPeer.doSelect(criteria, con);
                    for (TorqueDynamicUserDelegates torqueDynamicUserDelegates : collTorqueDynamicUserDelegatessRelatedByDelegateeUserId)
                    {
                        torqueDynamicUserDelegates.setTorqueDynamicUserRelatedByDelegateeUserId((TorqueDynamicUser) this);
                    }
                }
            }
        }
        lastTorqueDynamicUserDelegatesRelatedByDelegateeUserIdCriteria = criteria;

        return collTorqueDynamicUserDelegatessRelatedByDelegateeUserId;
    }

    /**
     * If this collection has already been initialized with
     * an identical criteria, it returns the collection.
     * Otherwise if this BaseTorqueDynamicUser is new, it will return
     * an empty collection; or if this thisObjectClassName has previously
     * been saved, it will retrieve the related objects from storage.
     *
     * This method is protected by default in order to keep the public
     * api reasonable.  You can change the access modifier to public
     * by overriding this method in the child class.
     *
     * @return List<TorqueDynamicUserGroup> the collection
     * @param criteria the criteria to use when filling the collection.
     * @throws TorqueException if associated objects are not found
     */
    protected List<TorqueDynamicUserGroup> getTorqueDynamicUserGroupsJoinTorqueDynamicGroup(Criteria criteria) throws TorqueException
    {
        try (TorqueConnection connection = Transaction.begin(criteria.getDbName()))
        {
            List<TorqueDynamicUserGroup> result = getTorqueDynamicUserGroupsJoinTorqueDynamicGroup(criteria, connection);

            Transaction.commit(connection);
            return result;
        }
    }

    /**
     * If this collection has already been initialized with
     * an identical criteria, it returns the collection.
     * Otherwise if this BaseTorqueDynamicUser is new, it will return
     * an empty collection; or if this BaseTorqueDynamicUser has previously
     * been saved, it will retrieve the related objects from storage.
     *
     * This method is protected by default in order to keep the public
     * api reasonable.  You can change the access modifier to public
     * by overriding this method in the child class.
     */
    protected List<TorqueDynamicUserGroup> getTorqueDynamicUserGroupsJoinTorqueDynamicGroup(Criteria criteria, Connection connection)
        throws TorqueException
    {
        if (collTorqueDynamicUserGroups == null)
        {
            if (isNew())
            {
                initTorqueDynamicUserGroups();
            }
            else
            {
                criteria.and(org.apache.fulcrum.security.torque.om.TorqueDynamicUserGroupPeer.USER_ID, getEntityId());
                collTorqueDynamicUserGroups = org.apache.fulcrum.security.torque.om.TorqueDynamicUserGroupPeer.doSelectJoinTorqueDynamicGroup(criteria, connection);
                for (TorqueDynamicUserGroup torqueDynamicUserGroup : collTorqueDynamicUserGroups)
                {
                    torqueDynamicUserGroup.setTorqueDynamicUser((TorqueDynamicUser) this);
                }
            }
        }
        else
        {
            // the following code is to determine if a new query is
            // called for.  If the criteria is the same as the last
            // one, just return the collection.
            criteria.and(org.apache.fulcrum.security.torque.om.TorqueDynamicUserGroupPeer.USER_ID, getEntityId());
            if (lastTorqueDynamicUserGroupCriteria == null
                        || !lastTorqueDynamicUserGroupCriteria.equals(criteria))
            {
                collTorqueDynamicUserGroups = org.apache.fulcrum.security.torque.om.TorqueDynamicUserGroupPeer.doSelectJoinTorqueDynamicGroup(criteria, connection);
                for (TorqueDynamicUserGroup torqueDynamicUserGroup : collTorqueDynamicUserGroups)
                {
                    torqueDynamicUserGroup.setTorqueDynamicUser((TorqueDynamicUser) this);
                }
            }
        }
        lastTorqueDynamicUserGroupCriteria = criteria;

        return collTorqueDynamicUserGroups;
    }

    /**
     * If this collection has already been initialized with
     * an identical criteria, it returns the collection.
     * Otherwise if this BaseTorqueDynamicUser is new, it will return
     * an empty collection; or if this thisObjectClassName has previously
     * been saved, it will retrieve the related objects from storage.
     *
     * This method is protected by default in order to keep the public
     * api reasonable.  You can change the access modifier to public
     * by overriding this method in the child class.
     *
     * @return List<TorqueDynamicUserDelegates> the collection
     * @param criteria the criteria to use when filling the collection.
     * @throws TorqueException if associated objects are not found
     */
    protected List<TorqueDynamicUserDelegates> getTorqueDynamicUserDelegatesRelatedByDelegatorUserIdsJoinTorqueDynamicUserRelatedByDelegateeUserId(Criteria criteria) throws TorqueException
    {
        try (TorqueConnection connection = Transaction.begin(criteria.getDbName()))
        {
            List<TorqueDynamicUserDelegates> result = getTorqueDynamicUserDelegatesRelatedByDelegatorUserIdsJoinTorqueDynamicUserRelatedByDelegateeUserId(criteria, connection);

            Transaction.commit(connection);
            return result;
        }
    }

    /**
     * If this collection has already been initialized with
     * an identical criteria, it returns the collection.
     * Otherwise if this BaseTorqueDynamicUser is new, it will return
     * an empty collection; or if this BaseTorqueDynamicUser has previously
     * been saved, it will retrieve the related objects from storage.
     *
     * This method is protected by default in order to keep the public
     * api reasonable.  You can change the access modifier to public
     * by overriding this method in the child class.
     */
    protected List<TorqueDynamicUserDelegates> getTorqueDynamicUserDelegatesRelatedByDelegatorUserIdsJoinTorqueDynamicUserRelatedByDelegateeUserId(Criteria criteria, Connection connection)
        throws TorqueException
    {
        if (collTorqueDynamicUserDelegatessRelatedByDelegatorUserId == null)
        {
            if (isNew())
            {
                initTorqueDynamicUserDelegatesRelatedByDelegatorUserIds();
            }
            else
            {
                criteria.and(org.apache.fulcrum.security.torque.om.TorqueDynamicUserDelegatesPeer.DELEGATOR_USER_ID, getEntityId());
                collTorqueDynamicUserDelegatessRelatedByDelegatorUserId = org.apache.fulcrum.security.torque.om.TorqueDynamicUserDelegatesPeer.doSelectJoinTorqueDynamicUserRelatedByDelegateeUserId(criteria, connection);
                for (TorqueDynamicUserDelegates torqueDynamicUserDelegates : collTorqueDynamicUserDelegatessRelatedByDelegatorUserId)
                {
                    torqueDynamicUserDelegates.setTorqueDynamicUserRelatedByDelegatorUserId((TorqueDynamicUser) this);
                }
            }
        }
        else
        {
            // the following code is to determine if a new query is
            // called for.  If the criteria is the same as the last
            // one, just return the collection.
            criteria.and(org.apache.fulcrum.security.torque.om.TorqueDynamicUserDelegatesPeer.DELEGATOR_USER_ID, getEntityId());
            if (lastTorqueDynamicUserDelegatesRelatedByDelegatorUserIdCriteria == null
                        || !lastTorqueDynamicUserDelegatesRelatedByDelegatorUserIdCriteria.equals(criteria))
            {
                collTorqueDynamicUserDelegatessRelatedByDelegatorUserId = org.apache.fulcrum.security.torque.om.TorqueDynamicUserDelegatesPeer.doSelectJoinTorqueDynamicUserRelatedByDelegateeUserId(criteria, connection);
                for (TorqueDynamicUserDelegates torqueDynamicUserDelegates : collTorqueDynamicUserDelegatessRelatedByDelegatorUserId)
                {
                    torqueDynamicUserDelegates.setTorqueDynamicUserRelatedByDelegatorUserId((TorqueDynamicUser) this);
                }
            }
        }
        lastTorqueDynamicUserDelegatesRelatedByDelegatorUserIdCriteria = criteria;

        return collTorqueDynamicUserDelegatessRelatedByDelegatorUserId;
    }

    /**
     * If this collection has already been initialized with
     * an identical criteria, it returns the collection.
     * Otherwise if this BaseTorqueDynamicUser is new, it will return
     * an empty collection; or if this thisObjectClassName has previously
     * been saved, it will retrieve the related objects from storage.
     *
     * This method is protected by default in order to keep the public
     * api reasonable.  You can change the access modifier to public
     * by overriding this method in the child class.
     *
     * @return List<TorqueDynamicUserDelegates> the collection
     * @param criteria the criteria to use when filling the collection.
     * @throws TorqueException if associated objects are not found
     */
    protected List<TorqueDynamicUserDelegates> getTorqueDynamicUserDelegatesRelatedByDelegateeUserIdsJoinTorqueDynamicUserRelatedByDelegatorUserId(Criteria criteria) throws TorqueException
    {
        try (TorqueConnection connection = Transaction.begin(criteria.getDbName()))
        {
            List<TorqueDynamicUserDelegates> result = getTorqueDynamicUserDelegatesRelatedByDelegateeUserIdsJoinTorqueDynamicUserRelatedByDelegatorUserId(criteria, connection);

            Transaction.commit(connection);
            return result;
        }
    }

    /**
     * If this collection has already been initialized with
     * an identical criteria, it returns the collection.
     * Otherwise if this BaseTorqueDynamicUser is new, it will return
     * an empty collection; or if this BaseTorqueDynamicUser has previously
     * been saved, it will retrieve the related objects from storage.
     *
     * This method is protected by default in order to keep the public
     * api reasonable.  You can change the access modifier to public
     * by overriding this method in the child class.
     */
    protected List<TorqueDynamicUserDelegates> getTorqueDynamicUserDelegatesRelatedByDelegateeUserIdsJoinTorqueDynamicUserRelatedByDelegatorUserId(Criteria criteria, Connection connection)
        throws TorqueException
    {
        if (collTorqueDynamicUserDelegatessRelatedByDelegateeUserId == null)
        {
            if (isNew())
            {
                initTorqueDynamicUserDelegatesRelatedByDelegateeUserIds();
            }
            else
            {
                criteria.and(org.apache.fulcrum.security.torque.om.TorqueDynamicUserDelegatesPeer.DELEGATEE_USER_ID, getEntityId());
                collTorqueDynamicUserDelegatessRelatedByDelegateeUserId = org.apache.fulcrum.security.torque.om.TorqueDynamicUserDelegatesPeer.doSelectJoinTorqueDynamicUserRelatedByDelegatorUserId(criteria, connection);
                for (TorqueDynamicUserDelegates torqueDynamicUserDelegates : collTorqueDynamicUserDelegatessRelatedByDelegateeUserId)
                {
                    torqueDynamicUserDelegates.setTorqueDynamicUserRelatedByDelegateeUserId((TorqueDynamicUser) this);
                }
            }
        }
        else
        {
            // the following code is to determine if a new query is
            // called for.  If the criteria is the same as the last
            // one, just return the collection.
            criteria.and(org.apache.fulcrum.security.torque.om.TorqueDynamicUserDelegatesPeer.DELEGATEE_USER_ID, getEntityId());
            if (lastTorqueDynamicUserDelegatesRelatedByDelegateeUserIdCriteria == null
                        || !lastTorqueDynamicUserDelegatesRelatedByDelegateeUserIdCriteria.equals(criteria))
            {
                collTorqueDynamicUserDelegatessRelatedByDelegateeUserId = org.apache.fulcrum.security.torque.om.TorqueDynamicUserDelegatesPeer.doSelectJoinTorqueDynamicUserRelatedByDelegatorUserId(criteria, connection);
                for (TorqueDynamicUserDelegates torqueDynamicUserDelegates : collTorqueDynamicUserDelegatessRelatedByDelegateeUserId)
                {
                    torqueDynamicUserDelegates.setTorqueDynamicUserRelatedByDelegateeUserId((TorqueDynamicUser) this);
                }
            }
        }
        lastTorqueDynamicUserDelegatesRelatedByDelegateeUserIdCriteria = criteria;

        return collTorqueDynamicUserDelegatessRelatedByDelegateeUserId;
    }





    /**
     * Stores an object in the database.  If the object is new,
     * it is inserted; otherwise an update is performed.
     *
     * @throws TorqueException if an error occurs during saving.
     */
    public void save() throws TorqueException
    {
        save(TorqueDynamicUserPeer.DATABASE_NAME);
    }

    /**
     * Stores an object in the database.  If the object is new,
     * it is inserted; otherwise an update is performed.
     *
     * @param dbName the name of the database to which the object
     *        should be saved.
     *
     * @throws TorqueException if an error occurs during saving.
     */
    public void save(String dbName) 
            throws TorqueException
    {
        try (TorqueConnection con = Transaction.begin(dbName))
        {
            save(con);
            Transaction.commit(con);
        }
    }

    /**
     * Stores an object in the database.  If the object is new,
     * it is inserted; otherwise an update is performed.  This method
     * is meant to be used as part of a transaction, otherwise use
     * the save() method and the connection details will be handled
     * internally.
     *
     * @param con the connection to use for saving the object, not null.
     *
     * @throws TorqueException if an error occurs during saving.
     */
    public void save(Connection con) 
            throws TorqueException
    {
        if (isSaving())
        {
            return;
        }
        try
        {
            setSaving(true);
            // If this object has been modified, then save it to the database.
            if (isModified())
            {
                if (isNew())
                {
                    TorqueDynamicUserPeer.doInsert((TorqueDynamicUser) this, con);
                    setNew(false);
                }
                else
                {
                    TorqueDynamicUserPeer.doUpdate((TorqueDynamicUser) this, con);
                }
            }

            if (isTorqueDynamicUserGroupsInitialized())
            {
                for (TorqueDynamicUserGroup collTorqueDynamicUserGroups : getTorqueDynamicUserGroups())
                {
                    collTorqueDynamicUserGroups.save(con);
                }
            }
            if (isTorqueDynamicUserDelegatesRelatedByDelegatorUserIdsInitialized())
            {
                for (TorqueDynamicUserDelegates collTorqueDynamicUserDelegatessRelatedByDelegatorUserId : getTorqueDynamicUserDelegatesRelatedByDelegatorUserIds())
                {
                    collTorqueDynamicUserDelegatessRelatedByDelegatorUserId.save(con);
                }
            }
            if (isTorqueDynamicUserDelegatesRelatedByDelegateeUserIdsInitialized())
            {
                for (TorqueDynamicUserDelegates collTorqueDynamicUserDelegatessRelatedByDelegateeUserId : getTorqueDynamicUserDelegatesRelatedByDelegateeUserIds())
                {
                    collTorqueDynamicUserDelegatessRelatedByDelegateeUserId.save(con);
                }
            }
        }
        finally
        {
            setSaving(false);
        }
    }




    /**
     * Set the PrimaryKey using ObjectKey.
     *
     * @param key entityId ObjectKey
     */
    public void setPrimaryKey(ObjectKey<?> key)
        
    {
        setEntityId(Integer.valueOf(((NumberKey) key).intValue()));
    }

    /**
     * Set the PrimaryKey using a String.
     *
     * @param key the primary key to set.
     */
    public void setPrimaryKey(String key) 
    {
        setEntityId(new Integer(key));
    }


    /**
     * returns an id that differentiates this object from others
     * of its class.
     */
    public ObjectKey<?> getPrimaryKey()
    {
        return SimpleKey.keyFor(getEntityId());
    }



    /**
     * Makes a copy of this object.
     * It creates a new object filling in the simple attributes.
     * It then fills all the association collections and sets the
     * related objects to isNew=true.
     * @throws TorqueException if retrieval of the associated objects fails  
     */
    public TorqueDynamicUser copy() throws TorqueException
    {
        return copy(true);
    }

    /**
     * Makes a copy of this object using a connection.
     * It creates a new object filling in the simple attributes.
     * It then fills all the association collections and sets the
     * related objects to isNew=true.
     *
     * @param con the database connection to read associated objects.
     * @throws TorqueException if retrieval of the associated objects fails     
     */
    public TorqueDynamicUser copy(Connection con) throws TorqueException
    {
        return copy(true, con);
    }

    /**
     * Makes a copy of this object.
     * It creates a new object filling in the simple attributes.
     * If the parameter deepcopy is true, it then fills all the
     * association collections and sets the related objects to
     * isNew=true.
     *
     * @param deepcopy whether to copy the associated objects.
     * @throws TorqueException if retrieval of the associated objects fails
     */
    public TorqueDynamicUser copy(boolean deepcopy) throws TorqueException
    {
        TorqueDynamicUser torqueDynamicUser = new TorqueDynamicUser();

        return copyInto(torqueDynamicUser, deepcopy);
    }

    /**
     * Makes a copy of this object using connection.
     * It creates a new object filling in the simple attributes.
     * If the parameter deepcopy is true, it then fills all the
     * association collections and sets the related objects to
     * isNew=true.
     *
     * @param deepcopy whether to copy the associated objects.
     * @param con the database connection to read associated objects.
     * @throws TorqueException if retrieval of the associated objects fails
     */
    public TorqueDynamicUser copy(boolean deepcopy, Connection con) throws TorqueException
    {
        TorqueDynamicUser torqueDynamicUser = new TorqueDynamicUser();

        return copyInto(torqueDynamicUser, deepcopy, con);
    }
  
    /**
     * Fills the copyObj with the contents of this object.
     * The associated objects are also copied and treated as new objects.
     *
     * @param copyObj the object to fill.
     * @throws TorqueException if retrieval of the associated objects fails
     */
    public TorqueDynamicUser copyInto(TorqueDynamicUser copyObj) throws TorqueException
    {
        return copyInto(copyObj, true);
    }

    /**
     * Fills the copyObj with the contents of this object using connection.
     * The associated objects are also copied and treated as new objects.
     *
     * @param copyObj the object to fill.
     * @param con the database connection to read associated objects.
     * @throws TorqueException if retrieval of the associated objects fails
     */
    public TorqueDynamicUser copyInto(TorqueDynamicUser copyObj, Connection con) throws TorqueException
    {
        return copyInto(copyObj, true, con);
    }
  
    /**
     * Fills the copyObj with the contents of this object.
     * If deepcopy is true, The associated objects are also copied
     * and treated as new objects.
     *
     * @param copyObj the object to fill.
     * @param deepcopy whether the associated objects should be copied.
     * @throws TorqueException if retrieval of the associated objects fails
     */
    protected TorqueDynamicUser copyInto(TorqueDynamicUser copyObj, boolean deepcopy) throws TorqueException
    {
        copyObj.setEntityId((Integer) null);
        copyObj.setEntityName(entityName);
        copyObj.setPassword(password);

        if (deepcopy)
        {
            if (collTorqueDynamicUserGroups != null)
            {
                for (TorqueDynamicUserGroup obj : collTorqueDynamicUserGroups)
                {
                    copyObj.addTorqueDynamicUserGroup(obj.copy());
                }
            }
            else
            {
                copyObj.collTorqueDynamicUserGroups = null;
            }
            if (collTorqueDynamicUserDelegatessRelatedByDelegatorUserId != null)
            {
                for (TorqueDynamicUserDelegates obj : collTorqueDynamicUserDelegatessRelatedByDelegatorUserId)
                {
                    copyObj.addTorqueDynamicUserDelegatesRelatedByDelegatorUserId(obj.copy());
                }
            }
            else
            {
                copyObj.collTorqueDynamicUserDelegatessRelatedByDelegatorUserId = null;
            }
            if (collTorqueDynamicUserDelegatessRelatedByDelegateeUserId != null)
            {
                for (TorqueDynamicUserDelegates obj : collTorqueDynamicUserDelegatessRelatedByDelegateeUserId)
                {
                    copyObj.addTorqueDynamicUserDelegatesRelatedByDelegateeUserId(obj.copy());
                }
            }
            else
            {
                copyObj.collTorqueDynamicUserDelegatessRelatedByDelegateeUserId = null;
            }
        }
        return copyObj;
    }
        
    
    /**
     * Fills the copyObj with the contents of this object using connection.
     * If deepcopy is true, The associated objects are also copied
     * and treated as new objects.
     *
     * @param copyObj the object to fill.
     * @param deepcopy whether the associated objects should be copied.
     * @param con the database connection to read associated objects.
     * @throws TorqueException if retrieval of the associated objects fails
     */
    public TorqueDynamicUser copyInto(TorqueDynamicUser copyObj, boolean deepcopy, Connection con) throws TorqueException
    {
        copyObj.setEntityId((Integer) null);
        copyObj.setEntityName(entityName);
        copyObj.setPassword(password);

        if (deepcopy)
        {
            for (TorqueDynamicUserGroup obj : getTorqueDynamicUserGroups(con))
            {
                copyObj.addTorqueDynamicUserGroup(obj.copy());
            }
            for (TorqueDynamicUserDelegates obj : getTorqueDynamicUserDelegatesRelatedByDelegatorUserIds(con))
            {
                copyObj.addTorqueDynamicUserDelegatesRelatedByDelegatorUserId(obj.copy());
            }
            for (TorqueDynamicUserDelegates obj : getTorqueDynamicUserDelegatesRelatedByDelegateeUserIds(con))
            {
                copyObj.addTorqueDynamicUserDelegatesRelatedByDelegateeUserId(obj.copy());
            }
        }
        return copyObj;
    }

    /** The Peer class */
    private static final org.apache.fulcrum.security.torque.om.TorqueDynamicUserPeer peer
            = new org.apache.fulcrum.security.torque.om.TorqueDynamicUserPeer();

    /**
     * returns a peer instance associated with this om.  Since Peer classes
     * are not to have any instance attributes, this method returns the
     * same instance for all member of this class. The method could therefore
     * be static, but this would prevent one from overriding the behavior.
     */
    public org.apache.fulcrum.security.torque.om.TorqueDynamicUserPeer getPeer()
    {
        return peer;
    }

    /**
     * Retrieves the TableMap object related to this Table data without
     * compiler warnings of using getPeer().getTableMap().
     *
     * @return The associated TableMap object.
     * @throws TorqueException if associated objects are not found
     */
    public TableMap getTableMap() throws TorqueException
    {
        return org.apache.fulcrum.security.torque.om.TorqueDynamicUserPeer.getTableMap();
    }



    public String toString()
    {
        StringBuffer str = new StringBuffer();
        str.append("TorqueDynamicUser:\n");
        str.append("entityId = ")
           .append(getEntityId())
           .append("\n");
        str.append("entityName = ")
           .append(getEntityName())
           .append("\n");
        str.append("password = ")
           .append(getPassword())
           .append("\n");
        return(str.toString());
    }

    /**
     * Compares the primary key of this instance with the key of another.
     *
     * @param toCompare The object to compare to.
     * @return Whether the primary keys are equal and the object have the
     *         same class.
     */
    public boolean equals(Object toCompare)
    {
        if (toCompare == null)
        {
            return false;
        }
        if (this == toCompare)
        {
            return true;
        }
        if (!getClass().equals(toCompare.getClass()))
        {
            return false;
        }
        TorqueDynamicUser other = (TorqueDynamicUser) toCompare;
        if (getPrimaryKey() == null || other.getPrimaryKey() == null)
        {
            return false;
        }
        return getPrimaryKey().equals(other.getPrimaryKey());
    }

    /**
     * If the primary key is not <code>null</code>, return the hashcode of the
     * primary key.  Otherwise calls <code>Object.hashCode()</code>.
     *
     * @return an <code>int</code> value
     */
    public int hashCode()
    {
        ObjectKey<?> ok = getPrimaryKey();
        if (ok == null)
        {
            return super.hashCode();
        }

        return ok.hashCode();
    }



    /**
     * Compares the content of this object to another object
     *
     * @param toCompare The object to compare to.
     * @return true if all of the columns in the other object have 
     *         the same value as the objects in this class.
     */
    public boolean valueEquals(TorqueDynamicUser toCompare)
    {
        if (toCompare == null)
        {
            return false;
        }
        if (this == toCompare)
        {
            return true;
        }
        if (!Objects.equals(this.entityId, toCompare.getEntityId()))
        {
            return false;
        }
        if (!Objects.equals(this.entityName, toCompare.getEntityName()))
        {
            return false;
        }
        if (!Objects.equals(this.password, toCompare.getPassword()))
        {
            return false;
        }
        return true;
    }



}
