package org.apache.fulcrum.security.torque.om;

import java.sql.Connection;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;

import org.apache.torque.NoRowsException;
import org.apache.torque.TooManyRowsException;
import org.apache.torque.Column;
import org.apache.torque.Torque;
import org.apache.torque.TorqueException;
import org.apache.torque.adapter.IDMethod;
import org.apache.torque.criteria.Criteria;
import org.apache.torque.map.DatabaseMap;
import org.apache.torque.map.TableMap;
import org.apache.torque.map.ColumnMap;
import org.apache.torque.om.mapper.RecordMapper;
import org.apache.torque.om.ObjectKey;
import org.apache.torque.util.ColumnValues;
import org.apache.torque.util.JdbcTypedValue;



/**
 * The skeleton for this class was autogenerated by Torque on:
 *
 * [Fri Nov 03 10:19:39 CET 2023]
 *
 * You should not use this class directly.  It should not even be
 * extended; all references should be to TorqueDynamicPermissionPeer
 */

@SuppressWarnings("unused")
public abstract class BaseTorqueDynamicPermissionPeer
{
    /** The default database name for this class. */
    public static final String DATABASE_NAME;

     /** The table name for this class. */
    public static final String TABLE_NAME;

     /** The table map for this class. */
    public static final TableMap TABLE;
    /** The column for the PERMISSION_ID field */
    public static final ColumnMap PERMISSION_ID;
    /** The column for the PERMISSION_NAME field */
    public static final ColumnMap PERMISSION_NAME;

    /** number of columns for this peer */
    public static final int numColumns = 2;


    /** The implementation of the peer. */
    private static TorqueDynamicPermissionPeerImpl torqueDynamicPermissionPeerImpl;


    static
    {
        DatabaseMap dbMap = Torque.getOrCreateDatabase("fulcrum")
                .getDatabaseMap();
        if (dbMap.getTable("FULCRUM_DYNAMIC_PERMISSION") == null)
        {
            dbMap.addTable("FULCRUM_DYNAMIC_PERMISSION");
        }
        DATABASE_NAME = "fulcrum";
        TABLE_NAME = "FULCRUM_DYNAMIC_PERMISSION";

        TABLE = dbMap.getTable("FULCRUM_DYNAMIC_PERMISSION");
        TABLE.setJavaName("TorqueDynamicPermission");
        TABLE.setOMClass(org.apache.fulcrum.security.torque.om.TorqueDynamicPermission.class);
        TABLE.setPeerClass(org.apache.fulcrum.security.torque.om.TorqueDynamicPermissionPeer.class);
        TABLE.setPrimaryKeyMethod(IDMethod.ID_BROKER);
        TABLE.setPrimaryKeyMethodInfo(IDMethod.ID_BROKER, TABLE.getName());
        TABLE.setPrimaryKeyMethodInfo(IDMethod.SEQUENCE, "$sequenceName");
        TABLE.setPrimaryKeyMethodInfo(IDMethod.AUTO_INCREMENT, "FULCRUM_DYNAMIC_PERMISSION");
        TABLE.setUseInheritance(true);


    // ------------- Column: PERMISSION_ID --------------------
        PERMISSION_ID = new ColumnMap("PERMISSION_ID", TABLE);
        PERMISSION_ID.setType(Integer.valueOf(0));
        PERMISSION_ID.setTorqueType("INTEGER");
        PERMISSION_ID.setUsePrimitive(false);
        PERMISSION_ID.setPrimaryKey(true);
        PERMISSION_ID.setNotNull(true);
        PERMISSION_ID.setJavaName("EntityId");
        PERMISSION_ID.setAutoIncrement(true);
        PERMISSION_ID.setProtected(false);
        PERMISSION_ID.setJavaType( "Integer" );
        PERMISSION_ID.setPosition(1);
        TABLE.addColumn(PERMISSION_ID);
    // ------------- Column: PERMISSION_NAME --------------------
        PERMISSION_NAME = new ColumnMap("PERMISSION_NAME", TABLE);
        PERMISSION_NAME.setType("");
        PERMISSION_NAME.setTorqueType("VARCHAR");
        PERMISSION_NAME.setUsePrimitive(false);
        PERMISSION_NAME.setPrimaryKey(false);
        PERMISSION_NAME.setNotNull(true);
        PERMISSION_NAME.setJavaName("EntityName");
        PERMISSION_NAME.setAutoIncrement(true);
        PERMISSION_NAME.setProtected(false);
        PERMISSION_NAME.setJavaType( "String" );
        PERMISSION_NAME.setSize(64);
        PERMISSION_NAME.setPosition(2);
        TABLE.addColumn(PERMISSION_NAME);



        initDatabaseMap();
    }

    /**
     * Creates a new instance of the  implementation of the peer.
     *
     * @return the new instance.
     */
    protected static TorqueDynamicPermissionPeerImpl createTorqueDynamicPermissionPeerImpl()
    {
        TorqueDynamicPermissionPeerImpl instance = new TorqueDynamicPermissionPeerImpl();
        return instance;
    }


    /**
     * Returns an instance of the implementation of the peer.
     * If no instance is currently cached, a new instance is created and cached.
     *
     * @return an instance of the implementation of the peer, not null.
     */
    public static TorqueDynamicPermissionPeerImpl getTorqueDynamicPermissionPeerImpl()
    {
        TorqueDynamicPermissionPeerImpl peerImplInstance = torqueDynamicPermissionPeerImpl;
        if (peerImplInstance == null)
        {
            peerImplInstance = TorqueDynamicPermissionPeer.createTorqueDynamicPermissionPeerImpl();
            torqueDynamicPermissionPeerImpl = peerImplInstance;
            Torque.registerPeerInstance(TorqueDynamicPermission.class, peerImplInstance);
        }
        return peerImplInstance;
    }



    /**
     * Sets the instance of the implementation of the peer.
     *
     * @param peerImplInstance an instance of the implementation of the peer, or null
     *        if a new instance should be created automatically.
     */
    public static void setTorqueDynamicPermissionPeerImpl(TorqueDynamicPermissionPeerImpl peerImplInstance)
    {
        torqueDynamicPermissionPeerImpl = peerImplInstance;
    }


    /**
     * Add all the columns needed to create a new object.
     *
     * @param criteria object containing the columns to add.
     */
    public static void addSelectColumns(Criteria criteria)
    {
        getTorqueDynamicPermissionPeerImpl().addSelectColumns(criteria);
    }

    /**
     * changes the boolean values in the criteria to the appropriate type,
     * whenever a booleanchar or booleanint column is involved.
     * This enables the user to create criteria using Boolean values
     * for booleanchar or booleanint columns.
     *
     * @param criteria the criteria in which the boolean values
     *        should be corrected.
     *
     * @throws TorqueException if the database map for the criteria cannot be 
               obtained.
     */
    public static void correctBooleans(Criteria criteria) throws TorqueException
    {
        getTorqueDynamicPermissionPeerImpl().correctBooleans(criteria);
    }

    /**
     * Checks all columns in the criteria to see whether
     * booleanchar and booleanint columns are queried with a boolean.
     * If yes, the query values are mapped onto values the database
     * does understand, i.e. 0 and 1 for booleanints and N and Y for
     * booleanchar columns.
     *
     * @param columnValues The value to be checked for booleanint
     *        and booleanchar columns.
     * @throws TorqueException if the database map for the criteria cannot be
     *         retrieved.
     */
    public static void correctBooleans(
            ColumnValues columnValues)
        throws TorqueException
    {
        getTorqueDynamicPermissionPeerImpl().correctBooleans(columnValues);
    }
    
    /**
     * Selects TorqueDynamicPermission objects from a database.
     *
     * @param criteria object used to create the SELECT statement.
     *
     * @return the list of selected objects, not null.
     *
     * @throws TorqueException Any exceptions caught during processing will be
     *         rethrown wrapped into a TorqueException.
     */
    public static List<TorqueDynamicPermission> doSelect(Criteria criteria)
            throws TorqueException
    {
        return getTorqueDynamicPermissionPeerImpl().doSelect(criteria);
    }

    /**
     * Selects TorqueDynamicPermission objects from a database
     * within a transaction.
     *
     * @param criteria object used to create the SELECT statement.
     * @param connection the connection holding the transaction, not null.
     *
     * @return The list of selected objects, not null.
     *
     * @throws TorqueException Any exceptions caught during processing will be
     *         rethrown wrapped into a TorqueException.
     */
    public static List<TorqueDynamicPermission> doSelect(
                Criteria criteria,
                Connection connection)
            throws TorqueException
    {
        return getTorqueDynamicPermissionPeerImpl().doSelect(criteria, connection);
    }

    /**
     * Selects TorqueDynamicPermission objects from a database
     * within a transaction.
     *
     * This method returns a stream that <b>must</b> be closed after use.
     * All resources used by this method will be closed when the stream is
     * closed.
     *
     * @param criteria object used to create the SELECT statement.
     * @param connection the connection holding the transaction, not null.
     *
     * @return The results of the query as a Stream, not null.
     *
     * @throws TorqueException Any exceptions caught during processing will be
     *         rethrown wrapped into a TorqueException.
     */
    public static Stream<TorqueDynamicPermission> doSelectAsStream(
                Criteria criteria,
                Connection connection)
            throws TorqueException
    {
        return getTorqueDynamicPermissionPeerImpl().doSelectAsStream(criteria, connection);
    }

    /**
     * Selects rows from a database an maps them to objects.
     *
     * @param criteria A Criteria specifying the records to select, not null.
     * @param mapper The mapper creating the objects from the resultSet,
     *        not null.
     *
     * @return The results of the query, not null.
     *
     * @throws TorqueException if querying the database fails.
     */
    public static <T> List<T> doSelect(
                Criteria criteria,
                RecordMapper<T> mapper)
            throws TorqueException
    {
        return getTorqueDynamicPermissionPeerImpl().doSelect(criteria, mapper);
    }

    /**
     * Selects rows from a database an maps them to objects.
     *
     * @param criteria A Criteria specifying the records to select, not null.
     * @param mapper The mapper creating the objects from the resultSet,
     *        not null.
     * @param connection the database connection for selecting records,
     *        not null.
     *
     * @return The results of the query, not null.
     *
     * @throws TorqueException Error performing database query.
     */
    public static <T> List<T> doSelect(
            Criteria criteria,
            RecordMapper<T> mapper,
            Connection connection)
        throws TorqueException
    {
        return getTorqueDynamicPermissionPeerImpl().doSelect(
                criteria,
                mapper,
                connection);
    }

    /**
     * Selects rows from a database an maps them to objects.
     *
     * This method returns a stream that <b>must</b> be closed after use.
     * All resources used by this method will be closed when the stream is
     * closed.
     *
     * @param criteria A Criteria specifying the records to select, not null.
     * @param mapper The mapper creating the objects from the resultSet,
     *        not null.
     * @param connection the database connection for selecting records,
     *        not null.
     *
     * @return The results of the query as a Stream, not null.
     *
     * @throws TorqueException Error performing database query.
     */
    public static <T> Stream<T> doSelectAsStream(
            Criteria criteria,
            RecordMapper<T> mapper,
            Connection connection)
        throws TorqueException
    {
        return getTorqueDynamicPermissionPeerImpl().doSelectAsStream(
                criteria,
                mapper,
                connection);
    }

    /**
     * Selects rows from a database an maps them to objects.
     *
     * @param query the sql query to execute, not null.
     * @param mapper The mapper creating the objects from the resultSet,
     *        not null.
     * @param dbName The name of the database to create the connection for,
     *        or null for the default SDB.
     *
     * @return The results of the query, not null.
     *
     * @throws TorqueException if querying the database fails.
     */
    public static <T> List<T> doSelect(
                String query,
                RecordMapper<T> mapper,
                String dbName)
            throws TorqueException
    {
        return getTorqueDynamicPermissionPeerImpl().doSelect(
                query,
                mapper,
                dbName);
    }

    /**
     * Selects rows from a database an maps them to objects.
     *
     * @param query the SQL Query to execute, not null.
     * @param mapper The mapper creating the objects from the resultSet,
     *        not null.
     * @param connection the database connection, not null.
     *
     * @return The results of the query, not null.
     *
     * @throws TorqueException if querying the database fails.
     */
    public static <T> List<T> doSelect(
                String query,
                RecordMapper<T> mapper,
                Connection connection)
            throws TorqueException
    {
        return getTorqueDynamicPermissionPeerImpl().doSelect(
                query,
                mapper,
                connection);
    }

    /**
     * Selects rows from a database an maps them to objects.
     *
     * This method returns a stream that <b>must</b> be closed after use.
     * All resources used by this method will be closed when the stream is
     * closed.
     *
     * @param query the SQL Query to execute, not null.
     * @param mapper The mapper creating the objects from the resultSet,
     *        not null.
     * @param connection the database connection, not null.
     *
     * @return The results of the query as a Stream, not null.
     *
     * @throws TorqueException if querying the database fails.
     */
    public static <T> Stream<T> doSelectAsStream(
                String query,
                RecordMapper<T> mapper,
                Connection connection)
            throws TorqueException
    {
        return getTorqueDynamicPermissionPeerImpl().doSelectAsStream(
                query,
                mapper,
                connection);
    }

    /**
     * Selects TorqueDynamicPermission objects from the database which have
     * the same content as the passed object.
     *
     * @return The list of selected objects, not null.
     *
     * @throws TorqueException Any exceptions caught during processing will be
     *         rethrown wrapped into a TorqueException.
     */
    public static List<TorqueDynamicPermission> doSelect(TorqueDynamicPermission obj)
            throws TorqueException
    {
        return getTorqueDynamicPermissionPeerImpl().doSelect(obj);
    }

    /**
     * Selects at most one TorqueDynamicPermission object from a database.
     *
     * @param criteria object used to create the SELECT statement.
     *
     * @return the selected Object, or null if no object was selected.
     *
     * @throws TorqueException If more than one record is selected or if
     *         an error occurs when processing the query.
     */
    public static TorqueDynamicPermission doSelectSingleRecord(
                Criteria criteria)
            throws TorqueException
    {
        return getTorqueDynamicPermissionPeerImpl().doSelectSingleRecord(criteria);
    }

    /**
     * Selects at most one TorqueDynamicPermission object from a database
     * within a transaction.
     *
     * @param criteria object used to create the SELECT statement.
     * @param connection the connection holding the transaction, not null.
     *
     * @return the selected Object, or null if no object was selected.
     *
     * @throws TorqueException If more than one record is selected or if
     *         an error occurs when processing the query.
     */
    public static TorqueDynamicPermission doSelectSingleRecord(
                Criteria criteria,
                Connection connection)
            throws TorqueException
    {
        return getTorqueDynamicPermissionPeerImpl().doSelectSingleRecord(criteria, connection);
    }

    /**
     * Selects at most a single row from a database an maps them to objects.
     *
     * @param criteria A Criteria specifying the records to select, not null.
     * @param mapper The mapper creating the objects from the resultSet,
     *        not null.
     *
     * @return The selected row, or null if no records was selected.
     *
     * @throws TorqueException if querying the database fails.
     */
    public static <T> T doSelectSingleRecord(
                org.apache.torque.criteria.Criteria criteria,
                RecordMapper<T> mapper)
            throws TorqueException
    {
        return getTorqueDynamicPermissionPeerImpl().doSelectSingleRecord(
                criteria,
                mapper);
    }

    /**
     * Selects at most a single row from a database an maps them to objects.
     *
     * @param criteria A Criteria specifying the records to select, not null.
     * @param mapper The mapper creating the objects from the resultSet,
     *        not null.
     * @param connection the database connection, not null.
     *
     * @return The selected row, or null if no records was selected.
     *
     * @throws TorqueException if querying the database fails.
     */
    public static <T> T doSelectSingleRecord(
                org.apache.torque.criteria.Criteria criteria,
                RecordMapper<T> mapper,
                Connection connection)
            throws TorqueException
    {
        return getTorqueDynamicPermissionPeerImpl().doSelectSingleRecord(
                criteria,
                mapper,
                connection);
    }

    /**
     * Selects at most one TorqueDynamicPermission object from the database
     * which has the same content as the passed object.
     *
     * @return the selected Object, or null if no object was selected.
     *
     * @throws TorqueException If more than one record is selected or if
     *         an error occurs when processing the query.
     */
    public static TorqueDynamicPermission doSelectSingleRecord(
                TorqueDynamicPermission obj)
            throws TorqueException
    {
        return getTorqueDynamicPermissionPeerImpl().doSelectSingleRecord(obj);
    }


    /**
     * Returns a new instance of the Data object class
     */
    public static TorqueDynamicPermission getDbObjectInstance()
    {
        return getTorqueDynamicPermissionPeerImpl().getDbObjectInstance();
    }


    /**
     * Method to do inserts.
     *
     * @param columnValues the values to insert.
     *
     * @return the primary key of the inserted row.
     *
     * @throws TorqueException Any exceptions caught during processing will be
     *         rethrown wrapped into a TorqueException.
     */
    public static ObjectKey<?> doInsert(ColumnValues columnValues) 
            throws TorqueException
    {
        return getTorqueDynamicPermissionPeerImpl().doInsert(columnValues);
    }

    /**
     * Method to do inserts.  This method is to be used during a transaction,
     * otherwise use the doInsert(Criteria) method.
     *
     * @param columnValues the values to insert.
     * @param con the connection to use, not null.
     *
     * @return the primary key of the inserted row.
     *
     * @throws TorqueException Any exceptions caught during processing will be
     *         rethrown wrapped into a TorqueException.
     */
    public static ObjectKey<?> doInsert(ColumnValues columnValues, Connection con)
            throws TorqueException
    {
        return getTorqueDynamicPermissionPeerImpl().doInsert(columnValues, con);
    }
    /**
     * Method to do inserts
     *
     * @throws TorqueException Any exceptions caught during processing will be
     *         rethrown wrapped into a TorqueException.
     */
    public static void doInsert(TorqueDynamicPermission obj)
            throws TorqueException
    {
        getTorqueDynamicPermissionPeerImpl().doInsert(obj);
    }

    /**
     * Method to do inserts.  This method is to be used during a transaction,
     * otherwise use the doInsert(TorqueDynamicPermission) method.  It will take
     * care of the connection details internally.
     *
     * @param obj the data object to insert into the database.
     * @param con the connection to use
     * @throws TorqueException Any exceptions caught during processing will be
     *         rethrown wrapped into a TorqueException.
     */
    public static void doInsert(TorqueDynamicPermission obj, Connection con)
            throws TorqueException
    {
        getTorqueDynamicPermissionPeerImpl().doInsert(obj, con);
    }

    /**
     * Executes a insert into...select statement.
     *
     * @param toInsertInto the columns in which to insert, not null.
     * @param criteria the criteria which selects the values to insert,
     *        not null.
     *
     * @return the number of inserted rows.
     *
     * @throws TorqueException if a database error occurs.
     */
    public static int doInsert(
                final Column[] toInsertInto,
                final Criteria criteria)
            throws TorqueException
    {
        return getTorqueDynamicPermissionPeerImpl().doInsert(toInsertInto, criteria);
    }

    /**
     * Executes a insert into...select statement.
     *
     * @param toInsertInto the columns in which to insert, not null.
     * @param criteria the criteria which selects the values to insert,
     *        not null.
     * @param dbName the database name, or null to take the database name
     *        from getDatabaseName().
     *
     * @return the number of inserted rows.
     *
     * @throws TorqueException if a database error occurs.
     */
    public static int doInsert(
                final Column[] toInsertInto,
                final Criteria criteria,
                final String dbName)
            throws TorqueException
    {
        return getTorqueDynamicPermissionPeerImpl().doInsert(toInsertInto, criteria, dbName);
    }

    /**
     * Executes a insert into...select statement.
     *
     * @param toInsertInto the columns in which to insert, not null.
     * @param criteria the criteria which selects the values to insert,
     *        not null.
     * @param connection the database connection to use, not null.
     *
     * @return the number of inserted rows.
     *
     * @throws TorqueException if a database error occurs.
     */
    public static int doInsert(
                final Column[] toInsertInto,
                final Criteria criteria,
                final Connection connection)
            throws TorqueException
    {
        return getTorqueDynamicPermissionPeerImpl().doInsert(toInsertInto, criteria, connection);
    }

    /**
     * Executes a insert into...select statement.
     *
     * @param toInsertInto the columns in which to insert, not null.
     * @param criteria the criteria which selects the values to insert,
     *        not null.
     * @param dbName the database name, or null to take the database name
     *        from getDatabaseName().
     * @param connection the database connection to use, not null.
     *
     * @return the number of inserted rows.
     *
     * @throws TorqueException if a database error occurs.
     */
    public static int doInsert(
                final Column[] toInsertInto,
                final Criteria criteria,
                String dbName,
                final Connection connection)
            throws TorqueException
    {
        return getTorqueDynamicPermissionPeerImpl().doInsert(
                 toInsertInto,
                 criteria,
                 dbName,
                 connection);
    }

    /**
     * Method to do updates.
     *
     * @param columnValues the values to update plus the primary key
     *        identifying the row to update.
     *
     * @throws TorqueException Any exceptions caught during processing will be
     *         rethrown wrapped into a TorqueException.
     */
    public static int doUpdate(ColumnValues columnValues) throws TorqueException
    {
        return getTorqueDynamicPermissionPeerImpl().doUpdate(columnValues);
    }

    /**
     * Method to do updates.  This method is to be used during a transaction,
     * otherwise use the doUpdate(Criteria) method.  It will take care of
     * the connection details internally.
     *
     * @param columnValues the values to update plus the primary key
     *        identifying the row to update.
     * @param con the connection to use, not null.
     *
     * @return the number of affected rows.
     *
     * @throws TorqueException Any exceptions caught during processing will be
     *         rethrown wrapped into a TorqueException.
     */
    public static int doUpdate(ColumnValues columnValues, Connection con)
        throws TorqueException
    {
        return getTorqueDynamicPermissionPeerImpl().doUpdate(columnValues, con);
    }

    /**
     * Executes an update against the database. The rows to be updated
     * are selected using <code>criteria</code> and updated using the values
     * in <code>updateValues</code>.
     *
     * @param selectCriteria selects which rows of which table should be updated.
     * @param updateValues Which columns to update with which values, not null.
     *
     * @return the number of affected rows.
     *
     * @throws TorqueException if updating fails.
     */
    public static int doUpdate(
                Criteria selectCriteria,
                ColumnValues updateValues)
            throws TorqueException
    {
        return getTorqueDynamicPermissionPeerImpl().doUpdate(
            selectCriteria,
            updateValues);
    }

    /**
     * Executes an update against the database. The rows to be updated
     * are selected using <code>criteria</code> and updated using the values
     * in <code>updateValues</code>.
     *
     * @param criteria selects which rows of which table should be updated.
     * @param updateValues Which columns to update with which values, not null.
     * @param connection the database connection to use, not null.
     *
     * @return the number of affected rows.
     *
     * @throws TorqueException if updating fails.
     */
    public static int doUpdate(
                Criteria criteria,
                ColumnValues updateValues,
                Connection connection)
            throws TorqueException
    {
        return getTorqueDynamicPermissionPeerImpl().doUpdate(
            criteria,
             updateValues,
              connection);
    }

    /**
     * Updates an TorqueDynamicPermission in the database.
     * The primary key is used to identify the object to update.
     *
     * @param obj the data object to update in the database.
     *
     * @return the number of affected rows.
     *
     * @throws TorqueException Any exceptions caught during processing will be
     *         rethrown wrapped into a TorqueException.
     */
    public static int doUpdate(TorqueDynamicPermission obj) throws TorqueException
    {
        return getTorqueDynamicPermissionPeerImpl().doUpdate(obj);
    }

    /**
     * Updates a TorqueDynamicPermission in the database.
     * The primary key is used to identify the object to update.
     * This method is to be used during a transaction,
     * otherwise the doUpdate(TorqueDynamicPermission) method can be used.
     *
     * @param obj the data object to update in the database.
     * @param con the connection to use, not null.
     
     * @throws TorqueException Any exceptions caught during processing will be
     *         rethrown wrapped into a TorqueException.
     */
    public static int doUpdate(TorqueDynamicPermission obj, Connection con)
        throws TorqueException
    {
        return getTorqueDynamicPermissionPeerImpl().doUpdate(obj, con);
    }

    /**
     * Utility method which executes a given sql statement
     * as prepared statement.
     * This method should be used for update, insert, and delete statements.
     * Use executeQuery() for selects.
     *
     * @param statementString A String with the sql statement to execute.
     *
     * @return The number of rows affected.
     *
     * @throws TorqueException if executing the statement fails
     *         or no database connection can be established.
     */
    public static int executeStatement(String statementString) 
            throws TorqueException
    {
        return getTorqueDynamicPermissionPeerImpl().executeStatement(statementString);
    }

    /**
     * Utility method which executes a given sql statement
     * as prepared statement.
     * This method should be used for update, insert, and delete statements.
     * Use executeQuery() for selects.
     *
     * @param statementString A String with the sql statement to execute.
     * @param replacementValues values to use as placeholders in the query.
     *        or null or empty if no placeholders need to be filled.
     *
     * @return The number of rows affected.
     *
     * @throws TorqueException if executing the statement fails
     *         or no database connection can be established.
     */
    public static int executeStatement(
                String statementString,
                List<JdbcTypedValue> replacementValues)
            throws TorqueException
    {
        return getTorqueDynamicPermissionPeerImpl().executeStatement(
                statementString, 
                replacementValues);
    }

    /**
     * Utility method which executes a given sql statement
     * as prepared statement.
     * This method should be used for update, insert, and delete statements.
     * Use executeQuery() for selects.
     *
     * @param statementString A String with the sql statement to execute.
     * @param dbName The name of the database to execute the statement against,
     *        or null for the default DB.
     * @param replacementValues values to use as placeholders in the query.
     *        or null or empty if no placeholders need to be filled.
     *
     * @return The number of rows affected.
     *
     * @throws TorqueException if executing the statement fails
     *         or no database connection can be established.
     */
    public static int executeStatement(
            String statementString,
            String dbName,
            List<JdbcTypedValue> replacementValues)
        throws TorqueException
    {
        return getTorqueDynamicPermissionPeerImpl().executeStatement(
                statementString, 
                dbName,
                replacementValues);
    }

    /**
     * Utility method which executes a given sql statement
     * as prepared statement.
     * This method should be used for update, insert, and delete statements.
     * Use executeQuery() for selects.
     *
     * @param statementString A String with the sql statement to execute.
     * @param con The database connection to use.
     * @param replacementValues values to use as placeholders in the query.
     *        or null or empty if no placeholders need to be filled.
     *
     * @return The number of rows affected.
     *
     * @throws TorqueException if executing the statement fails.
     */
    public static int executeStatement(
            String statementString,
            Connection con,
            List<JdbcTypedValue> replacementValues)
        throws TorqueException
    {
        return getTorqueDynamicPermissionPeerImpl().executeStatement(
                statementString, 
                con,
                replacementValues);
    }

    /**
     * Utility method which executes a given sql statement
     * as prepared statement.
     * This method should be used for update, insert, and delete statements.
     * Use executeQuery() for selects.
     *
     * @param statementString A String with the sql statement to execute,
     *        containing placeholders of the form ":${placeholderName}".
     *        ${placeholderName} must contain only letters, digits and the underscore
     *        Each placeholder must be followed by a space, except when it is at the end of the statement.
     * @param replacementValues a map mapping the placeholder names to values
     *        to use as placeholders in the query.
     *        Can be null or empty if no placeholders need to be filled.
     *
     * @return The number of rows affected.
     *
     * @throws TorqueException if executing the statement fails.
     */
    public static int executeStatement(
            final String statementString,
            final Map<String, JdbcTypedValue> replacementValues)
        throws TorqueException
    {
        return getTorqueDynamicPermissionPeerImpl().executeStatement(
                statementString,
                replacementValues);
    }

    /**
     * Utility method which executes a given sql statement
     * as prepared statement.
     * This method should be used for update, insert, and delete statements.
     * Use executeQuery() for selects.
     *
     * @param statementString A String with the sql statement to execute,
     *        containing placeholders of the form ":${placeholderName}".
     *        ${placeholderName} must contain only letters, digits and the underscore
     *        Each placeholder must be followed by a space, except when it is at the end of the statement.
     * @param dbName The name of the database to execute the statement against,
     *        or null for the default DB.
     * @param replacementValues a map mapping the placeholder names to values
     *        to use as placeholders in the query.
     *        Can be null or empty if no placeholders need to be filled.
     *
     * @return The number of rows affected.
     *
     * @throws TorqueException if executing the statement fails.
     */
    public static int executeStatement(
                final String statementString,
                final String dbName,
                final Map<String, JdbcTypedValue> replacementValues)
            throws TorqueException
        {
        return getTorqueDynamicPermissionPeerImpl().executeStatement(
                statementString,
                dbName,
                replacementValues);
        }

        /**
     * Utility method which executes a given sql statement
     * as prepared statement.
     * This method should be used for update, insert, and delete statements.
     * Use executeQuery() for selects.
     *
     * @param statementString A String with the sql statement to execute,
     *        containing placeholders of the form ":${placeholderName}".
     *        ${placeholderName} must contain only letters, digits and the underscore
     *        Each placeholder must be followed by a space, except when it is at the end of the statement.
     * @param con The database connection to use.
     * @param replacementValues a map mapping the placeholder names (without leading colons)
     *        to values to use as placeholders in the query.
     *        Can be null or empty if no placeholders need to be filled.
     *
     * @return The number of rows affected.
     *
     * @throws TorqueException if executing the statement fails.
     */
    public static int executeStatement(
                final String statementString,
                final Connection con,
                final Map<String, JdbcTypedValue> replacementValues)
            throws TorqueException
    {
        return getTorqueDynamicPermissionPeerImpl().executeStatement(
                statementString,
                con,
                replacementValues);
    }

    
    /**
     * Deletes rows from a database table.
     *
     * @param criteria defines the rows to be deleted, not null.
     *
     * @return the number of deleted rows.
     *
     * @throws TorqueException Any exceptions caught during processing will be
     *         rethrown wrapped into a TorqueException.
     */
     public static int doDelete(Criteria criteria) throws TorqueException
     {
        return getTorqueDynamicPermissionPeerImpl().doDelete(criteria);
     }

    /**
     * Deletes rows from a table.
     * This method uses the passed connection to delete the rows;
     * if a transaction is open in the connection, the deletion happens inside
     * this transaction.
    *
     * @param criteria defines the rows to be deleted, not null.
     * @param con the connection to use, not null.
     *
     * @return the number of deleted rows.
     *
     * @throws TorqueException Any exceptions caught during processing will be
     *         rethrown wrapped into a TorqueException.
     */
     public static int doDelete(Criteria criteria, Connection con)
        throws TorqueException
     {
        return getTorqueDynamicPermissionPeerImpl().doDelete(criteria, con);
     }

    /**
     * Deletes a data object, i.e. a row in a table, in the database.
     *
     * @param obj the data object to delete in the database, not null.
     *
     * @return the number of deleted rows.
     *
     * @throws TorqueException Any exceptions caught during processing will be
     *         rethrown wrapped into a TorqueException.
     */
    public static int doDelete(TorqueDynamicPermission obj) throws TorqueException
    {
        return getTorqueDynamicPermissionPeerImpl().doDelete(obj);
    }

    /**
     * Deletes a data object, i.e. a row in a table, in the database.
     * This method uses the passed connection to delete the rows;
     * if a transaction is open in the connection, the deletion happens inside
     * this transaction.
     *
     * @param obj the data object to delete in the database, not null.
     * @param con the connection to use, not null.
     *
     * @return the number of deleted rows.
     *
     * @throws TorqueException Any exceptions caught during processing will be
     *         rethrown wrapped into a TorqueException.
     */
    public static int doDelete(TorqueDynamicPermission obj, Connection con)
        throws TorqueException
    {
        return getTorqueDynamicPermissionPeerImpl().doDelete(obj, con);
    }

    /**
     * Deletes data objects, i.e. rows in a table, in the database.
     *
     * @param objects the datas object to delete in the database, not null,
     *        may not contain null.
     *
     * @return the number of deleted rows.
     *
     * @throws TorqueException Any exceptions caught during processing will be
     *         rethrown wrapped into a TorqueException.
     */
    public static int doDelete(Collection<TorqueDynamicPermission> objects)
            throws TorqueException
    {
        return getTorqueDynamicPermissionPeerImpl().doDelete(objects);
    }

    /**
     * Deletes data objects, i.e. rows in a table, in the database.
     * This method uses the passed connection to delete the rows;
     * if a transaction is open in the connection, the deletion happens inside
     * this transaction.
     *
     * @param objects the datas object to delete in the database, not null,
     *        may not contain null.
     * @param con the connection to use for deleting, not null.
     *
     * @return the number of deleted rows.
     *
     * @throws TorqueException Any exceptions caught during processing will be
     *         rethrown wrapped into a TorqueException.
     */
    public static int doDelete(
            Collection<TorqueDynamicPermission> objects,
            Connection con)
        throws TorqueException
    {
        return getTorqueDynamicPermissionPeerImpl().doDelete(objects, con);
    }

    /**
     * Deletes a row in the database.
     *
     * @param pk the ObjectKey that identifies the row to delete.
     *
     * @return the number of deleted rows.
     *
     * @throws TorqueException Any exceptions caught during processing will be
     *         rethrown wrapped into a TorqueException.
     */
    public static int doDelete(ObjectKey<?> pk) throws TorqueException
    {
        return getTorqueDynamicPermissionPeerImpl().doDelete(pk);
    }

    /**
     * Deletes a row in the database.
     * This method uses the passed connection to delete the rows;
     * if a transaction is open in the connection, the deletion happens inside
     * this transaction.
     *
     * @param pk the ObjectKey that identifies the row to delete.
     * @param con the connection to use for deleting, not null.
     *
     * @return the number of deleted rows.
     *
     * @throws TorqueException Any exceptions caught during processing will be
     *         rethrown wrapped into a TorqueException.
     */
    public static int doDelete(ObjectKey<?> pk, Connection con)
        throws TorqueException
    {
        return getTorqueDynamicPermissionPeerImpl().doDelete(pk, con);
    }

    /** 
     * Build a Criteria object which selects all objects which have a given
     * primary key.
     *
     * @param pk the primary key value to build the criteria from, not null.
     */
    public static Criteria buildCriteria(ObjectKey<?> pk)
    {
        return getTorqueDynamicPermissionPeerImpl().buildCriteria(pk);
    }

    /** 
     * Build a Criteria object which selects all objects which primary keys
     * are contained in the passed collection.
     *
     * @param pks the primary key values to build the criteria from, not null,
     *        may not contain null.
     */
    public static Criteria buildCriteria(Collection<ObjectKey<?>> pks)
    {
        return getTorqueDynamicPermissionPeerImpl().buildCriteria(pks);
    }

    /** 
     * Build a Criteria object which selects all passed objects using their
     * primary key. Objects which do not yet have a primary key are ignored.
     *
     * @param objects the objects to build the criteria from, not null,
     *        may not contain null.
     */
    public static Criteria buildPkCriteria(
            Collection<TorqueDynamicPermission> objects)
    {
        return getTorqueDynamicPermissionPeerImpl().buildPkCriteria(objects);
    }

    /** 
     * Build a Criteria object from the data object for this peer.
     *
     * @param obj the object to build the criteria from, not null.
     */
    public static Criteria buildCriteria(TorqueDynamicPermission obj)
    {
        return getTorqueDynamicPermissionPeerImpl().buildCriteria(obj);
    }

    /** 
     * Build a Criteria object from the data object for this peer,
     * skipping all binary columns.
     *
     * @param obj the object to build the criteria from, not null.
     */
    public static Criteria buildSelectCriteria(TorqueDynamicPermission obj)
    {
        return getTorqueDynamicPermissionPeerImpl().buildSelectCriteria(obj);
    }

    /** 
     * Returns the contents of the object as ColumnValues object
     *
     * @throws TorqueException if the table map cannot be retrieved
     *         (should not happen).
     */
    public static ColumnValues buildColumnValues(TorqueDynamicPermission torqueDynamicPermission)
            throws TorqueException
    {
        
        return getTorqueDynamicPermissionPeerImpl().buildColumnValues(torqueDynamicPermission);
    }

    /**
     * Retrieve a single object by pk
     *
     * @param pk the primary key
     * @throws TorqueException Any exceptions caught during processing will be
     *         rethrown wrapped into a TorqueException.
     * @throws NoRowsException Primary key was not found in database.
     * @throws TooManyRowsException Primary key was not found in database.
     */
    public static TorqueDynamicPermission retrieveByPK(Integer pk)
        throws TorqueException, NoRowsException, TooManyRowsException
    {
        return getTorqueDynamicPermissionPeerImpl().retrieveByPK(pk);
    }

    /**
     * Retrieve a single object by pk
     *
     * @param pk the primary key
     * @param con the connection to use
     * @throws TorqueException Any exceptions caught during processing will be
     *         rethrown wrapped into a TorqueException.
     * @throws NoRowsException Primary key was not found in database.
     * @throws TooManyRowsException Primary key was not found in database.
     */
    public static TorqueDynamicPermission retrieveByPK(Integer pk, Connection con)
        throws TorqueException, NoRowsException, TooManyRowsException
    {
        return getTorqueDynamicPermissionPeerImpl().retrieveByPK(pk, con);
    }
    
    
    

    /**
     * Retrieve a single object by pk
     *
     * @param pk the primary key
     * @throws TorqueException Any exceptions caught during processing will be
     *         rethrown wrapped into a TorqueException.
     * @throws NoRowsException Primary key was not found in database.
     * @throws TooManyRowsException Primary key was not found in database.
     */
    public static TorqueDynamicPermission retrieveByPK(ObjectKey<?> pk)
        throws TorqueException, NoRowsException, TooManyRowsException
    {
        return getTorqueDynamicPermissionPeerImpl().retrieveByPK(pk);
    }

    /**
     * Retrieve a single object by pk
     *
     * @param pk the primary key
     * @param con the connection to use
     * @throws TorqueException Any exceptions caught during processing will be
     *         rethrown wrapped into a TorqueException.
     * @throws NoRowsException Primary key was not found in database.
     * @throws TooManyRowsException Primary key was not found in database.
     */
    public static TorqueDynamicPermission retrieveByPK(ObjectKey<?> pk, Connection con)
        throws TorqueException, NoRowsException, TooManyRowsException
    {
        return getTorqueDynamicPermissionPeerImpl().retrieveByPK(pk, con);
    }


    /**
     * Retrieve multiple objects by pk.
     *
     * @param pks List of primary keys
     *
     * @return the list of matching objects, not null.
     *
     * @throws TorqueException Any exceptions caught during processing will be
     *         rethrown wrapped into a TorqueException.
     */
    public static List<TorqueDynamicPermission> retrieveByTypedPKs(Collection<Integer> pks)
        throws TorqueException
    {
        return getTorqueDynamicPermissionPeerImpl().retrieveByTypedPKs(pks);
    }

    /**
     * Retrieve multiple objects by pk.
     *
     * @param pks List of primary keys
     * @param dbcon the connection to use
     *
     * @return the list of matching objects, not null.
     *
     * @throws TorqueException Any exceptions caught during processing will be
     *         rethrown wrapped into a TorqueException.
     */
    public static List<TorqueDynamicPermission> retrieveByTypedPKs(
                Collection<Integer> pks,
                Connection dbcon)
            throws TorqueException
    {
        return getTorqueDynamicPermissionPeerImpl().retrieveByTypedPKs(pks, dbcon);
    }

    /**
     * Retrieve a multiple objects by pk.
     *
     * @param pks List of primary keys
     *
     * @return the list of matching objects, not null.
     *
     * @throws TorqueException Any exceptions caught during processing will be
     *         rethrown wrapped into a TorqueException.
     */
    public static List<TorqueDynamicPermission> retrieveByObjectKeys(Collection<ObjectKey<?>> pks)
        throws TorqueException
    {
        return getTorqueDynamicPermissionPeerImpl().retrieveByObjectKeys(pks);
    }

    /**
     * Retrieve multiple objects by pk.
     *
     * @param pks List of primary keys
     * @param con the connection to use
     *
     * @return the list of matching objects, not null.
     *
     * @throws TorqueException Any exceptions caught during processing will be
     *         rethrown wrapped into a TorqueException.
     */
    public static List<TorqueDynamicPermission> retrieveByObjectKeys(Collection<ObjectKey<?>> pks, Connection con)
        throws TorqueException
    {
        return getTorqueDynamicPermissionPeerImpl().retrieveByObjectKeys(pks, con);
    }




    /** 
     * Saves the passed collection as linked objects.
     * This means the following is done:
     * <ul>
     *  <li>
     *    The current collection of objects which are linked to toLinkTo
     *    and which are also in the list toSave is read from the database
     *    into the list intersection.
     *  </li>
     *  <li>
     *    All objects in toSave which are not in intersection are inserted.
     *  </li>
     *  <li>
     *    All objects in intersection are updated with the 
     *    corresponding values in toSave and saved.
     *  </li>
     *  <li>
     *    All objects in the database which are linked to toLinkTo but are 
     *    not in toSave are deleted from the database.
     *  </li>
     * </ul>
     *
     * @param toLinkTo the object which collections should be set with the
     *        values in toSave.
     * @param toSave Contains the objects to save, not null, 
     *        may not contain null.
     *
     * @throws TorqueException if an error accessing the database occurs.
     * @throws NullPointerException if toSave is null or contains null elements.
     */
    public static void setAndSaveTorqueDynamicRolePermissions(
            TorqueDynamicPermission toLinkTo,
            Collection<TorqueDynamicRolePermission> toSave) 
        throws TorqueException
    {
        getTorqueDynamicPermissionPeerImpl().setAndSaveTorqueDynamicRolePermissions(toLinkTo, toSave);
    }

    /** 
     * Saves the passed collection as linked objects.
     * This means the following is done:
     * <ul>
     *  <li>
     *    The current collection of objects which are linked to toLinkTo
     *    and which are also in the list toSave is read from the database
     *    into the list intersection.
     *  </li>
     *  <li>
     *    All objects in toSave which are not in intersection are inserted.
     *  </li>
     *  <li>
     *    All objects in intersection are updated with the 
     *    corresponding values in toSave and saved.
     *  </li>
     *  <li>
     *    All objects in the database which are linked to toLinkTo but are 
     *    not in toSave are deleted from the database.
     *  </li>
     * </ul>
     *
     * @param toLinkTo the object which collections should be set with the
     *        values in toSave.
     * @param toSave Contains the objects to save, not null, 
     *        may not contain null.
     * @param connection the database connection to use.
     *
     * @throws TorqueException if an error accessing the database occurs.
     * @throws NullPointerException if toSave is null or contains null elements.
     */
    public void setAndSaveTorqueDynamicRolePermissions(
            TorqueDynamicPermission toLinkTo,
            Collection<TorqueDynamicRolePermission> toSave,
            Connection connection) 
        throws TorqueException
    {
        getTorqueDynamicPermissionPeerImpl().setAndSaveTorqueDynamicRolePermissions(toLinkTo, toSave);
    }

    /**
     * Returns the TableMap related to this peer.
     *
     * @return the table map, not null.
     *
     * @throws TorqueException if the Peer instance does not hold a Table map.
     */
    public static TableMap getTableMap()
        throws TorqueException
    {
        return getTorqueDynamicPermissionPeerImpl().getTableMap();
    }

    public static void initDatabaseMap()
    {
    }


}
