package org.apache.fulcrum.security.torque.om;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.torque.Column;
import org.apache.torque.TorqueException;
import org.apache.torque.criteria.Criteria;
import org.apache.torque.om.mapper.RecordMapper;


/**
 * Maps ResultSet rows into TorqueBasicUser objects.
 *
 * The skeleton for this class was autogenerated by Torque on:
 *
 * [Fri Nov 03 10:19:40 CET 2023]
 *
 */
@SuppressWarnings("unused")
public class BaseTorqueBasicUserRecordMapper implements RecordMapper<TorqueBasicUser>
{
    /** Serial version */
    private static final long serialVersionUID = 1699003180933L;

    /** The class log. */
    private static Log log
            = LogFactory.getLog(BaseTorqueBasicUserRecordMapper.class);

    /**
     * Constructs the object from the current row in the resultSet.
     *
     * @param resultSet the resultSet to operate on, already pointing
     *        to the correct row. Not null.
     * @param offset a possible offset in the columns to be considered
     *        (if previous columns contain other objects),
     *        or 0 for no offset.
     * @param criteria The criteria which created the result set.
     *        If set, the attributes to set in the data object
     *        are determined from the select columns in the criteria;
     *        if no matching column can be found, null is returned.
     *        If not set, all of the table's columns are read from the
     *        result set in the order defined in the table definition.
     *
     * @return the mapped object, not null.
     *
     * @throws TorqueException when reading fields from the RecordSet fails
     *         or if a Criteria is passed which contains select columns other
     *         than the columns in the FULCRUM_BASIC_USER table.
     */
    public TorqueBasicUser processRow(
                ResultSet resultSet,
                int offset,
                Criteria criteria)
            throws TorqueException
    {
        TorqueBasicUser torqueBasicUser = new TorqueBasicUser();

        try 
        {
            torqueBasicUser.setLoading(true);
            if (criteria == null)
            {
                torqueBasicUser.setEntityId(
                        getEntityId(resultSet, offset + 1));
                torqueBasicUser.setEntityName(
                        getEntityName(resultSet, offset + 2));
                torqueBasicUser.setPassword(
                        getPassword(resultSet, offset + 3));
            }
            else
            {
                // try to get columns to be mapped
                // from criteria's select columns
                boolean columnMapped = false;
                int totalOffset = offset + 1;
                List<Column> selectColumns = criteria.getSelectColumns();
                List<Column> columnsWithoutOffset = selectColumns.subList(
                        offset, 
                        selectColumns.size());
                for (Column column : columnsWithoutOffset)
                {
                    if (BaseTorqueBasicUserPeer.USER_ID.getSqlExpression().equals(
                            column.getSqlExpression()))
                    {
                        torqueBasicUser.setEntityId(
                            getEntityId(resultSet, totalOffset));
                        columnMapped = true;
                    }
                    else if (BaseTorqueBasicUserPeer.LOGIN_NAME.getSqlExpression().equals(
                            column.getSqlExpression()))
                    {
                        torqueBasicUser.setEntityName(
                            getEntityName(resultSet, totalOffset));
                        columnMapped = true;
                    }
                    else if (BaseTorqueBasicUserPeer.PASSWORD_VALUE.getSqlExpression().equals(
                            column.getSqlExpression()))
                    {
                        torqueBasicUser.setPassword(
                            getPassword(resultSet, totalOffset));
                        columnMapped = true;
                    }
                    totalOffset++;
                }
                if (!columnMapped)
                {
                    log.debug("no columns to map found in criteria, "
                        + "returning null");
                    return null;
                }
            }
            torqueBasicUser.setNew(false);
            torqueBasicUser.setModified(false);
        }
        finally
        {
            torqueBasicUser.setLoading(false);
        }
        return torqueBasicUser;
    }

    /**
     * Reads the value of the <code>columnIndex</code>'th column
     * in the <code>resultSet</code> so that it can be used to set
     * the field entityId in TorqueBasicUser.
     *
     * @param resultSet the ResultSet to read from, not null.
     * @param columnIndex the index in the resultSet which should be read.
     *
     * @return the content of the column.
     *
     * @throws SQLException if a problem occurs when reading
     *         from the resultSet.
     */
    protected Integer getEntityId(
                ResultSet resultSet,
                int columnIndex)
            throws TorqueException
    {
        try
        {
            Integer value = resultSet.getInt(columnIndex);
            if (resultSet.wasNull())
            {
                value = null;
            }
            return value;
        }
        catch (SQLException e)
        {
            throw new TorqueException(e);
        }
    }
    /**
     * Reads the value of the <code>columnIndex</code>'th column
     * in the <code>resultSet</code> so that it can be used to set
     * the field entityName in TorqueBasicUser.
     *
     * @param resultSet the ResultSet to read from, not null.
     * @param columnIndex the index in the resultSet which should be read.
     *
     * @return the content of the column.
     *
     * @throws SQLException if a problem occurs when reading
     *         from the resultSet.
     */
    protected String getEntityName(
                ResultSet resultSet,
                int columnIndex)
            throws TorqueException
    {
        try
        {
            return resultSet.getString(columnIndex);
        }
        catch (SQLException e)
        {
            throw new TorqueException(e);
        }
    }
    /**
     * Reads the value of the <code>columnIndex</code>'th column
     * in the <code>resultSet</code> so that it can be used to set
     * the field password in TorqueBasicUser.
     *
     * @param resultSet the ResultSet to read from, not null.
     * @param columnIndex the index in the resultSet which should be read.
     *
     * @return the content of the column.
     *
     * @throws SQLException if a problem occurs when reading
     *         from the resultSet.
     */
    protected String getPassword(
                ResultSet resultSet,
                int columnIndex)
            throws TorqueException
    {
        try
        {
            return resultSet.getString(columnIndex);
        }
        catch (SQLException e)
        {
            throw new TorqueException(e);
        }
    }

}
