package org.apache.fulcrum.security.torque.om;

import java.sql.Connection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

import org.apache.torque.NoRowsException;
import org.apache.torque.TooManyRowsException;
import org.apache.torque.TorqueException;
import org.apache.torque.criteria.Criteria;
import org.apache.torque.criteria.Criterion;
import org.apache.torque.om.mapper.RecordMapper;
import org.apache.torque.om.mapper.CompositeMapper;
import org.apache.torque.om.ObjectKey;
import org.apache.torque.om.SimpleKey;
import org.apache.torque.map.TableMap;
import org.apache.torque.util.TorqueConnection;
import org.apache.torque.util.Transaction;
import org.apache.torque.util.ColumnValues;
import org.apache.torque.util.JdbcTypedValue;



/**
 * The skeleton for this class was autogenerated by Torque on:
 *
 * [Fri Nov 03 10:19:40 CET 2023]
 *
 * You should not use this class directly.  It should not even be
 * extended; all references should be to TorqueBasicUserGroupPeer
 */

@SuppressWarnings("unused")
public abstract class BaseTorqueBasicUserGroupPeerImpl
    extends org.apache.torque.util.AbstractPeerImpl<TorqueBasicUserGroup>
{
    /** Serial version */
    private static final long serialVersionUID = 1699003180053L;



    /**
     * Constructor.
     * The recordMapper, tableMap and databaseName fields are correctly
     * initialized.
     */
    public BaseTorqueBasicUserGroupPeerImpl()
    {
        this(new TorqueBasicUserGroupRecordMapper(),
            TorqueBasicUserGroupPeer.TABLE,
            TorqueBasicUserGroupPeer.DATABASE_NAME);
    }

    /**
     * Constructor providing the objects to be injected as parameters.
     *
     * @param recordMapper a record mapper to map JDBC result sets to objects
     * @param tableMap the default table map
     * @param databaseName the name of the database
     */
    public BaseTorqueBasicUserGroupPeerImpl(
            RecordMapper<TorqueBasicUserGroup> recordMapper, 
            TableMap tableMap,
            String databaseName)
    {
        super(recordMapper, tableMap, databaseName);
    }


    /**
     * Returns a new instance of the Data object class
     */
    public TorqueBasicUserGroup getDbObjectInstance()
    {
        return new TorqueBasicUserGroup();
    }


    /**
     * Method to do updates.  This method is to be used during a transaction,
     * otherwise use the doUpdate(Criteria) method.
     *
     * @param columnValues the values to update plus the primary key
     *        identifying the row to update.
     * @param con the connection to use, not null.
     *
     * @return the number of affected rows.
     *
     * @throws TorqueException Any exceptions caught during processing will be
     *         rethrown wrapped into a TorqueException.
     */
    public int doUpdate(ColumnValues columnValues, Connection con)
        throws TorqueException
    {
        Criteria selectCriteria = new Criteria(getDatabaseName());
        correctBooleans(columnValues);

        {
            JdbcTypedValue pkValue
                = columnValues.remove(TorqueBasicUserGroupPeer.USER_ID);
            if (pkValue == null)
            {
                throw new TorqueException(
                        "The value for the primary key column "
                        + "TorqueBasicUserGroupPeer.USER_ID"
                        + " must be set");
            }
            if (pkValue.getSqlExpression() == null)
            {
                selectCriteria.where(
                        TorqueBasicUserGroupPeer.USER_ID,
                        pkValue.getValue());
            }
            else
            {
                selectCriteria.where(
                        TorqueBasicUserGroupPeer.USER_ID,
                        pkValue.getSqlExpression());
            }
        }
        {
            JdbcTypedValue pkValue
                = columnValues.remove(TorqueBasicUserGroupPeer.GROUP_ID);
            if (pkValue == null)
            {
                throw new TorqueException(
                        "The value for the primary key column "
                        + "TorqueBasicUserGroupPeer.GROUP_ID"
                        + " must be set");
            }
            if (pkValue.getSqlExpression() == null)
            {
                selectCriteria.where(
                        TorqueBasicUserGroupPeer.GROUP_ID,
                        pkValue.getValue());
            }
            else
            {
                selectCriteria.where(
                        TorqueBasicUserGroupPeer.GROUP_ID,
                        pkValue.getSqlExpression());
            }
        }


        int rowCount = doUpdate(selectCriteria, columnValues, con);
        return rowCount;
    }

    /**
     * Deletes a data object, i.e. a row in a table, in the database.
     *
     * @param obj the data object to delete in the database, not null.
     *
     * @return the number of deleted rows.
     *
     * @throws TorqueException Any exceptions caught during processing will be
     *         rethrown wrapped into a TorqueException.
     */
    public int doDelete(TorqueBasicUserGroup obj) throws TorqueException
    {
        int result = doDelete(buildCriteria(obj.getPrimaryKey()));
        obj.setDeleted(true);
        return result;
    }

    /**
     * Deletes a data object, i.e. a row in a table, in the database.
     * This method is to be used during a transaction, otherwise use the
     * doDelete(TorqueBasicUserGroup) method.
     *
     * @param obj the data object to delete in the database, not null.
     * @param con the connection to use, not null.
     *
     * @return the number of deleted rows.
     *
     * @throws TorqueException Any exceptions caught during processing will be
     *         rethrown wrapped into a TorqueException.
     */
    public int doDelete(TorqueBasicUserGroup obj, Connection con)
        throws TorqueException
    {
        int result = doDelete(buildCriteria(obj.getPrimaryKey()), con);
        obj.setDeleted(true);
        return result;
    }

    /**
     * Deletes data objects, i.e. rows in a table, in the database.
     *
     * @param objects the data object to delete in the database, not null,
     *        may not contain null.
     *
     * @return the number of deleted rows.
     *
     * @throws TorqueException Any exceptions caught during processing will be
     *         rethrown wrapped into a TorqueException.
     */
    public int doDelete(Collection<TorqueBasicUserGroup> objects)
            throws TorqueException
    {
        int result = doDelete(buildPkCriteria(objects));
        objects.forEach(object -> object.setDeleted(true));
        return result;
    }

    /**
     * Deletes data objects, i.e. rows in a table, in the database.
     * This method uses the passed connection to delete the rows;
     * if a transaction is open in the connection, the deletion happens inside
     * this transaction.
     *
     * @param objects the data objects to delete in the database, not null,
     *        may not contain null.
     * @param con the connection to use for deleting, not null.
     *
     * @return the number of deleted rows.
     *
     * @throws TorqueException Any exceptions caught during processing will be
     *         rethrown wrapped into a TorqueException.
     */
    public int doDelete(
            Collection<TorqueBasicUserGroup> objects,
            Connection con)
        throws TorqueException
    {
        int result = doDelete(buildPkCriteria(objects), con);
        objects.forEach(object -> object.setDeleted(true));
        return result;
    }

    /** 
     * Build a Criteria object which selects all objects which have a given
     * primary key.
     *
     * @param pk the primary key value to build the criteria from, not null.
     */
    public Criteria buildCriteria(ObjectKey<?> pk)
    {
        Criteria criteria = new Criteria();
        SimpleKey<?>[] keys = (SimpleKey[])pk.getValue();
        criteria.and(TorqueBasicUserGroupPeer.USER_ID, keys[0]);
        criteria.and(TorqueBasicUserGroupPeer.GROUP_ID, keys[1]);
        return criteria;
     }

    /** 
     * Build a Criteria object which selects all objects which primary keys
     * are contained in the passed collection.
     *
     * @param pks the primary key values to build the criteria from, not null,
     *        may not contain null.
     */
    public Criteria buildCriteria(Collection<ObjectKey<?>> pks)
    {
        Criteria criteria = new Criteria();
        for (ObjectKey<?> pk : pks)
        {
            SimpleKey<?>[] keys = (SimpleKey[])pk.getValue();
                Criterion c0 = new Criterion(
                    TorqueBasicUserGroupPeer.USER_ID, keys[0], Criteria.EQUAL);
                Criterion c1 = new Criterion(
                    TorqueBasicUserGroupPeer.GROUP_ID, keys[1], Criteria.EQUAL);
                    c0.and(c1);
            criteria.or(c0);
        }
        return criteria;
     }


    /** 
     * Build a Criteria object which selects all passed objects using their
     * primary key. Objects which do not yet have a primary key are ignored.
     *
     * @param objects the objects to build the criteria from, not null,
     *        may not contain null.
     */
    public Criteria buildPkCriteria(
            Collection<TorqueBasicUserGroup> objects)
    {
        return buildCriteria(objects.stream()
                .map(object -> object.getPrimaryKey())
                .collect(Collectors.toList()));
    }

    /** 
     * Build a Criteria object from the data object for this peer.
     *
     * @param obj the object to build the criteria from, not null.
     */
    public Criteria buildCriteria(TorqueBasicUserGroup obj)
    {
        Criteria criteria = new Criteria(getDatabaseName());
        criteria.and(TorqueBasicUserGroupPeer.USER_ID, obj.getUserId());
        criteria.and(TorqueBasicUserGroupPeer.GROUP_ID, obj.getGroupId());
        return criteria;
    }

    /** 
     * Build a Criteria object from the data object for this peer,
     * skipping all binary columns.
     *
     * @param obj the object to build the criteria from, not null.
     */
    public Criteria buildSelectCriteria(TorqueBasicUserGroup obj)
    {
        Criteria criteria = new Criteria(getDatabaseName());
        criteria.and(TorqueBasicUserGroupPeer.USER_ID, obj.getUserId());
        criteria.and(TorqueBasicUserGroupPeer.GROUP_ID, obj.getGroupId());
        return criteria;
    }

    /** 
     * Returns the contents of the object as ColumnValues object.
     * Primary key columns which are generated on insertion are not
     * added to the returned object if they still have their initial
     * value. Also, columns which have the useDatabaseDefaultValue
     * flag set to true are also not added to the returned object
     * if they still have their initial value.
     *
     * @throws TorqueException if the table map cannot be retrieved
     *         (should not happen).
     */
    public ColumnValues buildColumnValues(TorqueBasicUserGroup torqueBasicUserGroup)
            throws TorqueException
    {
        ColumnValues columnValues = new ColumnValues();
        columnValues.put(
                TorqueBasicUserGroupPeer.USER_ID,
                new JdbcTypedValue(
                    torqueBasicUserGroup.getUserId(),
                    4));
        columnValues.put(
                TorqueBasicUserGroupPeer.GROUP_ID,
                new JdbcTypedValue(
                    torqueBasicUserGroup.getGroupId(),
                    4));
        return columnValues;
    }

    /**
     * retrieve object using using pk values.
     *
     * @param userId Integer
     * @param groupId Integer
     */
    public TorqueBasicUserGroup retrieveByPK(
            Integer userId,
            Integer groupId)
        throws TorqueException
    {
        try (TorqueConnection connection = Transaction.begin(getDatabaseName()))
        {
            TorqueBasicUserGroup result = retrieveByPK(
               userId,
               groupId,
               connection);
            Transaction.commit(connection);
            return result;
        }
    }

    /**
     * retrieve object using using pk values.
     *
     * @param userId Integer
     * @param groupId Integer
     * @param con Connection
     */
    public TorqueBasicUserGroup retrieveByPK(
            Integer userId,
            Integer groupId,
            Connection con) throws TorqueException
    {

        Criteria criteria = new Criteria();
        criteria.and(TorqueBasicUserGroupPeer.USER_ID, userId);
        criteria.and(TorqueBasicUserGroupPeer.GROUP_ID, groupId);
        TorqueBasicUserGroup v = doSelectSingleRecord(criteria, con);
        if (v == null)
        {
            throw new NoRowsException("Failed to select a row.");
        }

        return v;
    }

    /**
     * Retrieve a single object by pk
     *
     * @param pk the primary key
     * @throws TorqueException Any exceptions caught during processing will be
     *         rethrown wrapped into a TorqueException.
     * @throws NoRowsException Primary key was not found in database.
     * @throws TooManyRowsException Primary key was not found in database.
     */
    public TorqueBasicUserGroup retrieveByPK(ObjectKey<?> pk)
        throws TorqueException, NoRowsException, TooManyRowsException
    {
        try (TorqueConnection connection = Transaction.begin(getDatabaseName()))
        {
            TorqueBasicUserGroup result = retrieveByPK(pk, connection);
            Transaction.commit(connection);
            return result;
        }
    }

    /**
     * Retrieve a single object by pk
     *
     * @param pk the primary key
     * @param con the connection to use
     * @throws TorqueException Any exceptions caught during processing will be
     *         rethrown wrapped into a TorqueException.
     * @throws NoRowsException Primary key was not found in database.
     * @throws TooManyRowsException Primary key was not found in database.
     */
    public TorqueBasicUserGroup retrieveByPK(ObjectKey<?> pk, Connection con)
        throws TorqueException, NoRowsException, TooManyRowsException
    {
        Criteria criteria = buildCriteria(pk);
        TorqueBasicUserGroup v = doSelectSingleRecord(criteria, con);
        if (v == null)
        {
            throw new NoRowsException("Failed to select a row.");
        }

        return v;
    }


    /**
     * Retrieve multiple objects by pk.
     *
     * @param pks List of primary keys.
     *        Entries in pks which do not match entries in the database are ignored.
     *
     * @return the list of matching objects, not null.
     *
     * @throws TorqueException Any exceptions caught during processing will be
     *         rethrown wrapped into a TorqueException.
     */
    public List<TorqueBasicUserGroup> retrieveByObjectKeys(Collection<ObjectKey<?>> pks)
        throws TorqueException
    {
        try (TorqueConnection connection = Transaction.begin(getDatabaseName()))
        {
            List<TorqueBasicUserGroup> result = retrieveByObjectKeys(pks, connection);
            Transaction.commit(connection);
            return result;
        }
    }

    /**
     * Retrieve multiple objects by pk.
     *
     * @param pks List of primary keys.
     *        Entries in pks which do not match entries in the database are ignored.
     * @param dbcon the connection to use
     *
     * @return the list of matching objects, not null.
     *
     * @throws TorqueException Any exceptions caught during processing will be
     *         rethrown wrapped into a TorqueException.
     */
    public List<TorqueBasicUserGroup> retrieveByObjectKeys(
                Collection<ObjectKey<?>> pks,
                Connection dbcon)
            throws TorqueException
    {
        if (pks == null || pks.size() == 0)
        {
            return new ArrayList<TorqueBasicUserGroup>();
        }
        Criteria criteria = buildCriteria(pks);
        List<TorqueBasicUserGroup> result = doSelect(criteria, dbcon);
        return result;
    }


    /**
     * Selects a collection of dbObjectClassName objects pre-filled with their
     * TorqueBasicUser objects.
     *
     * @throws TorqueException Any exceptions caught during processing will be
     *         rethrown wrapped into a TorqueException.
     */
    public List<TorqueBasicUserGroup> doSelectJoinTorqueBasicUser(Criteria criteria)
        throws TorqueException
    {
        try (TorqueConnection connection = Transaction.begin(getDatabaseName()))
        {
            List<TorqueBasicUserGroup> result
                    = TorqueBasicUserGroupPeer.doSelectJoinTorqueBasicUser(criteria, connection);
            Transaction.commit(connection);
            return result;
        }
    }

    /**
     * Selects a collection of TorqueBasicUserGroup objects pre-filled with their
     * TorqueBasicUser objects.
     *
     * @throws TorqueException Any exceptions caught during processing will be
     *         rethrown wrapped into a TorqueException.
     */
    public List<TorqueBasicUserGroup> doSelectJoinTorqueBasicUser(
            Criteria criteria, Connection conn)
        throws TorqueException
    {
        setDbName(criteria);

        addSelectColumns(criteria);
        org.apache.fulcrum.security.torque.om.TorqueBasicUserPeer.addSelectColumns(criteria);

        CompositeMapper compositeMapper = new CompositeMapper();
        compositeMapper.addMapper(
                new TorqueBasicUserGroupRecordMapper(),
                0);
        compositeMapper.addMapper(
                new TorqueBasicUserRecordMapper(),
                TorqueBasicUserGroupPeer.numColumns);
        criteria.addJoin(TorqueBasicUserGroupPeer.USER_ID,
            org.apache.fulcrum.security.torque.om.TorqueBasicUserPeer.USER_ID);

        correctBooleans(criteria);

        List<TorqueBasicUserGroup> result = new ArrayList<TorqueBasicUserGroup>();
        List<List<Object>> rawResult = doSelect(
                criteria, compositeMapper, conn);
        for (List<Object> rawResultRow : rawResult)
        {
            TorqueBasicUserGroup obj1 = (TorqueBasicUserGroup) rawResultRow.get(0);
            TorqueBasicUser obj2 = (TorqueBasicUser) rawResultRow.get(1);

            boolean newObject = true;
            for (int j = 0; j < result.size(); j++)
            {
                TorqueBasicUserGroup temp_obj1 = result.get(j);
                org.apache.fulcrum.security.torque.om.TorqueBasicUser temp_obj2 = temp_obj1.getTorqueBasicUser();
                if (temp_obj2.getPrimaryKey().equals(obj2.getPrimaryKey()))
                {
                    newObject = false;
                    temp_obj2.addTorqueBasicUserGroup(obj1);
                    break;
                }
            }
            if (newObject)
            {
                obj2.initTorqueBasicUserGroups();
                obj2.addTorqueBasicUserGroup(obj1);
            }
            result.add(obj1);
        }
        return result;
    }
    /**
     * Selects a collection of dbObjectClassName objects pre-filled with their
     * TorqueBasicGroup objects.
     *
     * @throws TorqueException Any exceptions caught during processing will be
     *         rethrown wrapped into a TorqueException.
     */
    public List<TorqueBasicUserGroup> doSelectJoinTorqueBasicGroup(Criteria criteria)
        throws TorqueException
    {
        try (TorqueConnection connection = Transaction.begin(getDatabaseName()))
        {
            List<TorqueBasicUserGroup> result
                    = TorqueBasicUserGroupPeer.doSelectJoinTorqueBasicGroup(criteria, connection);
            Transaction.commit(connection);
            return result;
        }
    }

    /**
     * Selects a collection of TorqueBasicUserGroup objects pre-filled with their
     * TorqueBasicGroup objects.
     *
     * @throws TorqueException Any exceptions caught during processing will be
     *         rethrown wrapped into a TorqueException.
     */
    public List<TorqueBasicUserGroup> doSelectJoinTorqueBasicGroup(
            Criteria criteria, Connection conn)
        throws TorqueException
    {
        setDbName(criteria);

        addSelectColumns(criteria);
        org.apache.fulcrum.security.torque.om.TorqueBasicGroupPeer.addSelectColumns(criteria);

        CompositeMapper compositeMapper = new CompositeMapper();
        compositeMapper.addMapper(
                new TorqueBasicUserGroupRecordMapper(),
                0);
        compositeMapper.addMapper(
                new TorqueBasicGroupRecordMapper(),
                TorqueBasicUserGroupPeer.numColumns);
        criteria.addJoin(TorqueBasicUserGroupPeer.GROUP_ID,
            org.apache.fulcrum.security.torque.om.TorqueBasicGroupPeer.GROUP_ID);

        correctBooleans(criteria);

        List<TorqueBasicUserGroup> result = new ArrayList<TorqueBasicUserGroup>();
        List<List<Object>> rawResult = doSelect(
                criteria, compositeMapper, conn);
        for (List<Object> rawResultRow : rawResult)
        {
            TorqueBasicUserGroup obj1 = (TorqueBasicUserGroup) rawResultRow.get(0);
            TorqueBasicGroup obj2 = (TorqueBasicGroup) rawResultRow.get(1);

            boolean newObject = true;
            for (int j = 0; j < result.size(); j++)
            {
                TorqueBasicUserGroup temp_obj1 = result.get(j);
                org.apache.fulcrum.security.torque.om.TorqueBasicGroup temp_obj2 = temp_obj1.getTorqueBasicGroup();
                if (temp_obj2.getPrimaryKey().equals(obj2.getPrimaryKey()))
                {
                    newObject = false;
                    temp_obj2.addTorqueBasicUserGroup(obj1);
                    break;
                }
            }
            if (newObject)
            {
                obj2.initTorqueBasicUserGroups();
                obj2.addTorqueBasicUserGroup(obj1);
            }
            result.add(obj1);
        }
        return result;
    }




}
