package org.apache.fulcrum.security.torque.om;

import java.sql.Connection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

import org.apache.torque.NoRowsException;
import org.apache.torque.TooManyRowsException;
import org.apache.torque.TorqueException;
import org.apache.torque.criteria.Criteria;
import org.apache.torque.criteria.Criterion;
import org.apache.torque.om.mapper.RecordMapper;
import org.apache.torque.om.mapper.CompositeMapper;
import org.apache.torque.om.ObjectKey;
import org.apache.torque.om.SimpleKey;
import org.apache.torque.map.TableMap;
import org.apache.torque.util.TorqueConnection;
import org.apache.torque.util.Transaction;
import org.apache.torque.util.ColumnValues;
import org.apache.torque.util.JdbcTypedValue;



/**
 * The skeleton for this class was autogenerated by Torque on:
 *
 * [Thu Nov 04 10:24:03 CET 2021]
 *
 * You should not use this class directly.  It should not even be
 * extended; all references should be to TurbineUserGroupRolePeer
 */

@SuppressWarnings("unused")
public abstract class BaseTurbineUserGroupRolePeerImpl
    extends org.apache.torque.util.AbstractPeerImpl<TurbineUserGroupRole>
{
    /** Serial version */
    private static final long serialVersionUID = 1636017843466L;



    /**
     * Constructor.
     * The recordMapper, tableMap and databaseName fields are correctly
     * initialized.
     */
    public BaseTurbineUserGroupRolePeerImpl()
    {
        this(new TurbineUserGroupRoleRecordMapper(),
            TurbineUserGroupRolePeer.TABLE,
            TurbineUserGroupRolePeer.DATABASE_NAME);
    }

    /**
     * Constructor providing the objects to be injected as parameters.
     *
     * @param recordMapper a record mapper to map JDBC result sets to objects
     * @param tableMap the default table map
     * @param databaseName the name of the database
     */
    public BaseTurbineUserGroupRolePeerImpl(
            RecordMapper<TurbineUserGroupRole> recordMapper, 
            TableMap tableMap,
            String databaseName)
    {
        super(recordMapper, tableMap, databaseName);
    }


    /**
     * Returns a new instance of the Data object class
     */
    public TurbineUserGroupRole getDbObjectInstance()
    {
        return new TurbineUserGroupRole();
    }


    /**
     * Method to do updates.  This method is to be used during a transaction,
     * otherwise use the doUpdate(Criteria) method.
     *
     * @param columnValues the values to update plus the primary key
     *        identifying the row to update.
     * @param con the connection to use, not null.
     *
     * @return the number of affected rows.
     *
     * @throws TorqueException Any exceptions caught during processing will be
     *         rethrown wrapped into a TorqueException.
     */
    public int doUpdate(ColumnValues columnValues, Connection con)
        throws TorqueException
    {
        Criteria selectCriteria = new Criteria(getDatabaseName());
        correctBooleans(columnValues);

        {
            JdbcTypedValue pkValue
                = columnValues.remove(TurbineUserGroupRolePeer.USER_ID);
            if (pkValue == null)
            {
                throw new TorqueException(
                        "The value for the primary key column "
                        + "TurbineUserGroupRolePeer.USER_ID"
                        + " must be set");
            }
            if (pkValue.getSqlExpression() == null)
            {
                selectCriteria.where(
                        TurbineUserGroupRolePeer.USER_ID,
                        pkValue.getValue());
            }
            else
            {
                selectCriteria.where(
                        TurbineUserGroupRolePeer.USER_ID,
                        pkValue.getSqlExpression());
            }
        }
        {
            JdbcTypedValue pkValue
                = columnValues.remove(TurbineUserGroupRolePeer.GROUP_ID);
            if (pkValue == null)
            {
                throw new TorqueException(
                        "The value for the primary key column "
                        + "TurbineUserGroupRolePeer.GROUP_ID"
                        + " must be set");
            }
            if (pkValue.getSqlExpression() == null)
            {
                selectCriteria.where(
                        TurbineUserGroupRolePeer.GROUP_ID,
                        pkValue.getValue());
            }
            else
            {
                selectCriteria.where(
                        TurbineUserGroupRolePeer.GROUP_ID,
                        pkValue.getSqlExpression());
            }
        }
        {
            JdbcTypedValue pkValue
                = columnValues.remove(TurbineUserGroupRolePeer.ROLE_ID);
            if (pkValue == null)
            {
                throw new TorqueException(
                        "The value for the primary key column "
                        + "TurbineUserGroupRolePeer.ROLE_ID"
                        + " must be set");
            }
            if (pkValue.getSqlExpression() == null)
            {
                selectCriteria.where(
                        TurbineUserGroupRolePeer.ROLE_ID,
                        pkValue.getValue());
            }
            else
            {
                selectCriteria.where(
                        TurbineUserGroupRolePeer.ROLE_ID,
                        pkValue.getSqlExpression());
            }
        }


        int rowCount = doUpdate(selectCriteria, columnValues, con);
        return rowCount;
    }

    /**
     * Deletes a data object, i.e. a row in a table, in the database.
     *
     * @param obj the data object to delete in the database, not null.
     *
     * @return the number of deleted rows.
     *
     * @throws TorqueException Any exceptions caught during processing will be
     *         rethrown wrapped into a TorqueException.
     */
    public int doDelete(TurbineUserGroupRole obj) throws TorqueException
    {
        int result = doDelete(buildCriteria(obj.getPrimaryKey()));
        obj.setDeleted(true);
        return result;
    }

    /**
     * Deletes a data object, i.e. a row in a table, in the database.
     * This method is to be used during a transaction, otherwise use the
     * doDelete(TurbineUserGroupRole) method.
     *
     * @param obj the data object to delete in the database, not null.
     * @param con the connection to use, not null.
     *
     * @return the number of deleted rows.
     *
     * @throws TorqueException Any exceptions caught during processing will be
     *         rethrown wrapped into a TorqueException.
     */
    public int doDelete(TurbineUserGroupRole obj, Connection con)
        throws TorqueException
    {
        int result = doDelete(buildCriteria(obj.getPrimaryKey()), con);
        obj.setDeleted(true);
        return result;
    }

    /**
     * Deletes data objects, i.e. rows in a table, in the database.
     *
     * @param objects the data object to delete in the database, not null,
     *        may not contain null.
     *
     * @return the number of deleted rows.
     *
     * @throws TorqueException Any exceptions caught during processing will be
     *         rethrown wrapped into a TorqueException.
     */
    public int doDelete(Collection<TurbineUserGroupRole> objects)
            throws TorqueException
    {
        int result = doDelete(buildPkCriteria(objects));
        objects.forEach(object -> object.setDeleted(true));
        return result;
    }

    /**
     * Deletes data objects, i.e. rows in a table, in the database.
     * This method uses the passed connection to delete the rows;
     * if a transaction is open in the connection, the deletion happens inside
     * this transaction.
     *
     * @param objects the data objects to delete in the database, not null,
     *        may not contain null.
     * @param con the connection to use for deleting, not null.
     *
     * @return the number of deleted rows.
     *
     * @throws TorqueException Any exceptions caught during processing will be
     *         rethrown wrapped into a TorqueException.
     */
    public int doDelete(
            Collection<TurbineUserGroupRole> objects,
            Connection con)
        throws TorqueException
    {
        int result = doDelete(buildPkCriteria(objects), con);
        objects.forEach(object -> object.setDeleted(true));
        return result;
    }

    /** 
     * Build a Criteria object which selects all objects which have a given
     * primary key.
     *
     * @param pk the primary key value to build the criteria from, not null.
     */
    public Criteria buildCriteria(ObjectKey<?> pk)
    {
        Criteria criteria = new Criteria();
        SimpleKey<?>[] keys = (SimpleKey[])pk.getValue();
        criteria.and(TurbineUserGroupRolePeer.USER_ID, keys[0]);
        criteria.and(TurbineUserGroupRolePeer.GROUP_ID, keys[1]);
        criteria.and(TurbineUserGroupRolePeer.ROLE_ID, keys[2]);
        return criteria;
     }

    /** 
     * Build a Criteria object which selects all objects which primary keys
     * are contained in the passed collection.
     *
     * @param pks the primary key values to build the criteria from, not null,
     *        may not contain null.
     */
    public Criteria buildCriteria(Collection<ObjectKey<?>> pks)
    {
        Criteria criteria = new Criteria();
        for (ObjectKey<?> pk : pks)
        {
            SimpleKey<?>[] keys = (SimpleKey[])pk.getValue();
                Criterion c0 = new Criterion(
                    TurbineUserGroupRolePeer.USER_ID, keys[0], Criteria.EQUAL);
                Criterion c1 = new Criterion(
                    TurbineUserGroupRolePeer.GROUP_ID, keys[1], Criteria.EQUAL);
                    c0.and(c1);
                Criterion c2 = new Criterion(
                    TurbineUserGroupRolePeer.ROLE_ID, keys[2], Criteria.EQUAL);
                    c1.and(c2);
            criteria.or(c0);
        }
        return criteria;
     }


    /** 
     * Build a Criteria object which selects all passed objects using their
     * primary key. Objects which do not yet have a primary key are ignored.
     *
     * @param objects the objects to build the criteria from, not null,
     *        may not contain null.
     */
    public Criteria buildPkCriteria(
            Collection<TurbineUserGroupRole> objects)
    {
        return buildCriteria(objects.stream()
                .map(object -> object.getPrimaryKey())
                .collect(Collectors.toList()));
    }

    /** 
     * Build a Criteria object from the data object for this peer.
     *
     * @param obj the object to build the criteria from, not null.
     */
    public Criteria buildCriteria(TurbineUserGroupRole obj)
    {
        Criteria criteria = new Criteria(getDatabaseName());
        criteria.and(TurbineUserGroupRolePeer.USER_ID, obj.getUserId());
        criteria.and(TurbineUserGroupRolePeer.GROUP_ID, obj.getGroupId());
        criteria.and(TurbineUserGroupRolePeer.ROLE_ID, obj.getRoleId());
        return criteria;
    }

    /** 
     * Build a Criteria object from the data object for this peer,
     * skipping all binary columns.
     *
     * @param obj the object to build the criteria from, not null.
     */
    public Criteria buildSelectCriteria(TurbineUserGroupRole obj)
    {
        Criteria criteria = new Criteria(getDatabaseName());
        criteria.and(TurbineUserGroupRolePeer.USER_ID, obj.getUserId());
        criteria.and(TurbineUserGroupRolePeer.GROUP_ID, obj.getGroupId());
        criteria.and(TurbineUserGroupRolePeer.ROLE_ID, obj.getRoleId());
        return criteria;
    }

    /** 
     * Returns the contents of the object as ColumnValues object.
     * Primary key columns which are generated on insertion are not
     * added to the returned object if they still have their initial
     * value. Also, columns which have the useDatabaseDefaultValue
     * flag set to true are also not added to the returned object
     * if they still have their initial value.
     *
     * @throws TorqueException if the table map cannot be retrieved
     *         (should not happen).
     */
    public ColumnValues buildColumnValues(TurbineUserGroupRole turbineUserGroupRole)
            throws TorqueException
    {
        ColumnValues columnValues = new ColumnValues();
        columnValues.put(
                TurbineUserGroupRolePeer.USER_ID,
                new JdbcTypedValue(
                    turbineUserGroupRole.getUserId(),
                    4));
        columnValues.put(
                TurbineUserGroupRolePeer.GROUP_ID,
                new JdbcTypedValue(
                    turbineUserGroupRole.getGroupId(),
                    4));
        columnValues.put(
                TurbineUserGroupRolePeer.ROLE_ID,
                new JdbcTypedValue(
                    turbineUserGroupRole.getRoleId(),
                    4));
        return columnValues;
    }

    /**
     * retrieve object using using pk values.
     *
     * @param userId Integer
     * @param groupId Integer
     * @param roleId Integer
     */
    public TurbineUserGroupRole retrieveByPK(
            Integer userId,
            Integer groupId,
            Integer roleId)
        throws TorqueException
    {
        try (TorqueConnection connection = Transaction.begin(getDatabaseName()))
        {
            TurbineUserGroupRole result = retrieveByPK(
               userId,
               groupId,
               roleId,
               connection);
            Transaction.commit(connection);
            return result;
        }
    }

    /**
     * retrieve object using using pk values.
     *
     * @param userId Integer
     * @param groupId Integer
     * @param roleId Integer
     * @param con Connection
     */
    public TurbineUserGroupRole retrieveByPK(
            Integer userId,
            Integer groupId,
            Integer roleId,
            Connection con) throws TorqueException
    {

        Criteria criteria = new Criteria();
        criteria.and(TurbineUserGroupRolePeer.USER_ID, userId);
        criteria.and(TurbineUserGroupRolePeer.GROUP_ID, groupId);
        criteria.and(TurbineUserGroupRolePeer.ROLE_ID, roleId);
        TurbineUserGroupRole v = doSelectSingleRecord(criteria, con);
        if (v == null)
        {
            throw new NoRowsException("Failed to select a row.");
        }

        return v;
    }

    /**
     * Retrieve a single object by pk
     *
     * @param pk the primary key
     * @throws TorqueException Any exceptions caught during processing will be
     *         rethrown wrapped into a TorqueException.
     * @throws NoRowsException Primary key was not found in database.
     * @throws TooManyRowsException Primary key was not found in database.
     */
    public TurbineUserGroupRole retrieveByPK(ObjectKey<?> pk)
        throws TorqueException, NoRowsException, TooManyRowsException
    {
        try (TorqueConnection connection = Transaction.begin(getDatabaseName()))
        {
            TurbineUserGroupRole result = retrieveByPK(pk, connection);
            Transaction.commit(connection);
            return result;
        }
    }

    /**
     * Retrieve a single object by pk
     *
     * @param pk the primary key
     * @param con the connection to use
     * @throws TorqueException Any exceptions caught during processing will be
     *         rethrown wrapped into a TorqueException.
     * @throws NoRowsException Primary key was not found in database.
     * @throws TooManyRowsException Primary key was not found in database.
     */
    public TurbineUserGroupRole retrieveByPK(ObjectKey<?> pk, Connection con)
        throws TorqueException, NoRowsException, TooManyRowsException
    {
        Criteria criteria = buildCriteria(pk);
        TurbineUserGroupRole v = doSelectSingleRecord(criteria, con);
        if (v == null)
        {
            throw new NoRowsException("Failed to select a row.");
        }

        return v;
    }


    /**
     * Retrieve multiple objects by pk.
     *
     * @param pks List of primary keys.
     *        Entries in pks which do not match entries in the database are ignored.
     *
     * @return the list of matching objects, not null.
     *
     * @throws TorqueException Any exceptions caught during processing will be
     *         rethrown wrapped into a TorqueException.
     */
    public List<TurbineUserGroupRole> retrieveByObjectKeys(Collection<ObjectKey<?>> pks)
        throws TorqueException
    {
        try (TorqueConnection connection = Transaction.begin(getDatabaseName()))
        {
            List<TurbineUserGroupRole> result = retrieveByObjectKeys(pks, connection);
            Transaction.commit(connection);
            return result;
        }
    }

    /**
     * Retrieve multiple objects by pk.
     *
     * @param pks List of primary keys.
     *        Entries in pks which do not match entries in the database are ignored.
     * @param dbcon the connection to use
     *
     * @return the list of matching objects, not null.
     *
     * @throws TorqueException Any exceptions caught during processing will be
     *         rethrown wrapped into a TorqueException.
     */
    public List<TurbineUserGroupRole> retrieveByObjectKeys(
                Collection<ObjectKey<?>> pks,
                Connection dbcon)
            throws TorqueException
    {
        if (pks == null || pks.size() == 0)
        {
            return new ArrayList<TurbineUserGroupRole>();
        }
        Criteria criteria = buildCriteria(pks);
        List<TurbineUserGroupRole> result = doSelect(criteria, dbcon);
        return result;
    }


    /**
     * Selects a collection of dbObjectClassName objects pre-filled with their
     * TurbineUser objects.
     *
     * @throws TorqueException Any exceptions caught during processing will be
     *         rethrown wrapped into a TorqueException.
     */
    public List<TurbineUserGroupRole> doSelectJoinTurbineUser(Criteria criteria)
        throws TorqueException
    {
        try (TorqueConnection connection = Transaction.begin(getDatabaseName()))
        {
            List<TurbineUserGroupRole> result
                    = TurbineUserGroupRolePeer.doSelectJoinTurbineUser(criteria, connection);
            Transaction.commit(connection);
            return result;
        }
    }

    /**
     * Selects a collection of TurbineUserGroupRole objects pre-filled with their
     * TurbineUser objects.
     *
     * @throws TorqueException Any exceptions caught during processing will be
     *         rethrown wrapped into a TorqueException.
     */
    public List<TurbineUserGroupRole> doSelectJoinTurbineUser(
            Criteria criteria, Connection conn)
        throws TorqueException
    {
        setDbName(criteria);

        addSelectColumns(criteria);
        org.apache.fulcrum.security.torque.om.TurbineUserPeer.addSelectColumns(criteria);

        CompositeMapper compositeMapper = new CompositeMapper();
        compositeMapper.addMapper(
                new TurbineUserGroupRoleRecordMapper(),
                0);
        compositeMapper.addMapper(
                new TurbineUserRecordMapper(),
                TurbineUserGroupRolePeer.numColumns);
        criteria.addJoin(TurbineUserGroupRolePeer.USER_ID,
            org.apache.fulcrum.security.torque.om.TurbineUserPeer.USER_ID);

        correctBooleans(criteria);

        List<TurbineUserGroupRole> result = new ArrayList<TurbineUserGroupRole>();
        List<List<Object>> rawResult = doSelect(
                criteria, compositeMapper, conn);
        for (List<Object> rawResultRow : rawResult)
        {
            TurbineUserGroupRole obj1 = (TurbineUserGroupRole) rawResultRow.get(0);
            TurbineUser obj2 = (TurbineUser) rawResultRow.get(1);

            boolean newObject = true;
            for (int j = 0; j < result.size(); j++)
            {
                TurbineUserGroupRole temp_obj1 = result.get(j);
                org.apache.fulcrum.security.torque.om.TurbineUser temp_obj2 = temp_obj1.getTurbineUser();
                if (temp_obj2.getPrimaryKey().equals(obj2.getPrimaryKey()))
                {
                    newObject = false;
                    temp_obj2.addTurbineUserGroupRole(obj1);
                    break;
                }
            }
            if (newObject)
            {
                obj2.initTurbineUserGroupRoles();
                obj2.addTurbineUserGroupRole(obj1);
            }
            result.add(obj1);
        }
        return result;
    }
    /**
     * Selects a collection of dbObjectClassName objects pre-filled with their
     * TurbineGroup objects.
     *
     * @throws TorqueException Any exceptions caught during processing will be
     *         rethrown wrapped into a TorqueException.
     */
    public List<TurbineUserGroupRole> doSelectJoinTurbineGroup(Criteria criteria)
        throws TorqueException
    {
        try (TorqueConnection connection = Transaction.begin(getDatabaseName()))
        {
            List<TurbineUserGroupRole> result
                    = TurbineUserGroupRolePeer.doSelectJoinTurbineGroup(criteria, connection);
            Transaction.commit(connection);
            return result;
        }
    }

    /**
     * Selects a collection of TurbineUserGroupRole objects pre-filled with their
     * TurbineGroup objects.
     *
     * @throws TorqueException Any exceptions caught during processing will be
     *         rethrown wrapped into a TorqueException.
     */
    public List<TurbineUserGroupRole> doSelectJoinTurbineGroup(
            Criteria criteria, Connection conn)
        throws TorqueException
    {
        setDbName(criteria);

        addSelectColumns(criteria);
        org.apache.fulcrum.security.torque.om.TurbineGroupPeer.addSelectColumns(criteria);

        CompositeMapper compositeMapper = new CompositeMapper();
        compositeMapper.addMapper(
                new TurbineUserGroupRoleRecordMapper(),
                0);
        compositeMapper.addMapper(
                new TurbineGroupRecordMapper(),
                TurbineUserGroupRolePeer.numColumns);
        criteria.addJoin(TurbineUserGroupRolePeer.GROUP_ID,
            org.apache.fulcrum.security.torque.om.TurbineGroupPeer.GROUP_ID);

        correctBooleans(criteria);

        List<TurbineUserGroupRole> result = new ArrayList<TurbineUserGroupRole>();
        List<List<Object>> rawResult = doSelect(
                criteria, compositeMapper, conn);
        for (List<Object> rawResultRow : rawResult)
        {
            TurbineUserGroupRole obj1 = (TurbineUserGroupRole) rawResultRow.get(0);
            TurbineGroup obj2 = (TurbineGroup) rawResultRow.get(1);

            boolean newObject = true;
            for (int j = 0; j < result.size(); j++)
            {
                TurbineUserGroupRole temp_obj1 = result.get(j);
                org.apache.fulcrum.security.torque.om.TurbineGroup temp_obj2 = temp_obj1.getTurbineGroup();
                if (temp_obj2.getPrimaryKey().equals(obj2.getPrimaryKey()))
                {
                    newObject = false;
                    temp_obj2.addTurbineUserGroupRole(obj1);
                    break;
                }
            }
            if (newObject)
            {
                obj2.initTurbineUserGroupRoles();
                obj2.addTurbineUserGroupRole(obj1);
            }
            result.add(obj1);
        }
        return result;
    }
    /**
     * Selects a collection of dbObjectClassName objects pre-filled with their
     * TurbineRole objects.
     *
     * @throws TorqueException Any exceptions caught during processing will be
     *         rethrown wrapped into a TorqueException.
     */
    public List<TurbineUserGroupRole> doSelectJoinTurbineRole(Criteria criteria)
        throws TorqueException
    {
        try (TorqueConnection connection = Transaction.begin(getDatabaseName()))
        {
            List<TurbineUserGroupRole> result
                    = TurbineUserGroupRolePeer.doSelectJoinTurbineRole(criteria, connection);
            Transaction.commit(connection);
            return result;
        }
    }

    /**
     * Selects a collection of TurbineUserGroupRole objects pre-filled with their
     * TurbineRole objects.
     *
     * @throws TorqueException Any exceptions caught during processing will be
     *         rethrown wrapped into a TorqueException.
     */
    public List<TurbineUserGroupRole> doSelectJoinTurbineRole(
            Criteria criteria, Connection conn)
        throws TorqueException
    {
        setDbName(criteria);

        addSelectColumns(criteria);
        org.apache.fulcrum.security.torque.om.TurbineRolePeer.addSelectColumns(criteria);

        CompositeMapper compositeMapper = new CompositeMapper();
        compositeMapper.addMapper(
                new TurbineUserGroupRoleRecordMapper(),
                0);
        compositeMapper.addMapper(
                new TurbineRoleRecordMapper(),
                TurbineUserGroupRolePeer.numColumns);
        criteria.addJoin(TurbineUserGroupRolePeer.ROLE_ID,
            org.apache.fulcrum.security.torque.om.TurbineRolePeer.ROLE_ID);

        correctBooleans(criteria);

        List<TurbineUserGroupRole> result = new ArrayList<TurbineUserGroupRole>();
        List<List<Object>> rawResult = doSelect(
                criteria, compositeMapper, conn);
        for (List<Object> rawResultRow : rawResult)
        {
            TurbineUserGroupRole obj1 = (TurbineUserGroupRole) rawResultRow.get(0);
            TurbineRole obj2 = (TurbineRole) rawResultRow.get(1);

            boolean newObject = true;
            for (int j = 0; j < result.size(); j++)
            {
                TurbineUserGroupRole temp_obj1 = result.get(j);
                org.apache.fulcrum.security.torque.om.TurbineRole temp_obj2 = temp_obj1.getTurbineRole();
                if (temp_obj2.getPrimaryKey().equals(obj2.getPrimaryKey()))
                {
                    newObject = false;
                    temp_obj2.addTurbineUserGroupRole(obj1);
                    break;
                }
            }
            if (newObject)
            {
                obj2.initTurbineUserGroupRoles();
                obj2.addTurbineUserGroupRole(obj1);
            }
            result.add(obj1);
        }
        return result;
    }

    /**
     * selects a collection of TurbineUserGroupRole objects pre-filled with
     * all related objects.
     *
     * This method is protected by default in order to keep the public
     * api reasonable.  You can provide public methods for those you
     * actually need in TurbineUserGroupRolePeerImpl.
     *
     * @throws TorqueException Any exceptions caught during processing will be
     *         rethrown wrapped into a TorqueException.
     */
    protected List<TurbineUserGroupRole> doSelectJoinAllExceptTurbineUser(Criteria criteria)
        throws TorqueException
    {
        try (TorqueConnection connection = Transaction.begin(getDatabaseName()))
        {
            List<TurbineUserGroupRole> result
                    = TurbineUserGroupRolePeer.doSelectJoinAllExceptTurbineUser(criteria, connection);
            Transaction.commit(connection);
            return result;
        }
    }

    /**
     * selects a collection of TurbineUserGroupRole objects pre-filled with
     * related objects.
     *
     * This method is protected by default in order to keep the public
     * api reasonable.  You can provide public methods for those you
     * actually need in TurbineUserGroupRolePeerImpl.
     *
     * @throws TorqueException Any exceptions caught during processing will be
     *         rethrown wrapped into a TorqueException.
     */
    protected List<TurbineUserGroupRole> doSelectJoinAllExceptTurbineUser(Criteria criteria, Connection conn)
        throws TorqueException
    {
        setDbName(criteria);

        CompositeMapper compositeMapper = new CompositeMapper();
        compositeMapper.addMapper(new TurbineUserGroupRoleRecordMapper(), 0);
        TurbineUserGroupRolePeer.addSelectColumns(criteria);
        int offset = TurbineUserGroupRolePeer.numColumns;
 
        org.apache.fulcrum.security.torque.om.TurbineGroupPeer.addSelectColumns(criteria);
        criteria.addJoin(TurbineUserGroupRolePeer.GROUP_ID, org.apache.fulcrum.security.torque.om.TurbineGroupPeer.GROUP_ID);
        compositeMapper.addMapper(new TurbineGroupRecordMapper(), offset);
        offset = offset + org.apache.fulcrum.security.torque.om.TurbineGroupPeer.numColumns;
 
        org.apache.fulcrum.security.torque.om.TurbineRolePeer.addSelectColumns(criteria);
        criteria.addJoin(TurbineUserGroupRolePeer.ROLE_ID, org.apache.fulcrum.security.torque.om.TurbineRolePeer.ROLE_ID);
        compositeMapper.addMapper(new TurbineRoleRecordMapper(), offset);
        offset = offset + org.apache.fulcrum.security.torque.om.TurbineRolePeer.numColumns;

        correctBooleans(criteria);

        List<TurbineUserGroupRole> result = new ArrayList<TurbineUserGroupRole>();
        List<List<Object>> rawResult = doSelect(
                criteria, compositeMapper, conn);
        for (List<Object> rawResultRow : rawResult)
        {
            TurbineUserGroupRole turbineUserGroupRole = (TurbineUserGroupRole) rawResultRow.get(0);

            org.apache.fulcrum.security.torque.om.TurbineGroup obj1 = (org.apache.fulcrum.security.torque.om.TurbineGroup) rawResultRow.get(1);
            boolean newObject = true;
            for (int j = 0; j < result.size(); j++)
            {
                org.apache.fulcrum.security.torque.om.TurbineUserGroupRole temp_turbineUserGroupRole = result.get(j);
                org.apache.fulcrum.security.torque.om.TurbineGroup temp_obj1 = temp_turbineUserGroupRole.getTurbineGroup();
                if (temp_obj1.getPrimaryKey().equals(obj1.getPrimaryKey()))
                {
                    newObject = false;
                    temp_obj1.addTurbineUserGroupRole(turbineUserGroupRole);
                    break;
                }
            }
            if (newObject)
            {
                obj1.initTurbineUserGroupRoles();
                obj1.addTurbineUserGroupRole(turbineUserGroupRole);
            }

            org.apache.fulcrum.security.torque.om.TurbineRole obj2 = (org.apache.fulcrum.security.torque.om.TurbineRole) rawResultRow.get(2);
            newObject = true;
            for (int j = 0; j < result.size(); j++)
            {
                org.apache.fulcrum.security.torque.om.TurbineUserGroupRole temp_turbineUserGroupRole = result.get(j);
                org.apache.fulcrum.security.torque.om.TurbineRole temp_obj2 = temp_turbineUserGroupRole.getTurbineRole();
                if (temp_obj2.getPrimaryKey().equals(obj2.getPrimaryKey()))
                {
                    newObject = false;
                    temp_obj2.addTurbineUserGroupRole(turbineUserGroupRole);
                    break;
                }
            }
            if (newObject)
            {
                obj2.initTurbineUserGroupRoles();
                obj2.addTurbineUserGroupRole(turbineUserGroupRole);
            }
            result.add(turbineUserGroupRole);
        }
        return result;
    }
    /**
     * selects a collection of TurbineUserGroupRole objects pre-filled with
     * all related objects.
     *
     * This method is protected by default in order to keep the public
     * api reasonable.  You can provide public methods for those you
     * actually need in TurbineUserGroupRolePeerImpl.
     *
     * @throws TorqueException Any exceptions caught during processing will be
     *         rethrown wrapped into a TorqueException.
     */
    protected List<TurbineUserGroupRole> doSelectJoinAllExceptTurbineGroup(Criteria criteria)
        throws TorqueException
    {
        try (TorqueConnection connection = Transaction.begin(getDatabaseName()))
        {
            List<TurbineUserGroupRole> result
                    = TurbineUserGroupRolePeer.doSelectJoinAllExceptTurbineGroup(criteria, connection);
            Transaction.commit(connection);
            return result;
        }
    }

    /**
     * selects a collection of TurbineUserGroupRole objects pre-filled with
     * related objects.
     *
     * This method is protected by default in order to keep the public
     * api reasonable.  You can provide public methods for those you
     * actually need in TurbineUserGroupRolePeerImpl.
     *
     * @throws TorqueException Any exceptions caught during processing will be
     *         rethrown wrapped into a TorqueException.
     */
    protected List<TurbineUserGroupRole> doSelectJoinAllExceptTurbineGroup(Criteria criteria, Connection conn)
        throws TorqueException
    {
        setDbName(criteria);

        CompositeMapper compositeMapper = new CompositeMapper();
        compositeMapper.addMapper(new TurbineUserGroupRoleRecordMapper(), 0);
        TurbineUserGroupRolePeer.addSelectColumns(criteria);
        int offset = TurbineUserGroupRolePeer.numColumns;
 
        org.apache.fulcrum.security.torque.om.TurbineUserPeer.addSelectColumns(criteria);
        criteria.addJoin(TurbineUserGroupRolePeer.USER_ID, org.apache.fulcrum.security.torque.om.TurbineUserPeer.USER_ID);
        compositeMapper.addMapper(new TurbineUserRecordMapper(), offset);
        offset = offset + org.apache.fulcrum.security.torque.om.TurbineUserPeer.numColumns;
 
        org.apache.fulcrum.security.torque.om.TurbineRolePeer.addSelectColumns(criteria);
        criteria.addJoin(TurbineUserGroupRolePeer.ROLE_ID, org.apache.fulcrum.security.torque.om.TurbineRolePeer.ROLE_ID);
        compositeMapper.addMapper(new TurbineRoleRecordMapper(), offset);
        offset = offset + org.apache.fulcrum.security.torque.om.TurbineRolePeer.numColumns;

        correctBooleans(criteria);

        List<TurbineUserGroupRole> result = new ArrayList<TurbineUserGroupRole>();
        List<List<Object>> rawResult = doSelect(
                criteria, compositeMapper, conn);
        for (List<Object> rawResultRow : rawResult)
        {
            TurbineUserGroupRole turbineUserGroupRole = (TurbineUserGroupRole) rawResultRow.get(0);

            org.apache.fulcrum.security.torque.om.TurbineUser obj1 = (org.apache.fulcrum.security.torque.om.TurbineUser) rawResultRow.get(1);
            boolean newObject = true;
            for (int j = 0; j < result.size(); j++)
            {
                org.apache.fulcrum.security.torque.om.TurbineUserGroupRole temp_turbineUserGroupRole = result.get(j);
                org.apache.fulcrum.security.torque.om.TurbineUser temp_obj1 = temp_turbineUserGroupRole.getTurbineUser();
                if (temp_obj1.getPrimaryKey().equals(obj1.getPrimaryKey()))
                {
                    newObject = false;
                    temp_obj1.addTurbineUserGroupRole(turbineUserGroupRole);
                    break;
                }
            }
            if (newObject)
            {
                obj1.initTurbineUserGroupRoles();
                obj1.addTurbineUserGroupRole(turbineUserGroupRole);
            }

            org.apache.fulcrum.security.torque.om.TurbineRole obj2 = (org.apache.fulcrum.security.torque.om.TurbineRole) rawResultRow.get(2);
            newObject = true;
            for (int j = 0; j < result.size(); j++)
            {
                org.apache.fulcrum.security.torque.om.TurbineUserGroupRole temp_turbineUserGroupRole = result.get(j);
                org.apache.fulcrum.security.torque.om.TurbineRole temp_obj2 = temp_turbineUserGroupRole.getTurbineRole();
                if (temp_obj2.getPrimaryKey().equals(obj2.getPrimaryKey()))
                {
                    newObject = false;
                    temp_obj2.addTurbineUserGroupRole(turbineUserGroupRole);
                    break;
                }
            }
            if (newObject)
            {
                obj2.initTurbineUserGroupRoles();
                obj2.addTurbineUserGroupRole(turbineUserGroupRole);
            }
            result.add(turbineUserGroupRole);
        }
        return result;
    }
    /**
     * selects a collection of TurbineUserGroupRole objects pre-filled with
     * all related objects.
     *
     * This method is protected by default in order to keep the public
     * api reasonable.  You can provide public methods for those you
     * actually need in TurbineUserGroupRolePeerImpl.
     *
     * @throws TorqueException Any exceptions caught during processing will be
     *         rethrown wrapped into a TorqueException.
     */
    protected List<TurbineUserGroupRole> doSelectJoinAllExceptTurbineRole(Criteria criteria)
        throws TorqueException
    {
        try (TorqueConnection connection = Transaction.begin(getDatabaseName()))
        {
            List<TurbineUserGroupRole> result
                    = TurbineUserGroupRolePeer.doSelectJoinAllExceptTurbineRole(criteria, connection);
            Transaction.commit(connection);
            return result;
        }
    }

    /**
     * selects a collection of TurbineUserGroupRole objects pre-filled with
     * related objects.
     *
     * This method is protected by default in order to keep the public
     * api reasonable.  You can provide public methods for those you
     * actually need in TurbineUserGroupRolePeerImpl.
     *
     * @throws TorqueException Any exceptions caught during processing will be
     *         rethrown wrapped into a TorqueException.
     */
    protected List<TurbineUserGroupRole> doSelectJoinAllExceptTurbineRole(Criteria criteria, Connection conn)
        throws TorqueException
    {
        setDbName(criteria);

        CompositeMapper compositeMapper = new CompositeMapper();
        compositeMapper.addMapper(new TurbineUserGroupRoleRecordMapper(), 0);
        TurbineUserGroupRolePeer.addSelectColumns(criteria);
        int offset = TurbineUserGroupRolePeer.numColumns;
 
        org.apache.fulcrum.security.torque.om.TurbineUserPeer.addSelectColumns(criteria);
        criteria.addJoin(TurbineUserGroupRolePeer.USER_ID, org.apache.fulcrum.security.torque.om.TurbineUserPeer.USER_ID);
        compositeMapper.addMapper(new TurbineUserRecordMapper(), offset);
        offset = offset + org.apache.fulcrum.security.torque.om.TurbineUserPeer.numColumns;
 
        org.apache.fulcrum.security.torque.om.TurbineGroupPeer.addSelectColumns(criteria);
        criteria.addJoin(TurbineUserGroupRolePeer.GROUP_ID, org.apache.fulcrum.security.torque.om.TurbineGroupPeer.GROUP_ID);
        compositeMapper.addMapper(new TurbineGroupRecordMapper(), offset);
        offset = offset + org.apache.fulcrum.security.torque.om.TurbineGroupPeer.numColumns;

        correctBooleans(criteria);

        List<TurbineUserGroupRole> result = new ArrayList<TurbineUserGroupRole>();
        List<List<Object>> rawResult = doSelect(
                criteria, compositeMapper, conn);
        for (List<Object> rawResultRow : rawResult)
        {
            TurbineUserGroupRole turbineUserGroupRole = (TurbineUserGroupRole) rawResultRow.get(0);

            org.apache.fulcrum.security.torque.om.TurbineUser obj1 = (org.apache.fulcrum.security.torque.om.TurbineUser) rawResultRow.get(1);
            boolean newObject = true;
            for (int j = 0; j < result.size(); j++)
            {
                org.apache.fulcrum.security.torque.om.TurbineUserGroupRole temp_turbineUserGroupRole = result.get(j);
                org.apache.fulcrum.security.torque.om.TurbineUser temp_obj1 = temp_turbineUserGroupRole.getTurbineUser();
                if (temp_obj1.getPrimaryKey().equals(obj1.getPrimaryKey()))
                {
                    newObject = false;
                    temp_obj1.addTurbineUserGroupRole(turbineUserGroupRole);
                    break;
                }
            }
            if (newObject)
            {
                obj1.initTurbineUserGroupRoles();
                obj1.addTurbineUserGroupRole(turbineUserGroupRole);
            }

            org.apache.fulcrum.security.torque.om.TurbineGroup obj2 = (org.apache.fulcrum.security.torque.om.TurbineGroup) rawResultRow.get(2);
            newObject = true;
            for (int j = 0; j < result.size(); j++)
            {
                org.apache.fulcrum.security.torque.om.TurbineUserGroupRole temp_turbineUserGroupRole = result.get(j);
                org.apache.fulcrum.security.torque.om.TurbineGroup temp_obj2 = temp_turbineUserGroupRole.getTurbineGroup();
                if (temp_obj2.getPrimaryKey().equals(obj2.getPrimaryKey()))
                {
                    newObject = false;
                    temp_obj2.addTurbineUserGroupRole(turbineUserGroupRole);
                    break;
                }
            }
            if (newObject)
            {
                obj2.initTurbineUserGroupRoles();
                obj2.addTurbineUserGroupRole(turbineUserGroupRole);
            }
            result.add(turbineUserGroupRole);
        }
        return result;
    }



}
