package org.apache.fulcrum.security.torque.om;

import java.sql.Connection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.HashSet;
import java.util.Objects;
import java.util.stream.Collectors;

import org.apache.torque.NoRowsException;
import org.apache.torque.TooManyRowsException;
import org.apache.torque.TorqueException;
import org.apache.torque.criteria.Criteria;
import org.apache.torque.criteria.Criterion;
import org.apache.torque.om.mapper.RecordMapper;
import org.apache.torque.om.ObjectKey;
import org.apache.torque.om.SimpleKey;
import org.apache.torque.map.TableMap;
import org.apache.torque.util.TorqueConnection;
import org.apache.torque.util.Transaction;
import org.apache.torque.util.ColumnValues;
import org.apache.torque.util.JdbcTypedValue;



/**
 * The skeleton for this class was autogenerated by Torque on:
 *
 * [Thu Nov 04 10:24:03 CET 2021]
 *
 * You should not use this class directly.  It should not even be
 * extended; all references should be to TurbinePermissionPeer
 */

@SuppressWarnings("unused")
public abstract class BaseTurbinePermissionPeerImpl
    extends org.apache.torque.util.AbstractPeerImpl<TurbinePermission>
{
    /** Serial version */
    private static final long serialVersionUID = 1636017843346L;



    /**
     * Constructor.
     * The recordMapper, tableMap and databaseName fields are correctly
     * initialized.
     */
    public BaseTurbinePermissionPeerImpl()
    {
        this(new TurbinePermissionRecordMapper(),
            TurbinePermissionPeer.TABLE,
            TurbinePermissionPeer.DATABASE_NAME);
    }

    /**
     * Constructor providing the objects to be injected as parameters.
     *
     * @param recordMapper a record mapper to map JDBC result sets to objects
     * @param tableMap the default table map
     * @param databaseName the name of the database
     */
    public BaseTurbinePermissionPeerImpl(
            RecordMapper<TurbinePermission> recordMapper, 
            TableMap tableMap,
            String databaseName)
    {
        super(recordMapper, tableMap, databaseName);
    }


    /**
     * Returns a new instance of the Data object class
     */
    public TurbinePermission getDbObjectInstance()
    {
        return new TurbinePermission();
    }


    /**
     * Method to do updates.  This method is to be used during a transaction,
     * otherwise use the doUpdate(Criteria) method.
     *
     * @param columnValues the values to update plus the primary key
     *        identifying the row to update.
     * @param con the connection to use, not null.
     *
     * @return the number of affected rows.
     *
     * @throws TorqueException Any exceptions caught during processing will be
     *         rethrown wrapped into a TorqueException.
     */
    public int doUpdate(ColumnValues columnValues, Connection con)
        throws TorqueException
    {
        Criteria selectCriteria = new Criteria(getDatabaseName());
        correctBooleans(columnValues);

        {
            JdbcTypedValue pkValue
                = columnValues.remove(TurbinePermissionPeer.PERMISSION_ID);
            if (pkValue == null)
            {
                throw new TorqueException(
                        "The value for the primary key column "
                        + "TurbinePermissionPeer.PERMISSION_ID"
                        + " must be set");
            }
            if (pkValue.getSqlExpression() == null)
            {
                selectCriteria.where(
                        TurbinePermissionPeer.PERMISSION_ID,
                        pkValue.getValue());
            }
            else
            {
                selectCriteria.where(
                        TurbinePermissionPeer.PERMISSION_ID,
                        pkValue.getSqlExpression());
            }
        }


        int rowCount = doUpdate(selectCriteria, columnValues, con);
        return rowCount;
    }

    /**
     * Deletes a data object, i.e. a row in a table, in the database.
     *
     * @param obj the data object to delete in the database, not null.
     *
     * @return the number of deleted rows.
     *
     * @throws TorqueException Any exceptions caught during processing will be
     *         rethrown wrapped into a TorqueException.
     */
    public int doDelete(TurbinePermission obj) throws TorqueException
    {
        int result = doDelete(buildCriteria(obj.getPrimaryKey()));
        obj.setDeleted(true);
        return result;
    }

    /**
     * Deletes a data object, i.e. a row in a table, in the database.
     * This method is to be used during a transaction, otherwise use the
     * doDelete(TurbinePermission) method.
     *
     * @param obj the data object to delete in the database, not null.
     * @param con the connection to use, not null.
     *
     * @return the number of deleted rows.
     *
     * @throws TorqueException Any exceptions caught during processing will be
     *         rethrown wrapped into a TorqueException.
     */
    public int doDelete(TurbinePermission obj, Connection con)
        throws TorqueException
    {
        int result = doDelete(buildCriteria(obj.getPrimaryKey()), con);
        obj.setDeleted(true);
        return result;
    }

    /**
     * Deletes data objects, i.e. rows in a table, in the database.
     *
     * @param objects the data object to delete in the database, not null,
     *        may not contain null.
     *
     * @return the number of deleted rows.
     *
     * @throws TorqueException Any exceptions caught during processing will be
     *         rethrown wrapped into a TorqueException.
     */
    public int doDelete(Collection<TurbinePermission> objects)
            throws TorqueException
    {
        int result = doDelete(buildPkCriteria(objects));
        objects.forEach(object -> object.setDeleted(true));
        return result;
    }

    /**
     * Deletes data objects, i.e. rows in a table, in the database.
     * This method uses the passed connection to delete the rows;
     * if a transaction is open in the connection, the deletion happens inside
     * this transaction.
     *
     * @param objects the data objects to delete in the database, not null,
     *        may not contain null.
     * @param con the connection to use for deleting, not null.
     *
     * @return the number of deleted rows.
     *
     * @throws TorqueException Any exceptions caught during processing will be
     *         rethrown wrapped into a TorqueException.
     */
    public int doDelete(
            Collection<TurbinePermission> objects,
            Connection con)
        throws TorqueException
    {
        int result = doDelete(buildPkCriteria(objects), con);
        objects.forEach(object -> object.setDeleted(true));
        return result;
    }

    /** 
     * Build a Criteria object which selects all objects which have a given
     * primary key.
     *
     * @param pk the primary key value to build the criteria from, not null.
     */
    public Criteria buildCriteria(ObjectKey<?> pk)
    {
        Criteria criteria = new Criteria();
        criteria.and(TurbinePermissionPeer.PERMISSION_ID, pk);
        return criteria;
     }

    /** 
     * Build a Criteria object which selects all objects which primary keys
     * are contained in the passed collection.
     *
     * @param pks the primary key values to build the criteria from, not null,
     *        may not contain null.
     */
    public Criteria buildCriteria(Collection<ObjectKey<?>> pks)
    {
        Criteria criteria = new Criteria();
        criteria.andIn(TurbinePermissionPeer.PERMISSION_ID, pks);
        return criteria;
     }


    /** 
     * Build a Criteria object which selects all passed objects using their
     * primary key. Objects which do not yet have a primary key are ignored.
     *
     * @param objects the objects to build the criteria from, not null,
     *        may not contain null.
     */
    public Criteria buildPkCriteria(
            Collection<TurbinePermission> objects)
    {
        return buildCriteria(objects.stream()
                .map(object -> object.getPrimaryKey())
                .collect(Collectors.toList()));
    }

    /** 
     * Build a Criteria object from the data object for this peer.
     * The primary key columns are only added if the object is not new.
     *
     * @param obj the object to build the criteria from, not null.
     */
    public Criteria buildCriteria(TurbinePermission obj)
    {
        Criteria criteria = new Criteria(getDatabaseName());
        if (!obj.isNew())
        {
            criteria.and(TurbinePermissionPeer.PERMISSION_ID, obj.getEntityId());
        }
        criteria.and(TurbinePermissionPeer.PERMISSION_NAME, obj.getEntityName());
        return criteria;
    }

    /** 
     * Build a Criteria object from the data object for this peer,
     * skipping all binary columns.
     *
     * @param obj the object to build the criteria from, not null.
     */
    public Criteria buildSelectCriteria(TurbinePermission obj)
    {
        Criteria criteria = new Criteria(getDatabaseName());
        if (!obj.isNew())
        {
            criteria.and(TurbinePermissionPeer.PERMISSION_ID, obj.getEntityId());
        }
        criteria.and(TurbinePermissionPeer.PERMISSION_NAME, obj.getEntityName());
        return criteria;
    }

    /** 
     * Returns the contents of the object as ColumnValues object.
     * Primary key columns which are generated on insertion are not
     * added to the returned object if they still have their initial
     * value. Also, columns which have the useDatabaseDefaultValue
     * flag set to true are also not added to the returned object
     * if they still have their initial value.
     *
     * @throws TorqueException if the table map cannot be retrieved
     *         (should not happen).
     */
    public ColumnValues buildColumnValues(TurbinePermission turbinePermission)
            throws TorqueException
    {
        ColumnValues columnValues = new ColumnValues();
        if (!turbinePermission.isNew() 
            || turbinePermission.getEntityId() != null)
        {
            columnValues.put(
                    TurbinePermissionPeer.PERMISSION_ID,
                    new JdbcTypedValue(
                        turbinePermission.getEntityId(),
                        4));
        }
        columnValues.put(
                TurbinePermissionPeer.PERMISSION_NAME,
                new JdbcTypedValue(
                    turbinePermission.getEntityName(),
                    12));
        return columnValues;
    }

    /**
     * Retrieve a single object by pk
     *
     * @param pk the primary key
     * @throws TorqueException Any exceptions caught during processing will be
     *         rethrown wrapped into a TorqueException.
     * @throws NoRowsException Primary key was not found in database.
     * @throws TooManyRowsException Primary key was not found in database.
     */
    public TurbinePermission retrieveByPK(Integer pk)
        throws TorqueException, NoRowsException, TooManyRowsException
    {
        return retrieveByPK(SimpleKey.keyFor(pk));
    }

    /**
     * Retrieve a single object by pk
     *
     * @param pk the primary key
     * @param con the connection to use
     * @throws TorqueException Any exceptions caught during processing will be
     *         rethrown wrapped into a TorqueException.
     * @throws NoRowsException Primary key was not found in database.
     * @throws TooManyRowsException Primary key was not found in database.
     */
    public TurbinePermission retrieveByPK(Integer pk, Connection con)
        throws TorqueException, NoRowsException, TooManyRowsException
    {
        return retrieveByPK(SimpleKey.keyFor(pk), con);
    }
    
    
    

    /**
     * Retrieve a single object by pk
     *
     * @param pk the primary key
     * @throws TorqueException Any exceptions caught during processing will be
     *         rethrown wrapped into a TorqueException.
     * @throws NoRowsException Primary key was not found in database.
     * @throws TooManyRowsException Primary key was not found in database.
     */
    public TurbinePermission retrieveByPK(ObjectKey<?> pk)
        throws TorqueException, NoRowsException, TooManyRowsException
    {
        try (TorqueConnection connection = Transaction.begin(getDatabaseName()))
        {
            TurbinePermission result = retrieveByPK(pk, connection);
            Transaction.commit(connection);
            return result;
        }
    }

    /**
     * Retrieve a single object by pk
     *
     * @param pk the primary key
     * @param con the connection to use
     * @throws TorqueException Any exceptions caught during processing will be
     *         rethrown wrapped into a TorqueException.
     * @throws NoRowsException Primary key was not found in database.
     * @throws TooManyRowsException Primary key was not found in database.
     */
    public TurbinePermission retrieveByPK(ObjectKey<?> pk, Connection con)
        throws TorqueException, NoRowsException, TooManyRowsException
    {
        Criteria criteria = buildCriteria(pk);
        TurbinePermission v = doSelectSingleRecord(criteria, con);
        if (v == null)
        {
            throw new NoRowsException("Failed to select a row.");
        }

        return v;
    }


    /**
     * Retrieve multiple objects by pk.
     *
     * @param pks List of primary keys.
     *        Entries in pks which do not match entries in the database are ignored.
     *
     * @return the list of matching objects, not null.
     *
     * @throws TorqueException Any exceptions caught during processing will be
     *         rethrown wrapped into a TorqueException.
     */
    public List<TurbinePermission> retrieveByTypedPKs(Collection<Integer> pks)
        throws TorqueException
    {
        try (TorqueConnection connection = Transaction.begin(getDatabaseName()))
        {
            List<TurbinePermission> result = retrieveByTypedPKs(pks, connection);
            Transaction.commit(connection);
            return result;
        }
    }

    /**
     * Retrieve multiple objects by pk.
     *
     * @param pks List of primary keys.
     *        Entries in pks which do not match entries in the database are ignored.
     * @param dbcon the connection to use
     *
     * @return the list of matching objects, not null.
     *
     * @throws TorqueException Any exceptions caught during processing will be
     *         rethrown wrapped into a TorqueException.
     */
    public List<TurbinePermission> retrieveByTypedPKs(
                Collection<Integer> pks,
                Connection dbcon)
            throws TorqueException
    {
        if (pks == null || pks.size() == 0)
        {
            return new ArrayList<TurbinePermission>();
        }
        List<ObjectKey<?>> objectKeyList = new ArrayList<ObjectKey<?>>();
        for (Integer pk : pks)
        {
            objectKeyList.add(SimpleKey.keyFor(pk));
        }
        Criteria criteria = buildCriteria(objectKeyList);
        List<TurbinePermission> result = doSelect(criteria, dbcon);
        return result;
    }

    /**
     * Retrieve multiple objects by pk.
     *
     * @param pks List of primary keys.
     *        Entries in pks which do not match entries in the database are ignored.
     *
     * @return the list of matching objects, not null.
     *
     * @throws TorqueException Any exceptions caught during processing will be
     *         rethrown wrapped into a TorqueException.
     */
    public List<TurbinePermission> retrieveByObjectKeys(Collection<ObjectKey<?>> pks)
        throws TorqueException
    {
        try (TorqueConnection connection = Transaction.begin(getDatabaseName()))
        {
            List<TurbinePermission> result = retrieveByObjectKeys(pks, connection);
            Transaction.commit(connection);
            return result;
        }
    }

    /**
     * Retrieve multiple objects by pk.
     *
     * @param pks List of primary keys.
     *        Entries in pks which do not match entries in the database are ignored.
     * @param dbcon the connection to use
     *
     * @return the list of matching objects, not null.
     *
     * @throws TorqueException Any exceptions caught during processing will be
     *         rethrown wrapped into a TorqueException.
     */
    public List<TurbinePermission> retrieveByObjectKeys(
                Collection<ObjectKey<?>> pks,
                Connection dbcon)
            throws TorqueException
    {
        if (pks == null || pks.size() == 0)
        {
            return new ArrayList<TurbinePermission>();
        }
        Criteria criteria = buildCriteria(pks);
        List<TurbinePermission> result = doSelect(criteria, dbcon);
        return result;
    }




    /** 
     * Saves the passed collection as linked objects.
     * This means the following is done:
     * <ul>
     *  <li>
     *    The current collection of objects which are linked to toLinkTo
     *    and which are also in the list toSave is read from the database
     *    into the list intersection.
     *  </li>
     *  <li>
     *    All objects in toSave which are not in intersection are inserted.
     *  </li>
     *  <li>
     *    All objects in intersection are updated with the 
     *    corresponding values in toSave and saved.
     *  </li>
     *  <li>
     *    All objects in the database which are linked to toLinkTo but are 
     *    not in toSave are deleted from the database.
     *  </li>
     * </ul>
     *
     * @param toLinkTo the object which collections should be set with the
     *        values in toSave.
     * @param toSave Contains the objects to save, not null, 
     *        may not contain null.
     *
     * @throws TorqueException if an error accessing the database occurs.
     * @throws NullPointerException if toSave is null or contains null elements.
     */
    public void setAndSaveTurbineRolePermissions(
            TurbinePermission toLinkTo,
            Collection<TurbineRolePermission> toSave) 
        throws TorqueException
    {
        try (TorqueConnection connection = Transaction.begin(getDatabaseName()))
        {
            setAndSaveTurbineRolePermissions(toLinkTo, toSave, connection);
            Transaction.commit(connection);
        }
    }

    /** 
     * Saves the passed collection as linked objects.
     * This means the following is done:
     * <ul>
     *  <li>
     *    The current collection of objects which are linked to toLinkTo
     *    and which are also in the list toSave is read from the database
     *    into the list intersection.
     *  </li>
     *  <li>
     *    All objects in toSave which are not in intersection are inserted.
     *  </li>
     *  <li>
     *    All objects in intersection are updated with the 
     *    corresponding values in toSave and saved.
     *  </li>
     *  <li>
     *    All objects in the database which are linked to toLinkTo but are 
     *    not in toSave are deleted from the database.
     *  </li>
     * </ul>
     *
     * @param toLinkTo the object which collections should be set with the
     *        values in toSave.
     * @param toSave Contains the objects to save, not null, 
     *        may not contain null.
     * @param connection the database connection to use.
     *
     * @throws TorqueException if an error accessing the database occurs.
     * @throws NullPointerException if toSave is null or contains null elements.
     */
    public void setAndSaveTurbineRolePermissions(
            TurbinePermission toLinkTo,
            Collection<TurbineRolePermission> toSave,
            Connection connection) 
        throws TorqueException
    {
        // make sure the collection cache in toLinkTo represents the current
        // database state
        toLinkTo.resetTurbineRolePermission();
        toLinkTo.getTurbineRolePermissions(connection);
        ObjectKey<?> localKey = toLinkTo.getPrimaryKey();

        Criteria criteria = new Criteria();
        Criterion onlyReferencingCriterion = new Criterion(
                TurbineRolePermissionPeer.PERMISSION_ID, 
                localKey);
        criteria.where(onlyReferencingCriterion);
        Set<ObjectKey<?>> toSaveKeys = new HashSet<ObjectKey<?>>();
        for (TurbineRolePermission toSaveElement : toSave)
        {
            ObjectKey<?> toSaveKey = toSaveElement.getPrimaryKey();
            if (toSaveKey.getValue() != null)
            {
                toSaveKeys.add(toSaveKey);
            }
        }
        
        // calculate intersection between objects in the database
        // and objects in the list
        List<TurbineRolePermission> intersection;
        if (toSaveKeys.isEmpty())
        {
            intersection = new ArrayList<TurbineRolePermission>();
        }
        else
        {
            Criterion toSaveKeyCriterion = null;
            for (ObjectKey<?> toSaveKey : toSaveKeys)
            {
                SimpleKey<?>[] toSavePrimaryKeys = (SimpleKey[]) toSaveKey.getValue();
                 Criterion p0 = new Criterion(
                        TurbineRolePermissionPeer.ROLE_ID,
                        toSavePrimaryKeys[0]);
                 Criterion p1 = new Criterion(
                        TurbineRolePermissionPeer.PERMISSION_ID,
                        toSavePrimaryKeys[1]);
                p0.and(p1);
                if (toSaveKeyCriterion == null)
                {
                    toSaveKeyCriterion = p0;
                }
                else
                {
                    toSaveKeyCriterion.or(p0);
                }
            }
            criteria.and(toSaveKeyCriterion);
            intersection = TurbineRolePermissionPeer.doSelect(
                    criteria,
                    connection);
        }
        if (toLinkTo.isTurbineRolePermissionsInitialized())
        {
            toLinkTo.getTurbineRolePermissions().clear();
        }
        else
        {
           toLinkTo.initTurbineRolePermissions();
        }
        for (TurbineRolePermission toSaveElement : toSave)
        {
            int listIndex = intersection.indexOf(toSaveElement);
            if (listIndex == -1)
            {
                toLinkTo.addTurbineRolePermission(toSaveElement);
                toSaveElement.save(connection);
            }
            else
            {
                toLinkTo.addTurbineRolePermission(toSaveElement);
                toSaveElement.setNew(false);
                if (!toSaveElement.valueEquals(intersection.get(listIndex)))
                {
                    //force saving if content differs
                    toSaveElement.setModified(true);
                }
                toSaveElement.save(connection);
            }
            toSaveKeys.add(toSaveElement.getPrimaryKey());
        }
        
        // delete elements not in intersection
        Criteria deleteCriteria = new Criteria();
        deleteCriteria.where(onlyReferencingCriterion);
        if (!toSaveKeys.isEmpty())
        {
            Criterion toSaveKeyCriterion = null;
            for (ObjectKey<?> toSaveKey : toSaveKeys)
            {
                SimpleKey<?>[] toSavePrimaryKeys = (SimpleKey[]) toSaveKey.getValue();
                  Criterion p0 = new Criterion(
                         TurbineRolePermissionPeer.ROLE_ID,
                         toSavePrimaryKeys[0],
                         Criteria.NOT_EQUAL);
                  Criterion p1 = new Criterion(
                         TurbineRolePermissionPeer.PERMISSION_ID,
                         toSavePrimaryKeys[1],
                         Criteria.NOT_EQUAL);
                p0.or(p1);
                if (toSaveKeyCriterion == null)
                {
                    toSaveKeyCriterion = p0;
                }
                else
                {
                    toSaveKeyCriterion.and(p0);
                }
            }
            deleteCriteria.and(toSaveKeyCriterion);
        }
        TurbineRolePermissionPeer.doDelete(deleteCriteria, connection);
    }


}
