/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fulcrum.security.model.test;

import org.apache.fulcrum.security.SecurityService;
import org.apache.fulcrum.security.UserManager;
import org.apache.fulcrum.security.acl.AccessControlList;
import org.apache.fulcrum.security.entity.User;
import org.apache.fulcrum.security.util.EntityExistsException;
import org.apache.fulcrum.security.util.PasswordMismatchException;
import org.apache.fulcrum.security.util.UnknownEntityException;
import org.apache.fulcrum.security.util.UserSet;
import org.apache.fulcrum.testcontainer.BaseUnit5Test;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public abstract class AbstractUserManagerTest
extends BaseUnit5Test {
    protected User user;
    protected UserManager userManager;
    protected SecurityService securityService;

    @Test
    public void testCheckExists() throws Exception {
        this.user = this.userManager.getUserInstance("Philip");
        this.userManager.addUser(this.user, "bobo");
        Assertions.assertTrue((boolean)this.userManager.checkExists("philip"));
        Assertions.assertTrue((boolean)this.userManager.checkExists(this.user));
        Assertions.assertFalse((boolean)this.userManager.checkExists("ImaginaryFriend"));
        this.user = this.userManager.getUserInstance("ImaginaryFriend");
        Assertions.assertFalse((boolean)this.userManager.checkExists(this.user));
    }

    @Test
    public void testCheckExistsWithString() throws Exception {
        this.user = this.userManager.getUserInstance("Philip2");
        this.userManager.addUser(this.user, "bobo");
        Assertions.assertTrue((boolean)this.userManager.checkExists("philip2"));
        Assertions.assertTrue((boolean)this.userManager.checkExists(this.user.getName()));
        Assertions.assertFalse((boolean)this.userManager.checkExists("ImaginaryFriend2"));
        this.user = this.userManager.getUserInstance("ImaginaryFriend2");
        Assertions.assertFalse((boolean)this.userManager.checkExists(this.user.getName()));
    }

    @Test
    public void testGetUserString() throws Exception {
        this.user = this.userManager.getUserInstance("QuietMike");
        this.userManager.addUser(this.user, "bobo");
        this.user = this.userManager.getUser("QuietMike");
        Assertions.assertNotNull((Object)this.user);
    }

    @Test
    public void testGetUserById() throws Exception {
        this.user = this.userManager.getUserInstance("QuietMike2");
        this.userManager.addUser(this.user, "bobo");
        User user2 = this.userManager.getUserById(this.user.getId());
        Assertions.assertEquals((Object)this.user.getName(), (Object)user2.getName());
        Assertions.assertEquals((Object)this.user.getId(), (Object)user2.getId());
    }

    @Test
    public void testGetUserStringString() throws Exception {
        this.user = this.userManager.getUserInstance("Richard");
        this.userManager.addUser(this.user, "va");
        this.user = this.userManager.getUser("Richard", "va");
        Assertions.assertNotNull((Object)this.user);
        this.user = this.userManager.getUser("richard", "va");
        Assertions.assertNotNull((Object)this.user);
        try {
            this.user = this.userManager.getUser("richard", "VA");
            Assertions.fail((String)"should have thrown PasswordMismatchException");
        }
        catch (PasswordMismatchException passwordMismatchException) {
            // empty catch block
        }
    }

    @Test
    public void testGetAllUsers() throws Exception {
        int size = this.userManager.getAllUsers().size();
        this.user = this.userManager.getUserInstance("Bob");
        this.userManager.addUser(this.user, "");
        UserSet userSet = this.userManager.getAllUsers();
        Assertions.assertEquals((int)(size + 1), (int)userSet.size());
    }

    @Test
    public void testAuthenticate() throws Exception {
        this.user = this.userManager.getUserInstance("Kay");
        this.userManager.addUser(this.user, "jc");
        this.userManager.authenticate(this.user, "jc");
        try {
            this.userManager.authenticate(this.user, "JC");
            Assertions.fail((String)"should have thrown PasswordMismatchException");
        }
        catch (PasswordMismatchException passwordMismatchException) {
            // empty catch block
        }
    }

    @Test
    public void testChangePassword() throws Exception {
        this.user = this.userManager.getUserInstance("Jonathan");
        this.userManager.addUser(this.user, "jc");
        try {
            this.userManager.changePassword(this.user, "WrongPWD", "JC");
            Assertions.fail((String)"should have thrown PasswordMismatchException");
        }
        catch (PasswordMismatchException passwordMismatchException) {
            // empty catch block
        }
        this.userManager.changePassword(this.user, "jc", "JC");
        this.userManager.authenticate(this.user, "JC");
    }

    @Test
    public void testForcePassword() throws Exception {
        this.user = this.userManager.getUserInstance("Connor");
        this.userManager.addUser(this.user, "jc_subset");
        this.userManager.forcePassword(this.user, "JC_SUBSET");
        this.userManager.authenticate(this.user, "JC_SUBSET");
    }

    @Test
    public void testGetUserInstance() throws Exception {
        this.user = this.userManager.getUserInstance();
        Assertions.assertNotNull((Object)this.user);
        Assertions.assertTrue((this.user.getName() == null ? 1 : 0) != 0);
    }

    @Test
    public void testGetUserInstanceString() throws Exception {
        this.user = this.userManager.getUserInstance("Philip");
        Assertions.assertEquals((Object)"philip", (Object)this.user.getName());
    }

    @Test
    public void testSaveUser() throws Exception {
        this.user = this.userManager.getUserInstance("Kate");
        this.userManager.addUser(this.user, "katiedid");
        this.user = this.userManager.getUser(this.user.getName());
        this.userManager.saveUser(this.user);
        Assertions.assertEquals((Object)"kate", (Object)this.userManager.getUser(this.user.getName()).getName());
    }

    public void testGetACL() throws Exception {
        this.user = this.userManager.getUserInstance("Tony");
        this.userManager.addUser(this.user, "california");
        AccessControlList acl = this.userManager.getACL(this.user);
        Assertions.assertNotNull((Object)acl);
    }

    public void testRemoveUser() throws Exception {
        this.user = this.userManager.getUserInstance("Rick");
        this.userManager.addUser(this.user, "nb");
        this.userManager.removeUser(this.user);
        try {
            User user2 = this.userManager.getUser(this.user.getName());
            Assertions.fail((String)"Should have thrown UEE");
        }
        catch (UnknownEntityException unknownEntityException) {
            // empty catch block
        }
    }

    @Test
    public void testAddUser() throws Exception {
        this.user = this.userManager.getUserInstance("Joe1");
        Assertions.assertNull((Object)this.user.getId());
        this.userManager.addUser(this.user, "mc");
        this.user = this.userManager.getUserInstance("Joe2");
        Assertions.assertNull((Object)this.user.getId());
        this.userManager.addUser(this.user, "mc");
        Assertions.assertNotNull((Object)this.user.getId());
        Assertions.assertNotNull((Object)this.userManager.getUser(this.user.getName()));
    }

    public void testAddUserTwiceFails() throws Exception {
        this.user = this.userManager.getUserInstance("EATLUNCH");
        this.userManager.addUser(this.user, "bob");
        Assertions.assertTrue((boolean)this.userManager.checkExists(this.user.getName()));
        User user2 = this.userManager.getUserInstance("EATLUNCH");
        try {
            this.userManager.addUser(user2, "bob");
        }
        catch (EntityExistsException entityExistsException) {
            // empty catch block
        }
        try {
            this.userManager.addUser(user2, "differentpassword");
        }
        catch (EntityExistsException entityExistsException) {
            // empty catch block
        }
    }

    @Test
    public void testCheckUserCaseSensitiveExists() throws Exception {
        this.user = this.userManager.getUserInstance("borrisJohnson");
        this.userManager.addUser(this.user, "bob");
        Assertions.assertTrue((boolean)this.userManager.checkExists("borrisJohnson"));
    }
}

