/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fulcrum.security.torque.turbine;

import java.sql.Connection;
import java.util.List;
import org.apache.fulcrum.security.entity.SecurityEntity;
import org.apache.fulcrum.security.entity.User;
import org.apache.fulcrum.security.model.turbine.TurbineUserManager;
import org.apache.fulcrum.security.torque.om.TorqueTurbineUser;
import org.apache.fulcrum.security.torque.om.TorqueTurbineUserPeer;
import org.apache.fulcrum.security.torque.peer.TorqueTurbinePeer;
import org.apache.fulcrum.security.torque.peer.TorqueTurbineUserGroupRolePeer;
import org.apache.fulcrum.security.torque.peer.managers.PeerUserManager;
import org.apache.fulcrum.security.torque.security.TorqueAbstractSecurityEntity;
import org.apache.fulcrum.security.torque.security.turbine.TorqueAbstractTurbineTurbineSecurityEntityDefault;
import org.apache.fulcrum.security.util.DataBackendException;
import org.apache.fulcrum.security.util.UnknownEntityException;
import org.apache.fulcrum.security.util.UserSet;
import org.apache.torque.NoRowsException;
import org.apache.torque.TooManyRowsException;
import org.apache.torque.TorqueException;
import org.apache.torque.criteria.Criteria;
import org.apache.torque.util.TorqueConnection;
import org.apache.torque.util.Transaction;

public class TorqueTurbineUserManagerImpl
extends PeerUserManager
implements TurbineUserManager {
    private static final long serialVersionUID = 1L;
    private static final String ANON = "anon";

    public <T extends User> T getAnonymousUser() throws UnknownEntityException {
        try {
            T anonUser = this.getUser(ANON);
            return anonUser;
        }
        catch (DataBackendException e) {
            throw new UnknownEntityException("Failed to load anonymous user", (Throwable)e);
        }
    }

    public boolean isAnonymousUser(User u) {
        try {
            Object anon = this.getAnonymousUser();
            if (u.equals(anon)) {
                return true;
            }
        }
        catch (Exception e) {
            this.getLogger().error("Failed to check user:" + e.getMessage(), (Throwable)e);
        }
        return false;
    }

    @Override
    protected <T extends User> List<T> doSelectAllUsers(Connection con) throws TorqueException {
        Criteria criteria = new Criteria();
        if (this.getCustomPeer().booleanValue()) {
            try {
                TorqueTurbinePeer peerInstance = (TorqueTurbinePeer)this.getPeerInstance();
                return peerInstance.doSelect(criteria, con);
            }
            catch (DataBackendException e) {
                throw new TorqueException((Throwable)e);
            }
        }
        return TorqueTurbineUserPeer.doSelect(criteria, con);
    }

    @Override
    protected <T extends User> T doSelectById(Integer id, Connection con) throws NoRowsException, TooManyRowsException, TorqueException {
        if (this.getCustomPeer().booleanValue()) {
            try {
                TorqueTurbinePeer peerInstance = (TorqueTurbinePeer)this.getPeerInstance();
                return (T)((User)peerInstance.retrieveByPK(id, con));
            }
            catch (DataBackendException e) {
                throw new TorqueException((Throwable)e);
            }
        }
        return (T)TorqueTurbineUserPeer.retrieveByPK(id, con);
    }

    @Override
    protected <T extends User> T doSelectByName(String name, Connection con) throws NoRowsException, TooManyRowsException, TorqueException {
        Criteria criteria = new Criteria();
        criteria.setIgnoreCase(true);
        criteria.setSingleRecord(true);
        List<TorqueTurbineUser> users = null;
        if (this.getCustomPeer().booleanValue()) {
            try {
                TorqueTurbinePeer peerInstance = (TorqueTurbinePeer)this.getPeerInstance();
                criteria.where((Object)peerInstance.getTableMap().getColumn(this.getColumnName()), (Object)name);
                users = peerInstance.doSelect(criteria, con);
            }
            catch (DataBackendException e) {
                throw new TorqueException((Throwable)e);
            }
        } else {
            criteria.where((Object)TorqueTurbineUserPeer.LOGIN_NAME, (Object)name);
            users = TorqueTurbineUserPeer.doSelect(criteria, con);
        }
        if (users.isEmpty()) {
            throw new NoRowsException(name);
        }
        return (T)((User)users.get(0));
    }

    @Override
    public <T extends User> T getUser(String userName) throws UnknownEntityException, DataBackendException {
        T user = null;
        TorqueConnection con = null;
        try {
            con = Transaction.begin();
            user = this.doSelectByName(userName.toLowerCase(), (Connection)con);
            this.attachRelatedObjects(user, (Connection)con);
            Transaction.commit((Connection)con);
            con = null;
        }
        catch (NoRowsException e) {
            throw new UnknownEntityException("Unknown user '" + userName + "'");
        }
        catch (TooManyRowsException e) {
            throw new DataBackendException("Multiple Users with same username '" + userName + "'");
        }
        catch (TorqueException e) {
            throw new DataBackendException("Error retrieving user information", (Throwable)e);
        }
        finally {
            if (con != null) {
                Transaction.safeRollback((Connection)con);
            }
        }
        return user;
    }

    @Override
    public <T extends User> UserSet<T> getAllUsers() throws DataBackendException {
        UserSet userSet = new UserSet();
        TorqueConnection con = null;
        try {
            con = Transaction.begin();
            List<T> users = this.doSelectAllUsers((Connection)con);
            for (User user : users) {
                this.attachRelatedObjects(user, (Connection)con);
                userSet.add((SecurityEntity)user);
            }
            Transaction.commit((Connection)con);
            con = null;
        }
        catch (TorqueException e) {
            throw new DataBackendException("Error retrieving all users", (Throwable)e);
        }
        finally {
            if (con != null) {
                Transaction.safeRollback((Connection)con);
            }
        }
        return userSet;
    }

    @Override
    public <T extends User> T getUserById(Object id) throws DataBackendException, UnknownEntityException {
        T user;
        if (id != null && id instanceof Integer) {
            TorqueConnection con = null;
            try {
                con = Transaction.begin();
                user = this.doSelectById((Integer)id, (Connection)con);
                this.attachRelatedObjects(user, (Connection)con);
                Transaction.commit((Connection)con);
                con = null;
            }
            catch (NoRowsException e) {
                throw new UnknownEntityException("User with id '" + id + "' does not exist.", (Throwable)e);
            }
            catch (TorqueException e) {
                throw new DataBackendException("Error retrieving user information", (Throwable)e);
            }
            finally {
                if (con != null) {
                    Transaction.safeRollback((Connection)con);
                }
            }
        } else {
            throw new UnknownEntityException("Invalid user id '" + id + "'");
        }
        return user;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private <T extends User> void attachRelatedObjects(T user, Connection con) throws TorqueException {
        if (!(user instanceof TorqueAbstractSecurityEntity)) return;
        if (this.getCustomPeer().booleanValue()) {
            try {
                TorqueTurbineUserGroupRolePeer peerInstance = (TorqueTurbineUserGroupRolePeer)this.getUserGroupRolePeerInstance();
                Criteria criteria = new Criteria();
                criteria.where((Object)peerInstance.getTableMap().getColumn(this.getColumnName4UserGroupRole()), (Object)((TorqueAbstractSecurityEntity)user).getEntityId());
                List ugrs = peerInstance.doSelectJoinTurbineGroup(criteria, con);
                if (!(user instanceof TorqueAbstractTurbineTurbineSecurityEntityDefault)) return;
                ((TorqueAbstractTurbineTurbineSecurityEntityDefault)user).retrieveAttachedObjects(con, false, ugrs);
                return;
            }
            catch (DataBackendException e) {
                throw new TorqueException((Throwable)e);
            }
        }
        try {
            ((TorqueAbstractSecurityEntity)user).retrieveAttachedObjects(con);
            return;
        }
        catch (DataBackendException e) {
            throw new TorqueException((Throwable)e);
        }
    }
}

