/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fulcrum.security.torque.peer;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.avalon.framework.activity.Disposable;
import org.apache.fulcrum.security.spi.AbstractManager;
import org.apache.fulcrum.security.torque.peer.Peer;
import org.apache.fulcrum.security.torque.peer.PeerManager;
import org.apache.fulcrum.security.util.DataBackendException;

public class PeerManagerDefaultImpl
extends AbstractManager
implements PeerManager,
Disposable {
    private static final long serialVersionUID = -3891813089694207441L;
    private Map<String, Peer> peers = new ConcurrentHashMap<String, Peer>(4, 0.75f, 4);

    @Override
    public <P extends Peer> P getPeerInstance(String peerClassName) throws DataBackendException {
        return this.getPeerInstance(peerClassName, Peer.class, null);
    }

    @Override
    public <P extends Peer> P getPeerInstance(String peerClassName, Class<? extends Peer> peerInterface, String className) throws DataBackendException {
        if (this.peers.containsKey(peerClassName)) {
            this.getLogger().debug(" get cached PeerInstance():" + this.peers.get(peerClassName));
            return (P)this.peers.get(peerClassName);
        }
        try {
            Peer peer = (Peer)Class.forName(peerClassName).getConstructor(new Class[0]).newInstance(new Object[0]);
            this.getLogger().debug(" getPeerInstance():" + peer);
            this.peers.put(peerClassName, peer);
            return (P)peer;
        }
        catch (ClassCastException e) {
            throw new DataBackendException(e.getMessage() + ".\nThe peer class " + peerClassName + " should implement " + peerInterface + "\n of generic type <" + className + ">.", (Throwable)e);
        }
        catch (Throwable e) {
            throw new DataBackendException("Problem creating instance of class " + peerClassName, e);
        }
    }
}

