/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fulcrum.security.torque.om;

import java.io.Serializable;
import java.sql.Connection;
import java.util.Objects;
import org.apache.fulcrum.security.torque.om.TurbineGroup;
import org.apache.fulcrum.security.torque.om.TurbineGroupPeer;
import org.apache.fulcrum.security.torque.om.TurbineRole;
import org.apache.fulcrum.security.torque.om.TurbineRolePeer;
import org.apache.fulcrum.security.torque.om.TurbineUser;
import org.apache.fulcrum.security.torque.om.TurbineUserGroupRole;
import org.apache.fulcrum.security.torque.om.TurbineUserGroupRolePeer;
import org.apache.fulcrum.security.torque.om.TurbineUserPeer;
import org.apache.torque.TorqueException;
import org.apache.torque.map.TableMap;
import org.apache.torque.om.ComboKey;
import org.apache.torque.om.NumberKey;
import org.apache.torque.om.ObjectKey;
import org.apache.torque.om.Persistent;
import org.apache.torque.om.SimpleKey;
import org.apache.torque.util.TorqueConnection;
import org.apache.torque.util.Transaction;

public abstract class BaseTurbineUserGroupRole
implements Persistent,
Serializable {
    private static final long serialVersionUID = 1636017840626L;
    private Integer userId = null;
    private Integer groupId = null;
    private Integer roleId = null;
    private boolean modified = true;
    private boolean isNew = true;
    private boolean saving = false;
    private boolean loading = false;
    private boolean deleted = false;
    private TurbineUser aTurbineUser = null;
    private TurbineGroup aTurbineGroup = null;
    private TurbineRole aTurbineRole = null;
    private final SimpleKey<?>[] pks = new SimpleKey[3];
    private final ComboKey comboPK = new ComboKey(this.pks);
    private static final TurbineUserGroupRolePeer peer = new TurbineUserGroupRolePeer();

    public Integer getUserId() {
        return this.userId;
    }

    public void setUserId(Integer v) {
        if (!Objects.equals(this.userId, v)) {
            this.setModified(true);
        }
        this.userId = v;
        if (this.aTurbineUser != null && !Objects.equals(this.aTurbineUser.getEntityId(), v)) {
            this.aTurbineUser = null;
        }
    }

    public Integer getGroupId() {
        return this.groupId;
    }

    public void setGroupId(Integer v) {
        if (!Objects.equals(this.groupId, v)) {
            this.setModified(true);
        }
        this.groupId = v;
        if (this.aTurbineGroup != null && !Objects.equals(this.aTurbineGroup.getEntityId(), v)) {
            this.aTurbineGroup = null;
        }
    }

    public Integer getRoleId() {
        return this.roleId;
    }

    public void setRoleId(Integer v) {
        if (!Objects.equals(this.roleId, v)) {
            this.setModified(true);
        }
        this.roleId = v;
        if (this.aTurbineRole != null && !Objects.equals(this.aTurbineRole.getEntityId(), v)) {
            this.aTurbineRole = null;
        }
    }

    public boolean isNew() {
        return this.isNew;
    }

    public void setNew(boolean isNew) {
        this.isNew = isNew;
    }

    public boolean isModified() {
        return this.modified;
    }

    public void setModified(boolean modified) {
        this.modified = modified;
    }

    public void resetModified() {
        this.modified = false;
    }

    public boolean isSaving() {
        return this.saving;
    }

    public void setSaving(boolean saving) {
        this.saving = saving;
    }

    public boolean isLoading() {
        return this.loading;
    }

    public void setLoading(boolean loading) {
        this.loading = loading;
    }

    public boolean isDeleted() {
        return this.deleted;
    }

    public void setDeleted(boolean deleted) {
        this.deleted = deleted;
    }

    public TurbineUser getTurbineUser() throws TorqueException {
        if (this.aTurbineUser == null && !Objects.equals(this.userId, null)) {
            this.aTurbineUser = TurbineUserPeer.retrieveByPK(SimpleKey.keyFor((Number)this.userId));
        }
        return this.aTurbineUser;
    }

    public TurbineUser getTurbineUser(Connection connection) throws TorqueException {
        if (this.aTurbineUser == null && !Objects.equals(this.userId, null)) {
            this.aTurbineUser = TurbineUserPeer.retrieveByPK(SimpleKey.keyFor((Number)this.userId), connection);
        }
        return this.aTurbineUser;
    }

    public void setTurbineUser(TurbineUser v) {
        if (v == null) {
            this.setUserId(null);
        } else {
            this.setUserId(v.getEntityId());
        }
        this.aTurbineUser = v;
    }

    public void setTurbineUserKey(ObjectKey<?> key) throws TorqueException {
        this.setUserId(((NumberKey)key).intValue());
    }

    public TurbineGroup getTurbineGroup() throws TorqueException {
        if (this.aTurbineGroup == null && !Objects.equals(this.groupId, null)) {
            this.aTurbineGroup = TurbineGroupPeer.retrieveByPK(SimpleKey.keyFor((Number)this.groupId));
        }
        return this.aTurbineGroup;
    }

    public TurbineGroup getTurbineGroup(Connection connection) throws TorqueException {
        if (this.aTurbineGroup == null && !Objects.equals(this.groupId, null)) {
            this.aTurbineGroup = TurbineGroupPeer.retrieveByPK(SimpleKey.keyFor((Number)this.groupId), connection);
        }
        return this.aTurbineGroup;
    }

    public void setTurbineGroup(TurbineGroup v) {
        if (v == null) {
            this.setGroupId(null);
        } else {
            this.setGroupId(v.getEntityId());
        }
        this.aTurbineGroup = v;
    }

    public void setTurbineGroupKey(ObjectKey<?> key) throws TorqueException {
        this.setGroupId(((NumberKey)key).intValue());
    }

    public TurbineRole getTurbineRole() throws TorqueException {
        if (this.aTurbineRole == null && !Objects.equals(this.roleId, null)) {
            this.aTurbineRole = TurbineRolePeer.retrieveByPK(SimpleKey.keyFor((Number)this.roleId));
        }
        return this.aTurbineRole;
    }

    public TurbineRole getTurbineRole(Connection connection) throws TorqueException {
        if (this.aTurbineRole == null && !Objects.equals(this.roleId, null)) {
            this.aTurbineRole = TurbineRolePeer.retrieveByPK(SimpleKey.keyFor((Number)this.roleId), connection);
        }
        return this.aTurbineRole;
    }

    public void setTurbineRole(TurbineRole v) {
        if (v == null) {
            this.setRoleId(null);
        } else {
            this.setRoleId(v.getEntityId());
        }
        this.aTurbineRole = v;
    }

    public void setTurbineRoleKey(ObjectKey<?> key) throws TorqueException {
        this.setRoleId(((NumberKey)key).intValue());
    }

    public void save() throws TorqueException {
        this.save(TurbineUserGroupRolePeer.DATABASE_NAME);
    }

    public void save(String dbName) throws TorqueException {
        try (TorqueConnection con = Transaction.begin((String)dbName);){
            this.save((Connection)con);
            Transaction.commit((Connection)con);
        }
    }

    public void save(Connection con) throws TorqueException {
        if (this.isSaving()) {
            return;
        }
        try {
            this.setSaving(true);
            if (this.isModified()) {
                if (this.isNew()) {
                    TurbineUserGroupRolePeer.doInsert((TurbineUserGroupRole)this, con);
                    this.setNew(false);
                } else {
                    TurbineUserGroupRolePeer.doUpdate((TurbineUserGroupRole)this, con);
                }
            }
        }
        finally {
            this.setSaving(false);
        }
    }

    public void setPrimaryKey(ObjectKey<?> key) throws TorqueException {
        SimpleKey[] keys = (SimpleKey[])key.getValue();
        this.setUserId(((NumberKey)keys[0]).intValue());
        this.setGroupId(((NumberKey)keys[1]).intValue());
        this.setRoleId(((NumberKey)keys[2]).intValue());
    }

    public void setPrimaryKey(Integer userId, Integer groupId, Integer roleId) {
        this.setUserId(userId);
        this.setGroupId(groupId);
        this.setRoleId(roleId);
    }

    public void setPrimaryKey(String key) throws TorqueException {
        this.setPrimaryKey((ObjectKey<?>)new ComboKey(key));
    }

    public ObjectKey<?> getPrimaryKey() {
        SimpleKey[] pks = new SimpleKey[]{SimpleKey.keyFor((Number)this.getUserId()), SimpleKey.keyFor((Number)this.getGroupId()), SimpleKey.keyFor((Number)this.getRoleId())};
        return new ComboKey(pks);
    }

    public ObjectKey<?> getForeignKeyForTurbineUser() {
        return SimpleKey.keyFor((Number)this.getUserId());
    }

    public ObjectKey<?> getForeignKeyForTurbineGroup() {
        return SimpleKey.keyFor((Number)this.getGroupId());
    }

    public ObjectKey<?> getForeignKeyForTurbineRole() {
        return SimpleKey.keyFor((Number)this.getRoleId());
    }

    public TurbineUserGroupRole copy() throws TorqueException {
        return this.copy(true);
    }

    public TurbineUserGroupRole copy(Connection con) throws TorqueException {
        return this.copy(true, con);
    }

    public TurbineUserGroupRole copy(boolean deepcopy) throws TorqueException {
        TurbineUserGroupRole turbineUserGroupRole = new TurbineUserGroupRole();
        return this.copyInto(turbineUserGroupRole, deepcopy);
    }

    public TurbineUserGroupRole copy(boolean deepcopy, Connection con) throws TorqueException {
        TurbineUserGroupRole turbineUserGroupRole = new TurbineUserGroupRole();
        return this.copyInto(turbineUserGroupRole, deepcopy, con);
    }

    public TurbineUserGroupRole copyInto(TurbineUserGroupRole copyObj) throws TorqueException {
        return this.copyInto(copyObj, true);
    }

    public TurbineUserGroupRole copyInto(TurbineUserGroupRole copyObj, Connection con) throws TorqueException {
        return this.copyInto(copyObj, true, con);
    }

    protected TurbineUserGroupRole copyInto(TurbineUserGroupRole copyObj, boolean deepcopy) throws TorqueException {
        copyObj.setUserId(null);
        copyObj.setGroupId(null);
        copyObj.setRoleId(null);
        if (deepcopy) {
            // empty if block
        }
        return copyObj;
    }

    public TurbineUserGroupRole copyInto(TurbineUserGroupRole copyObj, boolean deepcopy, Connection con) throws TorqueException {
        copyObj.setUserId(null);
        copyObj.setGroupId(null);
        copyObj.setRoleId(null);
        if (deepcopy) {
            // empty if block
        }
        return copyObj;
    }

    public TurbineUserGroupRolePeer getPeer() {
        return peer;
    }

    public TableMap getTableMap() throws TorqueException {
        return TurbineUserGroupRolePeer.getTableMap();
    }

    public String toString() {
        StringBuffer str = new StringBuffer();
        str.append("TurbineUserGroupRole:\n");
        str.append("userId = ").append(this.getUserId()).append("\n");
        str.append("groupId = ").append(this.getGroupId()).append("\n");
        str.append("roleId = ").append(this.getRoleId()).append("\n");
        return str.toString();
    }

    public boolean equals(Object toCompare) {
        if (toCompare == null) {
            return false;
        }
        if (this == toCompare) {
            return true;
        }
        if (!this.getClass().equals(toCompare.getClass())) {
            return false;
        }
        TurbineUserGroupRole other = (TurbineUserGroupRole)toCompare;
        if (this.getPrimaryKey() == null || other.getPrimaryKey() == null) {
            return false;
        }
        return this.getPrimaryKey().equals(other.getPrimaryKey());
    }

    public int hashCode() {
        ObjectKey<?> ok = this.getPrimaryKey();
        if (ok == null) {
            return super.hashCode();
        }
        return ok.hashCode();
    }

    public boolean valueEquals(TurbineUserGroupRole toCompare) {
        if (toCompare == null) {
            return false;
        }
        if (this == toCompare) {
            return true;
        }
        if (!Objects.equals(this.userId, toCompare.getUserId())) {
            return false;
        }
        if (!Objects.equals(this.groupId, toCompare.getGroupId())) {
            return false;
        }
        return Objects.equals(this.roleId, toCompare.getRoleId());
    }
}

