/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fulcrum.security.torque.om;

import java.io.Serializable;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.fulcrum.security.torque.om.TurbineUser;
import org.apache.fulcrum.security.torque.om.TurbineUserGroupRole;
import org.apache.fulcrum.security.torque.om.TurbineUserGroupRolePeer;
import org.apache.fulcrum.security.torque.om.TurbineUserPeer;
import org.apache.fulcrum.security.torque.turbine.DefaultAbstractTurbineUser;
import org.apache.torque.TorqueException;
import org.apache.torque.criteria.Criteria;
import org.apache.torque.map.TableMap;
import org.apache.torque.om.NumberKey;
import org.apache.torque.om.ObjectKey;
import org.apache.torque.om.Persistent;
import org.apache.torque.om.SimpleKey;
import org.apache.torque.util.TorqueConnection;
import org.apache.torque.util.Transaction;

public abstract class BaseTurbineUser
extends DefaultAbstractTurbineUser
implements Persistent,
Serializable {
    private static final long serialVersionUID = 1636017840491L;
    private Integer entityId = null;
    private String entityName = null;
    private String password = null;
    private String firstName = null;
    private String lastName = null;
    private String email = null;
    private byte[] objectdata = null;
    private boolean modified = true;
    private boolean isNew = true;
    private boolean saving = false;
    private boolean loading = false;
    private boolean deleted = false;
    protected List<TurbineUserGroupRole> collTurbineUserGroupRoles = null;
    private Criteria lastTurbineUserGroupRoleCriteria = null;
    private static final TurbineUserPeer peer = new TurbineUserPeer();

    @Override
    public Integer getEntityId() {
        return this.entityId;
    }

    @Override
    public void setEntityId(Integer v) {
        if (!Objects.equals(this.entityId, v)) {
            this.setModified(true);
        }
        this.entityId = v;
        if (this.collTurbineUserGroupRoles != null) {
            for (TurbineUserGroupRole element : this.collTurbineUserGroupRoles) {
                element.setUserId(v);
            }
        }
    }

    @Override
    public String getEntityName() {
        return this.entityName;
    }

    @Override
    public void setEntityName(String v) {
        if (!Objects.equals(this.entityName, v)) {
            this.setModified(true);
        }
        this.entityName = v;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String v) {
        if (!Objects.equals(this.password, v)) {
            this.setModified(true);
        }
        this.password = v;
    }

    public String getFirstName() {
        return this.firstName;
    }

    public void setFirstName(String v) {
        if (!Objects.equals(this.firstName, v)) {
            this.setModified(true);
        }
        this.firstName = v;
    }

    public String getLastName() {
        return this.lastName;
    }

    public void setLastName(String v) {
        if (!Objects.equals(this.lastName, v)) {
            this.setModified(true);
        }
        this.lastName = v;
    }

    public String getEmail() {
        return this.email;
    }

    public void setEmail(String v) {
        if (!Objects.equals(this.email, v)) {
            this.setModified(true);
        }
        this.email = v;
    }

    public byte[] getObjectdata() {
        return this.objectdata;
    }

    public void setObjectdata(byte[] v) {
        if (!Objects.equals(this.objectdata, v)) {
            this.setModified(true);
        }
        this.objectdata = v;
    }

    public boolean isNew() {
        return this.isNew;
    }

    public void setNew(boolean isNew) {
        this.isNew = isNew;
    }

    public boolean isModified() {
        return this.modified;
    }

    public void setModified(boolean modified) {
        this.modified = modified;
    }

    public void resetModified() {
        this.modified = false;
    }

    public boolean isSaving() {
        return this.saving;
    }

    public void setSaving(boolean saving) {
        this.saving = saving;
    }

    public boolean isLoading() {
        return this.loading;
    }

    public void setLoading(boolean loading) {
        this.loading = loading;
    }

    public boolean isDeleted() {
        return this.deleted;
    }

    public void setDeleted(boolean deleted) {
        this.deleted = deleted;
    }

    public List<TurbineUserGroupRole> initTurbineUserGroupRoles() {
        if (this.collTurbineUserGroupRoles == null) {
            this.collTurbineUserGroupRoles = new ArrayList<TurbineUserGroupRole>();
        }
        return this.collTurbineUserGroupRoles;
    }

    public boolean isTurbineUserGroupRolesInitialized() {
        return this.collTurbineUserGroupRoles != null;
    }

    public void addTurbineUserGroupRole(TurbineUserGroupRole toAdd) throws TorqueException {
        toAdd.setTurbineUser((TurbineUser)this);
        this.getTurbineUserGroupRoles().add(toAdd);
    }

    public void addTurbineUserGroupRole(TurbineUserGroupRole l, Connection con) throws TorqueException {
        this.getTurbineUserGroupRoles(con).add(l);
        l.setTurbineUser((TurbineUser)this);
    }

    public void resetTurbineUserGroupRole() {
        this.collTurbineUserGroupRoles = null;
    }

    public List<TurbineUserGroupRole> getTurbineUserGroupRoles() throws TorqueException {
        if (this.collTurbineUserGroupRoles == null) {
            this.collTurbineUserGroupRoles = this.getTurbineUserGroupRoles(new Criteria());
            for (TurbineUserGroupRole turbineUserGroupRole : this.collTurbineUserGroupRoles) {
                turbineUserGroupRole.setTurbineUser((TurbineUser)this);
            }
        }
        return this.collTurbineUserGroupRoles;
    }

    public List<TurbineUserGroupRole> getTurbineUserGroupRoles(Criteria criteria) throws TorqueException {
        if (this.collTurbineUserGroupRoles == null) {
            if (this.isNew()) {
                this.initTurbineUserGroupRoles();
            } else {
                criteria.and((Object)TurbineUserGroupRolePeer.USER_ID, (Object)this.getEntityId());
                this.collTurbineUserGroupRoles = TurbineUserGroupRolePeer.doSelect(criteria);
                for (TurbineUserGroupRole turbineUserGroupRole : this.collTurbineUserGroupRoles) {
                    turbineUserGroupRole.setTurbineUser((TurbineUser)this);
                }
            }
        } else if (!this.isNew()) {
            criteria.and((Object)TurbineUserGroupRolePeer.USER_ID, (Object)this.getEntityId());
            if (this.lastTurbineUserGroupRoleCriteria == null || !this.lastTurbineUserGroupRoleCriteria.equals((Object)criteria)) {
                this.collTurbineUserGroupRoles = TurbineUserGroupRolePeer.doSelect(criteria);
                for (TurbineUserGroupRole turbineUserGroupRole : this.collTurbineUserGroupRoles) {
                    turbineUserGroupRole.setTurbineUser((TurbineUser)this);
                }
            }
        }
        this.lastTurbineUserGroupRoleCriteria = criteria;
        return this.collTurbineUserGroupRoles;
    }

    public List<TurbineUserGroupRole> getTurbineUserGroupRoles(Connection con) throws TorqueException {
        if (this.collTurbineUserGroupRoles == null) {
            this.collTurbineUserGroupRoles = this.getTurbineUserGroupRoles(new Criteria(), con);
            for (TurbineUserGroupRole turbineUserGroupRole : this.collTurbineUserGroupRoles) {
                turbineUserGroupRole.setTurbineUser((TurbineUser)this);
            }
        }
        return this.collTurbineUserGroupRoles;
    }

    public List<TurbineUserGroupRole> getTurbineUserGroupRoles(Criteria criteria, Connection con) throws TorqueException {
        if (this.collTurbineUserGroupRoles == null) {
            if (this.isNew()) {
                this.initTurbineUserGroupRoles();
            } else {
                criteria.and((Object)TurbineUserGroupRolePeer.USER_ID, (Object)this.getEntityId());
                this.collTurbineUserGroupRoles = TurbineUserGroupRolePeer.doSelect(criteria, con);
                for (TurbineUserGroupRole turbineUserGroupRole : this.collTurbineUserGroupRoles) {
                    turbineUserGroupRole.setTurbineUser((TurbineUser)this);
                }
            }
        } else if (!this.isNew()) {
            criteria.and((Object)TurbineUserGroupRolePeer.USER_ID, (Object)this.getEntityId());
            if (this.lastTurbineUserGroupRoleCriteria == null || !this.lastTurbineUserGroupRoleCriteria.equals((Object)criteria)) {
                this.collTurbineUserGroupRoles = TurbineUserGroupRolePeer.doSelect(criteria, con);
                for (TurbineUserGroupRole turbineUserGroupRole : this.collTurbineUserGroupRoles) {
                    turbineUserGroupRole.setTurbineUser((TurbineUser)this);
                }
            }
        }
        this.lastTurbineUserGroupRoleCriteria = criteria;
        return this.collTurbineUserGroupRoles;
    }

    protected List<TurbineUserGroupRole> getTurbineUserGroupRolesJoinTurbineGroup(Criteria criteria) throws TorqueException {
        try (TorqueConnection connection = Transaction.begin((String)criteria.getDbName());){
            List<TurbineUserGroupRole> result = this.getTurbineUserGroupRolesJoinTurbineGroup(criteria, (Connection)connection);
            Transaction.commit((Connection)connection);
            List<TurbineUserGroupRole> list = result;
            return list;
        }
    }

    protected List<TurbineUserGroupRole> getTurbineUserGroupRolesJoinTurbineGroup(Criteria criteria, Connection connection) throws TorqueException {
        if (this.collTurbineUserGroupRoles == null) {
            if (this.isNew()) {
                this.initTurbineUserGroupRoles();
            } else {
                criteria.and((Object)TurbineUserGroupRolePeer.USER_ID, (Object)this.getEntityId());
                this.collTurbineUserGroupRoles = TurbineUserGroupRolePeer.doSelectJoinTurbineGroup(criteria, connection);
                for (TurbineUserGroupRole turbineUserGroupRole : this.collTurbineUserGroupRoles) {
                    turbineUserGroupRole.setTurbineUser((TurbineUser)this);
                }
            }
        } else {
            criteria.and((Object)TurbineUserGroupRolePeer.USER_ID, (Object)this.getEntityId());
            if (this.lastTurbineUserGroupRoleCriteria == null || !this.lastTurbineUserGroupRoleCriteria.equals((Object)criteria)) {
                this.collTurbineUserGroupRoles = TurbineUserGroupRolePeer.doSelectJoinTurbineGroup(criteria, connection);
                for (TurbineUserGroupRole turbineUserGroupRole : this.collTurbineUserGroupRoles) {
                    turbineUserGroupRole.setTurbineUser((TurbineUser)this);
                }
            }
        }
        this.lastTurbineUserGroupRoleCriteria = criteria;
        return this.collTurbineUserGroupRoles;
    }

    protected List<TurbineUserGroupRole> getTurbineUserGroupRolesJoinTurbineRole(Criteria criteria) throws TorqueException {
        try (TorqueConnection connection = Transaction.begin((String)criteria.getDbName());){
            List<TurbineUserGroupRole> result = this.getTurbineUserGroupRolesJoinTurbineRole(criteria, (Connection)connection);
            Transaction.commit((Connection)connection);
            List<TurbineUserGroupRole> list = result;
            return list;
        }
    }

    protected List<TurbineUserGroupRole> getTurbineUserGroupRolesJoinTurbineRole(Criteria criteria, Connection connection) throws TorqueException {
        if (this.collTurbineUserGroupRoles == null) {
            if (this.isNew()) {
                this.initTurbineUserGroupRoles();
            } else {
                criteria.and((Object)TurbineUserGroupRolePeer.USER_ID, (Object)this.getEntityId());
                this.collTurbineUserGroupRoles = TurbineUserGroupRolePeer.doSelectJoinTurbineRole(criteria, connection);
                for (TurbineUserGroupRole turbineUserGroupRole : this.collTurbineUserGroupRoles) {
                    turbineUserGroupRole.setTurbineUser((TurbineUser)this);
                }
            }
        } else {
            criteria.and((Object)TurbineUserGroupRolePeer.USER_ID, (Object)this.getEntityId());
            if (this.lastTurbineUserGroupRoleCriteria == null || !this.lastTurbineUserGroupRoleCriteria.equals((Object)criteria)) {
                this.collTurbineUserGroupRoles = TurbineUserGroupRolePeer.doSelectJoinTurbineRole(criteria, connection);
                for (TurbineUserGroupRole turbineUserGroupRole : this.collTurbineUserGroupRoles) {
                    turbineUserGroupRole.setTurbineUser((TurbineUser)this);
                }
            }
        }
        this.lastTurbineUserGroupRoleCriteria = criteria;
        return this.collTurbineUserGroupRoles;
    }

    public void save() throws TorqueException {
        this.save(TurbineUserPeer.DATABASE_NAME);
    }

    public void save(String dbName) throws TorqueException {
        try (TorqueConnection con = Transaction.begin((String)dbName);){
            this.save((Connection)con);
            Transaction.commit((Connection)con);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save(Connection con) throws TorqueException {
        if (this.isSaving()) {
            return;
        }
        try {
            this.setSaving(true);
            if (this.isModified()) {
                if (this.isNew()) {
                    TurbineUserPeer.doInsert((TurbineUser)this, con);
                    this.setNew(false);
                } else {
                    TurbineUserPeer.doUpdate((TurbineUser)this, con);
                }
            }
            if (this.isTurbineUserGroupRolesInitialized()) {
                for (TurbineUserGroupRole collTurbineUserGroupRoles : this.getTurbineUserGroupRoles()) {
                    collTurbineUserGroupRoles.save(con);
                }
            }
        }
        finally {
            this.setSaving(false);
        }
    }

    public void setPrimaryKey(ObjectKey<?> key) {
        this.setEntityId(((NumberKey)key).intValue());
    }

    public void setPrimaryKey(String key) {
        this.setEntityId(new Integer(key));
    }

    public ObjectKey<?> getPrimaryKey() {
        return SimpleKey.keyFor((Number)this.getEntityId());
    }

    public TurbineUser copy() throws TorqueException {
        return this.copy(true);
    }

    public TurbineUser copy(Connection con) throws TorqueException {
        return this.copy(true, con);
    }

    public TurbineUser copy(boolean deepcopy) throws TorqueException {
        TurbineUser turbineUser = new TurbineUser();
        return this.copyInto(turbineUser, deepcopy);
    }

    public TurbineUser copy(boolean deepcopy, Connection con) throws TorqueException {
        TurbineUser turbineUser = new TurbineUser();
        return this.copyInto(turbineUser, deepcopy, con);
    }

    public TurbineUser copyInto(TurbineUser copyObj) throws TorqueException {
        return this.copyInto(copyObj, true);
    }

    public TurbineUser copyInto(TurbineUser copyObj, Connection con) throws TorqueException {
        return this.copyInto(copyObj, true, con);
    }

    protected TurbineUser copyInto(TurbineUser copyObj, boolean deepcopy) throws TorqueException {
        copyObj.setEntityId(null);
        copyObj.setEntityName(this.entityName);
        copyObj.setPassword(this.password);
        copyObj.setFirstName(this.firstName);
        copyObj.setLastName(this.lastName);
        copyObj.setEmail(this.email);
        copyObj.setObjectdata(this.objectdata);
        if (deepcopy) {
            if (this.collTurbineUserGroupRoles != null) {
                for (TurbineUserGroupRole obj : this.collTurbineUserGroupRoles) {
                    copyObj.addTurbineUserGroupRole(obj.copy());
                }
            } else {
                copyObj.collTurbineUserGroupRoles = null;
            }
        }
        return copyObj;
    }

    public TurbineUser copyInto(TurbineUser copyObj, boolean deepcopy, Connection con) throws TorqueException {
        copyObj.setEntityId(null);
        copyObj.setEntityName(this.entityName);
        copyObj.setPassword(this.password);
        copyObj.setFirstName(this.firstName);
        copyObj.setLastName(this.lastName);
        copyObj.setEmail(this.email);
        copyObj.setObjectdata(this.objectdata);
        if (deepcopy) {
            for (TurbineUserGroupRole obj : this.getTurbineUserGroupRoles(con)) {
                copyObj.addTurbineUserGroupRole(obj.copy());
            }
        }
        return copyObj;
    }

    public TurbineUserPeer getPeer() {
        return peer;
    }

    public TableMap getTableMap() throws TorqueException {
        return TurbineUserPeer.getTableMap();
    }

    public String toString() {
        StringBuffer str = new StringBuffer();
        str.append("TurbineUser:\n");
        str.append("entityId = ").append(this.getEntityId()).append("\n");
        str.append("entityName = ").append(this.getEntityName()).append("\n");
        str.append("password = ").append(this.getPassword()).append("\n");
        str.append("firstName = ").append(this.getFirstName()).append("\n");
        str.append("lastName = ").append(this.getLastName()).append("\n");
        str.append("email = ").append(this.getEmail()).append("\n");
        str.append("objectdata = ").append("<binary>").append("\n");
        return str.toString();
    }

    public boolean equals(Object toCompare) {
        if (toCompare == null) {
            return false;
        }
        if (this == toCompare) {
            return true;
        }
        if (!this.getClass().equals(toCompare.getClass())) {
            return false;
        }
        TurbineUser other = (TurbineUser)toCompare;
        if (this.getPrimaryKey() == null || other.getPrimaryKey() == null) {
            return false;
        }
        return this.getPrimaryKey().equals(other.getPrimaryKey());
    }

    public int hashCode() {
        ObjectKey<?> ok = this.getPrimaryKey();
        if (ok == null) {
            return super.hashCode();
        }
        return ok.hashCode();
    }

    public boolean valueEquals(TurbineUser toCompare) {
        if (toCompare == null) {
            return false;
        }
        if (this == toCompare) {
            return true;
        }
        if (!Objects.equals(this.entityId, toCompare.getEntityId())) {
            return false;
        }
        if (!Objects.equals(this.entityName, toCompare.getEntityName())) {
            return false;
        }
        if (!Objects.equals(this.password, toCompare.getPassword())) {
            return false;
        }
        if (!Objects.equals(this.firstName, toCompare.getFirstName())) {
            return false;
        }
        if (!Objects.equals(this.lastName, toCompare.getLastName())) {
            return false;
        }
        if (!Objects.equals(this.email, toCompare.getEmail())) {
            return false;
        }
        return Objects.equals(this.objectdata, toCompare.getObjectdata());
    }
}

