/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fulcrum.security.torque.om;

import java.sql.Connection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.fulcrum.security.torque.om.TurbineRole;
import org.apache.fulcrum.security.torque.om.TurbineRolePeer;
import org.apache.fulcrum.security.torque.om.TurbineRolePermission;
import org.apache.fulcrum.security.torque.om.TurbineRolePermissionPeer;
import org.apache.fulcrum.security.torque.om.TurbineRoleRecordMapper;
import org.apache.fulcrum.security.torque.om.TurbineUserGroupRole;
import org.apache.fulcrum.security.torque.om.TurbineUserGroupRolePeer;
import org.apache.torque.Column;
import org.apache.torque.NoRowsException;
import org.apache.torque.TooManyRowsException;
import org.apache.torque.TorqueException;
import org.apache.torque.criteria.Criteria;
import org.apache.torque.criteria.Criterion;
import org.apache.torque.map.TableMap;
import org.apache.torque.om.ObjectKey;
import org.apache.torque.om.SimpleKey;
import org.apache.torque.om.mapper.RecordMapper;
import org.apache.torque.util.AbstractPeerImpl;
import org.apache.torque.util.ColumnValues;
import org.apache.torque.util.JdbcTypedValue;
import org.apache.torque.util.TorqueConnection;
import org.apache.torque.util.Transaction;

public abstract class BaseTurbineRolePeerImpl
extends AbstractPeerImpl<TurbineRole> {
    private static final long serialVersionUID = 1636017843366L;

    public BaseTurbineRolePeerImpl() {
        this(new TurbineRoleRecordMapper(), TurbineRolePeer.TABLE, TurbineRolePeer.DATABASE_NAME);
    }

    public BaseTurbineRolePeerImpl(RecordMapper<TurbineRole> recordMapper, TableMap tableMap, String databaseName) {
        super(recordMapper, tableMap, databaseName);
    }

    public TurbineRole getDbObjectInstance() {
        return new TurbineRole();
    }

    public int doUpdate(ColumnValues columnValues, Connection con) throws TorqueException {
        Criteria selectCriteria = new Criteria(this.getDatabaseName());
        this.correctBooleans(columnValues);
        JdbcTypedValue pkValue = columnValues.remove((Object)TurbineRolePeer.ROLE_ID);
        if (pkValue == null) {
            throw new TorqueException("The value for the primary key column TurbineRolePeer.ROLE_ID must be set");
        }
        if (pkValue.getSqlExpression() == null) {
            selectCriteria.where((Object)TurbineRolePeer.ROLE_ID, pkValue.getValue());
        } else {
            selectCriteria.where((Object)TurbineRolePeer.ROLE_ID, (Object)pkValue.getSqlExpression());
        }
        int rowCount = this.doUpdate(selectCriteria, columnValues, con);
        return rowCount;
    }

    public int doDelete(TurbineRole obj) throws TorqueException {
        int result = this.doDelete(this.buildCriteria(obj.getPrimaryKey()));
        obj.setDeleted(true);
        return result;
    }

    public int doDelete(TurbineRole obj, Connection con) throws TorqueException {
        int result = this.doDelete(this.buildCriteria(obj.getPrimaryKey()), con);
        obj.setDeleted(true);
        return result;
    }

    public int doDelete(Collection<TurbineRole> objects) throws TorqueException {
        int result = this.doDelete(this.buildPkCriteria(objects));
        objects.forEach(object -> object.setDeleted(true));
        return result;
    }

    public int doDelete(Collection<TurbineRole> objects, Connection con) throws TorqueException {
        int result = this.doDelete(this.buildPkCriteria(objects), con);
        objects.forEach(object -> object.setDeleted(true));
        return result;
    }

    public Criteria buildCriteria(ObjectKey<?> pk) {
        Criteria criteria = new Criteria();
        criteria.and((Object)TurbineRolePeer.ROLE_ID, pk);
        return criteria;
    }

    public Criteria buildCriteria(Collection<ObjectKey<?>> pks) {
        Criteria criteria = new Criteria();
        criteria.andIn((Object)TurbineRolePeer.ROLE_ID, pks);
        return criteria;
    }

    public Criteria buildPkCriteria(Collection<TurbineRole> objects) {
        return this.buildCriteria(objects.stream().map(object -> object.getPrimaryKey()).collect(Collectors.toList()));
    }

    public Criteria buildCriteria(TurbineRole obj) {
        Criteria criteria = new Criteria(this.getDatabaseName());
        if (!obj.isNew()) {
            criteria.and((Object)TurbineRolePeer.ROLE_ID, (Object)obj.getEntityId());
        }
        criteria.and((Object)TurbineRolePeer.ROLE_NAME, (Object)obj.getEntityName());
        return criteria;
    }

    public Criteria buildSelectCriteria(TurbineRole obj) {
        Criteria criteria = new Criteria(this.getDatabaseName());
        if (!obj.isNew()) {
            criteria.and((Object)TurbineRolePeer.ROLE_ID, (Object)obj.getEntityId());
        }
        criteria.and((Object)TurbineRolePeer.ROLE_NAME, (Object)obj.getEntityName());
        return criteria;
    }

    public ColumnValues buildColumnValues(TurbineRole turbineRole) throws TorqueException {
        ColumnValues columnValues = new ColumnValues();
        if (!turbineRole.isNew() || turbineRole.getEntityId() != null) {
            columnValues.put((Column)TurbineRolePeer.ROLE_ID, new JdbcTypedValue((Object)turbineRole.getEntityId(), 4));
        }
        columnValues.put((Column)TurbineRolePeer.ROLE_NAME, new JdbcTypedValue((Object)turbineRole.getEntityName(), 12));
        return columnValues;
    }

    public TurbineRole retrieveByPK(Integer pk) throws TorqueException, NoRowsException, TooManyRowsException {
        return this.retrieveByPK((ObjectKey<?>)SimpleKey.keyFor((Number)pk));
    }

    public TurbineRole retrieveByPK(Integer pk, Connection con) throws TorqueException, NoRowsException, TooManyRowsException {
        return this.retrieveByPK((ObjectKey<?>)SimpleKey.keyFor((Number)pk), con);
    }

    public TurbineRole retrieveByPK(ObjectKey<?> pk) throws TorqueException, NoRowsException, TooManyRowsException {
        try (TorqueConnection connection = Transaction.begin((String)this.getDatabaseName());){
            TurbineRole result = this.retrieveByPK(pk, (Connection)connection);
            Transaction.commit((Connection)connection);
            TurbineRole turbineRole = result;
            return turbineRole;
        }
    }

    public TurbineRole retrieveByPK(ObjectKey<?> pk, Connection con) throws TorqueException, NoRowsException, TooManyRowsException {
        Criteria criteria = this.buildCriteria(pk);
        TurbineRole v = (TurbineRole)this.doSelectSingleRecord(criteria, con);
        if (v == null) {
            throw new NoRowsException("Failed to select a row.");
        }
        return v;
    }

    public List<TurbineRole> retrieveByTypedPKs(Collection<Integer> pks) throws TorqueException {
        try (TorqueConnection connection = Transaction.begin((String)this.getDatabaseName());){
            List<TurbineRole> result = this.retrieveByTypedPKs(pks, (Connection)connection);
            Transaction.commit((Connection)connection);
            List<TurbineRole> list = result;
            return list;
        }
    }

    public List<TurbineRole> retrieveByTypedPKs(Collection<Integer> pks, Connection dbcon) throws TorqueException {
        if (pks == null || pks.size() == 0) {
            return new ArrayList<TurbineRole>();
        }
        ArrayList objectKeyList = new ArrayList();
        for (Integer pk : pks) {
            objectKeyList.add((ObjectKey<?>)SimpleKey.keyFor((Number)pk));
        }
        Criteria criteria = this.buildCriteria(objectKeyList);
        List result = this.doSelect(criteria, dbcon);
        return result;
    }

    public List<TurbineRole> retrieveByObjectKeys(Collection<ObjectKey<?>> pks) throws TorqueException {
        try (TorqueConnection connection = Transaction.begin((String)this.getDatabaseName());){
            List<TurbineRole> result = this.retrieveByObjectKeys(pks, (Connection)connection);
            Transaction.commit((Connection)connection);
            List<TurbineRole> list = result;
            return list;
        }
    }

    public List<TurbineRole> retrieveByObjectKeys(Collection<ObjectKey<?>> pks, Connection dbcon) throws TorqueException {
        if (pks == null || pks.size() == 0) {
            return new ArrayList<TurbineRole>();
        }
        Criteria criteria = this.buildCriteria(pks);
        List result = this.doSelect(criteria, dbcon);
        return result;
    }

    public void setAndSaveTurbineRolePermissions(TurbineRole toLinkTo, Collection<TurbineRolePermission> toSave) throws TorqueException {
        try (TorqueConnection connection = Transaction.begin((String)this.getDatabaseName());){
            this.setAndSaveTurbineRolePermissions(toLinkTo, toSave, (Connection)connection);
            Transaction.commit((Connection)connection);
        }
    }

    public void setAndSaveTurbineRolePermissions(TurbineRole toLinkTo, Collection<TurbineRolePermission> toSave, Connection connection) throws TorqueException {
        List<Object> intersection;
        toLinkTo.resetTurbineRolePermission();
        toLinkTo.getTurbineRolePermissions(connection);
        ObjectKey<?> localKey = toLinkTo.getPrimaryKey();
        Criteria criteria = new Criteria();
        Criterion onlyReferencingCriterion = new Criterion((Object)TurbineRolePermissionPeer.ROLE_ID, localKey);
        criteria.where(onlyReferencingCriterion);
        HashSet<Object> toSaveKeys = new HashSet<Object>();
        for (TurbineRolePermission toSaveElement : toSave) {
            ObjectKey<?> toSaveKey = toSaveElement.getPrimaryKey();
            if (toSaveKey.getValue() == null) continue;
            toSaveKeys.add(toSaveKey);
        }
        if (toSaveKeys.isEmpty()) {
            intersection = new ArrayList();
        } else {
            Criterion toSaveKeyCriterion = null;
            for (ObjectKey objectKey : toSaveKeys) {
                SimpleKey[] simpleKeyArray = (SimpleKey[])objectKey.getValue();
                Criterion p0 = new Criterion((Object)TurbineRolePermissionPeer.ROLE_ID, (Object)simpleKeyArray[0]);
                Criterion p1 = new Criterion((Object)TurbineRolePermissionPeer.PERMISSION_ID, (Object)simpleKeyArray[1]);
                p0.and(p1);
                if (toSaveKeyCriterion == null) {
                    toSaveKeyCriterion = p0;
                    continue;
                }
                toSaveKeyCriterion.or(p0);
            }
            criteria.and(toSaveKeyCriterion);
            intersection = TurbineRolePermissionPeer.doSelect(criteria, connection);
        }
        if (toLinkTo.isTurbineRolePermissionsInitialized()) {
            toLinkTo.getTurbineRolePermissions().clear();
        } else {
            toLinkTo.initTurbineRolePermissions();
        }
        for (TurbineRolePermission toSaveElement : toSave) {
            int n = intersection.indexOf(toSaveElement);
            if (n == -1) {
                toLinkTo.addTurbineRolePermission(toSaveElement);
                toSaveElement.save(connection);
            } else {
                toLinkTo.addTurbineRolePermission(toSaveElement);
                toSaveElement.setNew(false);
                if (!toSaveElement.valueEquals((TurbineRolePermission)intersection.get(n))) {
                    toSaveElement.setModified(true);
                }
                toSaveElement.save(connection);
            }
            toSaveKeys.add(toSaveElement.getPrimaryKey());
        }
        Criteria deleteCriteria = new Criteria();
        deleteCriteria.where(onlyReferencingCriterion);
        if (!toSaveKeys.isEmpty()) {
            Criterion toSaveKeyCriterion = null;
            for (ObjectKey objectKey : toSaveKeys) {
                SimpleKey[] toSavePrimaryKeys = (SimpleKey[])objectKey.getValue();
                Criterion p0 = new Criterion((Object)TurbineRolePermissionPeer.ROLE_ID, (Object)toSavePrimaryKeys[0], Criteria.NOT_EQUAL);
                Criterion p1 = new Criterion((Object)TurbineRolePermissionPeer.PERMISSION_ID, (Object)toSavePrimaryKeys[1], Criteria.NOT_EQUAL);
                p0.or(p1);
                if (toSaveKeyCriterion == null) {
                    toSaveKeyCriterion = p0;
                    continue;
                }
                toSaveKeyCriterion.and(p0);
            }
            deleteCriteria.and(toSaveKeyCriterion);
        }
        TurbineRolePermissionPeer.doDelete(deleteCriteria, connection);
    }

    public void setAndSaveTurbineUserGroupRoles(TurbineRole toLinkTo, Collection<TurbineUserGroupRole> toSave) throws TorqueException {
        try (TorqueConnection connection = Transaction.begin((String)this.getDatabaseName());){
            this.setAndSaveTurbineUserGroupRoles(toLinkTo, toSave, (Connection)connection);
            Transaction.commit((Connection)connection);
        }
    }

    public void setAndSaveTurbineUserGroupRoles(TurbineRole toLinkTo, Collection<TurbineUserGroupRole> toSave, Connection connection) throws TorqueException {
        List<Object> intersection;
        toLinkTo.resetTurbineUserGroupRole();
        toLinkTo.getTurbineUserGroupRoles(connection);
        ObjectKey<?> localKey = toLinkTo.getPrimaryKey();
        Criteria criteria = new Criteria();
        Criterion onlyReferencingCriterion = new Criterion((Object)TurbineUserGroupRolePeer.ROLE_ID, localKey);
        criteria.where(onlyReferencingCriterion);
        HashSet<Object> toSaveKeys = new HashSet<Object>();
        for (TurbineUserGroupRole toSaveElement : toSave) {
            ObjectKey<?> toSaveKey = toSaveElement.getPrimaryKey();
            if (toSaveKey.getValue() == null) continue;
            toSaveKeys.add(toSaveKey);
        }
        if (toSaveKeys.isEmpty()) {
            intersection = new ArrayList();
        } else {
            Criterion toSaveKeyCriterion = null;
            for (ObjectKey objectKey : toSaveKeys) {
                SimpleKey[] simpleKeyArray = (SimpleKey[])objectKey.getValue();
                Criterion p0 = new Criterion((Object)TurbineUserGroupRolePeer.USER_ID, (Object)simpleKeyArray[0]);
                Criterion p1 = new Criterion((Object)TurbineUserGroupRolePeer.GROUP_ID, (Object)simpleKeyArray[1]);
                p0.and(p1);
                Criterion p2 = new Criterion((Object)TurbineUserGroupRolePeer.ROLE_ID, (Object)simpleKeyArray[2]);
                p1.and(p2);
                if (toSaveKeyCriterion == null) {
                    toSaveKeyCriterion = p0;
                    continue;
                }
                toSaveKeyCriterion.or(p0);
            }
            criteria.and(toSaveKeyCriterion);
            intersection = TurbineUserGroupRolePeer.doSelect(criteria, connection);
        }
        if (toLinkTo.isTurbineUserGroupRolesInitialized()) {
            toLinkTo.getTurbineUserGroupRoles().clear();
        } else {
            toLinkTo.initTurbineUserGroupRoles();
        }
        for (TurbineUserGroupRole toSaveElement : toSave) {
            int n = intersection.indexOf(toSaveElement);
            if (n == -1) {
                toLinkTo.addTurbineUserGroupRole(toSaveElement);
                toSaveElement.save(connection);
            } else {
                toLinkTo.addTurbineUserGroupRole(toSaveElement);
                toSaveElement.setNew(false);
                if (!toSaveElement.valueEquals((TurbineUserGroupRole)intersection.get(n))) {
                    toSaveElement.setModified(true);
                }
                toSaveElement.save(connection);
            }
            toSaveKeys.add(toSaveElement.getPrimaryKey());
        }
        Criteria deleteCriteria = new Criteria();
        deleteCriteria.where(onlyReferencingCriterion);
        if (!toSaveKeys.isEmpty()) {
            Criterion toSaveKeyCriterion = null;
            for (ObjectKey objectKey : toSaveKeys) {
                SimpleKey[] toSavePrimaryKeys = (SimpleKey[])objectKey.getValue();
                Criterion p0 = new Criterion((Object)TurbineUserGroupRolePeer.USER_ID, (Object)toSavePrimaryKeys[0], Criteria.NOT_EQUAL);
                Criterion p1 = new Criterion((Object)TurbineUserGroupRolePeer.GROUP_ID, (Object)toSavePrimaryKeys[1], Criteria.NOT_EQUAL);
                p0.or(p1);
                Criterion p2 = new Criterion((Object)TurbineUserGroupRolePeer.ROLE_ID, (Object)toSavePrimaryKeys[2], Criteria.NOT_EQUAL);
                p1.or(p2);
                if (toSaveKeyCriterion == null) {
                    toSaveKeyCriterion = p0;
                    continue;
                }
                toSaveKeyCriterion.and(p0);
            }
            deleteCriteria.and(toSaveKeyCriterion);
        }
        TurbineUserGroupRolePeer.doDelete(deleteCriteria, connection);
    }
}

