/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fulcrum.security.torque;

import java.sql.Connection;
import java.util.List;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.fulcrum.security.entity.SecurityEntity;
import org.apache.fulcrum.security.entity.User;
import org.apache.fulcrum.security.spi.AbstractUserManager;
import org.apache.fulcrum.security.torque.security.TorqueAbstractSecurityEntity;
import org.apache.fulcrum.security.util.DataBackendException;
import org.apache.fulcrum.security.util.UnknownEntityException;
import org.apache.fulcrum.security.util.UserSet;
import org.apache.torque.NoRowsException;
import org.apache.torque.TooManyRowsException;
import org.apache.torque.TorqueException;
import org.apache.torque.util.TorqueConnection;
import org.apache.torque.util.Transaction;

public abstract class TorqueAbstractUserManager
extends AbstractUserManager {
    private static final long serialVersionUID = 2050218990148719292L;

    public void configure(Configuration conf) throws ConfigurationException {
        super.configure(conf);
    }

    protected abstract <T extends User> List<T> doSelectAllUsers(Connection var1) throws TorqueException;

    protected abstract <T extends User> T doSelectByName(String var1, Connection var2) throws NoRowsException, TooManyRowsException, TorqueException;

    protected abstract <T extends User> T doSelectById(Integer var1, Connection var2) throws NoRowsException, TooManyRowsException, TorqueException;

    public synchronized void removeUser(User user) throws DataBackendException, UnknownEntityException {
        try {
            ((TorqueAbstractSecurityEntity)user).delete();
        }
        catch (TorqueException e) {
            throw new DataBackendException("Removing User '" + user.getName() + "' failed", (Throwable)e);
        }
    }

    protected synchronized <T extends User> T persistNewUser(T user) throws DataBackendException {
        try {
            TorqueAbstractSecurityEntity u = (TorqueAbstractSecurityEntity)user;
            u.save();
        }
        catch (Exception e) {
            throw new DataBackendException("Adding User '" + user.getName() + "' failed", (Throwable)e);
        }
        return user;
    }

    public synchronized void saveUser(User user) throws DataBackendException, UnknownEntityException {
        if (this.checkExists(user)) {
            try {
                TorqueAbstractSecurityEntity u = (TorqueAbstractSecurityEntity)user;
                u.setNew(false);
                u.save();
            }
            catch (Exception e) {
                throw new DataBackendException("Saving User '" + user.getName() + "' failed", (Throwable)e);
            }
        } else {
            throw new UnknownEntityException("Unknown user '" + user + "'");
        }
    }

    public boolean checkExists(String userName) throws DataBackendException {
        boolean exists = false;
        TorqueConnection con = null;
        try {
            con = Transaction.begin();
            this.doSelectByName(userName, (Connection)con);
            Transaction.commit((Connection)con);
            con = null;
            exists = true;
        }
        catch (NoRowsException e) {
            exists = false;
        }
        catch (TooManyRowsException e) {
            throw new DataBackendException("Multiple Users with same username '" + userName + "'");
        }
        catch (TorqueException e) {
            throw new DataBackendException("Error retrieving user information", (Throwable)e);
        }
        finally {
            if (con != null) {
                Transaction.safeRollback((Connection)con);
            }
        }
        return exists;
    }

    public <T extends User> T getUser(String userName) throws UnknownEntityException, DataBackendException {
        T user = null;
        TorqueConnection con = null;
        try {
            con = Transaction.begin();
            user = this.doSelectByName(userName.toLowerCase(), (Connection)con);
            ((TorqueAbstractSecurityEntity)user).retrieveAttachedObjects((Connection)con, false);
            Transaction.commit((Connection)con);
            con = null;
        }
        catch (NoRowsException e) {
            throw new UnknownEntityException("Unknown user '" + userName + "'");
        }
        catch (TooManyRowsException e) {
            throw new DataBackendException("Multiple Users with same username '" + userName + "'");
        }
        catch (TorqueException e) {
            throw new DataBackendException("Error retrieving user information", (Throwable)e);
        }
        finally {
            if (con != null) {
                Transaction.safeRollback((Connection)con);
            }
        }
        return user;
    }

    public <T extends User> UserSet<T> getAllUsers() throws DataBackendException {
        UserSet userSet = new UserSet();
        TorqueConnection con = null;
        try {
            con = Transaction.begin();
            List<T> users = this.doSelectAllUsers((Connection)con);
            for (User user : users) {
                ((TorqueAbstractSecurityEntity)user).retrieveAttachedObjects((Connection)con, false);
                userSet.add((SecurityEntity)user);
            }
            Transaction.commit((Connection)con);
            con = null;
        }
        catch (TorqueException e) {
            throw new DataBackendException("Error retrieving all users", (Throwable)e);
        }
        finally {
            if (con != null) {
                Transaction.safeRollback((Connection)con);
            }
        }
        return userSet;
    }

    public <T extends User> T getUserById(Object id) throws DataBackendException, UnknownEntityException {
        T user;
        if (id != null && id instanceof Integer) {
            TorqueConnection con = null;
            try {
                con = Transaction.begin();
                user = this.doSelectById((Integer)id, (Connection)con);
                ((TorqueAbstractSecurityEntity)user).retrieveAttachedObjects((Connection)con, false);
                Transaction.commit((Connection)con);
                con = null;
            }
            catch (NoRowsException e) {
                throw new UnknownEntityException("User with id '" + id + "' does not exist.", (Throwable)e);
            }
            catch (TorqueException e) {
                throw new DataBackendException("Error retrieving user information", (Throwable)e);
            }
            finally {
                if (con != null) {
                    Transaction.safeRollback((Connection)con);
                }
            }
        } else {
            throw new UnknownEntityException("Invalid user id '" + id + "'");
        }
        return user;
    }
}

