/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fulcrum.security.torque;

import java.sql.Connection;
import java.util.List;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.fulcrum.security.entity.Permission;
import org.apache.fulcrum.security.entity.SecurityEntity;
import org.apache.fulcrum.security.spi.AbstractPermissionManager;
import org.apache.fulcrum.security.torque.security.TorqueAbstractSecurityEntity;
import org.apache.fulcrum.security.util.DataBackendException;
import org.apache.fulcrum.security.util.PermissionSet;
import org.apache.fulcrum.security.util.UnknownEntityException;
import org.apache.torque.NoRowsException;
import org.apache.torque.TooManyRowsException;
import org.apache.torque.TorqueException;
import org.apache.torque.util.TorqueConnection;
import org.apache.torque.util.Transaction;

public abstract class TorqueAbstractPermissionManager
extends AbstractPermissionManager {
    private static final long serialVersionUID = 194503017446833485L;

    public void configure(Configuration conf) throws ConfigurationException {
        super.configure(conf);
    }

    protected abstract <T extends Permission> List<T> doSelectAllPermissions(Connection var1) throws TorqueException;

    protected abstract <T extends Permission> T doSelectByName(String var1, Connection var2) throws NoRowsException, TooManyRowsException, TorqueException;

    protected abstract <T extends Permission> T doSelectById(Integer var1, Connection var2) throws NoRowsException, TooManyRowsException, TorqueException;

    public synchronized void renamePermission(Permission permission, String name) throws DataBackendException, UnknownEntityException {
        if (this.checkExists(permission)) {
            permission.setName(name);
            try {
                TorqueAbstractSecurityEntity p = (TorqueAbstractSecurityEntity)permission;
                p.setNew(false);
                p.save();
            }
            catch (Exception e) {
                throw new DataBackendException("Renaming Permission '" + permission.getName() + "' failed", (Throwable)e);
            }
        } else {
            throw new UnknownEntityException("Unknown permission '" + permission.getName() + "'");
        }
    }

    public synchronized void removePermission(Permission permission) throws DataBackendException, UnknownEntityException {
        if (this.checkExists(permission)) {
            try {
                ((TorqueAbstractSecurityEntity)permission).delete();
            }
            catch (TorqueException e) {
                throw new DataBackendException("Removing Permission '" + permission.getName() + "' failed", (Throwable)e);
            }
        } else {
            throw new UnknownEntityException("Unknown permission '" + permission.getName() + "'");
        }
    }

    protected synchronized <T extends Permission> T persistNewPermission(T permission) throws DataBackendException {
        try {
            ((TorqueAbstractSecurityEntity)permission).save();
        }
        catch (Exception e) {
            throw new DataBackendException("Adding Permission '" + permission.getName() + "' failed", (Throwable)e);
        }
        return permission;
    }

    public PermissionSet getAllPermissions() throws DataBackendException {
        PermissionSet permissionSet = new PermissionSet();
        TorqueConnection con = null;
        try {
            con = Transaction.begin();
            List permissions = this.doSelectAllPermissions((Connection)con);
            for (Permission p : permissions) {
                ((TorqueAbstractSecurityEntity)p).retrieveAttachedObjects((Connection)con, false);
                permissionSet.add((SecurityEntity)p);
            }
            Transaction.commit((Connection)con);
            con = null;
        }
        catch (TorqueException e) {
            throw new DataBackendException("Error retrieving permission information", (Throwable)e);
        }
        finally {
            if (con != null) {
                Transaction.safeRollback((Connection)con);
            }
        }
        return permissionSet;
    }

    public boolean checkExists(String permissionName) throws DataBackendException {
        boolean exists = false;
        TorqueConnection con = null;
        try {
            con = Transaction.begin();
            this.doSelectByName(permissionName, (Connection)con);
            Transaction.commit((Connection)con);
            con = null;
            exists = true;
        }
        catch (NoRowsException e) {
            exists = false;
        }
        catch (TooManyRowsException e) {
            throw new DataBackendException("Multiple permissions with same name '" + permissionName + "'");
        }
        catch (TorqueException e) {
            throw new DataBackendException("Error retrieving permission information", (Throwable)e);
        }
        finally {
            if (con != null) {
                Transaction.safeRollback((Connection)con);
            }
        }
        return exists;
    }

    public <T extends Permission> T getPermissionById(Object id) throws DataBackendException, UnknownEntityException {
        T permission;
        if (id != null && id instanceof Integer) {
            TorqueConnection con = null;
            try {
                con = Transaction.begin();
                permission = this.doSelectById((Integer)id, (Connection)con);
                ((TorqueAbstractSecurityEntity)permission).retrieveAttachedObjects((Connection)con, false);
                Transaction.commit((Connection)con);
                con = null;
            }
            catch (NoRowsException e) {
                throw new UnknownEntityException("Permission with id '" + id + "' does not exist.", (Throwable)e);
            }
            catch (TorqueException e) {
                throw new DataBackendException("Error retrieving permission information", (Throwable)e);
            }
            finally {
                if (con != null) {
                    Transaction.safeRollback((Connection)con);
                }
            }
        } else {
            throw new UnknownEntityException("Invalid permission id '" + id + "'");
        }
        return permission;
    }

    public <T extends Permission> T getPermissionByName(String name) throws DataBackendException, UnknownEntityException {
        T permission = null;
        TorqueConnection con = null;
        try {
            con = Transaction.begin();
            permission = this.doSelectByName(name, (Connection)con);
            ((TorqueAbstractSecurityEntity)permission).retrieveAttachedObjects((Connection)con, false);
            Transaction.commit((Connection)con);
            con = null;
        }
        catch (NoRowsException e) {
            throw new UnknownEntityException("Could not find permission " + name);
        }
        catch (TooManyRowsException e) {
            throw new DataBackendException("Multiple Permissions with same name '" + name + "'");
        }
        catch (TorqueException e) {
            throw new DataBackendException("Error retrieving permission information", (Throwable)e);
        }
        finally {
            if (con != null) {
                Transaction.safeRollback((Connection)con);
            }
        }
        return permission;
    }
}

