package org.apache.fulcrum.security.torque.om;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.torque.Column;
import org.apache.torque.TorqueException;
import org.apache.torque.criteria.Criteria;
import org.apache.torque.om.mapper.RecordMapper;


/**
 * Maps ResultSet rows into TorqueTurbineRolePermission objects.
 *
 * The skeleton for this class was autogenerated by Torque on:
 *
 * [Thu Nov 04 10:24:04 CET 2021]
 *
 */
@SuppressWarnings("unused")
public class BaseTorqueTurbineRolePermissionRecordMapper implements RecordMapper<TorqueTurbineRolePermission>
{
    /** Serial version */
    private static final long serialVersionUID = 1636017844174L;

    /** The class log. */
    private static Log log
            = LogFactory.getLog(BaseTorqueTurbineRolePermissionRecordMapper.class);

    /**
     * Constructs the object from the current row in the resultSet.
     *
     * @param resultSet the resultSet to operate on, already pointing
     *        to the correct row. Not null.
     * @param offset a possible offset in the columns to be considered
     *        (if previous columns contain other objects),
     *        or 0 for no offset.
     * @param criteria The criteria which created the result set.
     *        If set, the attributes to set in the data object
     *        are determined from the select columns in the criteria;
     *        if no matching column can be found, null is returned.
     *        If not set, all of the table's columns are read from the
     *        result set in the order defined in the table definition.
     *
     * @return the mapped object, not null.
     *
     * @throws TorqueException when reading fields from the RecordSet fails
     *         or if a Criteria is passed which contains select columns other
     *         than the columns in the TURBINE_ROLE_PERMISSION table.
     */
    public TorqueTurbineRolePermission processRow(
                ResultSet resultSet,
                int offset,
                Criteria criteria)
            throws TorqueException
    {
        TorqueTurbineRolePermission torqueTurbineRolePermission = new TorqueTurbineRolePermission();

        try 
        {
            torqueTurbineRolePermission.setLoading(true);
            if (criteria == null)
            {
                torqueTurbineRolePermission.setRoleId(
                        getRoleId(resultSet, offset + 1));
                torqueTurbineRolePermission.setPermissionId(
                        getPermissionId(resultSet, offset + 2));
            }
            else
            {
                // try to get columns to be mapped
                // from criteria's select columns
                boolean columnMapped = false;
                int totalOffset = offset + 1;
                List<Column> selectColumns = criteria.getSelectColumns();
                List<Column> columnsWithoutOffset = selectColumns.subList(
                        offset, 
                        selectColumns.size());
                for (Column column : columnsWithoutOffset)
                {
                    if (BaseTorqueTurbineRolePermissionPeer.ROLE_ID.getSqlExpression().equals(
                            column.getSqlExpression()))
                    {
                        torqueTurbineRolePermission.setRoleId(
                            getRoleId(resultSet, totalOffset));
                        columnMapped = true;
                    }
                    else if (BaseTorqueTurbineRolePermissionPeer.PERMISSION_ID.getSqlExpression().equals(
                            column.getSqlExpression()))
                    {
                        torqueTurbineRolePermission.setPermissionId(
                            getPermissionId(resultSet, totalOffset));
                        columnMapped = true;
                    }
                    totalOffset++;
                }
                if (!columnMapped)
                {
                    log.debug("no columns to map found in criteria, "
                        + "returning null");
                    return null;
                }
            }
            torqueTurbineRolePermission.setNew(false);
            torqueTurbineRolePermission.setModified(false);
        }
        finally
        {
            torqueTurbineRolePermission.setLoading(false);
        }
        return torqueTurbineRolePermission;
    }

    /**
     * Reads the value of the <code>columnIndex</code>'th column
     * in the <code>resultSet</code> so that it can be used to set
     * the field roleId in TorqueTurbineRolePermission.
     *
     * @param resultSet the ResultSet to read from, not null.
     * @param columnIndex the index in the resultSet which should be read.
     *
     * @return the content of the column.
     *
     * @throws SQLException if a problem occurs when reading
     *         from the resultSet.
     */
    protected Integer getRoleId(
                ResultSet resultSet,
                int columnIndex)
            throws TorqueException
    {
        try
        {
            Integer value = resultSet.getInt(columnIndex);
            if (resultSet.wasNull())
            {
                value = null;
            }
            return value;
        }
        catch (SQLException e)
        {
            throw new TorqueException(e);
        }
    }
    /**
     * Reads the value of the <code>columnIndex</code>'th column
     * in the <code>resultSet</code> so that it can be used to set
     * the field permissionId in TorqueTurbineRolePermission.
     *
     * @param resultSet the ResultSet to read from, not null.
     * @param columnIndex the index in the resultSet which should be read.
     *
     * @return the content of the column.
     *
     * @throws SQLException if a problem occurs when reading
     *         from the resultSet.
     */
    protected Integer getPermissionId(
                ResultSet resultSet,
                int columnIndex)
            throws TorqueException
    {
        try
        {
            Integer value = resultSet.getInt(columnIndex);
            if (resultSet.wasNull())
            {
                value = null;
            }
            return value;
        }
        catch (SQLException e)
        {
            throw new TorqueException(e);
        }
    }

}
