package org.apache.fulcrum.security.torque.om;

import java.sql.Connection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

import org.apache.torque.NoRowsException;
import org.apache.torque.TooManyRowsException;
import org.apache.torque.TorqueException;
import org.apache.torque.criteria.Criteria;
import org.apache.torque.criteria.Criterion;
import org.apache.torque.om.mapper.RecordMapper;
import org.apache.torque.om.mapper.CompositeMapper;
import org.apache.torque.om.ObjectKey;
import org.apache.torque.om.SimpleKey;
import org.apache.torque.map.TableMap;
import org.apache.torque.util.TorqueConnection;
import org.apache.torque.util.Transaction;
import org.apache.torque.util.ColumnValues;
import org.apache.torque.util.JdbcTypedValue;



/**
 * The skeleton for this class was autogenerated by Torque on:
 *
 * [Thu Nov 04 10:24:03 CET 2021]
 *
 * You should not use this class directly.  It should not even be
 * extended; all references should be to TorqueDynamicUserDelegatesPeer
 */

@SuppressWarnings("unused")
public abstract class BaseTorqueDynamicUserDelegatesPeerImpl
    extends org.apache.torque.util.AbstractPeerImpl<TorqueDynamicUserDelegates>
{
    /** Serial version */
    private static final long serialVersionUID = 1636017843313L;



    /**
     * Constructor.
     * The recordMapper, tableMap and databaseName fields are correctly
     * initialized.
     */
    public BaseTorqueDynamicUserDelegatesPeerImpl()
    {
        this(new TorqueDynamicUserDelegatesRecordMapper(),
            TorqueDynamicUserDelegatesPeer.TABLE,
            TorqueDynamicUserDelegatesPeer.DATABASE_NAME);
    }

    /**
     * Constructor providing the objects to be injected as parameters.
     *
     * @param recordMapper a record mapper to map JDBC result sets to objects
     * @param tableMap the default table map
     * @param databaseName the name of the database
     */
    public BaseTorqueDynamicUserDelegatesPeerImpl(
            RecordMapper<TorqueDynamicUserDelegates> recordMapper, 
            TableMap tableMap,
            String databaseName)
    {
        super(recordMapper, tableMap, databaseName);
    }


    /**
     * Returns a new instance of the Data object class
     */
    public TorqueDynamicUserDelegates getDbObjectInstance()
    {
        return new TorqueDynamicUserDelegates();
    }


    /**
     * Method to do updates.  This method is to be used during a transaction,
     * otherwise use the doUpdate(Criteria) method.
     *
     * @param columnValues the values to update plus the primary key
     *        identifying the row to update.
     * @param con the connection to use, not null.
     *
     * @return the number of affected rows.
     *
     * @throws TorqueException Any exceptions caught during processing will be
     *         rethrown wrapped into a TorqueException.
     */
    public int doUpdate(ColumnValues columnValues, Connection con)
        throws TorqueException
    {
        Criteria selectCriteria = new Criteria(getDatabaseName());
        correctBooleans(columnValues);

        {
            JdbcTypedValue pkValue
                = columnValues.remove(TorqueDynamicUserDelegatesPeer.DELEGATOR_USER_ID);
            if (pkValue == null)
            {
                throw new TorqueException(
                        "The value for the primary key column "
                        + "TorqueDynamicUserDelegatesPeer.DELEGATOR_USER_ID"
                        + " must be set");
            }
            if (pkValue.getSqlExpression() == null)
            {
                selectCriteria.where(
                        TorqueDynamicUserDelegatesPeer.DELEGATOR_USER_ID,
                        pkValue.getValue());
            }
            else
            {
                selectCriteria.where(
                        TorqueDynamicUserDelegatesPeer.DELEGATOR_USER_ID,
                        pkValue.getSqlExpression());
            }
        }
        {
            JdbcTypedValue pkValue
                = columnValues.remove(TorqueDynamicUserDelegatesPeer.DELEGATEE_USER_ID);
            if (pkValue == null)
            {
                throw new TorqueException(
                        "The value for the primary key column "
                        + "TorqueDynamicUserDelegatesPeer.DELEGATEE_USER_ID"
                        + " must be set");
            }
            if (pkValue.getSqlExpression() == null)
            {
                selectCriteria.where(
                        TorqueDynamicUserDelegatesPeer.DELEGATEE_USER_ID,
                        pkValue.getValue());
            }
            else
            {
                selectCriteria.where(
                        TorqueDynamicUserDelegatesPeer.DELEGATEE_USER_ID,
                        pkValue.getSqlExpression());
            }
        }


        int rowCount = doUpdate(selectCriteria, columnValues, con);
        return rowCount;
    }

    /**
     * Deletes a data object, i.e. a row in a table, in the database.
     *
     * @param obj the data object to delete in the database, not null.
     *
     * @return the number of deleted rows.
     *
     * @throws TorqueException Any exceptions caught during processing will be
     *         rethrown wrapped into a TorqueException.
     */
    public int doDelete(TorqueDynamicUserDelegates obj) throws TorqueException
    {
        int result = doDelete(buildCriteria(obj.getPrimaryKey()));
        obj.setDeleted(true);
        return result;
    }

    /**
     * Deletes a data object, i.e. a row in a table, in the database.
     * This method is to be used during a transaction, otherwise use the
     * doDelete(TorqueDynamicUserDelegates) method.
     *
     * @param obj the data object to delete in the database, not null.
     * @param con the connection to use, not null.
     *
     * @return the number of deleted rows.
     *
     * @throws TorqueException Any exceptions caught during processing will be
     *         rethrown wrapped into a TorqueException.
     */
    public int doDelete(TorqueDynamicUserDelegates obj, Connection con)
        throws TorqueException
    {
        int result = doDelete(buildCriteria(obj.getPrimaryKey()), con);
        obj.setDeleted(true);
        return result;
    }

    /**
     * Deletes data objects, i.e. rows in a table, in the database.
     *
     * @param objects the data object to delete in the database, not null,
     *        may not contain null.
     *
     * @return the number of deleted rows.
     *
     * @throws TorqueException Any exceptions caught during processing will be
     *         rethrown wrapped into a TorqueException.
     */
    public int doDelete(Collection<TorqueDynamicUserDelegates> objects)
            throws TorqueException
    {
        int result = doDelete(buildPkCriteria(objects));
        objects.forEach(object -> object.setDeleted(true));
        return result;
    }

    /**
     * Deletes data objects, i.e. rows in a table, in the database.
     * This method uses the passed connection to delete the rows;
     * if a transaction is open in the connection, the deletion happens inside
     * this transaction.
     *
     * @param objects the data objects to delete in the database, not null,
     *        may not contain null.
     * @param con the connection to use for deleting, not null.
     *
     * @return the number of deleted rows.
     *
     * @throws TorqueException Any exceptions caught during processing will be
     *         rethrown wrapped into a TorqueException.
     */
    public int doDelete(
            Collection<TorqueDynamicUserDelegates> objects,
            Connection con)
        throws TorqueException
    {
        int result = doDelete(buildPkCriteria(objects), con);
        objects.forEach(object -> object.setDeleted(true));
        return result;
    }

    /** 
     * Build a Criteria object which selects all objects which have a given
     * primary key.
     *
     * @param pk the primary key value to build the criteria from, not null.
     */
    public Criteria buildCriteria(ObjectKey<?> pk)
    {
        Criteria criteria = new Criteria();
        SimpleKey<?>[] keys = (SimpleKey[])pk.getValue();
        criteria.and(TorqueDynamicUserDelegatesPeer.DELEGATOR_USER_ID, keys[0]);
        criteria.and(TorqueDynamicUserDelegatesPeer.DELEGATEE_USER_ID, keys[1]);
        return criteria;
     }

    /** 
     * Build a Criteria object which selects all objects which primary keys
     * are contained in the passed collection.
     *
     * @param pks the primary key values to build the criteria from, not null,
     *        may not contain null.
     */
    public Criteria buildCriteria(Collection<ObjectKey<?>> pks)
    {
        Criteria criteria = new Criteria();
        for (ObjectKey<?> pk : pks)
        {
            SimpleKey<?>[] keys = (SimpleKey[])pk.getValue();
                Criterion c0 = new Criterion(
                    TorqueDynamicUserDelegatesPeer.DELEGATOR_USER_ID, keys[0], Criteria.EQUAL);
                Criterion c1 = new Criterion(
                    TorqueDynamicUserDelegatesPeer.DELEGATEE_USER_ID, keys[1], Criteria.EQUAL);
                    c0.and(c1);
            criteria.or(c0);
        }
        return criteria;
     }


    /** 
     * Build a Criteria object which selects all passed objects using their
     * primary key. Objects which do not yet have a primary key are ignored.
     *
     * @param objects the objects to build the criteria from, not null,
     *        may not contain null.
     */
    public Criteria buildPkCriteria(
            Collection<TorqueDynamicUserDelegates> objects)
    {
        return buildCriteria(objects.stream()
                .map(object -> object.getPrimaryKey())
                .collect(Collectors.toList()));
    }

    /** 
     * Build a Criteria object from the data object for this peer.
     *
     * @param obj the object to build the criteria from, not null.
     */
    public Criteria buildCriteria(TorqueDynamicUserDelegates obj)
    {
        Criteria criteria = new Criteria(getDatabaseName());
        criteria.and(TorqueDynamicUserDelegatesPeer.DELEGATOR_USER_ID, obj.getDelegatorUserId());
        criteria.and(TorqueDynamicUserDelegatesPeer.DELEGATEE_USER_ID, obj.getDelegateeUserId());
        return criteria;
    }

    /** 
     * Build a Criteria object from the data object for this peer,
     * skipping all binary columns.
     *
     * @param obj the object to build the criteria from, not null.
     */
    public Criteria buildSelectCriteria(TorqueDynamicUserDelegates obj)
    {
        Criteria criteria = new Criteria(getDatabaseName());
        criteria.and(TorqueDynamicUserDelegatesPeer.DELEGATOR_USER_ID, obj.getDelegatorUserId());
        criteria.and(TorqueDynamicUserDelegatesPeer.DELEGATEE_USER_ID, obj.getDelegateeUserId());
        return criteria;
    }

    /** 
     * Returns the contents of the object as ColumnValues object.
     * Primary key columns which are generated on insertion are not
     * added to the returned object if they still have their initial
     * value. Also, columns which have the useDatabaseDefaultValue
     * flag set to true are also not added to the returned object
     * if they still have their initial value.
     *
     * @throws TorqueException if the table map cannot be retrieved
     *         (should not happen).
     */
    public ColumnValues buildColumnValues(TorqueDynamicUserDelegates torqueDynamicUserDelegates)
            throws TorqueException
    {
        ColumnValues columnValues = new ColumnValues();
        columnValues.put(
                TorqueDynamicUserDelegatesPeer.DELEGATOR_USER_ID,
                new JdbcTypedValue(
                    torqueDynamicUserDelegates.getDelegatorUserId(),
                    4));
        columnValues.put(
                TorqueDynamicUserDelegatesPeer.DELEGATEE_USER_ID,
                new JdbcTypedValue(
                    torqueDynamicUserDelegates.getDelegateeUserId(),
                    4));
        return columnValues;
    }

    /**
     * retrieve object using using pk values.
     *
     * @param delegatorUserId Integer
     * @param delegateeUserId Integer
     */
    public TorqueDynamicUserDelegates retrieveByPK(
            Integer delegatorUserId,
            Integer delegateeUserId)
        throws TorqueException
    {
        try (TorqueConnection connection = Transaction.begin(getDatabaseName()))
        {
            TorqueDynamicUserDelegates result = retrieveByPK(
               delegatorUserId,
               delegateeUserId,
               connection);
            Transaction.commit(connection);
            return result;
        }
    }

    /**
     * retrieve object using using pk values.
     *
     * @param delegatorUserId Integer
     * @param delegateeUserId Integer
     * @param con Connection
     */
    public TorqueDynamicUserDelegates retrieveByPK(
            Integer delegatorUserId,
            Integer delegateeUserId,
            Connection con) throws TorqueException
    {

        Criteria criteria = new Criteria();
        criteria.and(TorqueDynamicUserDelegatesPeer.DELEGATOR_USER_ID, delegatorUserId);
        criteria.and(TorqueDynamicUserDelegatesPeer.DELEGATEE_USER_ID, delegateeUserId);
        TorqueDynamicUserDelegates v = doSelectSingleRecord(criteria, con);
        if (v == null)
        {
            throw new NoRowsException("Failed to select a row.");
        }

        return v;
    }

    /**
     * Retrieve a single object by pk
     *
     * @param pk the primary key
     * @throws TorqueException Any exceptions caught during processing will be
     *         rethrown wrapped into a TorqueException.
     * @throws NoRowsException Primary key was not found in database.
     * @throws TooManyRowsException Primary key was not found in database.
     */
    public TorqueDynamicUserDelegates retrieveByPK(ObjectKey<?> pk)
        throws TorqueException, NoRowsException, TooManyRowsException
    {
        try (TorqueConnection connection = Transaction.begin(getDatabaseName()))
        {
            TorqueDynamicUserDelegates result = retrieveByPK(pk, connection);
            Transaction.commit(connection);
            return result;
        }
    }

    /**
     * Retrieve a single object by pk
     *
     * @param pk the primary key
     * @param con the connection to use
     * @throws TorqueException Any exceptions caught during processing will be
     *         rethrown wrapped into a TorqueException.
     * @throws NoRowsException Primary key was not found in database.
     * @throws TooManyRowsException Primary key was not found in database.
     */
    public TorqueDynamicUserDelegates retrieveByPK(ObjectKey<?> pk, Connection con)
        throws TorqueException, NoRowsException, TooManyRowsException
    {
        Criteria criteria = buildCriteria(pk);
        TorqueDynamicUserDelegates v = doSelectSingleRecord(criteria, con);
        if (v == null)
        {
            throw new NoRowsException("Failed to select a row.");
        }

        return v;
    }


    /**
     * Retrieve multiple objects by pk.
     *
     * @param pks List of primary keys.
     *        Entries in pks which do not match entries in the database are ignored.
     *
     * @return the list of matching objects, not null.
     *
     * @throws TorqueException Any exceptions caught during processing will be
     *         rethrown wrapped into a TorqueException.
     */
    public List<TorqueDynamicUserDelegates> retrieveByObjectKeys(Collection<ObjectKey<?>> pks)
        throws TorqueException
    {
        try (TorqueConnection connection = Transaction.begin(getDatabaseName()))
        {
            List<TorqueDynamicUserDelegates> result = retrieveByObjectKeys(pks, connection);
            Transaction.commit(connection);
            return result;
        }
    }

    /**
     * Retrieve multiple objects by pk.
     *
     * @param pks List of primary keys.
     *        Entries in pks which do not match entries in the database are ignored.
     * @param dbcon the connection to use
     *
     * @return the list of matching objects, not null.
     *
     * @throws TorqueException Any exceptions caught during processing will be
     *         rethrown wrapped into a TorqueException.
     */
    public List<TorqueDynamicUserDelegates> retrieveByObjectKeys(
                Collection<ObjectKey<?>> pks,
                Connection dbcon)
            throws TorqueException
    {
        if (pks == null || pks.size() == 0)
        {
            return new ArrayList<TorqueDynamicUserDelegates>();
        }
        Criteria criteria = buildCriteria(pks);
        List<TorqueDynamicUserDelegates> result = doSelect(criteria, dbcon);
        return result;
    }


    /**
     * Selects a collection of dbObjectClassName objects pre-filled with their
     * TorqueDynamicUser objects.
     *
     * @throws TorqueException Any exceptions caught during processing will be
     *         rethrown wrapped into a TorqueException.
     */
    public List<TorqueDynamicUserDelegates> doSelectJoinTorqueDynamicUserRelatedByDelegatorUserId(Criteria criteria)
        throws TorqueException
    {
        try (TorqueConnection connection = Transaction.begin(getDatabaseName()))
        {
            List<TorqueDynamicUserDelegates> result
                    = TorqueDynamicUserDelegatesPeer.doSelectJoinTorqueDynamicUserRelatedByDelegatorUserId(criteria, connection);
            Transaction.commit(connection);
            return result;
        }
    }

    /**
     * Selects a collection of TorqueDynamicUserDelegates objects pre-filled with their
     * TorqueDynamicUser objects.
     *
     * @throws TorqueException Any exceptions caught during processing will be
     *         rethrown wrapped into a TorqueException.
     */
    public List<TorqueDynamicUserDelegates> doSelectJoinTorqueDynamicUserRelatedByDelegatorUserId(
            Criteria criteria, Connection conn)
        throws TorqueException
    {
        setDbName(criteria);

        addSelectColumns(criteria);
        org.apache.fulcrum.security.torque.om.TorqueDynamicUserPeer.addSelectColumns(criteria);

        CompositeMapper compositeMapper = new CompositeMapper();
        compositeMapper.addMapper(
                new TorqueDynamicUserDelegatesRecordMapper(),
                0);
        compositeMapper.addMapper(
                new TorqueDynamicUserRecordMapper(),
                TorqueDynamicUserDelegatesPeer.numColumns);
        criteria.addJoin(TorqueDynamicUserDelegatesPeer.DELEGATOR_USER_ID,
            org.apache.fulcrum.security.torque.om.TorqueDynamicUserPeer.USER_ID);

        correctBooleans(criteria);

        List<TorqueDynamicUserDelegates> result = new ArrayList<TorqueDynamicUserDelegates>();
        List<List<Object>> rawResult = doSelect(
                criteria, compositeMapper, conn);
        for (List<Object> rawResultRow : rawResult)
        {
            TorqueDynamicUserDelegates obj1 = (TorqueDynamicUserDelegates) rawResultRow.get(0);
            TorqueDynamicUser obj2 = (TorqueDynamicUser) rawResultRow.get(1);

            boolean newObject = true;
            for (int j = 0; j < result.size(); j++)
            {
                TorqueDynamicUserDelegates temp_obj1 = result.get(j);
                org.apache.fulcrum.security.torque.om.TorqueDynamicUser temp_obj2 = temp_obj1.getTorqueDynamicUserRelatedByDelegatorUserId();
                if (temp_obj2.getPrimaryKey().equals(obj2.getPrimaryKey()))
                {
                    newObject = false;
                    temp_obj2.addTorqueDynamicUserDelegatesRelatedByDelegatorUserId(obj1);
                    break;
                }
            }
            if (newObject)
            {
                obj2.initTorqueDynamicUserDelegatesRelatedByDelegatorUserIds();
                obj2.addTorqueDynamicUserDelegatesRelatedByDelegatorUserId(obj1);
            }
            result.add(obj1);
        }
        return result;
    }
    /**
     * Selects a collection of dbObjectClassName objects pre-filled with their
     * TorqueDynamicUser objects.
     *
     * @throws TorqueException Any exceptions caught during processing will be
     *         rethrown wrapped into a TorqueException.
     */
    public List<TorqueDynamicUserDelegates> doSelectJoinTorqueDynamicUserRelatedByDelegateeUserId(Criteria criteria)
        throws TorqueException
    {
        try (TorqueConnection connection = Transaction.begin(getDatabaseName()))
        {
            List<TorqueDynamicUserDelegates> result
                    = TorqueDynamicUserDelegatesPeer.doSelectJoinTorqueDynamicUserRelatedByDelegateeUserId(criteria, connection);
            Transaction.commit(connection);
            return result;
        }
    }

    /**
     * Selects a collection of TorqueDynamicUserDelegates objects pre-filled with their
     * TorqueDynamicUser objects.
     *
     * @throws TorqueException Any exceptions caught during processing will be
     *         rethrown wrapped into a TorqueException.
     */
    public List<TorqueDynamicUserDelegates> doSelectJoinTorqueDynamicUserRelatedByDelegateeUserId(
            Criteria criteria, Connection conn)
        throws TorqueException
    {
        setDbName(criteria);

        addSelectColumns(criteria);
        org.apache.fulcrum.security.torque.om.TorqueDynamicUserPeer.addSelectColumns(criteria);

        CompositeMapper compositeMapper = new CompositeMapper();
        compositeMapper.addMapper(
                new TorqueDynamicUserDelegatesRecordMapper(),
                0);
        compositeMapper.addMapper(
                new TorqueDynamicUserRecordMapper(),
                TorqueDynamicUserDelegatesPeer.numColumns);
        criteria.addJoin(TorqueDynamicUserDelegatesPeer.DELEGATEE_USER_ID,
            org.apache.fulcrum.security.torque.om.TorqueDynamicUserPeer.USER_ID);

        correctBooleans(criteria);

        List<TorqueDynamicUserDelegates> result = new ArrayList<TorqueDynamicUserDelegates>();
        List<List<Object>> rawResult = doSelect(
                criteria, compositeMapper, conn);
        for (List<Object> rawResultRow : rawResult)
        {
            TorqueDynamicUserDelegates obj1 = (TorqueDynamicUserDelegates) rawResultRow.get(0);
            TorqueDynamicUser obj2 = (TorqueDynamicUser) rawResultRow.get(1);

            boolean newObject = true;
            for (int j = 0; j < result.size(); j++)
            {
                TorqueDynamicUserDelegates temp_obj1 = result.get(j);
                org.apache.fulcrum.security.torque.om.TorqueDynamicUser temp_obj2 = temp_obj1.getTorqueDynamicUserRelatedByDelegateeUserId();
                if (temp_obj2.getPrimaryKey().equals(obj2.getPrimaryKey()))
                {
                    newObject = false;
                    temp_obj2.addTorqueDynamicUserDelegatesRelatedByDelegateeUserId(obj1);
                    break;
                }
            }
            if (newObject)
            {
                obj2.initTorqueDynamicUserDelegatesRelatedByDelegateeUserIds();
                obj2.addTorqueDynamicUserDelegatesRelatedByDelegateeUserId(obj1);
            }
            result.add(obj1);
        }
        return result;
    }




}
